/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingUpgrader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteConnectionInfo;
import org.elasticsearch.transport.RemoteConnectionManager;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class SniffConnectionStrategy
extends RemoteConnectionStrategy {
    public static final Setting.AffixSetting<List<String>> SEARCH_REMOTE_CLUSTERS_SEEDS;
    public static final SettingUpgrader<List<String>> SEARCH_REMOTE_CLUSTER_SEEDS_UPGRADER;
    public static final Setting.AffixSetting<List<String>> REMOTE_CLUSTER_SEEDS;
    public static final Setting.AffixSetting<String> SEARCH_REMOTE_CLUSTERS_PROXY;
    public static final Setting.AffixSetting<String> REMOTE_CLUSTERS_PROXY;
    public static final Setting<Integer> SEARCH_REMOTE_CONNECTIONS_PER_CLUSTER;
    public static final Setting<Integer> REMOTE_CONNECTIONS_PER_CLUSTER;
    public static final Setting.AffixSetting<Integer> REMOTE_NODE_CONNECTIONS;
    public static final SettingUpgrader<String> SEARCH_REMOTE_CLUSTERS_PROXY_UPGRADER;
    static final int CHANNELS_PER_CONNECTION = 6;
    private static final Logger logger;
    private static final Predicate<DiscoveryNode> DEFAULT_NODE_PREDICATE;
    private final List<String> configuredSeedNodes;
    private final List<Supplier<DiscoveryNode>> seedNodes;
    private final int maxNumRemoteConnections;
    private final Predicate<DiscoveryNode> nodePredicate;
    private final SetOnce<ClusterName> remoteClusterName = new SetOnce();
    private volatile String proxyAddress;
    static final /* synthetic */ boolean $assertionsDisabled;

    SniffConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, Settings settings) {
        this(clusterAlias, transportService, connectionManager, REMOTE_CLUSTERS_PROXY.getConcreteSettingForNamespace(clusterAlias).get(settings), settings, REMOTE_NODE_CONNECTIONS.getConcreteSettingForNamespace(clusterAlias).get(settings), SniffConnectionStrategy.getNodePredicate(settings), REMOTE_CLUSTER_SEEDS.getConcreteSettingForNamespace(clusterAlias).get(settings));
    }

    SniffConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, String proxyAddress, Settings settings, int maxNumRemoteConnections, Predicate<DiscoveryNode> nodePredicate, List<String> configuredSeedNodes) {
        this(clusterAlias, transportService, connectionManager, proxyAddress, settings, maxNumRemoteConnections, nodePredicate, configuredSeedNodes, configuredSeedNodes.stream().map(seedAddress -> () -> SniffConnectionStrategy.resolveSeedNode(clusterAlias, seedAddress, proxyAddress)).collect(Collectors.toList()));
    }

    SniffConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, String proxyAddress, Settings settings, int maxNumRemoteConnections, Predicate<DiscoveryNode> nodePredicate, List<String> configuredSeedNodes, List<Supplier<DiscoveryNode>> seedNodes) {
        super(clusterAlias, transportService, connectionManager, settings);
        this.proxyAddress = proxyAddress;
        this.maxNumRemoteConnections = maxNumRemoteConnections;
        this.nodePredicate = nodePredicate;
        this.configuredSeedNodes = configuredSeedNodes;
        this.seedNodes = seedNodes;
    }

    static Stream<Setting.AffixSetting<?>> enablementSettings() {
        return Stream.of(REMOTE_CLUSTER_SEEDS);
    }

    static Writeable.Reader<RemoteConnectionInfo.ModeInfo> infoReader() {
        return x$0 -> new SniffModeInfo(x$0);
    }

    @Override
    protected boolean shouldOpenMoreConnections() {
        return this.connectionManager.size() < this.maxNumRemoteConnections;
    }

    @Override
    protected boolean strategyMustBeRebuilt(Settings newSettings) {
        String proxy = REMOTE_CLUSTERS_PROXY.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        List<String> addresses = REMOTE_CLUSTER_SEEDS.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        int nodeConnections = REMOTE_NODE_CONNECTIONS.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        return nodeConnections != this.maxNumRemoteConnections || this.seedsChanged(this.configuredSeedNodes, addresses) || this.proxyChanged(this.proxyAddress, proxy);
    }

    @Override
    protected RemoteConnectionStrategy.ConnectionStrategy strategyType() {
        return RemoteConnectionStrategy.ConnectionStrategy.SNIFF;
    }

    @Override
    protected void connectImpl(ActionListener<Void> listener) {
        this.collectRemoteNodes(this.seedNodes.iterator(), listener);
    }

    @Override
    protected RemoteConnectionInfo.ModeInfo getModeInfo() {
        return new SniffModeInfo(this.configuredSeedNodes, this.maxNumRemoteConnections, this.connectionManager.size());
    }

    private void collectRemoteNodes(Iterator<Supplier<DiscoveryNode>> seedNodes, ActionListener<Void> listener) {
        if (Thread.currentThread().isInterrupted()) {
            listener.onFailure(new InterruptedException("remote connect thread got interrupted"));
            return;
        }
        if (seedNodes.hasNext()) {
            Consumer<Exception> onFailure = e -> {
                if ((e instanceof ConnectTransportException || e instanceof IOException || e instanceof IllegalStateException) && seedNodes.hasNext()) {
                    logger.debug(() -> new ParameterizedMessage("fetching nodes from external cluster [{}] failed moving to next node", (Object)this.clusterAlias), (Throwable)e);
                    this.collectRemoteNodes(seedNodes, listener);
                    return;
                }
                logger.warn(() -> new ParameterizedMessage("fetching nodes from external cluster [{}] failed", (Object)this.clusterAlias), (Throwable)e);
                listener.onFailure((Exception)e);
            };
            DiscoveryNode seedNode = seedNodes.next().get();
            logger.debug("[{}] opening connection to seed node: [{}] proxy address: [{}]", (Object)this.clusterAlias, (Object)seedNode, (Object)this.proxyAddress);
            StepListener<Transport.Connection> openConnectionStep = new StepListener<Transport.Connection>();
            try {
                this.connectionManager.openConnection(seedNode, null, openConnectionStep);
            }
            catch (Exception e2) {
                onFailure.accept(e2);
            }
            StepListener<TransportService.HandshakeResponse> handshakeStep = new StepListener<TransportService.HandshakeResponse>();
            openConnectionStep.whenComplete(connection -> {
                ConnectionProfile connectionProfile = this.connectionManager.getConnectionProfile();
                this.transportService.handshake((Transport.Connection)connection, connectionProfile.getHandshakeTimeout().millis(), this.getRemoteClusterNamePredicate(), (ActionListener<TransportService.HandshakeResponse>)handshakeStep);
            }, onFailure);
            StepListener<Void> fullConnectionStep = new StepListener<Void>();
            handshakeStep.whenComplete(handshakeResponse -> {
                DiscoveryNode handshakeNode = SniffConnectionStrategy.maybeAddProxyAddress(this.proxyAddress, handshakeResponse.getDiscoveryNode());
                if (this.nodePredicate.test(handshakeNode) && this.shouldOpenMoreConnections()) {
                    this.connectionManager.connectToNode(handshakeNode, null, this.transportService.connectionValidator(handshakeNode), fullConnectionStep);
                } else {
                    fullConnectionStep.onResponse(null);
                }
            }, e -> {
                Transport.Connection connection = (Transport.Connection)openConnectionStep.result();
                logger.warn((Message)new ParameterizedMessage("failed to connect to seed node [{}]", (Object)connection.getNode()), (Throwable)e);
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                onFailure.accept((Exception)e);
            });
            fullConnectionStep.whenComplete(aVoid -> {
                if (this.remoteClusterName.get() == null) {
                    TransportService.HandshakeResponse handshakeResponse = (TransportService.HandshakeResponse)handshakeStep.result();
                    if (!$assertionsDisabled && handshakeResponse.getClusterName().value() == null) {
                        throw new AssertionError();
                    }
                    this.remoteClusterName.set((Object)handshakeResponse.getClusterName());
                }
                Transport.Connection connection = (Transport.Connection)openConnectionStep.result();
                ClusterStateRequest request = new ClusterStateRequest();
                request.clear();
                request.nodes(true);
                ThreadPool threadPool = this.transportService.getThreadPool();
                ThreadContext threadContext = threadPool.getThreadContext();
                TransportService.ContextRestoreResponseHandler<ClusterStateResponse> responseHandler = new TransportService.ContextRestoreResponseHandler<ClusterStateResponse>(threadContext.newRestorableContext(false), new SniffClusterStateResponseHandler(connection, listener, seedNodes));
                try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                    threadContext.markAsSystemContext();
                    this.transportService.sendRequest(connection, "cluster:monitor/state", (TransportRequest)request, TransportRequestOptions.EMPTY, responseHandler);
                }
            }, e -> {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)openConnectionStep.result()});
                onFailure.accept((Exception)e);
            });
        } else {
            listener.onFailure(new IllegalStateException("no seed node left"));
        }
    }

    List<String> getSeedNodes() {
        return this.configuredSeedNodes;
    }

    int getMaxConnections() {
        return this.maxNumRemoteConnections;
    }

    private Predicate<ClusterName> getRemoteClusterNamePredicate() {
        return new Predicate<ClusterName>(){

            @Override
            public boolean test(ClusterName c) {
                return SniffConnectionStrategy.this.remoteClusterName.get() == null || c.equals(SniffConnectionStrategy.this.remoteClusterName.get());
            }

            public String toString() {
                return SniffConnectionStrategy.this.remoteClusterName.get() == null ? "any cluster name" : "expected remote cluster name [" + ((ClusterName)SniffConnectionStrategy.this.remoteClusterName.get()).value() + "]";
            }
        };
    }

    private static DiscoveryNode resolveSeedNode(String clusterAlias, String address, String proxyAddress) {
        if (proxyAddress == null || proxyAddress.isEmpty()) {
            TransportAddress transportAddress = new TransportAddress(SniffConnectionStrategy.parseConfiguredAddress(address));
            return new DiscoveryNode(clusterAlias + "#" + transportAddress.toString(), transportAddress, Version.CURRENT.minimumCompatibilityVersion());
        }
        TransportAddress transportAddress = new TransportAddress(SniffConnectionStrategy.parseConfiguredAddress(proxyAddress));
        String hostName = RemoteConnectionStrategy.parseHost(proxyAddress);
        return new DiscoveryNode("", clusterAlias + "#" + address, UUIDs.randomBase64UUID(), hostName, address, transportAddress, Collections.singletonMap("server_name", hostName), DiscoveryNodeRole.BUILT_IN_ROLES, Version.CURRENT.minimumCompatibilityVersion());
    }

    static Predicate<DiscoveryNode> getNodePredicate(Settings settings) {
        if (RemoteClusterService.REMOTE_NODE_ATTRIBUTE.exists(settings)) {
            String attribute = RemoteClusterService.REMOTE_NODE_ATTRIBUTE.get(settings);
            return DEFAULT_NODE_PREDICATE.and(node -> Booleans.parseBoolean((String)node.getAttributes().getOrDefault(attribute, "false")));
        }
        return DEFAULT_NODE_PREDICATE;
    }

    private static DiscoveryNode maybeAddProxyAddress(String proxyAddress, DiscoveryNode node) {
        if (proxyAddress == null || proxyAddress.isEmpty()) {
            return node;
        }
        InetSocketAddress proxyInetAddress = SniffConnectionStrategy.parseConfiguredAddress(proxyAddress);
        return new DiscoveryNode(node.getName(), node.getId(), node.getEphemeralId(), node.getHostName(), node.getHostAddress(), new TransportAddress(proxyInetAddress), node.getAttributes(), node.getRoles(), node.getVersion());
    }

    private boolean seedsChanged(List<String> oldSeedNodes, List<String> newSeedNodes) {
        if (oldSeedNodes.size() != newSeedNodes.size()) {
            return true;
        }
        HashSet<String> oldSeeds = new HashSet<String>(oldSeedNodes);
        HashSet<String> newSeeds = new HashSet<String>(newSeedNodes);
        return !oldSeeds.equals(newSeeds);
    }

    private boolean proxyChanged(String oldProxy, String newProxy) {
        if (oldProxy == null || oldProxy.isEmpty()) {
            return !(newProxy == null || newProxy.isEmpty());
        }
        return !Objects.equals(oldProxy, newProxy);
    }

    static {
        boolean bl = $assertionsDisabled = !SniffConnectionStrategy.class.desiredAssertionStatus();
        if (!$assertionsDisabled && Version.CURRENT.major >= 8) {
            throw new AssertionError();
        }
        SEARCH_REMOTE_CLUSTERS_SEEDS = Setting.affixKeySetting("search.remote.", "seeds", key -> Setting.listSetting(key, Collections.emptyList(), s -> {
            SniffConnectionStrategy.parsePort(s);
            return s;
        }, Setting.Property.Deprecated, Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
        SEARCH_REMOTE_CLUSTER_SEEDS_UPGRADER = new SettingUpgrader<List<String>>(){

            @Override
            public Setting<List<String>> getSetting() {
                return SEARCH_REMOTE_CLUSTERS_SEEDS;
            }

            @Override
            public String getKey(String key) {
                return key.replaceFirst("^search", "cluster");
            }
        };
        REMOTE_CLUSTER_SEEDS = Setting.affixKeySetting("cluster.remote.", "seeds", (ns, key) -> Setting.listSetting(key, SEARCH_REMOTE_CLUSTERS_SEEDS.getConcreteSettingForNamespace((String)ns), s -> {
            SniffConnectionStrategy.parsePort(s);
            return s;
        }, s -> SEARCH_REMOTE_CLUSTERS_SEEDS.getConcreteSettingForNamespace((String)ns).get((Settings)s), new RemoteConnectionStrategy.StrategyValidator((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.SNIFF), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
        SEARCH_REMOTE_CLUSTERS_PROXY = Setting.affixKeySetting("search.remote.", "proxy", key -> Setting.simpleString(key, s -> {
            if (Strings.hasLength(s)) {
                SniffConnectionStrategy.parsePort(s);
            }
        }, Setting.Property.Deprecated, Setting.Property.Dynamic, Setting.Property.NodeScope), () -> REMOTE_CLUSTER_SEEDS);
        REMOTE_CLUSTERS_PROXY = Setting.affixKeySetting("cluster.remote.", "proxy", (ns, key) -> Setting.simpleString(key, new RemoteConnectionStrategy.StrategyValidator<String>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.SNIFF, s -> {
            if (Strings.hasLength(s)) {
                SniffConnectionStrategy.parsePort(s);
            }
        }), SEARCH_REMOTE_CLUSTERS_PROXY.getConcreteSettingForNamespace((String)ns), Setting.Property.Dynamic, Setting.Property.NodeScope), () -> REMOTE_CLUSTER_SEEDS);
        SEARCH_REMOTE_CONNECTIONS_PER_CLUSTER = Setting.intSetting("search.remote.connections_per_cluster", 3, 1, Setting.Property.NodeScope, Setting.Property.Deprecated);
        REMOTE_CONNECTIONS_PER_CLUSTER = Setting.intSetting("cluster.remote.connections_per_cluster", SEARCH_REMOTE_CONNECTIONS_PER_CLUSTER, 1, Setting.Property.NodeScope);
        REMOTE_NODE_CONNECTIONS = Setting.affixKeySetting("cluster.remote.", "node_connections", (ns, key) -> Setting.intSetting(key, REMOTE_CONNECTIONS_PER_CLUSTER, 1, new RemoteConnectionStrategy.StrategyValidator<Integer>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.SNIFF), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
        SEARCH_REMOTE_CLUSTERS_PROXY_UPGRADER = new SettingUpgrader<String>(){

            @Override
            public Setting<String> getSetting() {
                return SEARCH_REMOTE_CLUSTERS_PROXY;
            }

            @Override
            public String getKey(String key) {
                return key.replaceFirst("^search", "cluster");
            }
        };
        logger = LogManager.getLogger(SniffConnectionStrategy.class);
        DEFAULT_NODE_PREDICATE = node -> Version.CURRENT.isCompatible(node.getVersion()) && (!node.isMasterNode() || node.isDataNode() || node.isIngestNode());
    }

    public static class SniffModeInfo
    implements RemoteConnectionInfo.ModeInfo {
        final List<String> seedNodes;
        final int maxConnectionsPerCluster;
        final int numNodesConnected;

        public SniffModeInfo(List<String> seedNodes, int maxConnectionsPerCluster, int numNodesConnected) {
            this.seedNodes = seedNodes;
            this.maxConnectionsPerCluster = maxConnectionsPerCluster;
            this.numNodesConnected = numNodesConnected;
        }

        private SniffModeInfo(StreamInput input) throws IOException {
            this.seedNodes = Arrays.asList(input.readStringArray());
            this.maxConnectionsPerCluster = input.readVInt();
            this.numNodesConnected = input.readVInt();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray("seeds");
            for (String address : this.seedNodes) {
                builder.value(address);
            }
            builder.endArray();
            builder.field("num_nodes_connected", this.numNodesConnected);
            builder.field("max_connections_per_cluster", this.maxConnectionsPerCluster);
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.seedNodes.toArray(new String[0]));
            out.writeVInt(this.maxConnectionsPerCluster);
            out.writeVInt(this.numNodesConnected);
        }

        @Override
        public boolean isConnected() {
            return this.numNodesConnected > 0;
        }

        @Override
        public String modeName() {
            return "sniff";
        }

        public List<String> getSeedNodes() {
            return this.seedNodes;
        }

        public int getMaxConnectionsPerCluster() {
            return this.maxConnectionsPerCluster;
        }

        public int getNumNodesConnected() {
            return this.numNodesConnected;
        }

        @Override
        public RemoteConnectionStrategy.ConnectionStrategy modeType() {
            return RemoteConnectionStrategy.ConnectionStrategy.SNIFF;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SniffModeInfo sniff = (SniffModeInfo)o;
            return this.maxConnectionsPerCluster == sniff.maxConnectionsPerCluster && this.numNodesConnected == sniff.numNodesConnected && Objects.equals(this.seedNodes, sniff.seedNodes);
        }

        public int hashCode() {
            return Objects.hash(this.seedNodes, this.maxConnectionsPerCluster, this.numNodesConnected);
        }
    }

    private class SniffClusterStateResponseHandler
    implements TransportResponseHandler<ClusterStateResponse> {
        private final Transport.Connection connection;
        private final ActionListener<Void> listener;
        private final Iterator<Supplier<DiscoveryNode>> seedNodes;

        SniffClusterStateResponseHandler(Transport.Connection connection, ActionListener<Void> listener, Iterator<Supplier<DiscoveryNode>> seedNodes) {
            this.connection = connection;
            this.listener = listener;
            this.seedNodes = seedNodes;
        }

        @Override
        public ClusterStateResponse read(StreamInput in) throws IOException {
            return new ClusterStateResponse(in);
        }

        @Override
        public void handleResponse(ClusterStateResponse response) {
            this.handleNodes(response.getState().nodes().getNodes().valuesIt());
        }

        private void handleNodes(final Iterator<DiscoveryNode> nodesIter) {
            while (nodesIter.hasNext()) {
                final DiscoveryNode node = SniffConnectionStrategy.maybeAddProxyAddress(SniffConnectionStrategy.this.proxyAddress, nodesIter.next());
                if (!SniffConnectionStrategy.this.nodePredicate.test(node) || !SniffConnectionStrategy.this.shouldOpenMoreConnections()) continue;
                SniffConnectionStrategy.this.connectionManager.connectToNode(node, null, SniffConnectionStrategy.this.transportService.connectionValidator(node), new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void aVoid) {
                        SniffClusterStateResponseHandler.this.handleNodes(nodesIter);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        if (e instanceof ConnectTransportException || e instanceof IllegalStateException) {
                            logger.debug(() -> new ParameterizedMessage("failed to connect to node {}", (Object)node), (Throwable)e);
                            SniffClusterStateResponseHandler.this.handleNodes(nodesIter);
                        } else {
                            logger.warn(() -> new ParameterizedMessage("fetching nodes from external cluster {} failed", (Object)SniffConnectionStrategy.this.clusterAlias), (Throwable)e);
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{SniffClusterStateResponseHandler.this.connection});
                            SniffConnectionStrategy.this.collectRemoteNodes(SniffClusterStateResponseHandler.this.seedNodes, SniffClusterStateResponseHandler.this.listener);
                        }
                    }
                });
                return;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.connection});
            this.listener.onResponse(null);
        }

        @Override
        public void handleException(TransportException exp) {
            logger.warn(() -> new ParameterizedMessage("fetching nodes from external cluster {} failed", (Object)SniffConnectionStrategy.this.clusterAlias), (Throwable)exp);
            try {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.connection});
            }
            finally {
                SniffConnectionStrategy.this.collectRemoteNodes(this.seedNodes, this.listener);
            }
        }

        @Override
        public String executor() {
            return "management";
        }
    }
}

