/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm;

import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.TypePath;

public abstract class ClassVisitor {
    protected final int api;
    protected ClassVisitor cv;

    public ClassVisitor(int api) {
        this(api, null);
    }

    public ClassVisitor(int api, ClassVisitor classVisitor) {
        if (api != 458752 && api != 393216 && api != 327680 && api != 262144) {
            throw new IllegalArgumentException("Unsupported api " + api);
        }
        this.api = api;
        this.cv = classVisitor;
    }

    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        if (this.cv != null) {
            this.cv.visit(version, access, name2, signature, superName, interfaces2);
        }
    }

    public void visitSource(String source2, String debug) {
        if (this.cv != null) {
            this.cv.visitSource(source2, debug);
        }
    }

    public ModuleVisitor visitModule(String name2, int access, String version) {
        if (this.api < 393216) {
            throw new UnsupportedOperationException("This feature requires ASM6");
        }
        if (this.cv != null) {
            return this.cv.visitModule(name2, access, version);
        }
        return null;
    }

    public void visitNestHost(String nestHost) {
        if (this.api < 458752) {
            throw new UnsupportedOperationException("This feature requires ASM7");
        }
        if (this.cv != null) {
            this.cv.visitNestHost(nestHost);
        }
    }

    public void visitOuterClass(String owner2, String name2, String descriptor) {
        if (this.cv != null) {
            this.cv.visitOuterClass(owner2, name2, descriptor);
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (this.cv != null) {
            return this.cv.visitAnnotation(descriptor, visible);
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException("This feature requires ASM5");
        }
        if (this.cv != null) {
            return this.cv.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }
        return null;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.cv != null) {
            this.cv.visitAttribute(attribute);
        }
    }

    public void visitNestMember(String nestMember) {
        if (this.api < 458752) {
            throw new UnsupportedOperationException("This feature requires ASM7");
        }
        if (this.cv != null) {
            this.cv.visitNestMember(nestMember);
        }
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        if (this.cv != null) {
            this.cv.visitInnerClass(name2, outerName, innerName, access);
        }
    }

    public FieldVisitor visitField(int access, String name2, String descriptor, String signature, Object value2) {
        if (this.cv != null) {
            return this.cv.visitField(access, name2, descriptor, signature, value2);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature, String[] exceptions) {
        if (this.cv != null) {
            return this.cv.visitMethod(access, name2, descriptor, signature, exceptions);
        }
        return null;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }
}

