
#ifndef KRUNNER_EXPORT_H
#define KRUNNER_EXPORT_H

#ifdef KRUNNER_STATIC_DEFINE
#  define KRUNNER_EXPORT
#  define KRUNNER_NO_EXPORT
#else
#  ifndef KRUNNER_EXPORT
#    ifdef KF5Runner_EXPORTS
        /* We are building this library */
#      define KRUNNER_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KRUNNER_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KRUNNER_NO_EXPORT
#    define KRUNNER_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KRUNNER_DECL_DEPRECATED
#  define KRUNNER_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KRUNNER_DECL_DEPRECATED_EXPORT
#  define KRUNNER_DECL_DEPRECATED_EXPORT KRUNNER_EXPORT KRUNNER_DECL_DEPRECATED
#endif

#ifndef KRUNNER_DECL_DEPRECATED_NO_EXPORT
#  define KRUNNER_DECL_DEPRECATED_NO_EXPORT KRUNNER_NO_EXPORT KRUNNER_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KRUNNER_NO_DEPRECATED
#    define KRUNNER_NO_DEPRECATED
#  endif
#endif

#define KRUNNER_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KRUNNER_NO_DEPRECATED) && !defined(KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KRUNNER_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KRUNNER_NO_DEPRECATED_WARNINGS) && !defined(KRUNNER_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KRUNNER_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KRUNNER_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KRUNNER_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KRUNNER_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KRUNNER_NO_DEPRECATED)
#  undef KRUNNER_DEPRECATED
#  define KRUNNER_DEPRECATED_EXPORT KRUNNER_EXPORT
#  define KRUNNER_DEPRECATED_NO_EXPORT KRUNNER_NO_EXPORT
#elif defined(KRUNNER_NO_DEPRECATED_WARNINGS)
#  define KRUNNER_DEPRECATED
#  define KRUNNER_DEPRECATED_EXPORT KRUNNER_EXPORT
#  define KRUNNER_DEPRECATED_NO_EXPORT KRUNNER_NO_EXPORT
#else
#  define KRUNNER_DEPRECATED KRUNNER_DECL_DEPRECATED
#  define KRUNNER_DEPRECATED_EXPORT KRUNNER_DECL_DEPRECATED_EXPORT
#  define KRUNNER_DEPRECATED_NO_EXPORT KRUNNER_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KRUNNER_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KRUNNER_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KRUNNER_NO_DEPRECATED
#  define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT 0x54600
#endif
#ifdef KRUNNER_NO_DEPRECATED_WARNINGS
#  define KRUNNER_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KRUNNER_DEPRECATED_WARNINGS_SINCE
#  ifdef KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KRUNNER_DEPRECATED_WARNINGS_SINCE KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KRUNNER_DEPRECATED_WARNINGS_SINCE 0x54600
#  endif
#endif

#ifndef KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KRUNNER_DEPRECATED
#  define KRUNNER_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KRUNNER_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x51c00
#  define KRUNNER_DEPRECATED_VERSION_5_28(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_28(text)
#endif
#define KRUNNER_DEPRECATED_VERSION_5(minor, text)      KRUNNER_DEPRECATED_VERSION_5_##minor(text)
#define KRUNNER_DEPRECATED_VERSION(major, minor, text) KRUNNER_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)

#endif /* KRUNNER_EXPORT_H */
