/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_mi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ANG = "ANG";
        final String metaValue_ARS = "ARS";
        final String metaValue_AWG = "AWG";
        final String metaValue_BBD = "BBD";
        final String metaValue_BMD = "BMD";
        final String metaValue_BSD = "BSD";
        final String metaValue_BZD = "BZD";
        final String metaValue_CRC = "CRC";
        final String metaValue_CUC = "CUC";
        final String metaValue_CUP = "CUP";
        final String metaValue_DOP = "DOP";
        final String metaValue_GTQ = "GTQ";
        final String metaValue_HNL = "HNL";
        final String metaValue_HTG = "HTG";
        final String metaValue_JMD = "JMD";
        final String metaValue_KYD = "KYD";
        final String metaValue_NIO = "NIO";
        final String metaValue_PAB = "PAB";
        final String metaValue_TTD = "TTD";
        final Object[][] data = new Object[][] {
            { "jmd", metaValue_JMD },
            { "BBD", metaValue_BBD },
            { "GTQ", metaValue_GTQ },
            { "HNL", metaValue_HNL },
            { "usd", "T\u0101ra US" },
            { "bzd", metaValue_BZD },
            { "CUC", metaValue_CUC },
            { "pab", metaValue_PAB },
            { "BSD", metaValue_BSD },
            { "nio", metaValue_NIO },
            { "KYD", metaValue_KYD },
            { "nzd", "T\u0101ra o Aotearoa" },
            { "brl", "Real Parahi" },
            { "CUP", metaValue_CUP },
            { "mxn", "MXN" },
            { "DOP", metaValue_DOP },
            { "bbd", metaValue_BBD },
            { "gtq", metaValue_GTQ },
            { "hnl", metaValue_HNL },
            { "cuc", metaValue_CUC },
            { "bsd", metaValue_BSD },
            { "CRC", metaValue_CRC },
            { "kyd", metaValue_KYD },
            { "ANG", metaValue_ANG },
            { "HTG", metaValue_HTG },
            { "cup", metaValue_CUP },
            { "ARS", metaValue_ARS },
            { "eur", "Euro" },
            { "dop", metaValue_DOP },
            { "TTD", metaValue_TTD },
            { "cad", "CAD" },
            { "AWG", metaValue_AWG },
            { "JPY", "\u00a5" },
            { "crc", metaValue_CRC },
            { "BMD", metaValue_BMD },
            { "xcd", "XCD" },
            { "htg", metaValue_HTG },
            { "ang", metaValue_ANG },
            { "RUB", "RUB" },
            { "JMD", metaValue_JMD },
            { "ars", metaValue_ARS },
            { "ttd", metaValue_TTD },
            { "inr", "Rupee Iniana" },
            { "BZD", metaValue_BZD },
            { "cny", "Yuan Haina" },
            { "awg", metaValue_AWG },
            { "PAB", metaValue_PAB },
            { "jpy", "Yen Hapanihi" },
            { "gbp", "P\u0101una Piritene" },
            { "NIO", metaValue_NIO },
            { "bmd", metaValue_BMD },
            { "NZD", "$" },
            { "xxx", "Moni T\u0113 M\u014dhiotia" },
            { "rub", "R\u016bpera Ruhiana" },
        };
        return data;
    }
}
