/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0430\u0440\u0430\u0431";
        final String metaValue_bn = "\u0431\u0435\u043d\u0433\u0430\u043b";
        final String metaValue_bo = "\u0442\u04e9\u0432\u0434";
        final String metaValue_el = "\u0433\u0440\u0435\u043a";
        final String metaValue_gu = "\u0433\u0443\u0436\u0430\u0440\u0430\u0442\u0438";
        final String metaValue_he = "\u0435\u0432\u0440\u0435\u0439";
        final String metaValue_ja = "\u044f\u043f\u043e\u043d";
        final String metaValue_ka = "\u0433\u04af\u0440\u0436";
        final String metaValue_km = "\u043a\u0445\u043c\u0435\u0440";
        final String metaValue_kn = "\u043a\u0430\u043d\u043d\u0430\u0434\u0430";
        final String metaValue_ko = "\u0441\u043e\u043b\u043e\u043d\u0433\u043e\u0441";
        final String metaValue_la = "\u043b\u0430\u0442\u0438\u043d";
        final String metaValue_lo = "\u043b\u0430\u043e\u0441";
        final String metaValue_ml = "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c";
        final String metaValue_or = "\u043e\u0440\u0438\u044f";
        final String metaValue_si = "\u0441\u0438\u043d\u0445\u0430\u043b\u0430";
        final String metaValue_ta = "\u0442\u0430\u043c\u0438\u043b";
        final String metaValue_te = "\u0442\u044d\u043b\u04af\u0433\u04af";
        final String metaValue_th = "\u0442\u0430\u0439";
        final Object[][] data = new Object[][] {
            { "ksh", "\u043a\u0451\u043b\u044c\u0448" },
            { "mwl", "\u043c\u0435\u0440\u0430\u043d\u0434\u0438" },
            { "Zsym", "\u0442\u044d\u043c\u0434\u044d\u0433" },
            { "Zsye", "\u044d\u043c\u043e\u0436\u0438" },
            { "tem", "\u0442\u0438\u043c\u043d" },
            { "teo", "\u0442\u044d\u0441\u043e" },
            { "rap", "\u0440\u0430\u043f\u0430\u043d\u0443\u0438" },
            { "AC", "\u0410\u0441\u0435\u043d\u0441\u0438\u043e\u043d \u0430\u0440\u0430\u043b" },
            { "rar", "\u0440\u0430\u0440\u043e\u0442\u043e\u043d\u0433" },
            { "tet", "\u0442\u0435\u0442\u0443\u043c" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u0410\u0440\u0430\u0431\u044b\u043d \u041d\u044d\u0433\u0434\u0441\u044d\u043d \u042d\u043c\u0438\u0440\u0442 \u0423\u043b\u0441" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434" },
            { "AF", "\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0431\u0430 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "type.ca.ethiopic", "\u044d\u0442\u0438\u043e\u043f \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u044c\u044f" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438" },
            { "AM", "\u0410\u0440\u043c\u0435\u043d\u0438" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u0421\u0430\u043c\u043e\u0430" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "en_US", "\u0430\u043c\u0435\u0440\u0438\u043a-\u0430\u043d\u0433\u043b\u0438" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0436\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438-\u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u043e" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "kum", "\u043a\u0443\u043c\u0443\u043a" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0438" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440" },
            { "BH", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d\u0442-\u0411\u0430\u0440\u0442\u0435\u043b\u044c\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0430" },
            { "myv", "\u044d\u0440\u0437\u044f" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438" },
            { "BQ", "\u041a\u0430\u0440\u0438\u0431\u044b\u043d \u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435 \u0430\u0440\u0430\u043b" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437\u0435" },
            { "type.ca.persian", "\u043f\u0435\u0440\u0441 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.nu.hebr", "\u0435\u0432\u0440\u0435\u0439 \u0442\u043e\u043e" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u0439\u043b\u0438\u043d\u0433) \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043d\u0434\u0435\u0440\u0430\u043d\u0438" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e-\u041a\u0438\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u0422\u04e9\u0432 \u0410\u0444\u0440\u0438\u043a\u0438\u0439\u043d \u0411\u04af\u0433\u0434 \u041d\u0430\u0439\u0440\u0430\u043c\u0434\u0430\u0445 \u0423\u043b\u0441" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e-\u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u044c" },
            { "CI", "\u041a\u043e\u0442-\u0434\u2019\u0418\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u04af\u04af\u043a\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u0425\u044f\u0442\u0430\u0434" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438" },
            { "CP", "\u041a\u043b\u0438\u043f\u043f\u0435\u0440\u0442\u043e\u043d \u0430\u0440\u0430\u043b" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0417\u0443\u043b \u0441\u0430\u0440\u044b\u043d \u0430\u0440\u0430\u043b" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "CZ", "\u0427\u0435\u0445" },
            { "eka", "\u044d\u043a\u0430\u0436\u0443\u043a" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d" },
            { "ace", "\u0430\u0447\u0438\u043d" },
            { "cgg", "\u0447\u0438\u0433\u0430" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e \u0413\u0430\u0440\u0441\u0438\u0430" },
            { "type.nu.deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438 \u0442\u043e\u043e" },
            { "DJ", "\u0414\u0436\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438" },
            { "Brai", "\u0431\u0440\u0430\u0439\u043b" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "type.nu.armnlow", "\u0436\u0438\u0436\u0438\u0433 \u0430\u0440\u043c\u0435\u043d \u0442\u043e\u043e" },
            { "DO", "\u0411\u04af\u0433\u0434 \u041d\u0430\u0439\u0440\u0430\u043c\u0434\u0430\u0445 \u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0423\u043b\u0441" },
            { "gor", "\u0433\u043e\u0440\u043e\u043d\u0442\u0430\u043b\u043e" },
            { "zun", "\u0437\u0443\u043d\u0438" },
            { "tig", "\u0442\u0438\u0433\u0440" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "pag", "\u043f\u0430\u043d\u0433\u0430\u0441\u0438\u043d" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0431\u0430 \u041c\u0435\u043b\u0438\u043b\u044c\u044f" },
            { "pam", "\u043f\u0430\u043c\u043f\u0430\u043d\u0433\u0430" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "pap", "\u043f\u0430\u043f\u044c\u044f\u043c\u0435\u043d\u0442\u043e" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u044d" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438" },
            { "EG", "\u0415\u0433\u0438\u043f\u0435\u0442" },
            { "EH", "\u0411\u0430\u0440\u0443\u0443\u043d \u0421\u0430\u0445\u0430\u0440" },
            { "pau", "\u043f\u0430\u043b\u0430\u0443" },
            { "chk", "\u0447\u0443\u0443\u043a" },
            { "chm", "\u043c\u0430\u0440\u0438 \u0445\u044d\u043b" },
            { "cho", "\u0447\u043e\u043a\u0442\u0430\u0443" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u0438" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u0439" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438" },
            { "ET", "\u042d\u0442\u0438\u043e\u043f" },
            { "EU", "\u0415\u0432\u0440\u043e\u043f\u044b\u043d \u0425\u043e\u043b\u0431\u043e\u043e" },
            { "type.ca.gregorian", "\u0433\u0440\u0435\u0433\u043e\u0440\u0438\u0439\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "EZ", "\u0415\u0432\u0440\u043e \u0431\u04af\u0441" },
            { "chy", "\u0447\u044d\u0435\u043d\u043d" },
            { "type.nu.gujr", "\u0433\u04af\u0436\u0430\u0440\u0430\u0442\u0438 \u0442\u043e\u043e" },
            { "ady", "\u0430\u0434\u0438\u0433\u044d" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434" },
            { "FJ", "\u0424\u0438\u0436\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "Taml", metaValue_ta },
            { "FR", "\u0424\u0440\u0430\u043d\u0446" },
            { "root", "\u0440\u0443\u0442" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "GB", "\u0418\u0445 \u0411\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "pcm", "\u043d\u0438\u0433\u0435\u0440\u0438\u0439\u043d \u043f\u0438\u0434\u0436\u0438\u043d" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u04af\u0440\u0436" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u0413\u0432\u0438\u0430\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u0439" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u044b\u043d \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "GR", "\u0413\u0440\u0435\u043a" },
            { "GS", "\u04e8\u043c\u043d\u04e9\u0434 \u0416\u043e\u0440\u0436\u0438\u0430 \u0431\u0430 \u04e8\u043c\u043d\u04e9\u0434 \u0421\u044d\u043d\u0434\u0432\u0438\u0447\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u0439-\u0411\u0438\u0441\u0430\u0443" },
            { "tlh", "\u043a\u043b\u0438\u043d\u0433\u043e\u043d" },
            { "GY", "\u0413\u0430\u0439\u0430\u043d\u0430" },
            { "ckb", "\u0442\u04e9\u0432 \u043a\u0443\u0440\u0434" },
            { "zxx", "\u0445\u044d\u043b \u0437\u04af\u0439\u043d \u0430\u0433\u0443\u0443\u043b\u0433\u0430\u0433\u04af\u0439" },
            { "de_AT", "\u0430\u0432\u0441\u0442\u0440\u0438-\u0433\u0435\u0440\u043c\u0430\u043d" },
            { "HK", "\u0411\u041d\u0425\u0410\u0423-\u044b\u043d \u0422\u0443\u0441\u0433\u0430\u0439 \u0437\u0430\u0445\u0438\u0440\u0433\u0430\u0430\u043d\u044b \u0431\u04af\u0441 \u0425\u043e\u043d\u0433 \u041a\u043e\u043d\u0433" },
            { "HM", "\u0425\u0435\u0440\u0434 \u0431\u0430 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442" },
            { "agq", "\u0430\u0433\u0435\u043c" },
            { "gsw", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438-\u0433\u0435\u0440\u043c\u0430\u043d" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "HU", "\u0423\u043d\u0433\u0430\u0440" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434" },
            { "nap", "\u043d\u0435\u0430\u043f\u043e\u043b\u0438\u0442\u0430\u043d" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "zza", "\u0437\u0430\u0437\u0430" },
            { "IL", "\u0418\u0437\u0440\u0430\u0438\u043b\u044c" },
            { "IM", "\u041c\u044d\u043d \u0410\u0440\u0430\u043b" },
            { "IN", "\u042d\u043d\u044d\u0442\u0445\u044d\u0433" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0439\u043d \u0445\u0430\u0440\u044c\u044f\u0430 \u042d\u043d\u044d\u0442\u0445\u044d\u0433\u0438\u0439\u043d \u0434\u0430\u043b\u0430\u0439 \u0434\u0430\u0445\u044c \u043d\u0443\u0442\u0430\u0433 \u0434\u044d\u0432\u0441\u0433\u044d\u0440" },
            { "IQ", "\u0418\u0440\u0430\u043a" },
            { "IR", "\u0418\u0440\u0430\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438" },
            { "Zmth", "\u043c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u043a \u0442\u043e\u043e\u043b\u043b\u044b\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "type.nu.thai", "\u0442\u0430\u0439 \u0442\u043e\u043e" },
            { "type.nu.beng", "\u0431\u0435\u043d\u0433\u0430\u043b \u0442\u043e\u043e" },
            { "JE", "\u0416\u0435\u0440\u0441\u0438" },
            { "type.ca.islamic", "\u0438\u0441\u043b\u0430\u043c\u044b\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "Beng", metaValue_bn },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "JO", "\u0419\u043e\u0440\u0434\u0430\u043d" },
            { "JP", "\u042f\u043f\u043e\u043d" },
            { "ain", "\u0430\u0439\u043d\u0443" },
            { "guz", "\u0433\u0443\u0437\u044b" },
            { "type.nu.knda", "\u043a\u0430\u043d\u043d\u0430\u0434\u0430 \u0442\u043e\u043e" },
            { "de_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u044c-\u0433\u0435\u0440\u043c\u0430\u043d" },
            { "type.ca.buddhist", "\u0431\u0443\u0434\u0434\u044b\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "KE", "\u041a\u0435\u043d\u0438" },
            { "419", "\u041b\u0430\u0442\u0438\u043d \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "KG", "\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0436" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "Knda", metaValue_kn },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0442\u0441 \u0431\u0430 \u041d\u0435\u0432\u0438\u0441" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434-\u0444\u0440\u0430\u043d\u0446" },
            { "KP", "\u0425\u043e\u0439\u0434 \u0421\u043e\u043b\u043e\u043d\u0433\u043e\u0441" },
            { "KR", "\u04e8\u043c\u043d\u04e9\u0434 \u0421\u043e\u043b\u043e\u043d\u0433\u043e\u0441" },
            { "fr_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438-\u0444\u0440\u0430\u043d\u0446" },
            { "KW", "\u041a\u0443\u0432\u0435\u0439\u0442" },
            { "tpi", "\u0442\u043e\u043a \u043f\u0438\u0441\u0438\u043d" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d\u044b \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u043b" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442 \u041b\u044e\u0441\u0438\u0430" },
            { "gwi", "\u0433\u0432\u0438\u0447\u0438\u043d" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438" },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "LY", "\u041b\u0438\u0432\u0438" },
            { "lad", "\u043b\u0430\u0434\u0438\u043d" },
            { "vun", "\u0432\u0443\u043d\u0436\u043e" },
            { "lag", "\u043b\u0430\u043d\u0433\u0438" },
            { "Thaa", "\u0442\u0430\u043d\u0430" },
            { "MA", "\u041c\u043e\u0440\u043e\u043a\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u0430\u0432" },
            { "ME", "\u041c\u043e\u043d\u0442\u0435\u043d\u0435\u0433\u0440\u043e" },
            { "MF", "\u0421\u0435\u043d\u0442-\u041c\u0430\u0440\u0442\u0438\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "Thai", metaValue_th },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "ale", "\u0430\u043b\u044e\u0442" },
            { "MK", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u044c\u044f\u043d\u043c\u0430\u0440" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b" },
            { "new", "\u043d\u0435\u0432\u0430\u0440\u0438" },
            { "MO", "\u0411\u041d\u0425\u0410\u0423-\u044b\u043d \u0422\u0443\u0441\u0433\u0430\u0439 \u0437\u0430\u0445\u0438\u0440\u0433\u0430\u0430\u043d\u044b \u0431\u04af\u0441 \u041c\u0430\u043a\u0430\u043e" },
            { "MP", "\u0425\u043e\u0439\u0434 \u041c\u0430\u0440\u0438\u0430\u043d\u044b \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439" },
            { "alt", "\u04e9\u043c\u043d\u04e9\u0434 \u0430\u043b\u0442\u0430\u0439" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a" },
            { "type.ca.japanese", "\u044f\u043f\u043e\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438" },
            { "202", "\u0421\u0430\u0445\u0430\u0440\u044b\u043d \u0446\u04e9\u043b\u0438\u0439\u043d \u0443\u0440\u0434 \u0445\u044d\u0441\u0433\u0438\u0439\u043d \u0410\u0444\u0440\u0438\u043a" },
            { "type.ca.hebrew", "\u0435\u0432\u0440\u0435\u0439 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "NC", "\u0428\u0438\u043d\u044d \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0430\u0440\u0430\u043b" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438" },
            { "trv", "\u0442\u0430\u0440\u043e\u043a\u043e" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438" },
            { "NP", "\u0411\u0430\u043b\u0431\u0430" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e" },
            { "NZ", "\u0428\u0438\u043d\u044d \u0417\u0435\u043b\u0430\u043d\u0434" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "anp", "\u0430\u043d\u0433\u0438\u043a" },
            { "crs", "\u0441\u0435\u0441\u0435\u043b\u0432\u0430 \u043a\u0440\u0435\u043e\u043b \u0444\u0440\u0430\u043d\u0446" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c" },
            { "en_GB", "\u0431\u0440\u0438\u0442\u0430\u043d\u0438-\u0430\u043d\u0433\u043b\u0438" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u041f\u043e\u043b\u0438\u043d\u0435\u0437" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u0428\u0438\u043d\u044d \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448" },
            { "ewo", "\u044d\u0432\u043e\u043d\u0434\u043e" },
            { "PM", "\u0421\u0435\u043d\u0442-\u041f\u044c\u0435\u0440 \u0431\u0430 \u041c\u0438\u043a\u0435\u043b\u043e" },
            { "PN", "\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u044b \u043d\u0443\u0442\u0430\u0433 \u0434\u044d\u0432\u0441\u0433\u044d\u0440" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "nia", "\u043d\u0438\u0430\u0441 \u0445\u044d\u043b" },
            { "type.nu.greklow", "\u0436\u0438\u0436\u0438\u0433 \u0433\u0440\u0435\u043a \u0442\u043e\u043e" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "tum", "\u0442\u0443\u043c\u0431\u0443\u043b\u0430" },
            { "Hebr", metaValue_he },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "niu", "\u043d\u0438\u0443\u044d" },
            { "QO", "\u041d\u043e\u043c\u0445\u043e\u043d \u0434\u0430\u043b\u0430\u0439\u0433 \u0442\u043e\u0439\u0440\u0441\u043e\u043d \u0443\u043b\u0441 \u043e\u0440\u043d\u0443\u0443\u0434" },
            { "lez", "\u043b\u0435\u0437\u0433\u0438" },
            { "tvl", "\u0442\u0443\u0432\u0430\u043b\u0443" },
            { "001", "\u0414\u044d\u043b\u0445\u0438\u0439" },
            { "002", "\u0410\u0444\u0440\u0438\u043a" },
            { "003", "\u0425\u043e\u0439\u0434 \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "RE", "\u0420\u0435\u044e\u043d\u0438\u043e\u043d" },
            { "005", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "jbo", "\u043b\u043e\u0436\u0431\u0430\u043d" },
            { "009", "\u041d\u043e\u043c\u0445\u043e\u043d \u0434\u0430\u043b\u0430\u0439\u043d \u043e\u0440\u043d\u0443\u0443\u0434" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438" },
            { "RU", "\u041e\u0440\u043e\u0441" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u0430\u0443\u0434\u044b\u043d \u0410\u0440\u0430\u0431" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u044b \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "twq", "\u0442\u0430\u0441\u0430\u0432\u0430\u043a" },
            { "011", "\u0411\u0430\u0440\u0443\u0443\u043d \u0410\u0444\u0440\u0438\u043a" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "013", "\u0422\u04e9\u0432 \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "SE", "\u0428\u0432\u0435\u0434" },
            { "014", "\u0417\u04af\u04af\u043d \u0410\u0444\u0440\u0438\u043a" },
            { "015", "\u0425\u043e\u0439\u0434 \u0410\u0444\u0440\u0438\u043a" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u0421\u0435\u043d\u0442 \u0425\u0435\u043b\u0435\u043d\u0430" },
            { "type.lb.strict", "\u0448\u0443\u043b\u0443\u0443\u043d \u043c\u04e9\u0440\u0438\u0439\u043d \u0437\u0430\u0439\u043d \u0437\u0430\u0433\u0432\u0430\u0440" },
            { "017", "\u0422\u04e9\u0432 \u0410\u0444\u0440\u0438\u043a" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438" },
            { "018", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u0444\u0440\u0438\u043a \u0442\u0438\u0432" },
            { "SJ", "\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0431\u0430 \u042f\u043d \u041c\u0430\u0439\u0435\u043d" },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "arn", "\u043c\u0430\u043f\u04af\u0447\u0438" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u0433\u043e" },
            { "type.nu.taml", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0442\u0430\u043c\u0438\u043b \u0442\u043e\u043e" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "SS", "\u04e8\u043c\u043d\u04e9\u0434 \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0431\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "SV", "\u042d\u043b\u044c \u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0438\u043d\u0442 \u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u0438\u0440\u0438" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0430\u043d\u0434" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d \u0434\u0430 \u041a\u0443\u043d\u044a\u044f" },
            { "asa", "\u0430\u0441\u0443" },
            { "type.ms.ussystem", "\u0410\u043c\u0435\u0440\u0438\u043a \u043d\u044d\u0433\u0436\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "021", "\u0425\u043e\u0439\u0434 \u0410\u043c\u0435\u0440\u0438\u043a \u0442\u0438\u0432" },
            { "TC", "\u0422\u0443\u0440\u043a \u0431\u0430 \u041a\u0430\u0439\u043a\u043e\u0441\u044b\u043d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "yav", "\u044f\u043d\u0433\u0431\u0435\u043d" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u04e9\u043c\u043d\u04e9\u0434 \u0433\u0430\u0437\u0430\u0440 \u043d\u0443\u0442\u0430\u0433" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0439\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "029", "\u041a\u0430\u0440\u0438\u0431\u044b\u043d \u0442\u044d\u043d\u0433\u0438\u0441" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0422\u0438\u043c\u043e\u0440-\u041b\u0435\u0441\u0442\u0435" },
            { "ybb", "\u0435\u043c\u0431\u0430" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u043a" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0431\u0430 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u0438" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438" },
            { "nmg", "\u043a\u0432\u0430\u0437\u0438\u043e" },
            { "Zzzz", "\u0442\u043e\u0434\u043e\u0440\u0445\u043e\u0439\u0433\u04af\u0439 \u0431\u0438\u0447\u0438\u0433" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d" },
            { "rup", "\u0430\u0440\u043e\u043c\u0430\u043d\u044b" },
            { "030", "\u0417\u04af\u04af\u043d \u0410\u0437\u0438" },
            { "tyv", "\u0442\u0443\u0432\u0430" },
            { "sw_CD", "\u043a\u043e\u043d\u0433\u043e\u0433\u0438\u0439\u043d \u0441\u0432\u0430\u0445\u0438\u043b\u0438" },
            { "034", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u0437\u0438" },
            { "035", "\u0417\u04af\u04af\u043d \u04e9\u043c\u043d\u04e9\u0434 \u0410\u0437\u0438" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "039", "\u04e8\u043c\u043d\u04e9\u0434 \u0415\u0432\u0440\u043e\u043f" },
            { "Sinh", metaValue_si },
            { "UM", "\u0410\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u041d\u044d\u0433\u0434\u0441\u044d\u043d \u0423\u043b\u0441\u044b\u043d \u0431\u0430\u0433\u0430 \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "UN", "\u041d\u044d\u0433\u0434\u0441\u044d\u043d \u04ae\u043d\u0434\u044d\u0441\u0442\u043d\u0438\u0439 \u0411\u0430\u0439\u0433\u0443\u0443\u043b\u043b\u0430\u0433\u0430" },
            { "US", "\u0410\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u041d\u044d\u0433\u0434\u0441\u044d\u043d \u0423\u043b\u0441" },
            { "haw", "\u0445\u0430\u0432\u0430\u0439" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "prg", "\u043f\u0440\u0443\u0441\u0441" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "tzm", "\u0422\u04e9\u0432 \u0410\u0442\u043b\u0430\u0441\u044b\u043d \u0442\u0430\u043c\u0430\u0437\u0430\u0439\u0442" },
            { "nnh", "\u043d\u0433\u0438\u0435\u043c\u0431\u04af\u04af\u043d" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d \u0445\u043e\u0442 \u0443\u043b\u0441" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0431\u0430 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0439\u043d \u0412\u0438\u0440\u0436\u0438\u043d\u0438\u0439 \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "VI", "\u0410\u041d\u0423-\u044b\u043d \u0412\u0438\u0440\u0436\u0438\u043d\u0438\u0439 \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "nog", "\u043d\u043e\u0433\u0430\u0438" },
            { "rwk", "\u0440\u0432\u0430" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438-\u0410\u0437\u0438" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u0431\u0430 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0439\u043d \u0431\u04af\u0441" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430" },
            { "wae", "\u0443\u043e\u043b\u0441\u044d\u0440" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "wal", "\u0443\u043e\u043b\u043b\u0430\u0439\u0442\u0442\u0430" },
            { "war", "\u0432\u0430\u0440\u0430\u0439" },
            { "awa", "\u0430\u0432\u0430\u0434\u0445\u0438" },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0431\u0438\u0447\u0438\u0433\u0434\u044d\u044d\u0433\u04af\u0439" },
            { "YE", "\u0419\u0435\u043c\u0435\u043d" },
            { "nqo", "\u043d\u043a\u043e" },
            { "type.co.standard", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "ZA", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u0444\u0440\u0438\u043a" },
            { "type.lb.loose", "\u0443\u0440\u0442 \u043c\u04e9\u0440\u0438\u0439\u043d \u0437\u0430\u0439\u043d \u0437\u0430\u0433\u0432\u0430\u0440" },
            { "Deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438" },
            { "type.nu.geor", "\u0433\u04af\u0440\u0436 \u0442\u043e\u043e" },
            { "Hira", "\u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u0422\u043e\u0434\u043e\u0440\u0445\u043e\u0439\u0433\u04af\u0439 \u0431\u04af\u0441" },
            { "type.ms.metric", "\u043c\u0435\u0442\u0440\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "type.ca.iso8601", "ISO-8601 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "nso", "\u0445\u043e\u0439\u0434 \u0441\u043e\u0442\u043e" },
            { "type.nu.telu", "\u0442\u044d\u043b\u04af\u0433\u04af \u0442\u043e\u043e" },
            { "loz", "\u043b\u043e\u0437\u0438" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u044d" },
            { "type.nu.hansfin", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d \u0445\u044f\u0442\u0430\u0434 \u0441\u0430\u043d\u0445\u04af\u04af\u0433\u0438\u0439\u043d \u0442\u043e\u043e" },
            { "hil", "\u0445\u0438\u043b\u0438\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "type.nu.arabext", "\u04e9\u0440\u0433\u04e9\u0442\u0433\u04e9\u0441\u04e9\u043d \u0430\u0440\u0430\u0431-\u044d\u043d\u044d\u0442\u0445\u044d\u0433 \u0442\u043e\u043e" },
            { "nus", "\u043d\u0443\u0435\u0440" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0430" },
            { "type.nu.fullwide", "\u0431\u04af\u0440\u044d\u043d \u0445\u044d\u043c\u0436\u044d\u044d\u0442\u044d\u0439 \u0442\u043e\u043e" },
            { "dar", "\u0434\u0430\u0440\u0433\u0432\u0430" },
            { "dav", "\u0442\u0430\u0439\u0442\u0430" },
            { "lrc", "\u0445\u043e\u0439\u0434 \u043b\u0443\u0440\u0438" },
            { "udm", "\u0443\u0434\u043c\u0443\u0440\u0442" },
            { "Khmr", metaValue_km },
            { "sad", "\u0441\u0430\u043d\u0434\u0430\u0432\u044d" },
            { "type.nu.roman", "\u0440\u043e\u043c \u0442\u043e\u043e" },
            { "sah", "\u0441\u0430\u0445\u0430" },
            { "saq", "\u0441\u0430\u043c\u0431\u04af\u0440\u04af" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0438" },
            { "sba", "\u043d\u0433\u0430\u043c\u0431\u0430\u0439" },
            { "Guru", "\u0433\u04af\u0440\u043c\u04af\u0445" },
            { "lua", "\u043b\u0443\u0431\u0430-\u043b\u0443\u043b\u0443\u0430" },
            { "sbp", "\u0441\u0430\u043d\u0433\u04af" },
            { "nyn", "\u043d\u044f\u043d\u043a\u043e\u043b\u0435" },
            { "lun", "\u043b\u0443\u043d\u0434\u0430" },
            { "luo", "\u043b\u0443\u043e" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u0438\u043d\u043e" },
            { "hmn", "\u0445\u043c\u043e\u043d\u0433" },
            { "lus", "\u043c\u0438\u0437\u043e" },
            { "ban", "\u0431\u0430\u043b\u0438" },
            { "luy", "\u043b\u0443\u044f\u0430" },
            { "bas", "\u0431\u0430\u0441\u0430\u0430" },
            { "es_ES", "\u0438\u0441\u043f\u0430\u043d\u0438 \u0445\u044d\u043b (\u0415\u0432\u0440\u043e\u043f)" },
            { "sco", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434" },
            { "scn", "\u0441\u0438\u0446\u0438\u043b" },
            { "aa", "\u0430\u0444\u0430\u0440" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "ak", "\u0430\u043a\u0430\u043d" },
            { "am", "\u0430\u043c\u0445\u0430\u0440" },
            { "Arab", metaValue_ar },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u044f\u043f\u043e\u043d \u0445\u044d\u043b\u043d\u0438\u0439 \u04af\u0435\u0438\u0439\u043d \u0446\u0430\u0433\u0430\u0430\u043d \u0442\u043e\u043b\u0433\u043e\u0439" },
            { "as", "\u0430\u0441\u0441\u0430\u043c" },
            { "av", "\u0430\u0432\u0430\u0440" },
            { "ay", "\u0430\u0439\u043c\u0430\u0440\u0430" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0436\u0430\u043d" },
            { "ba", "\u0431\u0430\u0448\u043a\u0438\u0440" },
            { "be", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u044c" },
            { "bg", "\u0431\u043e\u043b\u0433\u0430\u0440" },
            { "bi", "\u0431\u0438\u0441\u043b\u0430\u043c" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u0434\u043e\u0433\u0440\u0438\u0431" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438" },
            { "Mymr", "\u043c\u044c\u044f\u043d\u043c\u0430\u0440" },
            { "type.nu.laoo", "\u043b\u0430\u043e\u0441 \u0442\u043e\u043e" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u0430\u043d" },
            { "ses", "\u043a\u0451\u0440\u0430\u0431\u043e\u0440\u043e \u0441\u0435\u043d\u0438" },
            { "ce", "\u0447\u0435\u0447\u0435\u043d\u044c" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u0440\u043e" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a" },
            { "Orya", metaValue_or },
            { "cs", "\u0447\u0435\u0445" },
            { "cu", "\u0441\u04af\u043c\u0438\u0439\u043d \u0441\u043b\u0430\u0432\u044f\u043d" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448" },
            { "cy", "\u0443\u044d\u043b\u044c\u0441" },
            { "type.nu.ethi", "\u044d\u0442\u0438\u043e\u043f \u0442\u043e\u043e" },
            { "da", "\u0434\u0430\u043d\u0438" },
            { "pt_PT", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b \u0445\u044d\u043b (\u0415\u0432\u0440\u043e\u043f)" },
            { "de", "\u0433\u0435\u0440\u043c\u0430\u043d" },
            { "type.cf.standard", "\u043c\u04e9\u043d\u0433\u04e9\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442\u0438\u0439\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0445\u044d\u043b\u0431\u044d\u0440" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "type.nu.mong", "\u043c\u043e\u043d\u0433\u043e\u043b \u0442\u043e\u043e" },
            { "dv", "\u0434\u0438\u0432\u0435\u0445\u0438" },
            { "es_419", "\u0438\u0441\u043f\u0430\u043d\u0438 \u0445\u044d\u043b (\u041b\u0430\u0442\u0438\u043d \u0410\u043c\u0435\u0440\u0438\u043a)" },
            { "dz", "\u0437\u043e\u043d\u0445\u0430" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "type.ca.chinese", "\u0445\u044f\u0442\u0430\u0434 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "type.nu.grek", "\u0433\u0440\u0435\u043a \u0442\u043e\u043e" },
            { "ee", "\u044d\u0432\u044d" },
            { "type.lb.normal", "\u044d\u043d\u0433\u0438\u0439\u043d \u043c\u04e9\u0440\u0438\u0439\u043d \u0437\u0430\u0439\u043d \u0437\u0430\u0433\u0432\u0430\u0440" },
            { "ro_MD", "\u043c\u043e\u043b\u0434\u0430\u0432" },
            { "el", metaValue_el },
            { "en", "\u0430\u043d\u0433\u043b\u0438" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "es", "\u0438\u0441\u043f\u0430\u043d\u0438" },
            { "et", "\u044d\u0441\u0442\u043e\u043d\u0438" },
            { "Hanb", "\u0411\u043e\u043f\u043e\u043c\u043e\u0444\u043e\u0442\u043e\u0439 \u0445\u0430\u043d\u0437" },
            { "eu", "\u0431\u0430\u0441\u043a" },
            { "Hang", "\u0445\u0430\u043d\u0433\u044b\u043b\u044c" },
            { "shi", "\u0442\u0430\u0447\u0435\u043b\u0445\u0438\u0442" },
            { "hsb", "\u0434\u044d\u044d\u0434 \u0441\u043e\u0440\u0431\u0438" },
            { "Hani", "\u0445\u0430\u043d\u0437" },
            { "shn", "\u0448\u0430\u043d\u044c" },
            { "fa", "\u043f\u0435\u0440\u0441" },
            { "Hans", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d" },
            { "type.nu.latn", "\u0430\u0440\u0430\u0431 \u0442\u043e\u043e" },
            { "Hant", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442" },
            { "ff", "\u0444\u0443\u043b\u0430" },
            { "fi", "\u0444\u0438\u043d" },
            { "fj", "\u0444\u0438\u0436\u0438" },
            { "fon", "\u0444\u043e\u043d" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440" },
            { "umb", "\u0443\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446" },
            { "fy", "\u0431\u0430\u0440\u0443\u0443\u043d \u0444\u0440\u0438\u0437" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434" },
            { "gd", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434\u044b\u043d \u0433\u0435\u043b" },
            { "gl", "\u0433\u0430\u043b\u0435\u0433\u043e" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "bho", "\u0431\u043e\u0436\u043f\u0443\u0440\u0438" },
            { "und", "\u04ae\u043b \u043c\u044d\u0434\u044d\u0433\u0434\u044d\u0445 \u0445\u044d\u043b" },
            { "gu", metaValue_gu },
            { "gv", "\u043c\u0430\u043d\u043a\u0441" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "he", metaValue_he },
            { "hi", "\u0445\u0438\u043d\u0434\u0438" },
            { "hup", "\u0445\u0443\u043f\u0430" },
            { "bin", "\u0431\u0438\u043d\u0438" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442" },
            { "ht", "\u0413\u0430\u0438\u0442\u0438\u0439\u043d \u043a\u0440\u0435\u043e\u043b" },
            { "hu", "\u043c\u0430\u0436\u0430\u0440" },
            { "hy", "\u0430\u0440\u043c\u0435\u043d" },
            { "hz", "\u0445\u0435\u0440\u0435\u0440\u043e" },
            { "ia", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u043e" },
            { "Jamo", "\u0436\u0430\u043c\u043e" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438" },
            { "type.nu.tibt", "\u0442\u04e9\u0432\u0434 \u0442\u043e\u043e" },
            { "ie", "\u043d\u044d\u0433\u0434\u043c\u044d\u043b \u0445\u044d\u043b" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "ii", "\u0441\u044b\u0447\u0443\u0430\u043d\u044c \u0438" },
            { "io", "\u0438\u0434\u043e" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434" },
            { "it", "\u0438\u0442\u0430\u043b\u0438" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "sma", "\u04e9\u043c\u043d\u04e9\u0434 \u0441\u0430\u043c\u0438" },
            { "jv", "\u044f\u0432\u0430" },
            { "mad", "\u043c\u0430\u0434\u0443\u0440\u0438 \u0445\u044d\u043b" },
            { "smj", "\u043b\u044e\u043b\u0435 \u0441\u0430\u043c\u0438" },
            { "mag", "\u043c\u0430\u0433\u0430\u0445\u0438" },
            { "mai", "\u043c\u0430\u0439" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438 \u0441\u0430\u043c\u0438" },
            { "ka", metaValue_ka },
            { "bla", "\u0441\u0438\u043a\u0441\u0438\u043a\u0430" },
            { "mak", "\u043c\u0430\u043a\u0430\u0441\u0430\u0440" },
            { "sms", "\u0441\u043a\u043e\u043b\u0442 \u0441\u0430\u043c\u0438" },
            { "ki", "\u043a\u0438\u043a\u0443\u044e\u04af" },
            { "mas", "\u043c\u0430\u0441\u0430\u0439" },
            { "kj", "\u043a\u0443\u0430\u043d\u044c\u044f\u043c\u0430" },
            { "kk", "\u043a\u0430\u0437\u0430\u0445" },
            { "kl", "\u043a\u0430\u043b\u0430\u043b\u0438\u0441\u0443\u0442" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440" },
            { "ku", "\u043a\u0443\u0440\u0434" },
            { "kv", "\u043a\u043e\u043c\u0438" },
            { "kw", "\u043a\u043e\u0440\u043d" },
            { "ky", "\u043a\u0438\u0440\u0433\u0438\u0437" },
            { "snk", "\u0441\u043e\u043d\u0438\u043d\u043a\u0435" },
            { "la", metaValue_la },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "type.nu.mlym", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c \u0442\u043e\u043e" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "li", "\u043b\u0438\u043c\u0431\u0443\u0440\u0433" },
            { "Tibt", metaValue_bo },
            { "ln", "\u043b\u0438\u043d\u0433\u0430\u043b\u0430" },
            { "fur", "\u0444\u0440\u0438\u0443\u043b\u0430\u043d" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0410\u043d\u0433\u043b\u0438 \u043d\u044d\u0433\u0436\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "lt", "\u043b\u0438\u0442\u0432\u0430" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "lv", "\u043b\u0430\u0442\u0432\u0438" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0438" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b\u043b" },
            { "type.co.ducet", "\u044e\u043d\u0438\u043a\u043e\u0434\u044b\u043d \u04af\u043d\u0434\u0441\u044d\u043d \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "mi", "\u043c\u0430\u043e\u0440\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d" },
            { "ml", metaValue_ml },
            { "mn", "\u043c\u043e\u043d\u0433\u043e\u043b" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0438" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439" },
            { "mt", "\u043c\u0430\u043b\u0442\u0430" },
            { "my", "\u0431\u0438\u0440\u043c" },
            { "Armn", "\u0430\u0440\u043c\u0435\u043d\u0438" },
            { "mdf", "\u043c\u043e\u043a\u0448\u0430" },
            { "dsb", "\u0434\u043e\u043e\u0434 \u0441\u043e\u0440\u0431\u0438" },
            { "na", "\u043d\u0430\u0443\u0440\u0443" },
            { "type.co.search", "\u0435\u0440\u04e9\u043d\u0445\u0438\u0439 \u0445\u0430\u0439\u043b\u0442" },
            { "nb", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u0431\u0443\u043a\u043c\u043e\u043b" },
            { "nd", "\u0445\u043e\u0439\u0434 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "ne", "\u0431\u0430\u043b\u0431\u0430" },
            { "ng", "\u043d\u0434\u043e\u043d\u0433\u0430" },
            { "nl", "\u043d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "nn", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u043d\u0438\u043d\u043e\u0440\u0441\u043a" },
            { "no", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438" },
            { "nr", "\u04e9\u043c\u043d\u04e9\u0434 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "nv", "\u043d\u0430\u0432\u0430\u0445\u043e" },
            { "ny", "\u043d\u044f\u043d\u0436\u0430" },
            { "kac", "\u043a\u0430\u0447\u0438\u043d" },
            { "kab", "\u043a\u0430\u0431\u0438\u043b\u0435" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d" },
            { "kaj", "\u0436\u0436\u0443" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "type.nu.armn", "\u0430\u0440\u043c\u0435\u043d \u0442\u043e\u043e" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "or", metaValue_or },
            { "os", "\u043e\u0441\u0441\u0435\u0442\u0438\u043d" },
            { "kbd", "\u043a\u0430\u0431\u0430\u0440\u0434\u0438\u043d" },
            { "mfe", "\u043c\u043e\u0440\u0438\u0441\u0435\u043d" },
            { "srn", "\u0441\u0440\u0430\u043d\u0430\u043d \u0442\u043e\u043d\u0433\u043e" },
            { "pa", "\u043f\u0430\u043d\u0436\u0430\u0431\u0438" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "pl", "\u043f\u043e\u043b\u044c\u0448" },
            { "type.ca.dangi", "\u0434\u0430\u043d\u0433\u0438 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b" },
            { "key.co", "\u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "pt_BR", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b \u0445\u044d\u043b (\u0411\u0440\u0430\u0437\u0438\u043b)" },
            { "kcg", "\u0442\u044f\u043f" },
            { "mgh", "\u043c\u0430\u043a\u0443\u0432\u0430-\u043c\u0438\u0442\u043e" },
            { "key.cf", "\u043c\u04e9\u043d\u0433\u04e9\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442\u0438\u0439\u043d \u0445\u044d\u043b\u0431\u044d\u0440" },
            { "key.ca", "\u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "type.hc.h23", "24 \u0446\u0430\u0433\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c (0\u201323)" },
            { "type.hc.h24", "24 \u0446\u0430\u0433\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c (1\u201324)" },
            { "ssy", "\u0441\u0430\u0445\u043e" },
            { "type.nu.mymr", "\u043c\u044c\u044f\u043d\u043c\u0430\u0440 \u0442\u043e\u043e" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "brx", "\u0431\u043e\u0434\u043e" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435" },
            { "Ethi", "\u044d\u0442\u0438\u043e\u043f" },
            { "type.hc.h12", "12 \u0446\u0430\u0433\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c (1\u201312)" },
            { "type.hc.h11", "12 \u0446\u0430\u0433\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c (0\u201311)" },
            { "rm", "\u0440\u043e\u043c\u0430\u043d\u0448" },
            { "rn", "\u0440\u0443\u043d\u0434\u0438" },
            { "key.cu", "\u043c\u04e9\u043d\u0433\u04e9\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d" },
            { "type.nu.orya", "\u043e\u0440\u0438\u044f \u0442\u043e\u043e" },
            { "type.nu.hanidec", "\u0445\u044f\u0442\u0430\u0434 \u0430\u0440\u0430\u0432\u0442\u044b\u043d \u0442\u043e\u043e" },
            { "ru", "\u043e\u0440\u043e\u0441" },
            { "rw", "\u043a\u0438\u043d\u044c\u044f\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "kea", "\u043a\u0430\u0431\u04af\u0432\u0435\u0440\u0434\u0438\u0430\u043d\u0443" },
            { "mic", "\u043c\u0438\u043a\u043c\u0430\u043a" },
            { "suk", "\u0441\u0443\u043a\u0443\u043c\u0430" },
            { "en_AU", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438-\u0430\u043d\u0433\u043b\u0438" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sc", "\u0441\u0430\u0440\u0434\u0438\u043d" },
            { "sd", "\u0441\u0438\u043d\u0434\u0445\u0438" },
            { "se", "\u0445\u043e\u0439\u0434 \u0441\u0430\u043c\u0438" },
            { "min", "\u043c\u0438\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "sh", "\u0445\u043e\u0440\u0432\u0430\u0442\u044b\u043d \u0441\u0435\u0440\u0431" },
            { "si", metaValue_si },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u043a" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d\u0438" },
            { "sm", "\u0441\u0430\u043c\u043e\u0430" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438" },
            { "type.nu.arab", "\u0430\u0440\u0430\u0431-\u044d\u043d\u044d\u0442\u0445\u044d\u0433 \u0442\u043e\u043e" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u0438" },
            { "sr", "\u0441\u0435\u0440\u0431" },
            { "ss", "\u0441\u0432\u0430\u0442\u0438" },
            { "type.cf.account", "\u043c\u04e9\u043d\u0433\u04e9\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442\u0438\u0439\u043d \u043d\u044f\u0433\u0442\u043b\u0430\u043d \u0431\u043e\u0434\u043e\u0445 \u0431\u04af\u0440\u0442\u0433\u044d\u043b\u0438\u0439\u043d \u0445\u044d\u043b\u0431\u044d\u0440" },
            { "st", "\u0441\u0435\u0441\u043e\u0442\u043e" },
            { "su", "\u0441\u0443\u043d\u0434\u0430\u043d" },
            { "sv", "\u0448\u0432\u0435\u0434" },
            { "sw", "\u0441\u0432\u0430\u0445\u0438\u043b\u0438" },
            { "type.nu.hantfin", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0445\u044f\u0442\u0430\u0434 \u0441\u0430\u043d\u0445\u04af\u04af\u0433\u0438\u0439\u043d \u0442\u043e\u043e" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "iba", "\u0438\u0431\u0430\u043d" },
            { "ta", metaValue_ta },
            { "142", "\u0410\u0437\u0438" },
            { "143", "\u0422\u04e9\u0432 \u0410\u0437\u0438" },
            { "te", metaValue_te },
            { "145", "\u0411\u0430\u0440\u0443\u0443\u043d \u0410\u0437\u0438" },
            { "tg", "\u0442\u0430\u0436\u0438\u043a" },
            { "th", metaValue_th },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u044c\u044f" },
            { "bug", "\u0431\u0443\u0433\u0438" },
            { "kfo", "\u043a\u043e\u0440\u043e" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434-\u0430\u043d\u0433\u043b\u0438" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d" },
            { "tn", "\u0446\u0432\u0430\u043d\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430" },
            { "dyo", "\u0436\u043e\u043b\u0430-\u0444\u043e\u043d\u0438" },
            { "type.nu.jpan", "\u044f\u043f\u043e\u043d \u0442\u043e\u043e" },
            { "tr", "\u0442\u0443\u0440\u043a" },
            { "ts", "\u0446\u043e\u043d\u0433\u0430" },
            { "swb", "\u043a\u043e\u043c\u043e\u0440\u0438" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440" },
            { "tw", "\u0442\u0432\u0438" },
            { "ty", "\u0442\u0430\u0438\u0442\u0438" },
            { "150", "\u0415\u0432\u0440\u043e\u043f" },
            { "151", "\u0417\u04af\u04af\u043d \u0415\u0432\u0440\u043e\u043f" },
            { "154", "\u0425\u043e\u0439\u0434 \u0415\u0432\u0440\u043e\u043f" },
            { "dzg", "\u0434\u0430\u0437\u0430\u0433\u0430" },
            { "155", "\u0411\u0430\u0440\u0443\u0443\u043d \u0415\u0432\u0440\u043e\u043f" },
            { "ug", "\u0443\u0439\u0433\u0443\u0440" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u043d\u0438\u0439\u0442\u043b\u044d\u0433" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "xal", "\u0445\u0430\u043b\u0438\u043c\u0430\u0433" },
            { "uz", "\u0443\u0437\u0431\u0435\u043a" },
            { "kha", "\u043a\u0430\u0441\u0438" },
            { "nds_NL", "\u0431\u0430\u0433\u0430 \u0441\u0430\u043a\u0441\u043e\u043d" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "type.ca.roc", "\u043c\u0438\u043d\u0433\u043e \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "vi", "\u0432\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "khq", "\u043a\u043e\u0439\u0440\u0430 \u0447\u0438\u043d\u0438" },
            { "key.hc", "\u0446\u0430\u0433\u0438\u0439\u043d \u043c\u04e9\u0447\u043b\u04e9\u0433 (12 \u044d\u0441\u0432\u044d\u043b 24)" },
            { "vo", "\u0432\u043e\u043b\u0430\u043f\u044e\u043a" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "gaa", "\u0433\u0430" },
            { "wa", "\u0443\u043e\u043b\u043b\u0443\u043d" },
            { "gag", "\u0433\u0430\u0433\u0443\u0437" },
            { "syr", "\u0441\u0438\u0440\u0438" },
            { "Grek", metaValue_el },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "zgh", "\u041c\u043e\u0440\u043e\u043a\u043a\u043e\u0433\u0438\u0439\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0442\u0430\u043c\u0430\u0437\u0430\u0439\u0442" },
            { "ar_001", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0430\u0440\u0430\u0431" },
            { "Mong", "\u043c\u043e\u043d\u0433\u043e\u043b \u0431\u0438\u0447\u0438\u0433" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0438" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d \u0445\u044f\u0442\u0430\u0434 \u0442\u043e\u043e" },
            { "type.nu.hant", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0445\u044f\u0442\u0430\u0434 \u0442\u043e\u043e" },
            { "xh", "\u0445\u043e\u0441\u0430" },
            { "type.nu.romanlow", "\u0436\u0438\u0436\u0438\u0433 \u0440\u043e\u043c \u0442\u043e\u043e" },
            { "byn", "\u0431\u043b\u0438\u043d" },
            { "moh", "\u043c\u043e\u0445\u0430\u0443\u043a" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "yi", "\u0438\u0434\u0434\u0438\u0448" },
            { "mos", "\u043c\u043e\u0441\u0441\u0438" },
            { "yo", "\u0451\u0440\u0443\u0431\u0430" },
            { "es_MX", "\u0438\u0441\u043f\u0430\u043d\u0438 \u0445\u044d\u043b (\u041c\u0435\u043a\u0441\u0438\u043a)" },
            { "vai", "\u0432\u0430\u0439" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u0436\u0438\u043d" },
            { "zh", "\u0445\u044f\u0442\u0430\u0434" },
            { "Bopo", "\u0432\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "key.lb", "\u043c\u04e9\u0440\u0438\u0439\u043d \u0437\u0430\u0439\u043d \u0437\u0430\u0433\u0432\u0430\u0440" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "Geor", metaValue_ka },
            { "kmb", "\u043a\u0438\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "type.nu.jpanfin", "\u044f\u043f\u043e\u043d \u0441\u0430\u043d\u0445\u04af\u04af\u0433\u0438\u0439\u043d \u0442\u043e\u043e" },
            { "gez", "\u0433\u0438\u0439\u0437" },
            { "ebu", "\u044d\u043c\u0431\u0443" },
            { "zh_Hans", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d \u0445\u044f\u0442\u0430\u0434" },
            { "koi", "\u043a\u043e\u043c\u0438-\u043f\u0435\u0440\u043c\u044f\u043a" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "zh_Hant", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0445\u044f\u0442\u0430\u0434" },
            { "kpe", "\u043a\u043f\u0435\u043b\u043b\u0435" },
            { "type.nu.khmr", "\u043a\u0445\u043c\u0435\u0440 \u0442\u043e\u043e" },
            { "ilo", "\u0438\u043b\u043e\u043a\u043e" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "type.nu.guru", "\u0433\u04af\u0440\u043c\u04af\u0445\u0438 \u0442\u043e\u043e" },
            { "mul", "\u043e\u043b\u043e\u043d \u0445\u044d\u043b" },
            { "key.ms", "\u043d\u044d\u0433\u0436\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "mus", "\u043a\u0440\u0438\u043a" },
            { "gil", "\u0433\u0438\u043b\u0431\u0435\u0440\u0442" },
            { "type.nu.tamldec", "\u0442\u0430\u043c\u0438\u043b \u0442\u043e\u043e" },
            { "krc", "\u043a\u0430\u0440\u0430\u0447\u0430\u0439-\u0431\u0430\u043b\u043a\u0430\u0440" },
            { "inh", "\u0438\u043d\u0433\u0443\u0448" },
            { "krl", "\u043a\u0430\u0440\u0435\u043b\u044c" },
            { "efi", "\u044d\u0444\u0438\u043a" },
            { "key.nu", "\u0442\u043e\u043e" },
            { "kru", "\u043a\u0443\u0440\u0443\u043a" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b" },
            { "Telu", metaValue_te },
            { "ksf", "\u0431\u0430\u0444\u0438\u0430" },
        };
        return data;
    }
}
