/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.BlameCallback2;

public class BlameCallbackImpl
implements BlameCallback,
BlameCallback2 {
    private List<BlameLine> lines = new ArrayList<BlameLine>();

    @Override
    public void singleLine(Date date, long l, String string, String string2) {
        this.addBlameLine(new BlameLine(l, string, date, string2));
    }

    @Override
    public void singleLine(Date date, long l, String string, Date date2, long l2, String string2, String string3, String string4) {
        this.addBlameLine(new BlameLine(this.getRevision(l, l2), this.getAuthor(string, string2), this.getDate(date, date2), string4));
    }

    private Date getDate(Date date, Date date2) {
        return date2 == null ? date : date2;
    }

    private String getAuthor(String string, String string2) {
        return string2 == null ? string : string2;
    }

    private long getRevision(long l, long l2) {
        return l2 == -1L ? l : l2;
    }

    public int numberOfLines() {
        return this.lines.size();
    }

    public BlameLine getBlameLine(int n) {
        if (n >= this.lines.size()) {
            return null;
        }
        return this.lines.get(n);
    }

    protected void addBlameLine(BlameLine blameLine) {
        this.lines.add(blameLine);
    }

    public static class BlameLine {
        private long revision;
        private String author;
        private Date changed;
        private String line;

        public BlameLine(long l, String string, Date date, String string2) {
            this.revision = l;
            this.author = string;
            this.changed = date;
            this.line = string2;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getChanged() {
            return this.changed;
        }

        public String getLine() {
            return this.line;
        }

        public long getRevision() {
            return this.revision;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.revision > 0L) {
                this.pad(stringBuffer, Long.toString(this.revision), 6);
                stringBuffer.append(' ');
            } else {
                stringBuffer.append("     - ");
            }
            if (this.author != null) {
                this.pad(stringBuffer, this.author, 10);
                stringBuffer.append(" ");
            } else {
                stringBuffer.append("         - ");
            }
            stringBuffer.append(this.line);
            return stringBuffer.toString();
        }

        private void pad(StringBuffer stringBuffer, String string, int n) {
            int n2 = n - string.length();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
        }
    }
}

