/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.caffeine.cache;

import io.micronaut.caffeine.cache.CacheLoader;
import io.micronaut.caffeine.cache.LoadingCache;
import io.micronaut.caffeine.cache.LocalCache;
import io.micronaut.caffeine.cache.LocalManualCache;
import io.micronaut.caffeine.cache.RemovalCause;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

interface LocalLoadingCache<C extends LocalCache<K, V>, K, V>
extends LocalManualCache<C, K, V>,
LoadingCache<K, V> {
    public static final Logger logger = Logger.getLogger(LocalLoadingCache.class.getName());

    public CacheLoader<? super K, V> cacheLoader();

    public Function<K, V> mappingFunction();

    public boolean hasBulkLoader();

    default public boolean hasLoadAll(CacheLoader<? super K, V> loader) {
        try {
            Method classLoadAll = loader.getClass().getMethod("loadAll", Iterable.class);
            Method defaultLoadAll = CacheLoader.class.getMethod("loadAll", Iterable.class);
            return !classLoadAll.equals(defaultLoadAll);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.log(Level.WARNING, "Cannot determine if CacheLoader can bulk load", e);
            return false;
        }
    }

    @Override
    default public V get(K key) {
        return this.cache().computeIfAbsent(key, this.mappingFunction());
    }

    @Override
    default public Map<K, V> getAll(Iterable<? extends K> keys) {
        return this.hasBulkLoader() ? this.loadInBulk(keys) : this.loadSequentially(keys);
    }

    default public Map<K, V> loadSequentially(Iterable<? extends K> keys) {
        HashSet<K> uniqueKeys = new HashSet<K>();
        for (K key : keys) {
            uniqueKeys.add(key);
        }
        int count = 0;
        HashMap result = new HashMap(uniqueKeys.size());
        try {
            for (Object key : uniqueKeys) {
                ++count;
                V value = this.get(key);
                if (value == null) continue;
                result.put(key, value);
            }
        }
        catch (Throwable t) {
            this.cache().statsCounter().recordMisses(uniqueKeys.size() - count);
            throw t;
        }
        return Collections.unmodifiableMap(result);
    }

    default public Map<K, V> loadInBulk(Iterable<? extends K> keys) {
        Map found = this.cache().getAllPresent(keys);
        HashSet<K> keysToLoad = new HashSet<K>();
        for (K key : keys) {
            if (found.containsKey(key)) continue;
            keysToLoad.add(key);
        }
        if (keysToLoad.isEmpty()) {
            return found;
        }
        HashMap result = new HashMap(found);
        this.bulkLoad(keysToLoad, result);
        return Collections.unmodifiableMap(result);
    }

    default public void bulkLoad(Set<K> keysToLoad, Map<K, V> result) {
        boolean success = false;
        long startTime = this.cache().statsTicker().read();
        try {
            Map<Object, Object> loaded = this.cacheLoader().loadAll(keysToLoad);
            loaded.forEach((key, value) -> {
                this.cache().put((Object)key, (Object)value, false);
                if (keysToLoad.contains(key)) {
                    result.put(key, value);
                }
            });
            success = !loaded.isEmpty();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
        finally {
            long loadTime = this.cache().statsTicker().read() - startTime;
            if (success) {
                this.cache().statsCounter().recordLoadSuccess(loadTime);
            } else {
                this.cache().statsCounter().recordLoadFailure(loadTime);
            }
        }
    }

    @Override
    default public void refresh(K key) {
        Objects.requireNonNull(key);
        long[] writeTime = new long[1];
        long startTime = this.cache().statsTicker().read();
        Object oldValue = this.cache().getIfPresentQuietly(key, writeTime);
        CompletableFuture<V> refreshFuture = oldValue == null ? this.cacheLoader().asyncLoad(key, this.cache().executor()) : this.cacheLoader().asyncReload(key, oldValue, this.cache().executor());
        refreshFuture.whenComplete((newValue, error) -> {
            long loadTime = this.cache().statsTicker().read() - startTime;
            if (error != null) {
                logger.log(Level.WARNING, "Exception thrown during refresh", (Throwable)error);
                this.cache().statsCounter().recordLoadFailure(loadTime);
                return;
            }
            boolean[] discard = new boolean[1];
            this.cache().compute(key, (k, currentValue) -> {
                if (currentValue == null) {
                    return newValue;
                }
                if (currentValue == oldValue) {
                    long expectedWriteTime = writeTime[0];
                    if (this.cache().hasWriteTime()) {
                        this.cache().getIfPresentQuietly(key, writeTime);
                    }
                    if (writeTime[0] == expectedWriteTime) {
                        return newValue;
                    }
                }
                discard[0] = true;
                return currentValue;
            }, false, false);
            if (discard[0] && this.cache().hasRemovalListener()) {
                this.cache().notifyRemoval(key, (Object)newValue, RemovalCause.REPLACED);
            }
            if (newValue == null) {
                this.cache().statsCounter().recordLoadFailure(loadTime);
            } else {
                this.cache().statsCounter().recordLoadSuccess(loadTime);
            }
        });
    }
}

