/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericColor;
import javajs.util.Lst;
import javajs.util.PT;
import jspecview.common.Coordinate;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.source.JDXDataObject;
import jspecview.source.JDXSourceStreamTokenizer;
import org.jmol.util.Logger;

public class Spectrum
extends JDXDataObject {
    private Lst<Spectrum> subSpectra;
    private Lst<PeakInfo> peakList = new Lst();
    private String piUnitsX;
    private String piUnitsY;
    private PeakInfo selectedPeak;
    private PeakInfo highlightedPeak;
    private double specShift = 0.0;
    private int currentSubSpectrumIndex;
    private boolean isForcedSubset;
    public String id = "";
    private Spectrum convertedSpectrum;
    private double userYFactor = 1.0;
    public static final double MAXABS = 4.0;
    private boolean exportXAxisLeftToRight;
    GenericColor fillColor;

    public void finalize() {
        System.out.println("JDXSpectrum " + this + " finalized " + this.title);
    }

    public void dispose() {
    }

    public boolean isForcedSubset() {
        return this.isForcedSubset;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Spectrum() {
        this.headerTable = new Lst();
        this.xyCoords = new Coordinate[0];
        this.parent = this;
    }

    public Spectrum copy() {
        Spectrum newSpectrum = new Spectrum();
        this.copyTo(newSpectrum);
        newSpectrum.setPeakList(this.peakList, this.piUnitsX, null);
        newSpectrum.fillColor = this.fillColor;
        return newSpectrum;
    }

    public Coordinate[] getXYCoords() {
        return this.getCurrentSubSpectrum().xyCoords;
    }

    public Lst<PeakInfo> getPeakList() {
        return this.peakList;
    }

    public int setPeakList(Lst<PeakInfo> list, String piUnitsX, String piUnitsY) {
        this.peakList = list;
        this.piUnitsX = piUnitsX;
        this.piUnitsY = piUnitsY;
        int i = list.size();
        while (--i >= 0) {
            ((PeakInfo)this.peakList.get((int)i)).spectrum = this;
        }
        if (Logger.debugging) {
            Logger.info("Spectrum " + this.getTitle() + " peaks: " + list.size());
        }
        return list.size();
    }

    public PeakInfo selectPeakByFileIndex(String filePath, String index, String atomKey) {
        if (this.peakList != null && this.peakList.size() > 0 && (atomKey == null || this.sourceID.equals(index))) {
            for (int i = 0; i < this.peakList.size(); ++i) {
                if (!((PeakInfo)this.peakList.get(i)).checkFileIndex(filePath, index, atomKey)) continue;
                System.out.println("selecting peak by FileIndex " + this + " " + this.peakList.get(i));
                this.selectedPeak = (PeakInfo)this.peakList.get(i);
                return this.selectedPeak;
            }
        }
        return null;
    }

    public PeakInfo selectPeakByFilePathTypeModel(String filePath, String type, String model) {
        if (this.peakList != null && this.peakList.size() > 0) {
            for (int i = 0; i < this.peakList.size(); ++i) {
                if (!((PeakInfo)this.peakList.get(i)).checkFileTypeModel(filePath, type, model)) continue;
                System.out.println("selecting peak byFilePathTypeModel " + this + " " + this.peakList.get(i));
                this.selectedPeak = (PeakInfo)this.peakList.get(i);
                return this.selectedPeak;
            }
        }
        return null;
    }

    public boolean matchesPeakTypeModel(String type, String model) {
        if (type.equals("ID")) {
            return this.sourceID.equalsIgnoreCase(model);
        }
        if (this.peakList != null && this.peakList.size() > 0) {
            for (int i = 0; i < this.peakList.size(); ++i) {
                if (!((PeakInfo)this.peakList.get(i)).checkTypeModel(type, model)) continue;
                return true;
            }
        }
        return false;
    }

    public void setSelectedPeak(PeakInfo peak) {
        this.selectedPeak = peak;
    }

    public void setHighlightedPeak(PeakInfo peak) {
        this.highlightedPeak = peak;
    }

    public PeakInfo getSelectedPeak() {
        return this.selectedPeak;
    }

    public PeakInfo getModelPeakInfoForAutoSelectOnLoad() {
        if (this.peakList != null) {
            for (int i = 0; i < this.peakList.size(); ++i) {
                if (!((PeakInfo)this.peakList.get(i)).autoSelectOnLoad()) continue;
                return (PeakInfo)this.peakList.get(i);
            }
        }
        return null;
    }

    public PeakInfo getAssociatedPeakInfo(int xPixel, Coordinate coord) {
        this.selectedPeak = this.findPeakByCoord(xPixel, coord);
        return this.selectedPeak == null ? this.getBasePeakInfo() : this.selectedPeak;
    }

    public PeakInfo findPeakByCoord(int xPixel, Coordinate coord) {
        if (coord != null && this.peakList != null && this.peakList.size() > 0) {
            double xVal = coord.getXVal();
            int iBest = -1;
            double dBest = 1.0E100;
            for (int i = 0; i < this.peakList.size(); ++i) {
                double d = ((PeakInfo)this.peakList.get(i)).checkRange(xPixel, xVal);
                if (!(d < dBest)) continue;
                dBest = d;
                iBest = i;
            }
            if (iBest >= 0) {
                return (PeakInfo)this.peakList.get(iBest);
            }
        }
        return null;
    }

    public String getPeakTitle() {
        return this.selectedPeak != null ? this.selectedPeak.getTitle() : (this.highlightedPeak != null ? this.highlightedPeak.getTitle() : this.getTitleLabel());
    }

    public String getTitleLabel() {
        String type;
        String string = type = this.peakList == null || this.peakList.size() == 0 ? this.getQualifiedDataType() : ((PeakInfo)this.peakList.get(0)).getType();
        if (type != null && type.startsWith("NMR")) {
            type = this.nucleusY != null && !this.nucleusY.equals("?") ? "2D" + type : this.nucleusX + type;
        }
        return (type != null && type.length() > 0 ? type + " " : "") + this.getTitle();
    }

    public int setNextPeak(Coordinate coord, int istep) {
        if (this.peakList == null || this.peakList.size() == 0) {
            return -1;
        }
        double x0 = coord.getXVal() + (double)istep * 1.0E-6;
        int ipt1 = -1;
        int ipt2 = -1;
        double dmin1 = Double.MAX_VALUE * (double)istep;
        double dmin2 = 0.0;
        int i = this.peakList.size();
        while (--i >= 0) {
            double x = ((PeakInfo)this.peakList.get(i)).getX();
            if (istep > 0) {
                if (x > x0 && x < dmin1) {
                    ipt1 = i;
                    dmin1 = x;
                    continue;
                }
                if (!(x < x0) || !(x - x0 < dmin2)) continue;
                ipt2 = i;
                dmin2 = x - x0;
                continue;
            }
            if (x < x0 && x > dmin1) {
                ipt1 = i;
                dmin1 = x;
                continue;
            }
            if (!(x > x0) || !(x - x0 > dmin2)) continue;
            ipt2 = i;
            dmin2 = x - x0;
        }
        if (ipt1 < 0) {
            if (ipt2 < 0) {
                return -1;
            }
            ipt1 = ipt2;
        }
        return ipt1;
    }

    public double getPercentYValueAt(double x) {
        if (!this.isContinuous()) {
            return Double.NaN;
        }
        return this.getYValueAt(x);
    }

    public double getYValueAt(double x) {
        return Coordinate.getYValueAt(this.xyCoords, x);
    }

    public void setUserYFactor(double userYFactor) {
        this.userYFactor = userYFactor;
    }

    public double getUserYFactor() {
        return this.userYFactor;
    }

    public Spectrum getConvertedSpectrum() {
        return this.convertedSpectrum;
    }

    public void setConvertedSpectrum(Spectrum spectrum) {
        this.convertedSpectrum = spectrum;
    }

    public static Spectrum taConvert(Spectrum spectrum, IRMode mode) {
        if (!spectrum.isContinuous()) {
            return spectrum;
        }
        switch (mode) {
            case NO_CONVERT: {
                return spectrum;
            }
            case TO_ABS: {
                if (spectrum.isTransmittance()) break;
                return spectrum;
            }
            case TO_TRANS: {
                if (spectrum.isAbsorbance()) break;
                return spectrum;
            }
        }
        Spectrum spec = spectrum.getConvertedSpectrum();
        return spec != null ? spec : (spectrum.isAbsorbance() ? Spectrum.toT(spectrum) : Spectrum.toA(spectrum));
    }

    private static Spectrum toT(Spectrum spectrum) {
        if (!spectrum.isAbsorbance()) {
            return null;
        }
        Coordinate[] xyCoords = spectrum.getXYCoords();
        Coordinate[] newXYCoords = new Coordinate[xyCoords.length];
        if (!Coordinate.isYInRange(xyCoords, 0.0, 4.0)) {
            xyCoords = Coordinate.normalise(xyCoords, 0.0, 4.0);
        }
        for (int i = 0; i < xyCoords.length; ++i) {
            newXYCoords[i] = new Coordinate().set(xyCoords[i].getXVal(), Spectrum.toTransmittance(xyCoords[i].getYVal()));
        }
        return Spectrum.newSpectrum(spectrum, newXYCoords, "TRANSMITTANCE");
    }

    private static Spectrum toA(Spectrum spectrum) {
        if (!spectrum.isTransmittance()) {
            return null;
        }
        Coordinate[] xyCoords = spectrum.getXYCoords();
        Coordinate[] newXYCoords = new Coordinate[xyCoords.length];
        boolean isPercent = Coordinate.isYInRange(xyCoords, -2.0, 2.0);
        for (int i = 0; i < xyCoords.length; ++i) {
            newXYCoords[i] = new Coordinate().set(xyCoords[i].getXVal(), Spectrum.toAbsorbance(xyCoords[i].getYVal(), isPercent));
        }
        return Spectrum.newSpectrum(spectrum, newXYCoords, "ABSORBANCE");
    }

    public static Spectrum newSpectrum(Spectrum spectrum, Coordinate[] newXYCoords, String units) {
        Spectrum specNew = spectrum.copy();
        specNew.setOrigin("JSpecView Converted");
        specNew.setOwner("JSpecView Generated");
        specNew.setXYCoords(newXYCoords);
        specNew.setYUnits(units);
        spectrum.setConvertedSpectrum(specNew);
        specNew.setConvertedSpectrum(spectrum);
        return specNew;
    }

    private static double toAbsorbance(double x, boolean isPercent) {
        return Math.min(4.0, isPercent ? 2.0 - Spectrum.log10(x) : -Spectrum.log10(x));
    }

    private static double toTransmittance(double x) {
        return x <= 0.0 ? 1.0 : Math.pow(10.0, -x);
    }

    private static double log10(double value) {
        return Math.log(value) / Math.log(10.0);
    }

    public static boolean process(Lst<Spectrum> specs, IRMode irMode) {
        if (irMode == IRMode.TO_ABS || irMode == IRMode.TO_TRANS) {
            for (int i = 0; i < specs.size(); ++i) {
                specs.set(i, Spectrum.taConvert((Spectrum)specs.get(i), irMode));
            }
        }
        return true;
    }

    public Lst<Spectrum> getSubSpectra() {
        return this.subSpectra;
    }

    public Spectrum getCurrentSubSpectrum() {
        return this.subSpectra == null ? this : (Spectrum)this.subSpectra.get(this.currentSubSpectrumIndex);
    }

    public int advanceSubSpectrum(int dir) {
        return this.setCurrentSubSpectrum(this.currentSubSpectrumIndex + dir);
    }

    public int setCurrentSubSpectrum(int n) {
        this.currentSubSpectrumIndex = Coordinate.intoRange(n, 0, this.subSpectra.size() - 1);
        return this.currentSubSpectrumIndex;
    }

    public boolean addSubSpectrum(Spectrum spectrum, boolean forceSub) {
        if (!forceSub && (this.numDim < 2 || this.blockID != spectrum.blockID) || !Spectrum.allowSubSpec(this, spectrum)) {
            return false;
        }
        this.isForcedSubset = forceSub;
        if (this.subSpectra == null) {
            this.subSpectra = new Lst();
            this.addSubSpectrum(this, true);
        }
        this.subSpectra.addLast(spectrum);
        spectrum.parent = this;
        return true;
    }

    public int getSubIndex() {
        return this.subSpectra == null ? -1 : this.currentSubSpectrumIndex;
    }

    public void setExportXAxisDirection(boolean leftToRight) {
        this.exportXAxisLeftToRight = leftToRight;
    }

    public boolean isExportXAxisLeftToRight() {
        return this.exportXAxisLeftToRight;
    }

    public Map<String, Object> getInfo(String key) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        if ("id".equalsIgnoreCase(key)) {
            info.put(key, this.id);
            return info;
        }
        String keys = null;
        if ("".equals(key)) {
            keys = "id specShift header";
        }
        info.put("id", this.id);
        Parameters.putInfo(key, info, "specShift", this.specShift);
        boolean justHeader = "header".equals(key);
        if (!justHeader && key != null && keys == null) {
            int i = this.headerTable.size();
            while (--i >= 0) {
                String[] entry = (String[])this.headerTable.get(i);
                if (!entry[0].equalsIgnoreCase(key) && !entry[2].equalsIgnoreCase(key)) continue;
                info.put(key, entry[1]);
                return info;
            }
        }
        Hashtable head = new Hashtable();
        String[][] list = this.getHeaderRowDataAsArray();
        for (int i = 0; i < list.length; ++i) {
            String label = JDXSourceStreamTokenizer.cleanLabel(list[i][0]);
            if (keys != null) {
                keys = keys + " " + label;
                continue;
            }
            if (key != null && !justHeader && !label.equals(key)) continue;
            Object val = Spectrum.fixInfoValue(list[i][1]);
            if (key == null) {
                Hashtable<String, Object> data = new Hashtable<String, Object>();
                data.put("value", val);
                data.put("index", i + 1);
                info.put(label, data);
                continue;
            }
            info.put(label, val);
        }
        if (head.size() > 0) {
            info.put("header", head);
        }
        if (!justHeader) {
            if (keys != null) {
                keys = keys + "  titleLabel type isHZToPPM subSpectrumCount";
            } else {
                Parameters.putInfo(key, info, "titleLabel", this.getTitleLabel());
                Parameters.putInfo(key, info, "type", this.getDataType());
                Parameters.putInfo(key, info, "isHZToPPM", this.isHZtoPPM);
                Parameters.putInfo(key, info, "subSpectrumCount", this.subSpectra == null ? 0 : this.subSpectra.size());
            }
        }
        if (keys != null) {
            info.put("KEYS", keys);
        }
        return info;
    }

    private static Object fixInfoValue(String info) {
        try {
            return Integer.valueOf(info);
        }
        catch (Exception exception) {
            try {
                return Double.valueOf(info);
            }
            catch (Exception exception2) {
                return info;
            }
        }
    }

    public String toString() {
        return this.getTitleLabel();
    }

    public PeakInfo findMatchingPeakInfo(PeakInfo pi) {
        for (int i = 0; i < this.peakList.size(); ++i) {
            if (!((PeakInfo)this.peakList.get(i)).checkTypeMatch(pi)) continue;
            return (PeakInfo)this.peakList.get(i);
        }
        return null;
    }

    public PeakInfo getBasePeakInfo() {
        return this.peakList.size() == 0 ? new PeakInfo() : new PeakInfo(" baseModel=\"\" " + this.peakList.get(0));
    }

    public String getAxisLabel(boolean isX) {
        String units;
        String string = units = isX ? this.piUnitsX : this.piUnitsY;
        if (units == null) {
            String string2 = units = isX ? this.xLabel : this.yLabel;
        }
        if (units == null) {
            String string3 = units = isX ? this.xUnits : this.yUnits;
        }
        return units == null ? "" : (units.equalsIgnoreCase("WAVENUMBERS") ? "1/cm" : (units.equalsIgnoreCase("nanometers") ? "nm" : units));
    }

    public double findXForPeakNearest(double x) {
        return Coordinate.findXForPeakNearest(this.xyCoords, x, this.isInverted());
    }

    public double addSpecShift(double dx) {
        if (dx != 0.0) {
            this.specShift += dx;
            Coordinate.shiftX(this.xyCoords, dx);
            if (this.subSpectra != null) {
                int i = this.subSpectra.size();
                while (--i >= 0) {
                    Spectrum spec = (Spectrum)this.subSpectra.get(i);
                    if (spec == this || spec == this.parent) continue;
                    spec.addSpecShift(dx);
                }
            }
        }
        return this.specShift;
    }

    public static boolean allowSubSpec(Spectrum s1, Spectrum s2) {
        return s1.is1D() == s2.is1D() && s1.xUnits.equalsIgnoreCase(s2.xUnits) && s1.isHNMR() == s2.isHNMR();
    }

    public static boolean areXScalesCompatible(Spectrum s1, Spectrum s2, boolean isSubspecCheck, boolean isLinkCheck) {
        boolean isNMR1 = s1.isNMR();
        if (isNMR1 != s2.isNMR() || s1.isContinuous() != s2.isContinuous() || !isLinkCheck && !Spectrum.areUnitsCompatible(s1.xUnits, s2.xUnits)) {
            return false;
        }
        if (isSubspecCheck) {
            if (s1.is1D() != s2.is1D()) {
                return false;
            }
        } else if (isLinkCheck) {
            if (!isNMR1) {
                return true;
            }
        } else if (!s1.is1D() || !s2.is1D()) {
            return false;
        }
        return !isNMR1 || s2.is1D() && s1.parent.nucleusX.equals(s2.parent.nucleusX);
    }

    private static boolean areUnitsCompatible(String u1, String u2) {
        if (u1.equalsIgnoreCase(u2)) {
            return true;
        }
        u1 = u1.toUpperCase();
        u2 = u2.toUpperCase();
        return u1.equals("HZ") && u2.equals("PPM") || u1.equals("PPM") && u2.equals("HZ");
    }

    public static boolean areLinkableX(Spectrum s1, Spectrum s2) {
        return s1.isNMR() && s2.isNMR() && s1.nucleusX.equals(s2.nucleusX);
    }

    public static boolean areLinkableY(Spectrum s1, Spectrum s2) {
        return s1.isNMR() && s2.isNMR() && s1.nucleusX.equals(s2.nucleusY);
    }

    public void setNHydrogens(int nH) {
        this.nH = nH;
    }

    public float getPeakWidth() {
        double w = this.getLastX() - this.getFirstX();
        return (float)(w / 100.0);
    }

    public void setSimulated(String filePath) {
        this.isSimulation = true;
        String s = this.sourceID;
        if (s.length() == 0) {
            s = PT.rep(filePath, "http://SIMULATION/", "");
        }
        if (s.indexOf("MOL=") >= 0) {
            s = "";
        }
        this.title = "SIMULATED " + PT.rep(s, "$", "");
    }

    public void setFillColor(GenericColor color) {
        this.fillColor = color;
        if (this.convertedSpectrum != null) {
            this.convertedSpectrum.fillColor = color;
        }
    }

    public static enum IRMode {
        NO_CONVERT,
        TO_TRANS,
        TO_ABS,
        TOGGLE;


        public static IRMode getMode(String value) {
            switch (value == null ? 73 : (int)value.toUpperCase().charAt(0)) {
                case 65: {
                    return TO_ABS;
                }
                case 84: {
                    return value.equalsIgnoreCase("TOGGLE") ? TOGGLE : TO_TRANS;
                }
                case 78: {
                    return NO_CONVERT;
                }
            }
            return TOGGLE;
        }
    }
}

