/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.readers.quantum.NBOParser;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class GenNBOReader
extends MOReader {
    private boolean isOutputFile;
    private String nboType = "";
    private int nOrbitals0;
    private boolean is47File;
    private boolean isOpenShell;
    private boolean alphaOnly;
    private boolean betaOnly;
    private int nAOs;
    private int nNOs;
    private String topoType = "A";
    private int nStructures = 0;
    NBOParser nboParser;
    private boolean addBetaSet;
    private static String P_LIST = "101   102   103";
    private static String SP_LIST = "1     101   102   103";
    private static String DS_LIST = "255   252   253   254   251";
    private static String DC_LIST = "201   204   206   202   203   205";
    private static String FS_LIST = "351   352   353   354   355   356   357";
    private static String FC_LIST = "301   307   310   304   302   303   306   309   308   305";
    private static String GS_LIST = "451   452   453   454   455   456   457   458   459";
    private static String GC_LIST = "415   414   413   412   411   410   409   408   407   406   405   404   403   402   401";
    private static String HS_LIST = "551   552   553   554   555   556   557   558   559   560   561";
    private static String HC_LIST = "521   520   519   518   517   516   515   514   513   512   511   510   509   508   507   506   505   504   503   502   501";
    private static String IS_LIST = "651   652   653   654   655   656   657   658   659   660   661   662   663";
    private static String IC_LIST = "628   627   626   625   624   623   622   621   620   619   618   617   616   615   614   613   612   611   610   609   608   607   606   605   604   603   602   601";

    @Override
    protected void initializeReader() throws Exception {
        boolean isOK;
        String line1 = this.rd().trim().toUpperCase();
        boolean bl = this.is47File = line1.indexOf("$GENNBO") >= 0 || line1.indexOf("$NBO") >= 0;
        if (this.is47File) {
            if (line1.indexOf("BOHR") >= 0) {
                this.fileOffset = new P3();
                this.fileScaling = P3.new3(0.5291772f, 0.5291772f, 0.5291772f);
            }
            this.readData47();
            return;
        }
        this.alphaOnly = this.checkFilterKey("ALPHA");
        this.betaOnly = this.checkFilterKey("BETA");
        String line2 = this.rd();
        this.line = line1 + line2;
        boolean bl2 = this.isOutputFile = line2.indexOf("****") >= 0;
        if (this.isOutputFile) {
            isOK = this.getFile31();
            super.initializeReader();
        } else if (line2.indexOf("s in the AO basis:") >= 0) {
            this.nboType = line2.substring(1, line2.indexOf("s"));
            this.asc.setCollectionName(line1 + ": " + this.nboType + "s");
            isOK = this.getFile31();
        } else {
            this.nboType = "AO";
            this.asc.setCollectionName(line1 + ": " + this.nboType + "s");
            isOK = this.readData31(line1);
        }
        if (!isOK) {
            Logger.error("Unimplemented shell type -- no orbitals available: " + this.line);
        }
        if (this.isOutputFile) {
            return;
        }
        if (isOK) {
            this.readMOs();
        }
        this.continuing = false;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.appendLoadNote("NBO type " + this.nboType);
        if (this.isOpenShell) {
            this.asc.setCurrentModelInfo("isOpenShell", Boolean.TRUE);
        }
        this.finalizeReaderASCR();
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("SECOND ORDER PERTURBATION THEORY ANALYSIS") >= 0 && !this.orbitalsRead) {
            this.nboType = "NBO";
            String data = this.getFileData(".37");
            if (data == null) {
                return true;
            }
            BufferedReader readerSave = this.reader;
            this.reader = Rdr.getBR(data);
            this.rd();
            this.rd();
            this.readMOs();
            this.reader = readerSave;
            this.orbitalsRead = false;
            return true;
        }
        if (this.line.indexOf("$NRTSTRA") >= 0) {
            this.getStructures("NRTSTRA");
            return true;
        }
        if (this.line.indexOf("$NRTSTRB") >= 0) {
            this.getStructures("NRTSTRB");
            return true;
        }
        if (this.line.indexOf("$NRTSTR") >= 0) {
            this.getStructures("NRTSTR");
            return true;
        }
        if (this.line.indexOf(" TOPO ") >= 0) {
            this.getStructures("TOPO" + this.topoType);
            this.topoType = "B";
            return true;
        }
        if (this.line.indexOf("$CHOOSE") >= 0) {
            this.getStructures("CHOOSE");
            return true;
        }
        return this.checkNboLine();
    }

    private void getStructures(String type) throws Exception {
        if (this.nboParser == null) {
            this.nboParser = new NBOParser();
        }
        Lst<Object> structures = this.getStructureList();
        SB sb = new SB();
        while (!this.rd().trim().equals("$END")) {
            sb.append(this.line).append("\n");
        }
        this.nStructures = this.nboParser.getStructures(sb.toString(), type, structures);
        this.appendLoadNote(this.nStructures + " NBO " + type + " resonance structures");
    }

    private Lst<Object> getStructureList() {
        Lst structures = (Lst)this.asc.getAtomSetAuxiliaryInfo(this.asc.iSet).get("nboStructures");
        if (structures == null) {
            structures = new Lst();
            this.asc.setCurrentModelInfo("nboStructures", structures);
        }
        return structures;
    }

    private String getFileData(String ext) throws Exception {
        boolean isError;
        String fileName = (String)this.htParams.get("fullPathName");
        int pt = fileName.lastIndexOf(".");
        if (pt < 0) {
            pt = fileName.length();
        }
        fileName = fileName.substring(0, pt);
        this.moData.put("nboRoot", fileName);
        fileName = fileName + ext;
        String data = this.vwr.getFileAsString3(fileName, false, null);
        Logger.info(data.length() + " bytes read from " + fileName);
        boolean bl = isError = data.indexOf("java.io.") >= 0;
        if (data.length() == 0 || isError && this.nboType != "AO") {
            throw new Exception(" supplemental file " + fileName + " was not found");
        }
        return isError ? null : data;
    }

    private boolean getFile31() throws Exception {
        try {
            String data = this.getFileData(".31");
            if (data == null) {
                return false;
            }
            BufferedReader readerSave = this.reader;
            this.reader = Rdr.getBR(data);
            return this.readData31(null) && (this.reader = readerSave) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void getFile46() throws Exception {
        String data = this.getFileData(".46");
        if (data == null) {
            return;
        }
        BufferedReader readerSave = this.reader;
        this.reader = Rdr.getBR(data);
        this.readData46();
        this.reader = readerSave;
    }

    private void readData47() throws Exception {
        this.allowNoOrbitals = true;
        this.discardLinesUntilContains("$COORD");
        this.asc.newAtomSet();
        this.asc.setAtomSetName(this.rd().trim());
        while (this.rd().indexOf("$END") < 0) {
            String[] tokens = this.getTokens();
            this.addAtomXYZSymName((String[])tokens, (int)2, null, null).elementNumber = (short)this.parseIntStr(tokens[0]);
        }
        if (this.doReadMolecularOrbitals && !this.getFile31()) {
            this.alphaOnly = true;
            this.betaOnly = false;
            this.discardLinesUntilContains("$BASIS");
            this.appendLoadNote("basis AOs are unnormalized");
            int[] centers = this.getIntData();
            int[] labels = this.getIntData();
            this.discardLinesUntilContains("NSHELL =");
            this.shellCount = this.parseIntAt(this.line, 10);
            this.gaussianCount = this.parseIntAt(this.rd(), 10);
            this.rd();
            int[] ncomp = this.getIntData();
            int[] nprim = this.getIntData();
            int[] nptr = this.getIntData();
            this.shells = new Lst();
            this.gaussians = AU.newFloat2(this.gaussianCount);
            for (int i = 0; i < this.gaussianCount; ++i) {
                this.gaussians[i] = new float[6];
            }
            this.nOrbitals = 0;
            int ptCenter = 0;
            String l = this.line;
            for (int i = 0; i < this.shellCount; ++i) {
                int[] slater = new int[4];
                int nc = ncomp[i];
                slater[0] = centers[ptCenter];
                this.line = "";
                for (int ii = 0; ii < nc; ++ii) {
                    this.line = this.line + labels[ptCenter++] + " ";
                }
                if (this.fillSlater(slater, nc, nptr[i] - 1, nprim[i])) continue;
                return;
            }
            this.line = l;
            this.getAlphasAndExponents();
            this.nboType = "AO";
            this.readMOs();
        }
        this.continuing = false;
    }

    private int[] getIntData() throws Exception {
        while (this.line.indexOf("=") < 0) {
            this.rd();
        }
        String s = this.line.substring(this.line.indexOf("=") + 1);
        this.line = "";
        while (this.rd().indexOf("=") < 0 && this.line.indexOf("$") < 0) {
            s = s + this.line;
        }
        String[] tokens = PT.getTokens(s);
        int[] f = new int[tokens.length];
        int i = f.length;
        while (--i >= 0) {
            f[i] = this.parseIntStr(tokens[i]);
        }
        return f;
    }

    private boolean fillSlater(int[] slater, int n, int pt, int ng) {
        this.nOrbitals += n;
        switch (n) {
            case 1: {
                slater[1] = 0;
                break;
            }
            case 3: {
                if (!this.getDFMap("P", this.line, 1, P_LIST, 3)) {
                    return false;
                }
                slater[1] = 1;
                break;
            }
            case 4: {
                if (!this.getDFMap("SP", this.line, 2, SP_LIST, 1)) {
                    return false;
                }
                slater[1] = 2;
                break;
            }
            case 5: {
                if (!this.getDFMap("DS", this.line, 3, DS_LIST, 3)) {
                    return false;
                }
                slater[1] = 3;
                break;
            }
            case 6: {
                if (!this.getDFMap("DC", this.line, 4, DC_LIST, 3)) {
                    return false;
                }
                slater[1] = 4;
                break;
            }
            case 7: {
                if (!this.getDFMap("FS", this.line, 5, FS_LIST, 3)) {
                    return false;
                }
                slater[1] = 5;
                break;
            }
            case 10: {
                if (!this.getDFMap("FC", this.line, 6, FC_LIST, 3)) {
                    return false;
                }
                slater[1] = 6;
                break;
            }
            case 9: {
                if (!this.getDFMap("GS", this.line, 7, GS_LIST, 3)) {
                    return false;
                }
                slater[1] = 7;
                break;
            }
            case 15: {
                if (!this.getDFMap("GC", this.line, 8, GC_LIST, 3)) {
                    return false;
                }
                slater[1] = 8;
                break;
            }
            case 11: {
                if (!this.getDFMap("HS", this.line, 9, HS_LIST, 3)) {
                    return false;
                }
                slater[1] = 9;
                break;
            }
            case 21: {
                if (!this.getDFMap("HC", this.line, 10, HC_LIST, 3)) {
                    return false;
                }
                slater[1] = 10;
                break;
            }
            case 13: {
                if (!this.getDFMap("IS", this.line, 11, IS_LIST, 3)) {
                    return false;
                }
                slater[1] = 11;
                break;
            }
            case 28: {
                if (!this.getDFMap("IC", this.line, 12, IC_LIST, 3)) {
                    return false;
                }
                slater[1] = 12;
                break;
            }
            default: {
                Logger.error("Unrecognized orbital slater count: " + n);
            }
        }
        slater[2] = pt + 1;
        slater[3] = ng;
        this.shells.addLast(slater);
        return true;
    }

    private void getAlphasAndExponents() throws Exception {
        for (int j = 0; j < 5; ++j) {
            if (this.line.indexOf("=") < 0) {
                this.rd();
            }
            if (this.line.indexOf("$END") >= 0) break;
            this.line = this.line.substring(this.line.indexOf("=") + 1);
            float[] temp = this.fillFloatArray(this.line, 0, new float[this.gaussianCount]);
            for (int i = 0; i < this.gaussianCount; ++i) {
                this.gaussians[i][j] = temp[i];
                if (j <= 1) continue;
                float[] fArray = this.gaussians[i];
                fArray[5] = fArray[5] + temp[i];
            }
        }
        for (int i = 0; i < this.gaussianCount; ++i) {
            if (this.gaussians[i][1] != 0.0f) continue;
            this.gaussians[i][1] = this.gaussians[i][5];
        }
        if (this.debugging) {
            Logger.debug(this.shells.size() + " slater shells read");
            Logger.debug(this.gaussians.length + " gaussian primitives read");
        }
    }

    private boolean readData31(String line1) throws Exception {
        int i;
        if (line1 == null) {
            line1 = this.rd();
            this.rd();
        }
        this.rd();
        String[] tokens = PT.getTokens(this.rd());
        int ac = this.parseIntStr(tokens[0]);
        this.shellCount = this.parseIntStr(tokens[1]);
        this.gaussianCount = this.parseIntStr(tokens[2]);
        if (tokens.length < 4) {
            Logger.error("NOTE! .31 file is old; d orbitals are not normalized");
        }
        this.rd();
        this.asc.newAtomSet();
        this.asc.setAtomSetName(this.nboType + "s: " + line1.trim());
        this.asc.setCurrentModelInfo("nboType", this.nboType);
        for (i = 0; i < ac; ++i) {
            tokens = PT.getTokens(this.rd());
            int z = this.parseIntStr(tokens[0]);
            if (z < 0) continue;
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)z;
            this.setAtomCoordTokens(atom, tokens, 1);
        }
        this.shells = new Lst();
        this.gaussians = AU.newFloat2(this.gaussianCount);
        for (i = 0; i < this.gaussianCount; ++i) {
            this.gaussians[i] = new float[6];
        }
        this.rd();
        this.nOrbitals = 0;
        for (i = 0; i < this.shellCount; ++i) {
            tokens = PT.getTokens(this.rd());
            int[] slater = new int[4];
            slater[0] = this.parseIntStr(tokens[0]);
            int n = this.parseIntStr(tokens[1]);
            int pt = this.parseIntStr(tokens[2]) - 1;
            int ng = this.parseIntStr(tokens[3]);
            this.line = this.rd();
            int j = (n - 1) / 10;
            while (--j >= 0) {
                this.line = this.line + this.rd().substring(1);
            }
            this.line = this.line.trim();
            System.out.println(this.line);
            if (this.fillSlater(slater, n, pt, ng)) continue;
            return false;
        }
        this.rd();
        this.getAlphasAndExponents();
        return true;
    }

    private void readData46() throws Exception {
        Hashtable<String, String[]> map = new Hashtable<String, String[]>();
        String[] tokens = new String[]{};
        this.rd();
        this.nNOs = this.nAOs = this.nOrbitals;
        int nNOs = this.nAOs;
        String labelKey = GenNBOReader.getLabelKey(this.nboType);
        while (this.line != null && this.line.length() > 0) {
            tokens = PT.getTokens(this.line);
            String type = tokens[0];
            this.isOpenShell = tokens.length == 3;
            String ab = this.isOpenShell ? tokens[1] : "";
            String count = tokens[tokens.length - 1];
            String key = (ab.equals("BETA") ? "beta_" : "") + type;
            if (this.parseIntStr(count) != this.nOrbitals) {
                Logger.error("file 46 number of orbitals for " + this.line + " (" + count + ") does not match nOrbitals: " + this.nOrbitals + "\n");
                nNOs = this.parseIntStr(count);
            }
            if (type.equals(labelKey)) {
                this.nNOs = nNOs;
            }
            SB sb = new SB();
            while (this.rd() != null && this.line.length() > 4 && " NA NB AO NH".indexOf(this.line.substring(1, 4)) < 0) {
                sb.append(this.line.substring(1));
            }
            System.out.println(sb.length());
            tokens = new String[sb.length() / 10];
            int i = 0;
            int pt = 0;
            while (i < tokens.length) {
                tokens[i] = PT.rep(sb.substring2(pt, pt + 10), " ", "");
                ++i;
                pt += 10;
            }
            map.put(key, tokens);
        }
        tokens = (String[])map.get((this.betaOnly ? "beta_" : "") + labelKey);
        this.moData.put("nboLabelMap", map);
        if (tokens == null) {
            tokens = new String[nNOs];
            for (int i = 0; i < nNOs; ++i) {
                tokens[i] = this.nboType + (i + 1);
            }
            map.put(labelKey, tokens);
            if (this.isOpenShell) {
                map.put("beta_" + labelKey, tokens);
            }
        }
        this.moData.put("nboLabels", tokens);
        boolean bl = this.addBetaSet = this.isOpenShell && !this.betaOnly && !this.is47File;
        if (this.addBetaSet) {
            this.nOrbitals *= 2;
        }
        for (int i = 0; i < this.nOrbitals; ++i) {
            this.setMO(new Hashtable<String, Object>());
        }
        GenNBOReader.setNboLabels(tokens, nNOs, this.orbitals, this.nOrbitals0, this.nboType);
        if (this.addBetaSet) {
            this.moData.put("firstBeta", nNOs);
            GenNBOReader.setNboLabels((String[])map.get("beta_" + labelKey), nNOs, this.orbitals, this.nOrbitals0 + nNOs, this.nboType);
        }
        Lst<Object> structures = this.getStructureList();
        NBOParser.getStructures46((String[])map.get("NBO"), "alpha", structures, this.asc.ac);
        NBOParser.getStructures46((String[])map.get("beta_NBO"), "beta", structures, this.asc.ac);
    }

    private static String getLabelKey(String labelKey) {
        if (labelKey.startsWith("P")) {
            labelKey = labelKey.substring(1);
        }
        if (labelKey.equals("NLMO")) {
            labelKey = "NBO";
        }
        if (labelKey.equals("MO")) {
            labelKey = "NO";
        }
        return labelKey;
    }

    public static boolean readNBOCoefficients(Map<String, Object> moData, String nboType, Viewer vwr) {
        int ext = ";AO;  ;PNAO;;NAO; ;PNHO;;NHO; ;PNBO;;NBO; ;PNLMO;NLMO;;MO;  ;NO;".indexOf(";" + nboType + ";");
        ext = ext / 6 + 31;
        boolean isAO = nboType.equals("AO");
        boolean isNBO = nboType.equals("NBO");
        boolean hasNoBeta = PT.isOneOf(nboType, ";AO;PNAO;NAO;");
        Map map = (Map)moData.get("nboLabelMap");
        int nAOs = ((String[])map.get("AO")).length;
        String labelKey = GenNBOReader.getLabelKey(nboType);
        String[] nboLabels = (String[])map.get(labelKey);
        if (nboLabels == null) {
            nboLabels = new String[nAOs];
            for (int i = 0; i < nAOs; ++i) {
                nboLabels[i] = nboType + (i + 1);
            }
            labelKey = nboType;
            map.put(labelKey, nboLabels);
            if (!hasNoBeta) {
                map.put("beta_" + labelKey, nboLabels);
            }
        }
        int nMOs = nboLabels.length;
        try {
            Lst<Map<String, Object>> orbitals = (Lst<Map<String, Object>>)moData.get(nboType + "_coefs");
            if (orbitals == null) {
                Map<String, float[]> mo;
                String data = null;
                if (!isAO) {
                    String fileName = moData.get("nboRoot") + "." + ext;
                    data = vwr.getFileAsString3(fileName, true, null);
                    if (data == null) {
                        return false;
                    }
                    data = data.substring(data.indexOf("--\n") + 3).toLowerCase();
                    if (ext == 33) {
                        data = data.substring(0, data.indexOf("--\n") + 3);
                    }
                }
                orbitals = (Lst)moData.get("mos");
                Object dfCoefMaps = ((Map)orbitals.get(0)).get("dfCoefMaps");
                orbitals = new Lst<Map<String, Object>>();
                int len = 0;
                int[] next = null;
                int nOrbitals = nMOs;
                if (!isAO) {
                    if (data.indexOf("alpha") >= 0) {
                        nOrbitals *= 2;
                        data = data.substring(data.indexOf("alpha") + 10);
                    }
                    len = data.length();
                    next = new int[1];
                }
                int i = nOrbitals;
                while (--i >= 0) {
                    mo = new Hashtable();
                    orbitals.addLast(mo);
                    if (dfCoefMaps == null) continue;
                    mo.put("dfCoefMaps", (float[])dfCoefMaps);
                }
                GenNBOReader.setNboLabels(nboLabels, nMOs, orbitals, 0, nboType);
                for (i = 0; i < nOrbitals; ++i) {
                    if (!isAO && i == nMOs) {
                        if (isNBO) {
                            GenNBOReader.getNBOOccupanciesStatic(orbitals, nMOs, 0, data, len, next);
                        }
                        nboLabels = (String[])map.get("beta_" + labelKey);
                        next[0] = hasNoBeta ? 0 : data.indexOf("beta  spin") + 12;
                    }
                    mo = (Map)orbitals.get(i);
                    float[] coefs = new float[nAOs];
                    if (isAO) {
                        coefs[i % nAOs] = 1.0f;
                    } else if (i >= nAOs && hasNoBeta) {
                        coefs = (float[])((Map)orbitals.get(i % nAOs)).get("coefficients");
                    } else {
                        for (int j = 0; j < nAOs; ++j) {
                            coefs[j] = PT.parseFloatChecked(data, len, next, false);
                            if (!Float.isNaN(coefs[j])) continue;
                            System.out.println("oops = IsoExt ");
                        }
                    }
                    mo.put("coefficients", coefs);
                }
                if (isNBO) {
                    GenNBOReader.getNBOOccupanciesStatic(orbitals, nMOs, nOrbitals - nMOs, data, len, next);
                }
                moData.put(nboType + "_coefs", orbitals);
            }
            moData.put("nboType", nboType);
            moData.put("nboLabels", nboLabels);
            moData.put("mos", orbitals);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void getNBOOccupanciesStatic(Lst<Map<String, Object>> orbitals, int nAOs, int pt, String data, int len, int[] next) {
        float[] occupancies = new float[nAOs];
        for (int j = 0; j < nAOs; ++j) {
            occupancies[j] = PT.parseFloatChecked(data, len, next, false);
        }
        for (int i = 0; i < nAOs; ++i) {
            Map mo = (Map)orbitals.get(pt + i);
            mo.put("occupancy", Float.valueOf(occupancies[i]));
        }
    }

    private void readMOs() throws Exception {
        boolean isAO = this.nboType.equals("AO");
        boolean isNBO = this.nboType.equals("NBO");
        boolean discardExtra = PT.isOneOf(this.nboType, ";NBO;NLMO;");
        boolean hasNoBeta = PT.isOneOf(this.nboType, ";AO;PNAO;NAO;");
        this.nOrbitals0 = this.orbitals.size();
        this.getFile46();
        if (this.betaOnly) {
            this.discardLinesUntilContains("BETA");
            this.filterMO();
        }
        this.nOrbitals = this.orbitals.size();
        if (this.nOrbitals == 0) {
            return;
        }
        this.line = null;
        int pt = 0;
        int i = this.nOrbitals0;
        int n = this.nOrbitals0 + this.nOrbitals;
        while (i < n) {
            if (pt == this.nNOs) {
                if (isNBO) {
                    this.readNBO37Occupancies(pt);
                }
                if (discardExtra) {
                    this.discardLinesUntilContains2("BETA", "beta");
                }
            }
            Map mo = (Map)this.orbitals.get(i);
            float[] coefs = new float[this.nAOs];
            if (isAO) {
                coefs[pt % this.nAOs] = 1.0f;
            } else if (pt >= this.nNOs && hasNoBeta) {
                coefs = (float[])((Map)this.orbitals.get(pt % this.nNOs)).get("coefficients");
            } else {
                if (this.line == null) {
                    while (this.rd() != null && Float.isNaN(this.parseFloatStr(this.line))) {
                        this.filterMO();
                    }
                } else {
                    this.line = null;
                }
                this.fillFloatArray(this.line, 0, coefs);
                this.line = null;
            }
            mo.put("coefficients", coefs);
            ++i;
            ++pt;
        }
        if (isNBO) {
            this.readNBO37Occupancies(pt);
        }
        this.moData.put(this.nboType + "_coefs", this.orbitals);
        this.setMOData(false);
        this.moData.put("nboType", this.nboType);
        Logger.info(this.orbitals.size() - this.nOrbitals0 + " orbitals read");
    }

    private void readNBO37Occupancies(int pt) throws Exception {
        float[] occupancies = new float[this.nNOs];
        this.fillFloatArray(null, 0, occupancies);
        for (int i = 0; i < this.nNOs; ++i) {
            Map mo = (Map)this.orbitals.get(this.nOrbitals0 + pt - this.nNOs + i);
            mo.put("occupancy", Float.valueOf(occupancies[i]));
        }
    }

    public static void setNboLabels(String[] tokens, int nLabels, Lst<Map<String, Object>> orbitals, int nOrbitals0, String moType) {
        boolean addOccupancy;
        boolean alphaBeta = orbitals.size() == nLabels * 2;
        boolean bl = addOccupancy = !PT.isOneOf(moType, ";AO;NAO;PNAO;MO;NO;");
        String ab = !alphaBeta ? "" : (nOrbitals0 == 0 ? " alpha" : " beta");
        for (int j = 0; j < nLabels; ++j) {
            Map mo = (Map)orbitals.get(j + nOrbitals0);
            String type = tokens[j];
            mo.put("type", moType + " " + type + ab);
            if (!addOccupancy) continue;
            mo.put("occupancy", Float.valueOf(alphaBeta ? 1.0f : (type.indexOf("*") >= 0 || type.indexOf("(ry)") >= 0 ? 0.0f : 2.0f)));
        }
    }
}

