/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirSimpleDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirAnnotationCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirArrayOfCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirClassReferenceExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirConstExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirErrorExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirFunctionCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirGetClassCallImpl;
import org.jetbrains.kotlin.fir.impl.FirAbstractAnnotatedElement;
import org.jetbrains.kotlin.fir.java.JavaTypeParameterStack;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameter;
import org.jetbrains.kotlin.fir.java.enhancement.JavaTypeUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.impl.FirErrorNamedReferenceImpl;
import org.jetbrains.kotlin.fir.references.impl.FirResolvedNamedReferenceImpl;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationAsAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationOwner;
import org.jetbrains.kotlin.load.java.structure.JavaArrayAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassObjectAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaElementsKt;
import org.jetbrains.kotlin.load.java.structure.JavaEnumValueAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaModifierListOwner;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.JavaWildcardType;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u00b6\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a.\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u00162\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0018H\u0002\u001a\u0016\u0010\u0019\u001a\u00020\u001a*\u0004\u0018\u00010\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a'\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\u0010$\u001a$\u0010%\u001a\u00020\u001d*\u00020&2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a&\u0010%\u001a\u00020\u001d*\u0004\u0018\u00010'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0000\u001a(\u0010(\u001a\u00020!*\u0004\u0018\u00010'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010*H\u0000\u001a\u001c\u0010+\u001a\u00020,*\u00020-2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u001c\u0010.\u001a\u00020\u001a*\u00020/2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001c\u00100\u001a\u000201*\u00020'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a&\u00102\u001a\u000203*\u00020&2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\"\u001a\u00020#H\u0000\u001a\u001c\u00102\u001a\u000203*\u00020'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a$\u00104\u001a\u000205*\u0002062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u001c\u00109\u001a\u00020:*\u00020;2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u001e\u00109\u001a\u00020\u001d*\u0004\u0018\u00010'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006<"}, d2={"classKind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "getClassKind", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClass;)Lorg/jetbrains/kotlin/descriptors/ClassKind;", "modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "Lorg/jetbrains/kotlin/load/java/structure/JavaModifierListOwner;", "getModality", "(Lorg/jetbrains/kotlin/load/java/structure/JavaModifierListOwner;)Lorg/jetbrains/kotlin/descriptors/Modality;", "addAnnotationsFrom", "", "Lorg/jetbrains/kotlin/fir/impl/FirAbstractAnnotatedElement;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "javaAnnotationOwner", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationOwner;", "javaTypeParameterStack", "Lorg/jetbrains/kotlin/fir/java/JavaTypeParameterStack;", "createArrayOfCall", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayOfCall;", "T", "", "kind", "Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;", "createConstant", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "", "toConeKotlinType", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "Lorg/jetbrains/kotlin/name/ClassId;", "typeArguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinTypeProjection;", "isNullable", "", "(Lorg/jetbrains/kotlin/name/ClassId;[Lorg/jetbrains/kotlin/fir/types/ConeKotlinTypeProjection;Z)Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "toConeKotlinTypeWithNullability", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "toConeProjection", "boundTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "toFirAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "toFirExpression", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationArgument;", "toFirJavaTypeRef", "Lorg/jetbrains/kotlin/fir/types/jvm/FirJavaTypeRef;", "toFirResolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "toFirValueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/load/java/structure/JavaValueParameter;", "index", "", "toNotNullConeKotlinType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "java"})
public final class JavaUtilsKt {
    @NotNull
    public static final Modality getModality(@NotNull JavaModifierListOwner $this$modality) {
        Intrinsics.checkParameterIsNotNull($this$modality, "$this$modality");
        return $this$modality.isAbstract() ? Modality.ABSTRACT : ($this$modality.isFinal() ? Modality.FINAL : Modality.OPEN);
    }

    @NotNull
    public static final ClassKind getClassKind(@NotNull JavaClass $this$classKind) {
        Intrinsics.checkParameterIsNotNull($this$classKind, "$this$classKind");
        return $this$classKind.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : ($this$classKind.isInterface() ? ClassKind.INTERFACE : ($this$classKind.isEnum() ? ClassKind.ENUM_CLASS : ClassKind.CLASS));
    }

    @NotNull
    public static final ConeLookupTagBasedType toConeKotlinType(@NotNull ClassId $this$toConeKotlinType, @NotNull ConeKotlinTypeProjection[] typeArguments2, boolean isNullable2) {
        Intrinsics.checkParameterIsNotNull($this$toConeKotlinType, "$this$toConeKotlinType");
        Intrinsics.checkParameterIsNotNull(typeArguments2, "typeArguments");
        ConeClassLikeLookupTagImpl lookupTag = new ConeClassLikeLookupTagImpl($this$toConeKotlinType);
        return new ConeClassLikeTypeImpl(lookupTag, typeArguments2, isNullable2);
    }

    @NotNull
    public static final ConeKotlinType toNotNullConeKotlinType(@NotNull FirTypeRef $this$toNotNullConeKotlinType, @NotNull FirSession session, @NotNull JavaTypeParameterStack javaTypeParameterStack) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkParameterIsNotNull($this$toNotNullConeKotlinType, "$this$toNotNullConeKotlinType");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(javaTypeParameterStack, "javaTypeParameterStack");
        FirTypeRef firTypeRef = $this$toNotNullConeKotlinType;
        if (firTypeRef instanceof FirResolvedTypeRef) {
            coneKotlinType = ((FirResolvedTypeRef)$this$toNotNullConeKotlinType).getType();
        } else if (firTypeRef instanceof FirJavaTypeRef) {
            JavaType javaType = ((FirJavaTypeRef)$this$toNotNullConeKotlinType).getType();
            coneKotlinType = JavaUtilsKt.toNotNullConeKotlinType(javaType, session, javaTypeParameterStack);
        } else {
            coneKotlinType = new ConeClassErrorType("Unexpected type reference in JavaClassUseSiteMemberScope: " + $this$toNotNullConeKotlinType.getClass());
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ConeLookupTagBasedType toNotNullConeKotlinType(@Nullable JavaType $this$toNotNullConeKotlinType, @NotNull FirSession session, @NotNull JavaTypeParameterStack javaTypeParameterStack) {
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(javaTypeParameterStack, "javaTypeParameterStack");
        return JavaUtilsKt.toConeKotlinTypeWithNullability($this$toNotNullConeKotlinType, session, javaTypeParameterStack, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirJavaTypeRef toFirJavaTypeRef(@NotNull JavaType $this$toFirJavaTypeRef, @NotNull FirSession session, @NotNull JavaTypeParameterStack javaTypeParameterStack) {
        Collection<FirAnnotationCall> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$toFirJavaTypeRef, "$this$toFirJavaTypeRef");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(javaTypeParameterStack, "javaTypeParameterStack");
        JavaType javaType = $this$toFirJavaTypeRef;
        if (!(javaType instanceof JavaClassifierType)) {
            javaType = null;
        }
        JavaClassifierType javaClassifierType = (JavaClassifierType)javaType;
        Collection collection2 = javaClassifierType != null ? javaClassifierType.getAnnotations() : null;
        boolean bl = false;
        Collection collection3 = collection2;
        if (collection3 == null) {
            collection3 = CollectionsKt.emptyList();
        }
        Collection annotations2 = collection3;
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JavaAnnotation javaAnnotation = (JavaAnnotation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            FirAnnotationCall firAnnotationCall = JavaUtilsKt.toFirAnnotationCall((JavaAnnotation)it, session, javaTypeParameterStack);
            collection.add(firAnnotationCall);
        }
        collection = (List)destination$iv$iv;
        JavaType javaType2 = $this$toFirJavaTypeRef;
        List list2 = collection;
        return new FirJavaTypeRef(list2, javaType2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirResolvedTypeRef toFirResolvedTypeRef(@NotNull JavaClassifierType $this$toFirResolvedTypeRef, @NotNull FirSession session, @NotNull JavaTypeParameterStack javaTypeParameterStack, boolean isNullable2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$toFirResolvedTypeRef, "$this$toFirResolvedTypeRef");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(javaTypeParameterStack, "javaTypeParameterStack");
        ConeLookupTagBasedType coneType = JavaUtilsKt.toConeKotlinTypeWithNullability((JavaType)$this$toFirResolvedTypeRef, session, javaTypeParameterStack, isNullable2);
        FirResolvedTypeRefImpl firResolvedTypeRefImpl = new FirResolvedTypeRefImpl(null, coneType);
        boolean bl = false;
        boolean bl2 = false;
        FirResolvedTypeRefImpl $this$apply = firResolvedTypeRefImpl;
        boolean bl3 = false;
        Collection collection = $this$apply.getAnnotations();
        Iterable $this$map$iv = $this$toFirResolvedTypeRef.getAnnotations();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JavaAnnotation javaAnnotation = (JavaAnnotation)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl4 = false;
            FirAnnotationCall firAnnotationCall = JavaUtilsKt.toFirAnnotationCall((JavaAnnotation)it, session, javaTypeParameterStack);
            collection2.add(firAnnotationCall);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        boolean bl5 = false;
        CollectionsKt.addAll(collection, iterable2);
        return firResolvedTypeRefImpl;
    }

    public static /* synthetic */ FirResolvedTypeRef toFirResolvedTypeRef$default(JavaClassifierType javaClassifierType, FirSession firSession, JavaTypeParameterStack javaTypeParameterStack, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return JavaUtilsKt.toFirResolvedTypeRef(javaClassifierType, firSession, javaTypeParameterStack, bl);
    }

    @NotNull
    public static final ConeLookupTagBasedType toConeKotlinTypeWithNullability(@Nullable JavaType $this$toConeKotlinTypeWithNullability, @NotNull FirSession session, @NotNull JavaTypeParameterStack javaTypeParameterStack, boolean isNullable2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(javaTypeParameterStack, "javaTypeParameterStack");
        JavaType javaType = $this$toConeKotlinTypeWithNullability;
        if (javaType instanceof JavaClassifierType) {
            object = JavaUtilsKt.toConeKotlinTypeWithNullability((JavaClassifierType)$this$toConeKotlinTypeWithNullability, session, isNullable2, javaTypeParameterStack);
        } else if (javaType instanceof JavaPrimitiveType) {
            ClassId classId;
            PrimitiveType primitiveType = ((JavaPrimitiveType)$this$toConeKotlinTypeWithNullability).getType();
            Object object2 = primitiveType;
            String javaName = object2 != null && (object2 = object2.getTypeName()) != null ? ((Name)object2).asString() : null;
            String kotlinPrimitiveName = javaName == null ? "Unit" : StringsKt.capitalize(javaName);
            ClassId classId2 = classId = StandardClassIds.INSTANCE.byName(kotlinPrimitiveName);
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = new ConeKotlinTypeProjection[]{};
            object = JavaUtilsKt.toConeKotlinType(classId2, coneKotlinTypeProjectionArray, isNullable2);
        } else if (javaType instanceof JavaArrayType) {
            JavaType componentType = ((JavaArrayType)$this$toConeKotlinTypeWithNullability).getComponentType();
            if (!(componentType instanceof JavaPrimitiveType)) {
                ClassId classId = StandardClassIds.INSTANCE.getArray();
                ConeFlexibleType argumentType = new ConeFlexibleType(JavaUtilsKt.toConeKotlinTypeWithNullability(componentType, session, javaTypeParameterStack, false), JavaUtilsKt.toConeKotlinTypeWithNullability(componentType, session, javaTypeParameterStack, true));
                object = JavaUtilsKt.toConeKotlinType(classId, new ConeKotlinTypeProjection[]{argumentType}, isNullable2);
            } else {
                ClassId classId;
                Object object3 = ((JavaPrimitiveType)componentType).getType();
                if (object3 == null || (object3 = object3.getTypeName()) == null || (object3 = ((Name)object3).asString()) == null || (object3 = StringsKt.capitalize((String)object3)) == null) {
                    String argumentType = "Array of voids";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(argumentType.toString());
                }
                PrimitiveType javaComponentName = object3;
                ClassId classId3 = classId = StandardClassIds.INSTANCE.byName((String)((Object)javaComponentName) + "Array");
                ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = new ConeKotlinTypeProjection[]{};
                object = JavaUtilsKt.toConeKotlinType(classId3, coneKotlinTypeProjectionArray, isNullable2);
            }
        } else if (javaType instanceof JavaWildcardType) {
            object = ((JavaWildcardType)$this$toConeKotlinTypeWithNullability).getBound();
            if (object == null || (object = JavaUtilsKt.toNotNullConeKotlinType((JavaType)object, session, javaTypeParameterStack)) == null) {
                ClassId classId;
                JavaType componentType = $this$toConeKotlinTypeWithNullability;
                boolean bl = false;
                boolean bl2 = false;
                JavaWildcardType $this$run = (JavaWildcardType)componentType;
                boolean bl3 = false;
                ClassId classId4 = classId = StandardClassIds.INSTANCE.getAny();
                ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = new ConeKotlinTypeProjection[]{};
                object = JavaUtilsKt.toConeKotlinType(classId4, coneKotlinTypeProjectionArray, isNullable2);
            }
        } else if (javaType == null) {
            ClassId classId;
            ClassId classId5 = classId = StandardClassIds.INSTANCE.getAny();
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = new ConeKotlinTypeProjection[]{};
            object = JavaUtilsKt.toConeKotlinType(classId5, coneKotlinTypeProjectionArray, isNullable2);
        } else {
            String string2 = "Strange JavaType: " + $this$toConeKotlinTypeWithNullability.getClass();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeLookupTagBasedType toConeKotlinTypeWithNullability(@NotNull JavaClassifierType $this$toConeKotlinTypeWithNullability, @NotNull FirSession session, boolean isNullable2, @NotNull JavaTypeParameterStack javaTypeParameterStack) {
        ConeLookupTagBasedType coneLookupTagBasedType;
        Intrinsics.checkParameterIsNotNull($this$toConeKotlinTypeWithNullability, "$this$toConeKotlinTypeWithNullability");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(javaTypeParameterStack, "javaTypeParameterStack");
        JavaClassifier classifier2 = $this$toConeKotlinTypeWithNullability.getClassifier();
        if (classifier2 instanceof JavaClass) {
            void $this$toTypedArray$iv;
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray;
            void $this$mapIndexedTo$iv$iv;
            Collection $this$mapIndexed$iv;
            ClassId classId;
            ClassId classId2;
            ClassId classId3;
            FqName fqName2 = ((JavaClass)classifier2).getFqName();
            if (fqName2 == null) {
                Intrinsics.throwNpe();
            }
            if ((classId3 = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2)) == null && (classId3 = JavaElementsKt.getClassId((JavaClass)classifier2)) == null) {
                Intrinsics.throwNpe();
            }
            if ((classId2 = JavaTypeUtilsKt.readOnlyToMutable(classId = classId3)) == null) {
                classId2 = classId;
            }
            classId = classId2;
            ConeClassLikeLookupTagImpl lookupTag = new ConeClassLikeLookupTagImpl(classId);
            Iterable iterable = $this$toConeKotlinTypeWithNullability.getTypeArguments();
            ConeClassLikeLookupTag coneClassLikeLookupTag = lookupTag;
            boolean $i$f$mapIndexed = false;
            void var9_11 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void argument;
                int n = index$iv$iv++;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                JavaType javaType = (JavaType)item$iv$iv;
                int n3 = n2;
                coneKotlinTypeProjectionArray = collection;
                boolean bl2 = false;
                ConeKotlinTypeProjection coneKotlinTypeProjection = JavaUtilsKt.toConeProjection((JavaType)argument, session, javaTypeParameterStack, null);
                coneKotlinTypeProjectionArray.add(coneKotlinTypeProjection);
            }
            coneKotlinTypeProjectionArray = (ConeKotlinTypeProjection[])destination$iv$iv;
            $this$mapIndexed$iv = (Collection)coneKotlinTypeProjectionArray;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray2 = thisCollection$iv.toArray(new ConeKotlinTypeProjection[0]);
            if (coneKotlinTypeProjectionArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            coneKotlinTypeProjectionArray = coneKotlinTypeProjectionArray2;
            coneLookupTagBasedType = ResolveUtilsKt.constructClassType(coneClassLikeLookupTag, coneKotlinTypeProjectionArray, isNullable2);
        } else if (classifier2 instanceof JavaTypeParameter) {
            FirTypeParameterSymbol symbol2 = javaTypeParameterStack.get((JavaTypeParameter)classifier2);
            coneLookupTagBasedType = new ConeTypeParameterTypeImpl(symbol2.toLookupTag(), isNullable2);
        } else {
            coneLookupTagBasedType = new ConeClassErrorType("Unexpected classifier: " + classifier2);
        }
        return coneLookupTagBasedType;
    }

    @NotNull
    public static final FirAnnotationCall toFirAnnotationCall(@NotNull JavaAnnotation $this$toFirAnnotationCall, @NotNull FirSession session, @NotNull JavaTypeParameterStack javaTypeParameterStack) {
        Intrinsics.checkParameterIsNotNull($this$toFirAnnotationCall, "$this$toFirAnnotationCall");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(javaTypeParameterStack, "javaTypeParameterStack");
        ClassId classId = $this$toFirAnnotationCall.getClassId();
        if (classId == null) {
            Intrinsics.throwNpe();
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = new FirRegularClassSymbol(classId).toLookupTag();
        FirSourceElement firSourceElement = null;
        AnnotationUseSiteTarget annotationUseSiteTarget = null;
        FirSourceElement firSourceElement2 = null;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = new ConeKotlinTypeProjection[]{};
        boolean bl = false;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray2 = coneKotlinTypeProjectionArray;
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
        ConeKotlinType coneKotlinType = new ConeClassLikeTypeImpl(coneClassLikeLookupTag2, coneKotlinTypeProjectionArray2, bl);
        FirSourceElement firSourceElement3 = firSourceElement;
        FirTypeRef firTypeRef = new FirResolvedTypeRefImpl(firSourceElement3, coneKotlinType);
        AnnotationUseSiteTarget annotationUseSiteTarget2 = annotationUseSiteTarget;
        FirSourceElement firSourceElement4 = firSourceElement2;
        FirAnnotationCallImpl firAnnotationCallImpl = new FirAnnotationCallImpl(firSourceElement4, annotationUseSiteTarget2, firTypeRef);
        boolean bl2 = false;
        boolean bl3 = false;
        FirAnnotationCallImpl $this$apply = firAnnotationCallImpl;
        boolean bl4 = false;
        for (JavaAnnotationArgument argument : $this$toFirAnnotationCall.getArguments()) {
            Collection collection = $this$apply.getArguments();
            FirExpression firExpression2 = JavaUtilsKt.toFirExpression(argument, session, javaTypeParameterStack);
            boolean bl5 = false;
            collection.add(firExpression2);
        }
        return firAnnotationCallImpl;
    }

    public static final void addAnnotationsFrom(@NotNull FirAbstractAnnotatedElement $this$addAnnotationsFrom, @NotNull FirSession session, @NotNull JavaAnnotationOwner javaAnnotationOwner, @NotNull JavaTypeParameterStack javaTypeParameterStack) {
        Intrinsics.checkParameterIsNotNull($this$addAnnotationsFrom, "$this$addAnnotationsFrom");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(javaAnnotationOwner, "javaAnnotationOwner");
        Intrinsics.checkParameterIsNotNull(javaTypeParameterStack, "javaTypeParameterStack");
        for (JavaAnnotation annotation2 : javaAnnotationOwner.getAnnotations()) {
            Collection collection = $this$addAnnotationsFrom.getAnnotations();
            FirAnnotationCall firAnnotationCall = JavaUtilsKt.toFirAnnotationCall(annotation2, session, javaTypeParameterStack);
            boolean bl = false;
            collection.add(firAnnotationCall);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirValueParameter toFirValueParameter(@NotNull JavaValueParameter $this$toFirValueParameter, @NotNull FirSession session, int index2, @NotNull JavaTypeParameterStack javaTypeParameterStack) {
        FirPsiSourceElement firPsiSourceElement;
        Object object;
        JavaElementImpl javaElementImpl;
        Intrinsics.checkParameterIsNotNull($this$toFirValueParameter, "$this$toFirValueParameter");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(javaTypeParameterStack, "javaTypeParameterStack");
        FirSession firSession = session;
        JavaValueParameter javaValueParameter = $this$toFirValueParameter;
        if (!(javaValueParameter instanceof JavaElementImpl)) {
            javaValueParameter = null;
        }
        if ((javaElementImpl = (JavaElementImpl)((Object)javaValueParameter)) != null && (javaElementImpl = javaElementImpl.getPsi()) != null) {
            void $this$toFirSourceElement$iv;
            object = javaElementImpl;
            FirSession firSession2 = firSession;
            boolean $i$f$toFirSourceElement = false;
            FirPsiSourceElement firPsiSourceElement2 = new FirPsiSourceElement((PsiElement)$this$toFirSourceElement$iv);
            firSession = firSession2;
            firPsiSourceElement = firPsiSourceElement2;
        } else {
            firPsiSourceElement = null;
        }
        FirSourceElement firSourceElement = firPsiSourceElement;
        Name name = $this$toFirValueParameter.getName();
        if (name == null) {
            Name name2 = Name.identifier("" + 'p' + index2);
            name = name2;
            Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(\"p$index\")");
        }
        boolean bl = $this$toFirValueParameter.isVararg();
        FirJavaTypeRef firJavaTypeRef = JavaUtilsKt.toFirJavaTypeRef($this$toFirValueParameter.getType(), session, javaTypeParameterStack);
        Name name3 = name;
        FirSourceElement firSourceElement2 = firSourceElement;
        FirSession firSession3 = firSession;
        object = new FirJavaValueParameter(firSession3, firSourceElement2, name3, firJavaTypeRef, bl);
        boolean bl2 = false;
        boolean bl3 = false;
        Object $this$apply = object;
        boolean bl4 = false;
        JavaUtilsKt.addAnnotationsFrom((FirAbstractAnnotatedElement)$this$apply, session, $this$toFirValueParameter, javaTypeParameterStack);
        return (FirValueParameter)object;
    }

    @NotNull
    public static final ConeKotlinTypeProjection toConeProjection(@Nullable JavaType $this$toConeProjection, @NotNull FirSession session, @NotNull JavaTypeParameterStack javaTypeParameterStack, @Nullable FirTypeParameter boundTypeParameter) {
        ConeKotlinTypeProjection coneKotlinTypeProjection;
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(javaTypeParameterStack, "javaTypeParameterStack");
        JavaType javaType = $this$toConeProjection;
        if (javaType == null) {
            coneKotlinTypeProjection = ConeStarProjection.INSTANCE;
        } else if (javaType instanceof JavaWildcardType) {
            Object parameterVariance;
            JavaType bound = ((JavaWildcardType)$this$toConeProjection).getBound();
            Variance argumentVariance = ((JavaWildcardType)$this$toConeProjection).isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE;
            Object object = boundTypeParameter;
            if (object == null || (object = object.getVariance()) == null) {
                object = parameterVariance = Variance.INVARIANT;
            }
            if (bound == null || parameterVariance != Variance.INVARIANT && parameterVariance != argumentVariance) {
                coneKotlinTypeProjection = ConeStarProjection.INSTANCE;
            } else {
                ConeLookupTagBasedType boundType = JavaUtilsKt.toConeKotlinTypeWithNullability(bound, session, javaTypeParameterStack, false);
                coneKotlinTypeProjection = argumentVariance == Variance.OUT_VARIANCE ? new ConeKotlinTypeProjectionOut(boundType) : new ConeKotlinTypeProjectionIn(boundType);
            }
        } else {
            coneKotlinTypeProjection = javaType instanceof JavaClassifierType ? (ConeKotlinTypeProjection)JavaUtilsKt.toConeKotlinTypeWithNullability($this$toConeProjection, session, javaTypeParameterStack, false) : (ConeKotlinTypeProjection)new ConeClassErrorType("Unexpected type argument: " + $this$toConeProjection);
        }
        return coneKotlinTypeProjection;
    }

    private static final FirExpression toFirExpression(@NotNull JavaAnnotationArgument $this$toFirExpression, FirSession session, JavaTypeParameterStack javaTypeParameterStack) {
        FirExpression firExpression2;
        JavaAnnotationArgument javaAnnotationArgument = $this$toFirExpression;
        if (javaAnnotationArgument instanceof JavaLiteralAnnotationArgument) {
            firExpression2 = JavaUtilsKt.createConstant(((JavaLiteralAnnotationArgument)$this$toFirExpression).getValue(), session);
        } else if (javaAnnotationArgument instanceof JavaArrayAnnotationArgument) {
            FirArrayOfCallImpl firArrayOfCallImpl = new FirArrayOfCallImpl(null);
            boolean bl = false;
            boolean bl2 = false;
            FirArrayOfCallImpl $this$apply = firArrayOfCallImpl;
            boolean bl3 = false;
            for (JavaAnnotationArgument element : ((JavaArrayAnnotationArgument)$this$toFirExpression).getElements()) {
                Collection collection = $this$apply.getArguments();
                FirExpression firExpression3 = JavaUtilsKt.toFirExpression(element, session, javaTypeParameterStack);
                boolean bl4 = false;
                collection.add(firExpression3);
            }
            firExpression2 = firArrayOfCallImpl;
        } else if (javaAnnotationArgument instanceof JavaEnumValueAnnotationArgument) {
            FirResolvedNamedReferenceImpl calleeReference;
            FirResolvedNamedReferenceImpl firResolvedNamedReferenceImpl;
            FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(null);
            boolean bl = false;
            boolean bl5 = false;
            FirFunctionCallImpl $this$apply = firFunctionCallImpl;
            boolean bl6 = false;
            ClassId classId = ((JavaEnumValueAnnotationArgument)$this$toFirExpression).getEnumClassId();
            Name entryName = ((JavaEnumValueAnnotationArgument)$this$toFirExpression).getEntryName();
            if (classId != null && entryName != null) {
                FirCallableSymbol<?> callableSymbol;
                FirCallableSymbol<?> firCallableSymbol = callableSymbol = CollectionsKt.firstOrNull(FirSymbolProviderKt.getClassDeclaredCallableSymbols(ResolveUtilsKt.getFirSymbolProvider(session), classId, entryName));
                if (firCallableSymbol != null) {
                    FirCallableSymbol<?> firCallableSymbol2 = firCallableSymbol;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    FirCallableSymbol<?> it = firCallableSymbol2;
                    boolean bl9 = false;
                    firResolvedNamedReferenceImpl = new FirResolvedNamedReferenceImpl(null, entryName, (AbstractFirBasedSymbol)it);
                } else {
                    firResolvedNamedReferenceImpl = null;
                }
            } else {
                firResolvedNamedReferenceImpl = null;
            }
            FirResolvedNamedReferenceImpl firResolvedNamedReferenceImpl2 = calleeReference = firResolvedNamedReferenceImpl;
            $this$apply.setCalleeReference(firResolvedNamedReferenceImpl2 != null ? (FirNamedReference)firResolvedNamedReferenceImpl2 : (FirNamedReference)new FirErrorNamedReferenceImpl(null, new FirSimpleDiagnostic("Strange Java enum value: " + classId + '.' + entryName, DiagnosticKind.Java)));
            firExpression2 = firFunctionCallImpl;
        } else if (javaAnnotationArgument instanceof JavaClassObjectAnnotationArgument) {
            FirGetClassCallImpl firGetClassCallImpl = new FirGetClassCallImpl(null);
            boolean bl = false;
            boolean bl10 = false;
            FirGetClassCallImpl $this$apply = firGetClassCallImpl;
            boolean bl11 = false;
            JavaType referencedType = ((JavaClassObjectAnnotationArgument)$this$toFirExpression).getReferencedType();
            Collection collection = $this$apply.getArguments();
            FirClassReferenceExpressionImpl firClassReferenceExpressionImpl = new FirClassReferenceExpressionImpl(null, JavaUtilsKt.toFirResolvedTypeRef(referencedType, session, javaTypeParameterStack));
            boolean bl12 = false;
            collection.add(firClassReferenceExpressionImpl);
            firExpression2 = firGetClassCallImpl;
        } else {
            firExpression2 = javaAnnotationArgument instanceof JavaAnnotationAsAnnotationArgument ? (FirExpression)JavaUtilsKt.toFirAnnotationCall(((JavaAnnotationAsAnnotationArgument)$this$toFirExpression).getAnnotation(), session, javaTypeParameterStack) : (FirExpression)new FirErrorExpressionImpl(null, new FirSimpleDiagnostic("Unknown JavaAnnotationArgument: " + $this$toFirExpression.getClass(), DiagnosticKind.Java));
        }
        return firExpression2;
    }

    private static final <T> FirArrayOfCall createArrayOfCall(@NotNull List<? extends T> $this$createArrayOfCall, FirSession session, FirConstKind<T> kind) {
        FirArrayOfCallImpl firArrayOfCallImpl = new FirArrayOfCallImpl(null);
        boolean bl = false;
        boolean bl2 = false;
        FirArrayOfCallImpl $this$apply = firArrayOfCallImpl;
        boolean bl3 = false;
        for (T element : $this$createArrayOfCall) {
            Collection collection = $this$apply.getArguments();
            FirExpression firExpression2 = JavaUtilsKt.createConstant(element, session);
            boolean bl4 = false;
            collection.add(firExpression2);
        }
        return firArrayOfCallImpl;
    }

    @NotNull
    public static final FirExpression createConstant(@Nullable Object $this$createConstant, @NotNull FirSession session) {
        Intrinsics.checkParameterIsNotNull(session, "session");
        Object object = $this$createConstant;
        return (FirExpression)(object instanceof Byte ? (FirElement)new FirConstExpressionImpl<Object>(null, FirConstKind.Byte.INSTANCE, $this$createConstant) : (object instanceof Short ? (FirElement)new FirConstExpressionImpl<Object>(null, FirConstKind.Short.INSTANCE, $this$createConstant) : (object instanceof Integer ? (FirElement)new FirConstExpressionImpl<Object>(null, FirConstKind.Int.INSTANCE, $this$createConstant) : (object instanceof Long ? (FirElement)new FirConstExpressionImpl<Object>(null, FirConstKind.Long.INSTANCE, $this$createConstant) : (object instanceof Character ? (FirElement)new FirConstExpressionImpl<Object>(null, FirConstKind.Char.INSTANCE, $this$createConstant) : (object instanceof Float ? (FirElement)new FirConstExpressionImpl<Object>(null, FirConstKind.Float.INSTANCE, $this$createConstant) : (object instanceof Double ? (FirElement)new FirConstExpressionImpl<Object>(null, FirConstKind.Double.INSTANCE, $this$createConstant) : (object instanceof Boolean ? (FirElement)new FirConstExpressionImpl<Object>(null, FirConstKind.Boolean.INSTANCE, $this$createConstant) : (object instanceof String ? (FirElement)new FirConstExpressionImpl<Object>(null, FirConstKind.String.INSTANCE, $this$createConstant) : (object instanceof byte[] ? (FirElement)JavaUtilsKt.createArrayOfCall(ArraysKt.toList((byte[])$this$createConstant), session, FirConstKind.Byte.INSTANCE) : (object instanceof short[] ? (FirElement)JavaUtilsKt.createArrayOfCall(ArraysKt.toList((short[])$this$createConstant), session, FirConstKind.Short.INSTANCE) : (object instanceof int[] ? (FirElement)JavaUtilsKt.createArrayOfCall(ArraysKt.toList((int[])$this$createConstant), session, FirConstKind.Int.INSTANCE) : (object instanceof long[] ? (FirElement)JavaUtilsKt.createArrayOfCall(ArraysKt.toList((long[])$this$createConstant), session, FirConstKind.Long.INSTANCE) : (object instanceof char[] ? (FirElement)JavaUtilsKt.createArrayOfCall(ArraysKt.toList((char[])$this$createConstant), session, FirConstKind.Char.INSTANCE) : (object instanceof float[] ? (FirElement)JavaUtilsKt.createArrayOfCall(ArraysKt.toList((float[])$this$createConstant), session, FirConstKind.Float.INSTANCE) : (object instanceof double[] ? (FirElement)JavaUtilsKt.createArrayOfCall(ArraysKt.toList((double[])$this$createConstant), session, FirConstKind.Double.INSTANCE) : (object instanceof boolean[] ? (FirElement)JavaUtilsKt.createArrayOfCall(ArraysKt.toList((boolean[])$this$createConstant), session, FirConstKind.Boolean.INSTANCE) : (object == null ? (FirElement)new FirConstExpressionImpl<Object>(null, FirConstKind.Null.INSTANCE, null) : (FirElement)new FirErrorExpressionImpl(null, new FirSimpleDiagnostic("Unknown value in JavaLiteralAnnotationArgument: " + $this$createConstant, DiagnosticKind.Java))))))))))))))))))));
    }

    private static final FirResolvedTypeRef toFirResolvedTypeRef(@NotNull JavaType $this$toFirResolvedTypeRef, FirSession session, JavaTypeParameterStack javaTypeParameterStack) {
        if ($this$toFirResolvedTypeRef instanceof JavaClassifierType) {
            return JavaUtilsKt.toFirResolvedTypeRef$default((JavaClassifierType)$this$toFirResolvedTypeRef, session, javaTypeParameterStack, false, 4, null);
        }
        return new FirResolvedTypeRefImpl(null, new ConeClassErrorType("Unexpected JavaType: " + $this$toFirResolvedTypeRef));
    }
}

