/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVConfig;
import mediathek.daten.DatenBlacklist;
import mediathek.file.GetFile;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.tool.Filter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Listener;
import mediathek.tool.TextCopyPasteHandler;
import mediathek.tool.models.TModel;

public class PanelBlacklist
extends JPanel {
    public boolean ok = false;
    public String ziel;
    private final String name;
    private final Daten daten;
    private final JFrame parentComponent;
    private JCheckBox jCheckBoxZukunftNichtAnzeigen;
    private JSlider jSliderMinuten;
    private JTextField jTextFieldMinuten;
    private JCheckBox jCheckBoxGeo;
    private JTable jTableBlacklist;
    private JComboBox<String> jComboBoxSender;
    private JComboBox<String> jComboBoxThema;
    private JButton jButtonHinzufuegen;
    private JTextField jTextFieldTitel;
    private JTextField jTextFieldThemaTitel;
    private JButton jButtonAendern;
    private JRadioButton jRadioButtonBlacklist;
    private JRadioButton jRadioButtonWhitelist;
    private JButton jButtonHilfe;
    private JButton jButtonTabelleLoeschen;
    private JCheckBox jCheckBoxStart;
    private JCheckBox jCheckBoxBlacklistEingeschaltet;
    private JCheckBox jCheckBoxAbo;

    public PanelBlacklist(Daten d, JFrame parentComponent, String nname) {
        this.daten = d;
        this.parentComponent = parentComponent;
        this.initComponents();
        this.name = nname;
        this.jButtonHilfe.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonTabelleLoeschen.setIcon(Icons.ICON_BUTTON_DEL);
        this.init_();
        this.init();
        Listener.addListener(new Listener(39, this.name){

            @Override
            public void ping() {
                PanelBlacklist.this.init_();
            }
        });
        Listener.addListener(new Listener(40, this.name){

            @Override
            public void ping() {
                PanelBlacklist.this.jCheckBoxStart.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_START_ON)));
            }
        });
        Listener.addListener(new Listener(27, this.name){

            @Override
            public void ping() {
                PanelBlacklist.this.init_();
            }
        });
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                PanelBlacklist.this.comboThemaLaden();
            }
        });
    }

    private void init_() {
        this.jCheckBoxAbo.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_AUCH_ABO)));
        this.jCheckBoxStart.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_START_ON)));
        this.jCheckBoxBlacklistEingeschaltet.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ON)));
        this.jCheckBoxZukunftNichtAnzeigen.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ZUKUNFT_NICHT_ANZEIGEN)));
        this.jCheckBoxGeo.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_GEO_NICHT_ANZEIGEN)));
        try {
            this.jSliderMinuten.setValue(Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE)));
        }
        catch (Exception ex) {
            this.jSliderMinuten.setValue(0);
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE, "0");
        }
        this.tabelleLaden();
    }

    private void init() {
        this.jTableBlacklist.addMouseListener(new BeobMausTabelle());
        this.jTableBlacklist.getSelectionModel().addListSelectionListener(new BeobachterTableSelect());
        this.jRadioButtonWhitelist.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST)));
        this.jRadioButtonWhitelist.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST, Boolean.toString(this.jRadioButtonWhitelist.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jRadioButtonBlacklist.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST, Boolean.toString(this.jRadioButtonWhitelist.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jCheckBoxZukunftNichtAnzeigen.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_ZUKUNFT_NICHT_ANZEIGEN, Boolean.toString(this.jCheckBoxZukunftNichtAnzeigen.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jCheckBoxGeo.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_GEO_NICHT_ANZEIGEN, Boolean.toString(this.jCheckBoxGeo.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jCheckBoxAbo.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_AUCH_ABO, Boolean.toString(this.jCheckBoxAbo.isSelected()));
            Listener.notify(27, this.name);
        });
        this.jCheckBoxStart.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_START_ON, Boolean.toString(this.jCheckBoxStart.isSelected()));
            Listener.notify(40, this.name);
        });
        this.jCheckBoxBlacklistEingeschaltet.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_ON, Boolean.toString(this.jCheckBoxBlacklistEingeschaltet.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jButtonHinzufuegen.addActionListener(e -> {
            String se = Objects.requireNonNull(this.jComboBoxSender.getSelectedItem()).toString();
            String th = Objects.requireNonNull(this.jComboBoxThema.getSelectedItem()).toString();
            String ti = this.jTextFieldTitel.getText().trim();
            String thti = this.jTextFieldThemaTitel.getText().trim();
            if (!(se.isEmpty() && th.isEmpty() && ti.isEmpty() && thti.isEmpty())) {
                this.daten.getListeBlacklist().add(new DatenBlacklist(se, th, ti, thti));
                this.tabelleLaden();
            }
        });
        this.jButtonAendern.addActionListener(e -> {
            int selectedTableRow;
            String se = Objects.requireNonNull(this.jComboBoxSender.getSelectedItem()).toString();
            String th = Objects.requireNonNull(this.jComboBoxThema.getSelectedItem()).toString();
            String ti = this.jTextFieldTitel.getText().trim();
            String thti = this.jTextFieldThemaTitel.getText().trim();
            if (!(se.isEmpty() && th.isEmpty() && ti.isEmpty() && thti.isEmpty() || (selectedTableRow = this.jTableBlacklist.getSelectedRow()) < 0)) {
                int row = this.jTableBlacklist.convertRowIndexToModel(selectedTableRow);
                String delNr = this.jTableBlacklist.getModel().getValueAt(row, 0).toString();
                DatenBlacklist bl = this.daten.getListeBlacklist().get(delNr);
                bl.arr[1] = se;
                bl.arr[2] = th;
                bl.arr[3] = ti;
                bl.arr[4] = thti;
                this.tabelleLaden();
                this.jTableBlacklist.addRowSelectionInterval(row, row);
                this.notifyBlacklistChanged();
            }
        });
        this.jButtonHilfe.addActionListener(e -> new DialogHilfe(this.parentComponent, true, new GetFile().getHilfeSuchen("/mediathek/file/hilfetext_blacklist.txt")).setVisible(true));
        this.jButtonTabelleLoeschen.addActionListener(e -> {
            int ret = JOptionPane.showConfirmDialog(this.parentComponent, "Alle Eintr\u00e4ge werden gel\u00f6scht.", "L\u00f6schen?", 0);
            if (ret == 0) {
                this.daten.getListeBlacklist().clear();
                this.tabelleLaden();
            }
        });
        this.jComboBoxSender.addActionListener(e -> this.comboThemaLaden());
        this.jTextFieldTitel.getDocument().addDocumentListener(new BeobFilterTitelDoc());
        this.jTextFieldThemaTitel.getDocument().addDocumentListener(new BeobFilterTitelDoc());
        try {
            this.jSliderMinuten.setValue(Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE)));
        }
        catch (Exception ex) {
            this.jSliderMinuten.setValue(0);
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE, "0");
        }
        this.jTextFieldMinuten.setText(String.valueOf(this.jSliderMinuten.getValue()));
        if (this.jSliderMinuten.getValue() == 0) {
            this.jTextFieldMinuten.setText("alles");
        }
        this.jSliderMinuten.addChangeListener(e -> {
            this.jTextFieldMinuten.setText(String.valueOf(this.jSliderMinuten.getValue()));
            if (this.jSliderMinuten.getValue() == 0) {
                this.jTextFieldMinuten.setText("alles");
            }
            if (!this.jSliderMinuten.getValueIsAdjusting()) {
                MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE, String.valueOf(this.jSliderMinuten.getValue()));
                this.notifyBlacklistChanged();
            }
        });
        this.jComboBoxSender.setModel(GuiFunktionen.getSenderListComboBoxModel(this.daten.getListeFilme()));
        this.comboThemaLaden();
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldThemaTitel);
        this.jTextFieldThemaTitel.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldTitel);
        this.jTextFieldTitel.setComponentPopupMenu(handler.getPopupMenu());
    }

    private void notifyBlacklistChanged() {
        this.daten.getListeBlacklist().filterListe();
        Listener.notify(39, this.name);
    }

    private void comboThemaLaden() {
        String filterSender = Objects.requireNonNull(this.jComboBoxSender.getSelectedItem()).toString();
        if (filterSender.isEmpty()) {
            filterSender = "";
        }
        List<String> lst = this.daten.getListeFilmeNachBlackList().getThemen(filterSender);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        for (String item : lst) {
            model.addElement(item);
        }
        this.jComboBoxThema.setModel(model);
        lst.clear();
    }

    private void tabelleLaden() {
        this.jTableBlacklist.setModel(new TModel(this.daten.getListeBlacklist().getObjectData(), DatenBlacklist.COLUMN_NAMES));
    }

    private void tableSelect() {
        DatenBlacklist bl = null;
        int selectedTableRow = this.jTableBlacklist.getSelectedRow();
        if (selectedTableRow >= 0) {
            int del = this.jTableBlacklist.convertRowIndexToModel(selectedTableRow);
            String delNr = this.jTableBlacklist.getModel().getValueAt(del, 0).toString();
            bl = this.daten.getListeBlacklist().get(delNr);
        }
        if (bl != null) {
            this.jComboBoxSender.setSelectedItem(bl.arr[1]);
            this.jComboBoxThema.setSelectedItem(bl.arr[2]);
            this.jTextFieldTitel.setText(bl.arr[3]);
            this.jTextFieldThemaTitel.setText(bl.arr[4]);
        }
    }

    private void tabelleZeileLoeschen() {
        int selectedTableRow = this.jTableBlacklist.getSelectedRow();
        if (selectedTableRow >= 0) {
            int del = this.jTableBlacklist.convertRowIndexToModel(selectedTableRow);
            String delNr = this.jTableBlacklist.getModel().getValueAt(del, 0).toString();
            this.daten.getListeBlacklist().remove(delNr);
            this.tabelleLaden();
        }
    }

    private void initComponents() {
        JTabbedPane jTabbedPaneBlacklist = new JTabbedPane();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.jCheckBoxZukunftNichtAnzeigen = new JCheckBox();
        JPanel jPanel6 = new JPanel();
        this.jSliderMinuten = new JSlider();
        JLabel jLabel1 = new JLabel();
        this.jTextFieldMinuten = new JTextField();
        JLabel jLabel13 = new JLabel();
        JPanel jPanel7 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.jCheckBoxGeo = new JCheckBox();
        JLabel jLabel9 = new JLabel();
        JPanel jPanel1 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTableBlacklist = new JTable();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel5 = new JLabel();
        this.jComboBoxSender = new JComboBox();
        JLabel jLabel6 = new JLabel();
        this.jComboBoxThema = new JComboBox();
        this.jButtonHinzufuegen = new JButton();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        this.jTextFieldTitel = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldThemaTitel = new JTextField();
        this.jButtonAendern = new JButton();
        this.jRadioButtonBlacklist = new JRadioButton();
        this.jRadioButtonWhitelist = new JRadioButton();
        this.jButtonHilfe = new JButton();
        JLabel jLabel10 = new JLabel();
        this.jButtonTabelleLoeschen = new JButton();
        JPanel jPanel8 = new JPanel();
        this.jCheckBoxStart = new JCheckBox();
        this.jCheckBoxBlacklistEingeschaltet = new JCheckBox();
        this.jCheckBoxAbo = new JCheckBox();
        JPanel jPanel2 = new JPanel();
        jPanel5.setBorder(new EtchedBorder());
        jLabel3.setText("Filme, deren Datum in der Zukunft liegt, sind meist nur Trailer");
        this.jCheckBoxZukunftNichtAnzeigen.setText("Filme mit Datum in der Zukunft nicht anzeigen");
        GroupLayout jPanel5Layout = new GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup().addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup().addComponent(jLabel3).addComponent(this.jCheckBoxZukunftNichtAnzeigen)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup().addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxZukunftNichtAnzeigen).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6.setBorder(new EtchedBorder());
        this.jSliderMinuten.setValue(0);
        jLabel1.setText("Nur Filme anzeigen mit einer L\u00e4nge von mehr als [min]:");
        this.jTextFieldMinuten.setEditable(false);
        jLabel13.setText("Filme, die keine L\u00e4ngenangabe haben, werden immer angezeigt.");
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup().addComponent(this.jSliderMinuten, -1, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldMinuten, -2, 81, -2)).addComponent(jLabel13)).addGap(0, 405, Short.MAX_VALUE))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jTextFieldMinuten, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSliderMinuten, -2, -1, -2).addContainerGap()));
        jPanel7.setBorder(new EtchedBorder());
        jLabel4.setText("Geogeblockte Filme k\u00f6nnen im jeweiligen \"Ausland\" nicht abgerufen werden.");
        this.jCheckBoxGeo.setText("Filme, die per Geoblocking gesperrt sind, nicht anzeigen");
        jLabel9.setText("(Dazu muss die eigene Position in den Einstellungen angegeben werden)");
        GroupLayout jPanel7Layout = new GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup().addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup().addGroup(jPanel7Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(jLabel9)).addComponent(jLabel4).addComponent(this.jCheckBoxGeo)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup().addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxGeo).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup().addComponent(jPanel6, -1, -1, Short.MAX_VALUE).addComponent(jPanel5, -1, -1, Short.MAX_VALUE).addComponent(jPanel7, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel7, -2, -1, -2).addContainerGap(205, Short.MAX_VALUE)));
        jTabbedPaneBlacklist.addTab("Blacklist allgemein", jPanel3);
        this.jTableBlacklist.setAutoCreateRowSorter(true);
        jScrollPane1.setViewportView(this.jTableBlacklist);
        jPanel4.setBorder(new EtchedBorder());
        jLabel5.setText("Sender:");
        this.jComboBoxSender.setModel(new DefaultComboBoxModel<String>(new String[0]));
        jLabel6.setText("Thema:");
        this.jComboBoxThema.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.jButtonHinzufuegen.setText("Hinzuf\u00fcgen");
        jLabel7.setText("Sender, Thema, Titel oder Thema/Titel:");
        jLabel8.setText("Titel:");
        jLabel2.setText("Thema oder Titel:");
        this.jButtonAendern.setText("\u00c4ndern");
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addComponent(jLabel7).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addGap(68, 68, 68).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel6).addComponent(jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup().addComponent(this.jComboBoxSender).addComponent(this.jComboBoxThema))).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel2).addComponent(jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup().addComponent(this.jTextFieldTitel).addComponent(this.jTextFieldThemaTitel)))).addGap(12, 12, 12)))).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonAendern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHinzufuegen).addContainerGap()));
        jPanel4Layout.linkSize(0, this.jButtonAendern, this.jButtonHinzufuegen);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addGap(23, 23, 23).addComponent(jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.jComboBoxSender, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(this.jComboBoxThema, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel8).addComponent(this.jTextFieldTitel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.jTextFieldThemaTitel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHinzufuegen).addComponent(this.jButtonAendern)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(1, this.jComboBoxSender, this.jComboBoxThema, this.jTextFieldThemaTitel, this.jTextFieldTitel);
        this.jRadioButtonBlacklist.setSelected(true);
        this.jRadioButtonBlacklist.setText("\"Sender / Thema / Titel\" werden nicht angezeigt (Blacklist)");
        this.jRadioButtonWhitelist.setText("nur diese \"Sender / Thema / Titel\" anzeigen (Whitelist)");
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        jLabel10.setText("alle Eintr\u00e4ge l\u00f6schen:");
        this.jButtonTabelleLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-del.png")));
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup().addComponent(jScrollPane1, GroupLayout.Alignment.TRAILING).addComponent(jPanel4, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup().addComponent(this.jRadioButtonWhitelist).addComponent(this.jRadioButtonBlacklist)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 386, Short.MAX_VALUE).addComponent(this.jButtonHilfe)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonTabelleLoeschen))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonBlacklist).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonWhitelist)).addComponent(this.jButtonHilfe)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1, -1, 115, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel10).addComponent(this.jButtonTabelleLoeschen)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel4, -2, -1, -2).addContainerGap()));
        jTabbedPaneBlacklist.addTab("Sender-Thema-Titel", jPanel1);
        jPanel8.setBorder(new TitledBorder("Allgemeine Einstellungen"));
        jPanel8.setLayout(new GridLayout(3, 1));
        this.jCheckBoxStart.setText("Beim Programmstart einschalten");
        jPanel8.add(this.jCheckBoxStart);
        this.jCheckBoxBlacklistEingeschaltet.setText("Im Tab Filme einschalten");
        jPanel8.add(this.jCheckBoxBlacklistEingeschaltet);
        this.jCheckBoxAbo.setText("Bei der Suche nach Abos ber\u00fccksichtigen");
        this.jCheckBoxAbo.setToolTipText("<html>Die Blacklist beim Suchen nach Abos ber\u00fccksichtigen.<br/>Ansonsten wird die komplette Filmliste durchsucht.</html>");
        jPanel8.add(this.jCheckBoxAbo);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(jPanel8, -1, -1, Short.MAX_VALUE).addComponent(jTabbedPaneBlacklist)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel8, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTabbedPaneBlacklist, -2, 510, -2).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup().addGap(0, 100, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup().addGap(0, 100, Short.MAX_VALUE));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonBlacklist);
        buttonGroup1.add(this.jRadioButtonWhitelist);
    }

    private class BeobMausTabelle
    extends MouseAdapter {
        private final BeobLoeschen beobLoeschen = new BeobLoeschen();

        private BeobMausTabelle() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            Point p = evt.getPoint();
            int nr = PanelBlacklist.this.jTableBlacklist.rowAtPoint(p);
            if (nr >= 0) {
                PanelBlacklist.this.jTableBlacklist.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Zeile l\u00f6schen");
            item.addActionListener(this.beobLoeschen);
            jPopupMenu.add(item);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobLoeschen
        implements ActionListener {
            private BeobLoeschen() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelBlacklist.this.tabelleZeileLoeschen();
            }
        }
    }

    private class BeobachterTableSelect
    implements ListSelectionListener {
        private BeobachterTableSelect() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                PanelBlacklist.this.tableSelect();
            }
        }
    }

    private class BeobFilterTitelDoc
    implements DocumentListener {
        private BeobFilterTitelDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            Filter.checkPattern1(PanelBlacklist.this.jTextFieldThemaTitel);
            Filter.checkPattern1(PanelBlacklist.this.jTextFieldTitel);
        }
    }
}

