/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.gui.dialog.DialogZiel;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.javafx.FXErrorDialog;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MVInfoFile {
    private static final Logger logger = LogManager.getLogger(MVInfoFile.class);
    private static final String FILM_GROESSE = "Gr\u00f6\u00dfe [MB]";
    private static final String FILM_SENDER = "Sender";
    private static final String FILM_THEMA = "Thema";
    private static final String FILM_TITEL = "Titel";
    private static final String FILM_DATUM = "Datum";
    private static final String FILM_ZEIT = "Zeit";
    private static final String FILM_DAUER = "Dauer";
    private static final String FILM_URL = "URL";

    protected static String formatFilmAsString(DatenFilm film, int maxLengthHeaders) {
        if (null == film) {
            return "";
        }
        String formatString = String.format("%%-%ds %%s", maxLengthHeaders);
        StringBuilder sb = new StringBuilder();
        sb = MVInfoFile.appendFormatedTableLine(sb, formatString, FILM_SENDER, film.getSender());
        sb = MVInfoFile.appendFormatedTableLine(sb, formatString, FILM_THEMA, film.getThema()).append(System.lineSeparator());
        sb = MVInfoFile.appendFormatedTableLine(sb, formatString, FILM_TITEL, film.getTitle()).append(System.lineSeparator());
        sb = MVInfoFile.appendFormatedTableLine(sb, formatString, FILM_DATUM, film.getSendeDatum());
        sb = MVInfoFile.appendFormatedTableLine(sb, formatString, FILM_ZEIT, film.getSendeZeit());
        sb = MVInfoFile.appendFormatedTableLine(sb, formatString, FILM_DAUER, film.getDauer());
        sb = MVInfoFile.appendFormatedTableLine(sb, formatString, FILM_GROESSE, film.getSize()).append(System.lineSeparator());
        sb.append("Website");
        sb.append(System.lineSeparator());
        sb.append(film.getWebsiteLink());
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append(FILM_URL);
        sb.append(System.lineSeparator());
        sb.append(film.getUrl());
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append(MVInfoFile.splittStringIntoMaxFixedLengthLines(film.getDescription(), 62));
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    protected static StringBuilder appendFormatedTableLine(StringBuilder sb, String formatString, String keyTitle, String value) {
        return sb.append(String.format(formatString, String.format("%s:", keyTitle), value)).append(System.lineSeparator());
    }

    public static String splittStringIntoMaxFixedLengthLines(String input, int lineLength) {
        return Optional.ofNullable(input).map(s2 -> WordUtils.wrap(s2, lineLength)).orElse("");
    }

    public static int getMaxLengthFromStringArray(String[] array) {
        return Optional.ofNullable(array).stream().flatMap(Arrays::stream).max(Comparator.comparing(String::length)).map(String::length).orElse(0);
    }

    public void writeInfoFile(DatenFilm film) {
        Object titel = FilenameUtils.replaceLeerDateiname(film.getTitle(), false, Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_REPLACETABLE)), Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ONLY_ASCII)));
        String pfad = "";
        ListePset lp = Daten.listePset.getListeSpeichern();
        if (!lp.isEmpty()) {
            DatenPset p = (DatenPset)lp.get(0);
            pfad = p.getZielPfad();
        }
        if (pfad.isEmpty()) {
            pfad = GuiFunktionen.getStandardDownloadPath();
        }
        titel = ((String)titel).isEmpty() ? StringUtils.replace(film.getSender(), " ", "-") + ".txt" : (String)titel + ".txt";
        pfad = GuiFunktionen.addsPfad(pfad, (String)titel);
        DialogZiel dialog = new DialogZiel(null, true, pfad, "Infos speichern");
        dialog.setVisible(true);
        if (!dialog.ok) {
            return;
        }
        Path path = Paths.get(dialog.ziel, new String[0]);
        path.toFile().getParentFile().mkdirs();
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             DataOutputStream dos = new DataOutputStream(os);
             OutputStreamWriter osw = new OutputStreamWriter(dos);
             BufferedWriter br = new BufferedWriter(osw);){
            br.write(MVInfoFile.formatFilmAsString(film, FILM_GROESSE.length() + 2));
            br.flush();
            this.showSuccessDialog();
        }
        catch (IOException ex) {
            FXErrorDialog.showErrorDialog("MediathekView", "Infodatei schreiben", "Ein unbekannter Fehler ist aufgetreten!", ex);
            logger.error("Ziel: {}", (Object)dialog.ziel, (Object)ex);
        }
    }

    private void showSuccessDialog() {
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("MediathekView");
            alert.setHeaderText("Infodatei schreiben");
            alert.setContentText("Infodatei wurde erfolgreich geschrieben.");
            alert.showAndWait();
        });
    }

    public void writeInfoFile(DatenDownload datenDownload) {
        logger.info("Infofile schreiben nach: {}", (Object)datenDownload.arr[30]);
        new File(datenDownload.arr[30]).mkdirs();
        Path path = Paths.get(datenDownload.getFileNameWithoutSuffix() + ".txt", new String[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             DataOutputStream dos = new DataOutputStream(os);
             OutputStreamWriter osw = new OutputStreamWriter(dos);
             BufferedWriter br = new BufferedWriter(osw);){
            DatenFilm film = datenDownload.film;
            if (film != null) {
                br.write(MVInfoFile.formatFilmAsString(film, FILM_GROESSE.length() + 2));
                br.flush();
            }
            logger.info("Infodatei geschrieben");
        }
        catch (IOException ex) {
            FXErrorDialog.showErrorDialog("MediathekView", "Infodatei schreiben", "Ein unbekannter Fehler ist aufgetreten!", ex);
            logger.error("Ziel: {}", (Object)datenDownload.arr[31], (Object)ex);
        }
    }
}

