/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.-Platform;
import okio.-Util;
import okio.Buffer;
import okio.ByteString;
import okio.Segment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0005\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 J2\u00020\u0001:\u0001JB\u001d\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0015\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\b\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002JV\u0010\u001a\u001a\u00020\u001b2K\u0010\u001c\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u001b0\u001dH\u0082\bJf\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020!2K\u0010\u001c\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u001b0\u001dH\u0082\bJ\r\u0010&\u001a\u00020!H\u0010\u00a2\u0006\u0002\b'J\b\u0010(\u001a\u00020!H\u0016J\b\u0010)\u001a\u00020\u0011H\u0016J\u001d\u0010*\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b,J\u0018\u0010-\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010.\u001a\u00020!H\u0016J\r\u0010/\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u0002022\u0006\u00103\u001a\u00020!H\u0010\u00a2\u0006\u0002\b4J\u0018\u00105\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010.\u001a\u00020!H\u0016J(\u00106\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u00107\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0016J(\u00106\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u00107\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0016J\u0010\u00108\u001a\u00020!2\u0006\u00103\u001a\u00020!H\u0002J\u0010\u00109\u001a\u00020\u00112\u0006\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u00020\u00012\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020!H\u0016J\b\u0010=\u001a\u00020\u0001H\u0016J\b\u0010>\u001a\u00020\u0001H\u0016J\b\u0010?\u001a\u00020\u0004H\u0016J\b\u0010@\u001a\u00020\u0001H\u0002J\b\u0010A\u001a\u00020\u0011H\u0016J\u0010\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020DH\u0016J\u0015\u0010B\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020FH\u0010\u00a2\u0006\u0002\bGJ\b\u0010H\u001a\u00020IH\u0002R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006K"}, d2={"Lokio/SegmentedByteString;", "Lokio/ByteString;", "segments", "", "", "directory", "", "([[B[I)V", "getDirectory", "()[I", "getSegments", "()[[B", "[[B", "asByteBuffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "base64", "", "base64Url", "digest", "algorithm", "digest$jvm", "equals", "", "other", "", "forEachSegment", "", "action", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "data", "", "offset", "byteCount", "beginIndex", "endIndex", "getSize", "getSize$jvm", "hashCode", "hex", "hmac", "key", "hmac$jvm", "indexOf", "fromIndex", "internalArray", "internalArray$jvm", "internalGet", "", "pos", "internalGet$jvm", "lastIndexOf", "rangeEquals", "otherOffset", "segment", "string", "charset", "Ljava/nio/charset/Charset;", "substring", "toAsciiLowercase", "toAsciiUppercase", "toByteArray", "toByteString", "toString", "write", "out", "Ljava/io/OutputStream;", "buffer", "Lokio/Buffer;", "write$jvm", "writeReplace", "Ljava/lang/Object;", "Companion", "jvm"})
public final class SegmentedByteString
extends ByteString {
    @NotNull
    private final transient byte[][] segments;
    @NotNull
    private final transient int[] directory;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String string(@NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return this.toByteString().string(charset);
    }

    @Override
    @NotNull
    public String base64() {
        return this.toByteString().base64();
    }

    @Override
    @NotNull
    public String hex() {
        return this.toByteString().hex();
    }

    @Override
    @NotNull
    public ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    @Override
    @NotNull
    public ByteString toAsciiUppercase() {
        return this.toByteString().toAsciiUppercase();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ByteString digest$jvm(@NotNull String algorithm) {
        Intrinsics.checkParameterIsNotNull(algorithm, "algorithm");
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        SegmentedByteString this_$iv = this;
        int segmentCount$iv = ((Object[])this_$iv.getSegments()).length;
        int pos$iv = 0;
        for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
            void byteCount;
            void offset;
            int segmentPos$iv = this_$iv.getDirectory()[segmentCount$iv + s$iv];
            int nextSegmentOffset$iv = this_$iv.getDirectory()[s$iv];
            int n = nextSegmentOffset$iv - pos$iv;
            int n2 = segmentPos$iv;
            byte[] data = this_$iv.getSegments()[s$iv];
            digest.update(data, (int)offset, (int)byteCount);
            pos$iv = nextSegmentOffset$iv;
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "digest.digest()");
        return new ByteString(byArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ByteString hmac$jvm(@NotNull String algorithm, @NotNull ByteString key) {
        Intrinsics.checkParameterIsNotNull(algorithm, "algorithm");
        Intrinsics.checkParameterIsNotNull(key, "key");
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            SegmentedByteString this_$iv = this;
            int segmentCount$iv = ((Object[])this_$iv.getSegments()).length;
            int pos$iv = 0;
            for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
                void byteCount;
                void offset;
                int segmentPos$iv = this_$iv.getDirectory()[segmentCount$iv + s$iv];
                int nextSegmentOffset$iv = this_$iv.getDirectory()[s$iv];
                int n = nextSegmentOffset$iv - pos$iv;
                int n2 = segmentPos$iv;
                byte[] data = this_$iv.getSegments()[s$iv];
                mac.update(data, (int)offset, (int)byteCount);
                pos$iv = nextSegmentOffset$iv;
            }
            byte[] byArray = mac.doFinal();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "mac.doFinal()");
            return new ByteString(byArray);
        }
        catch (InvalidKeyException e) {
            throw (Throwable)new IllegalArgumentException(e);
        }
    }

    @Override
    @NotNull
    public String base64Url() {
        return this.toByteString().base64Url();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ByteString substring(int beginIndex, int endIndex) {
        boolean $i$a$2$require;
        boolean bl;
        boolean bl2 = bl = beginIndex >= 0;
        if (!bl) {
            String string = "beginIndex=" + beginIndex + " < 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = endIndex <= this.size();
        if (!bl) {
            String string = "endIndex=" + endIndex + " > length(" + this.size() + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int subLen = endIndex - beginIndex;
        boolean bl4 = $i$a$2$require = subLen >= 0;
        if (!$i$a$2$require) {
            String string = "endIndex=" + endIndex + " < beginIndex=" + beginIndex;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (beginIndex == 0 && endIndex == this.size()) {
            return this;
        }
        if (beginIndex == endIndex) {
            return ByteString.EMPTY;
        }
        int beginSegment = this.segment(beginIndex);
        int endSegment = this.segment(endIndex - 1);
        Object[] objectArray = (Object[])this.segments;
        int n = endSegment + 1;
        Object[] objectArray2 = Arrays.copyOfRange(objectArray, beginSegment, n);
        Intrinsics.checkExpressionValueIsNotNull(objectArray2, "java.util.Arrays.copyOfR\u2026this, fromIndex, toIndex)");
        byte[][] newSegments = (byte[][])objectArray2;
        int[] newDirectory = new int[((Object[])newSegments).length * 2];
        int index = 0;
        int n2 = beginSegment;
        int n3 = endSegment;
        if (n2 <= n3) {
            while (true) {
                int n4;
                void s2;
                int n5 = this.directory[s2] - beginIndex;
                int n6 = index;
                int[] nArray = newDirectory;
                nArray[n6] = n4 = Math.min(n5, subLen);
                newDirectory[index++ + ((Object[])newSegments).length] = this.directory[s2 + ((Object[])this.segments).length];
                if (s2 == n3) break;
                ++s2;
            }
        }
        int segmentOffset = beginSegment == 0 ? 0 : this.directory[beginSegment - 1];
        int n7 = ((Object[])newSegments).length;
        newDirectory[n7] = newDirectory[n7] + (beginIndex - segmentOffset);
        return new SegmentedByteString(newSegments, newDirectory);
    }

    @Override
    public byte internalGet$jvm(int pos) {
        -Util.checkOffsetAndCount(this.directory[((Object[])this.segments).length - 1], pos, 1L);
        int segment = this.segment(pos);
        int segmentOffset = segment == 0 ? 0 : this.directory[segment - 1];
        int segmentPos = this.directory[segment + ((Object[])this.segments).length];
        return this.segments[segment][pos - segmentOffset + segmentPos];
    }

    private final int segment(int pos) {
        int i = Arrays.binarySearch(this.directory, 0, ((Object[])this.segments).length, pos + 1);
        return i >= 0 ? i : ~i;
    }

    @Override
    public int getSize$jvm() {
        return this.directory[((Object[])this.segments).length - 1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] toByteArray() {
        byte[] result = new byte[this.size()];
        int resultPos = 0;
        SegmentedByteString this_$iv = this;
        int segmentCount$iv = ((Object[])this_$iv.getSegments()).length;
        int pos$iv = 0;
        for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
            void byteCount;
            void offset;
            int segmentPos$iv = this_$iv.getDirectory()[segmentCount$iv + s$iv];
            int nextSegmentOffset$iv = this_$iv.getDirectory()[s$iv];
            int n = nextSegmentOffset$iv - pos$iv;
            int n2 = segmentPos$iv;
            byte[] data = this_$iv.getSegments()[s$iv];
            -Platform.arraycopy(data, (int)offset, result, resultPos, (int)byteCount);
            resultPos += byteCount;
            pos$iv = nextSegmentOffset$iv;
        }
        return result;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.toByteArray()).asReadOnlyBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull OutputStream out) throws IOException {
        Intrinsics.checkParameterIsNotNull(out, "out");
        SegmentedByteString this_$iv = this;
        int segmentCount$iv = ((Object[])this_$iv.getSegments()).length;
        int pos$iv = 0;
        for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
            void byteCount;
            void offset;
            int segmentPos$iv = this_$iv.getDirectory()[segmentCount$iv + s$iv];
            int nextSegmentOffset$iv = this_$iv.getDirectory()[s$iv];
            int n = nextSegmentOffset$iv - pos$iv;
            int n2 = segmentPos$iv;
            byte[] data = this_$iv.getSegments()[s$iv];
            out.write(data, (int)offset, (int)byteCount);
            pos$iv = nextSegmentOffset$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write$jvm(@NotNull Buffer buffer) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        SegmentedByteString this_$iv = this;
        int segmentCount$iv = ((Object[])this_$iv.getSegments()).length;
        int pos$iv = 0;
        for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
            void byteCount;
            void offset;
            int segmentPos$iv = this_$iv.getDirectory()[segmentCount$iv + s$iv];
            int nextSegmentOffset$iv = this_$iv.getDirectory()[s$iv];
            int n = nextSegmentOffset$iv - pos$iv;
            int n2 = segmentPos$iv;
            byte[] data = this_$iv.getSegments()[s$iv];
            Segment segment = new Segment(data, (int)offset, (int)(offset + byteCount), true, false);
            if (buffer.head == null) {
                buffer.head = segment.next = (segment.prev = segment);
            } else {
                Segment segment2 = buffer.head;
                if (segment2 == null) {
                    Intrinsics.throwNpe();
                }
                Segment segment3 = segment2.prev;
                if (segment3 == null) {
                    Intrinsics.throwNpe();
                }
                segment3.push(segment);
            }
            pos$iv = nextSegmentOffset$iv;
        }
        Buffer buffer2 = buffer;
        buffer2.setSize$jvm(buffer2.size() + (long)this.size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean rangeEquals(int offset, @NotNull ByteString other, int otherOffset, int byteCount) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull(other, "other");
        if (offset < 0 || offset > this.size() - byteCount) {
            return false;
        }
        int otherOffset2 = otherOffset;
        SegmentedByteString segmentedByteString = this;
        int endIndex$iv = offset + byteCount;
        int s$iv = ((SegmentedByteString)this_$iv).segment(offset);
        int pos$iv = offset;
        while (pos$iv < endIndex$iv) {
            void byteCount2;
            void offset2;
            int segmentOffset$iv = s$iv == 0 ? 0 : this_$iv.getDirectory()[s$iv - 1];
            int segmentSize$iv = this_$iv.getDirectory()[s$iv] - segmentOffset$iv;
            int segmentPos$iv = this_$iv.getDirectory()[((Object[])this_$iv.getSegments()).length + s$iv];
            int n = segmentOffset$iv + segmentSize$iv;
            int byteCount$iv = Math.min(endIndex$iv, n) - pos$iv;
            int offset$iv = segmentPos$iv + (pos$iv - segmentOffset$iv);
            int n2 = byteCount$iv;
            int n3 = offset$iv;
            byte[] data = this_$iv.getSegments()[s$iv];
            if (!other.rangeEquals(otherOffset2, data, (int)offset2, (int)byteCount2)) {
                return false;
            }
            otherOffset2 += byteCount2;
            pos$iv += byteCount$iv;
            ++s$iv;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean rangeEquals(int offset, @NotNull byte[] other, int otherOffset, int byteCount) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull(other, "other");
        if (offset < 0 || offset > this.size() - byteCount || otherOffset < 0 || otherOffset > other.length - byteCount) {
            return false;
        }
        int otherOffset2 = otherOffset;
        SegmentedByteString segmentedByteString = this;
        int endIndex$iv = offset + byteCount;
        int s$iv = ((SegmentedByteString)this_$iv).segment(offset);
        int pos$iv = offset;
        while (pos$iv < endIndex$iv) {
            void byteCount2;
            void offset2;
            int segmentOffset$iv = s$iv == 0 ? 0 : this_$iv.getDirectory()[s$iv - 1];
            int segmentSize$iv = this_$iv.getDirectory()[s$iv] - segmentOffset$iv;
            int segmentPos$iv = this_$iv.getDirectory()[((Object[])this_$iv.getSegments()).length + s$iv];
            int n = segmentOffset$iv + segmentSize$iv;
            int byteCount$iv = Math.min(endIndex$iv, n) - pos$iv;
            int offset$iv = segmentPos$iv + (pos$iv - segmentOffset$iv);
            int n2 = byteCount$iv;
            int n3 = offset$iv;
            byte[] data = this_$iv.getSegments()[s$iv];
            if (!-Util.arrayRangeEquals(data, (int)offset2, other, otherOffset2, (int)byteCount2)) {
                return false;
            }
            otherOffset2 += byteCount2;
            pos$iv += byteCount$iv;
            ++s$iv;
        }
        return true;
    }

    @Override
    public int indexOf(@NotNull byte[] other, int fromIndex) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return this.toByteString().indexOf(other, fromIndex);
    }

    @Override
    public int lastIndexOf(@NotNull byte[] other, int fromIndex) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return this.toByteString().lastIndexOf(other, fromIndex);
    }

    private final ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    @Override
    @NotNull
    public byte[] internalArray$jvm() {
        return this.toByteArray();
    }

    private final void forEachSegment(Function3<? super byte[], ? super Integer, ? super Integer, Unit> action) {
        int segmentCount = ((Object[])this.getSegments()).length;
        int pos = 0;
        for (int s2 = 0; s2 < segmentCount; ++s2) {
            int segmentPos = this.getDirectory()[segmentCount + s2];
            int nextSegmentOffset = this.getDirectory()[s2];
            action.invoke((byte[])this.getSegments()[s2], (Integer)segmentPos, (Integer)(nextSegmentOffset - pos));
            pos = nextSegmentOffset;
        }
    }

    private final void forEachSegment(int beginIndex, int endIndex, Function3<? super byte[], ? super Integer, ? super Integer, Unit> action) {
        int s2 = this.segment(beginIndex);
        int pos = beginIndex;
        while (pos < endIndex) {
            int segmentOffset = s2 == 0 ? 0 : this.getDirectory()[s2 - 1];
            int segmentSize = this.getDirectory()[s2] - segmentOffset;
            int segmentPos = this.getDirectory()[((Object[])this.getSegments()).length + s2];
            int n = segmentOffset + segmentSize;
            int byteCount = Math.min(endIndex, n) - pos;
            int offset = segmentPos + (pos - segmentOffset);
            action.invoke((byte[])this.getSegments()[s2], (Integer)offset, (Integer)byteCount);
            pos += byteCount;
            ++s2;
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this ? true : (other instanceof ByteString ? ((ByteString)other).size() == this.size() && this.rangeEquals(0, (ByteString)other, 0, this.size()) : false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        int result = this.getHashCode$jvm();
        if (result != 0) {
            return result;
        }
        result = 1;
        SegmentedByteString this_$iv = this;
        int segmentCount$iv = ((Object[])this_$iv.getSegments()).length;
        int pos$iv = 0;
        for (int s$iv = 0; s$iv < segmentCount$iv; ++s$iv) {
            void byteCount;
            void offset;
            int segmentPos$iv = this_$iv.getDirectory()[segmentCount$iv + s$iv];
            int nextSegmentOffset$iv = this_$iv.getDirectory()[s$iv];
            int n = nextSegmentOffset$iv - pos$iv;
            int n2 = segmentPos$iv;
            byte[] data = this_$iv.getSegments()[s$iv];
            void limit = offset + byteCount;
            for (void i = offset; i < limit; ++i) {
                result = 31 * result + data[i];
            }
            pos$iv = nextSegmentOffset$iv;
        }
        this.setHashCode$jvm(result);
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return this.toByteString().toString();
    }

    private final Object writeReplace() {
        ByteString byteString = this.toByteString();
        if (byteString == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
        }
        return byteString;
    }

    @NotNull
    public final byte[][] getSegments() {
        return this.segments;
    }

    @NotNull
    public final int[] getDirectory() {
        return this.directory;
    }

    private SegmentedByteString(byte[][] segments, int[] directory) {
        super(ByteString.EMPTY.getData$jvm());
        this.segments = segments;
        this.directory = directory;
    }

    public /* synthetic */ SegmentedByteString(@NotNull byte[][] segments, @NotNull int[] directory, DefaultConstructorMarker $constructor_marker) {
        this(segments, directory);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lokio/SegmentedByteString$Companion;", "", "()V", "of", "Lokio/ByteString;", "buffer", "Lokio/Buffer;", "byteCount", "", "jvm"})
    public static final class Companion {
        @NotNull
        public final ByteString of(@NotNull Buffer buffer, int byteCount) {
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            -Util.checkOffsetAndCount(buffer.size(), 0L, byteCount);
            int offset = 0;
            int segmentCount = 0;
            Segment s2 = buffer.head;
            while (offset < byteCount) {
                Segment segment = s2;
                if (segment == null) {
                    Intrinsics.throwNpe();
                }
                if (segment.limit == s2.pos) {
                    throw (Throwable)((Object)new AssertionError((Object)"s.limit == s.pos"));
                }
                offset += s2.limit - s2.pos;
                ++segmentCount;
                s2 = s2.next;
            }
            byte[][] segments = new byte[segmentCount][];
            int[] directory = new int[segmentCount * 2];
            offset = 0;
            segmentCount = 0;
            s2 = buffer.head;
            while (offset < byteCount) {
                int n;
                Segment segment = s2;
                if (segment == null) {
                    Intrinsics.throwNpe();
                }
                segments[segmentCount] = segment.data;
                int n2 = segmentCount;
                int[] nArray = directory;
                nArray[n2] = n = Math.min(offset += s2.limit - s2.pos, byteCount);
                directory[segmentCount + ((Object[])segments).length] = s2.pos;
                s2.shared = true;
                ++segmentCount;
                s2 = s2.next;
            }
            return new SegmentedByteString(segments, directory, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

