/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionCross;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.ISwimlanesA;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.TextBlockInterceptorUDrawable;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddUrl;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAssembly;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateGroup;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateParallel;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorIf;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorRepeat;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorSwitch;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorWhile;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.VCompactFactory;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UGraphicDelegator;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.Styleable;
import net.sourceforge.plantuml.svek.UGraphicForSnake;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.comp.CompressionMode;
import net.sourceforge.plantuml.ugraphic.comp.SlotFinder;
import net.sourceforge.plantuml.ugraphic.comp.SlotSet;
import net.sourceforge.plantuml.utils.MathUtils;

public class SwimlanesA
extends AbstractTextBlock
implements ISwimlanesA,
TextBlock,
Styleable {
    protected final ISkinParam skinParam;
    private final Pragma pragma;
    protected final List<Swimlane> swimlanes = new ArrayList<Swimlane>();
    private Swimlane currentSwimlane = null;
    private final Instruction root;
    private Instruction currentInstruction = this.root = new InstructionList();
    private LinkRendering nextLinkRenderer = LinkRendering.none();
    private Style style;
    private MinMax cachedMinMax;

    @Override
    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.classDiagram, SName.swimlane);
    }

    public SwimlanesA(ISkinParam skinParam, Pragma pragma) {
        this.skinParam = skinParam;
        this.pragma = pragma;
    }

    protected Style getStyle() {
        if (this.style == null) {
            this.style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        }
        return this.style;
    }

    private FtileFactory getFtileFactory(StringBounder stringBounder) {
        FtileFactory factory = new VCompactFactory(this.skinParam, stringBounder);
        factory = new FtileFactoryDelegatorAddUrl(factory);
        factory = new FtileFactoryDelegatorAssembly(factory);
        factory = new FtileFactoryDelegatorIf(factory, this.pragma);
        factory = new FtileFactoryDelegatorSwitch(factory);
        factory = new FtileFactoryDelegatorWhile(factory);
        factory = new FtileFactoryDelegatorRepeat(factory);
        factory = new FtileFactoryDelegatorCreateParallel(factory);
        factory = new FtileFactoryDelegatorAddNote(factory);
        factory = new FtileFactoryDelegatorCreateGroup(factory);
        return factory;
    }

    @Override
    public void swimlane(String name, HColor color, Display label) {
        this.currentSwimlane = this.getOrCreate(name);
        if (color != null) {
            this.currentSwimlane.setSpecificColorTOBEREMOVED(ColorType.BACK, color);
        }
        if (!Display.isNull(label)) {
            this.currentSwimlane.setDisplay(label);
        }
    }

    private Swimlane getOrCreate(String name) {
        for (Swimlane s : this.swimlanes) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        Swimlane result = new Swimlane(name);
        this.swimlanes.add(result);
        return result;
    }

    protected double separationMargin() {
        return 10.0;
    }

    @Override
    public final void computeSize(StringBounder stringBounder) {
        SlotFinder ug = new SlotFinder(CompressionMode.ON_Y, stringBounder);
        if (this.swimlanes.size() > 1) {
            Ftile full = this.root.createFtile(this.getFtileFactory(stringBounder));
            this.computeSizeInternal(ug, full);
        }
    }

    @Override
    public final void drawU(UGraphic ug) {
        TextBlock full = this.root.createFtile(this.getFtileFactory(ug.getStringBounder()));
        ug = new UGraphicForSnake(ug);
        if (this.swimlanes.size() > 1) {
            this.drawWhenSwimlanes(ug, full);
        } else {
            full = new TextBlockInterceptorUDrawable(full);
            full.drawU(ug);
            ug.flushUg();
        }
    }

    private static void printDebug(UGraphic ug, SlotSet slot, HColor col, TextBlock full) {
        slot.drawDebugX(ug.apply(col).apply(col.bg()), full.calculateDimension(ug.getStringBounder()).getHeight());
    }

    protected void drawWhenSwimlanes(UGraphic ug, TextBlock full) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimensionFull = full.calculateDimension(stringBounder);
        double x2 = 0.0;
        for (Swimlane swimlane : this.swimlanes) {
            HColor back = swimlane.getColors(this.skinParam).getColor(ColorType.BACK);
            if (back != null) {
                UGraphic background = ug.apply(back.bg()).apply(back);
                background = background.apply(UTranslate.dx(x2));
                this.drawBackColor(background, swimlane, dimensionFull);
            }
            full.drawU(new UGraphicInterceptorOneSwimlane(ug, swimlane, this.swimlanes).apply(swimlane.getTranslate()).apply(this.getTitleHeightTranslate(stringBounder)));
            x2 += swimlane.getActualWidth();
        }
        Cross cross = new Cross(ug.apply(this.getTitleHeightTranslate(stringBounder)));
        full.drawU(cross);
        cross.flushUg();
    }

    protected void drawBackColor(UGraphic ug, Swimlane swimlane, Dimension2D dimensionFull) {
        StringBounder stringBounder = ug.getStringBounder();
        double height = dimensionFull.getHeight() + this.getTitleHeightTranslate(stringBounder).getDy();
        URectangle rectangle = new URectangle(swimlane.getActualWidth(), height).ignoreForCompressionOnX().ignoreForCompressionOnY();
        ug.draw(rectangle);
    }

    protected UTranslate getTitleHeightTranslate(StringBounder stringBounder) {
        return new UTranslate();
    }

    private void computeDrawingWidths(UGraphic ug, TextBlock full) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Swimlane swimlane : this.swimlanes) {
            LimitFinder limitFinder = new LimitFinder(stringBounder, false);
            UGraphicInterceptorOneSwimlane interceptor = new UGraphicInterceptorOneSwimlane(new UGraphicForSnake(limitFinder), swimlane, this.swimlanes);
            full.drawU(interceptor);
            interceptor.flushUg();
            MinMax minMax = limitFinder.getMinMax();
            swimlane.setMinMax(minMax);
        }
    }

    private void computeSizeInternal(UGraphic ug, TextBlock full) {
        this.computeDrawingWidths(ug, full);
        double x1 = 0.0;
        double swimlaneWidth = this.skinParam.swimlaneWidth();
        if (swimlaneWidth == -1.0) {
            for (Swimlane swimlane : this.swimlanes) {
                swimlaneWidth = Math.max(swimlaneWidth, this.rawDrawingWidth(swimlane));
            }
        }
        for (Swimlane swimlane : this.swimlanes) {
            double swimlaneActualWidth = this.swimlaneActualWidth(ug.getStringBounder(), swimlaneWidth, swimlane);
            UTranslate translate = UTranslate.dx(x1 - swimlane.getMinMax().getMinX() + this.separationMargin() + (swimlaneActualWidth - this.rawDrawingWidth(swimlane)) / 2.0);
            swimlane.setTranslate(translate);
            swimlane.setWidth(swimlaneActualWidth);
            x1 += swimlaneActualWidth;
        }
    }

    protected double swimlaneActualWidth(StringBounder stringBounder, double swimlaneWidth, Swimlane swimlane) {
        return MathUtils.max(swimlaneWidth, this.rawDrawingWidth(swimlane));
    }

    private double rawDrawingWidth(Swimlane swimlane) {
        return swimlane.getMinMax().getWidth() + 2.0 * this.separationMargin();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getMinMax(stringBounder).getDimension();
    }

    @Override
    public Instruction getCurrent() {
        return this.currentInstruction;
    }

    @Override
    public void setCurrent(Instruction current) {
        this.currentInstruction = current;
    }

    @Override
    public LinkRendering nextLinkRenderer() {
        return this.nextLinkRenderer;
    }

    @Override
    public void setNextLinkRenderer(LinkRendering link) {
        if (link == null) {
            throw new IllegalArgumentException();
        }
        this.nextLinkRenderer = link;
    }

    @Override
    public Swimlane getCurrentSwimlane() {
        return this.currentSwimlane;
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        if (this.cachedMinMax == null) {
            this.cachedMinMax = TextBlockUtils.getMinMax(this, stringBounder);
        }
        return this.cachedMinMax;
    }

    class Cross
    extends UGraphicDelegator {
        private Cross(UGraphic ug) {
            super(ug);
        }

        @Override
        public void draw(UShape shape) {
            if (shape instanceof Ftile) {
                Ftile tile = (Ftile)shape;
                tile.drawU(this);
            } else if (shape instanceof Connection) {
                Connection connection = (Connection)shape;
                Ftile tile1 = connection.getFtile1();
                Ftile tile2 = connection.getFtile2();
                if (tile1 == null || tile2 == null) {
                    return;
                }
                if (tile1.getSwimlaneOut() != tile2.getSwimlaneIn()) {
                    ConnectionCross connectionCross = new ConnectionCross(connection);
                    connectionCross.drawU(this.getUg());
                }
            }
        }

        @Override
        public UGraphic apply(UChange change) {
            return new Cross(this.getUg().apply(change));
        }
    }
}

