/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.time.Wink;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class ResourceDraw
implements UDrawable {
    private final Resource res;
    private final TimeScale timeScale;
    private final double y;
    private final Wink min;
    private final Wink max;
    private final GanttDiagram gantt;

    public ResourceDraw(GanttDiagram gantt, Resource res, TimeScale timeScale, double y, Wink min, Wink max) {
        this.res = res;
        this.timeScale = timeScale;
        this.y = y;
        this.min = min;
        this.max = max;
        this.gantt = gantt;
    }

    @Override
    public void drawU(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.res.getName()).create(this.getFontConfiguration(13), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        title.drawU(ug);
        ULine line = ULine.hline(this.timeScale.getEndingPosition(this.max) - this.timeScale.getStartingPosition(this.min));
        ug.apply(HColorUtils.BLACK).apply(UTranslate.dy(title.calculateDimension(ug.getStringBounder()).getHeight())).draw(line);
        Wink i = this.min;
        while (i.compareTo(this.max) <= 0) {
            int load = this.gantt.getLoadForResource(this.res, i);
            if (load > 0) {
                FontConfiguration fontConfiguration = this.getFontConfiguration(9, load > 100 ? HColorUtils.RED : HColorUtils.BLACK);
                TextBlock value = Display.getWithNewlines("" + load).create(fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                double start = (this.timeScale.getStartingPosition(i) + this.timeScale.getEndingPosition(i)) / 2.0 - value.calculateDimension(ug.getStringBounder()).getWidth() / 2.0;
                value.drawU(ug.apply(new UTranslate(start, 16.0)));
            }
            i = i.increment();
        }
    }

    private FontConfiguration getFontConfiguration(int size) {
        return this.getFontConfiguration(size, HColorUtils.BLACK);
    }

    private FontConfiguration getFontConfiguration(int size, HColor color) {
        UFont font = UFont.serif(size);
        return new FontConfiguration(font, color, color, false);
    }

    public double getHeight() {
        return 32.0;
    }

    public double getY() {
        return this.y;
    }
}

