/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import net.sourceforge.plantuml.project.lang.ComplementColors;
import net.sourceforge.plantuml.project.time.Wink;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TaskDrawDiamond
extends AbstractTaskDraw {
    private ComplementColors colors;

    public TaskDrawDiamond(TimeScale timeScale, double y, String prettyDisplay, Wink start) {
        super(timeScale, y, prettyDisplay, start);
    }

    @Override
    protected FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    @Override
    public final void drawTitle(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        double titleHeight = title.calculateDimension(ug.getStringBounder()).getHeight();
        double h = (2.0 + this.getShapeHeight() - titleHeight) / 2.0;
        double endingPosition = this.timeScale.getStartingPosition(this.start) + this.getHeight();
        title.drawU(ug.apply(new UTranslate(endingPosition, h)));
    }

    @Override
    public void drawU(UGraphic ug1) {
        double startPos = this.timeScale.getStartingPosition(this.start);
        ug1 = this.applyColors(ug1);
        UGraphic ug2 = ug1.apply(new UTranslate(startPos + 2.0, 2.0));
        this.drawShape(ug2);
    }

    private UGraphic applyColors(UGraphic ug) {
        if (this.colors != null && this.colors.isOk()) {
            return this.colors.apply(ug);
        }
        return ug.apply(HColorUtils.BLACK).apply(HColorUtils.BLACK.bg());
    }

    private void drawShape(UGraphic ug) {
        ug.draw(this.getDiamond());
    }

    private UShape getDiamond() {
        double h = this.getHeight() - 4.0;
        UPolygon result = new UPolygon();
        result.addPoint(h / 2.0, 0.0);
        result.addPoint(h, h / 2.0);
        result.addPoint(h / 2.0, h);
        result.addPoint(0.0, h / 2.0);
        return result;
    }

    @Override
    public void setColorsAndCompletion(ComplementColors colors, int completion, Url url) {
        this.colors = colors;
    }
}

