/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NodesStatsRequest
extends BaseNodesRequest<NodesStatsRequest> {
    private CommonStatsFlags indices = new CommonStatsFlags(new CommonStatsFlags.Flag[0]);
    private final Set<String> requestedMetrics = new HashSet<String>();

    public NodesStatsRequest() {
        super((String[])null);
    }

    public NodesStatsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = new CommonStatsFlags(in);
        this.requestedMetrics.clear();
        if (in.getVersion().before(Version.V_7_7_0)) {
            this.addOrRemoveMetric(in.readBoolean(), Metric.OS.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metric.PROCESS.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metric.JVM.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metric.THREAD_POOL.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metric.FS.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metric.TRANSPORT.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metric.HTTP.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metric.BREAKER.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metric.SCRIPT.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metric.DISCOVERY.metricName());
            this.addOrRemoveMetric(in.readBoolean(), Metric.INGEST.metricName());
            if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.addOrRemoveMetric(in.readBoolean(), Metric.ADAPTIVE_SELECTION.metricName());
            }
        } else {
            this.requestedMetrics.addAll(in.readStringList());
        }
    }

    public NodesStatsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    public NodesStatsRequest all() {
        this.indices.all();
        this.requestedMetrics.addAll(Metric.allMetrics());
        return this;
    }

    public NodesStatsRequest clear() {
        this.indices.clear();
        this.requestedMetrics.clear();
        return this;
    }

    public CommonStatsFlags indices() {
        return this.indices;
    }

    public NodesStatsRequest indices(CommonStatsFlags indices) {
        this.indices = indices;
        return this;
    }

    public NodesStatsRequest indices(boolean indices) {
        if (indices) {
            this.indices.all();
        } else {
            this.indices.clear();
        }
        return this;
    }

    public boolean os() {
        return Metric.OS.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest os(boolean os) {
        this.addOrRemoveMetric(os, Metric.OS.metricName());
        return this;
    }

    public boolean process() {
        return Metric.PROCESS.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest process(boolean process) {
        this.addOrRemoveMetric(process, Metric.PROCESS.metricName());
        return this;
    }

    public boolean jvm() {
        return Metric.JVM.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest jvm(boolean jvm) {
        this.addOrRemoveMetric(jvm, Metric.JVM.metricName());
        return this;
    }

    public boolean threadPool() {
        return Metric.THREAD_POOL.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest threadPool(boolean threadPool) {
        this.addOrRemoveMetric(threadPool, Metric.THREAD_POOL.metricName());
        return this;
    }

    public boolean fs() {
        return Metric.FS.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest fs(boolean fs) {
        this.addOrRemoveMetric(fs, Metric.FS.metricName());
        return this;
    }

    public boolean transport() {
        return Metric.TRANSPORT.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest transport(boolean transport) {
        this.addOrRemoveMetric(transport, Metric.TRANSPORT.metricName());
        return this;
    }

    public boolean http() {
        return Metric.HTTP.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest http(boolean http) {
        this.addOrRemoveMetric(http, Metric.HTTP.metricName());
        return this;
    }

    public boolean breaker() {
        return Metric.BREAKER.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest breaker(boolean breaker) {
        this.addOrRemoveMetric(breaker, Metric.BREAKER.metricName());
        return this;
    }

    public boolean script() {
        return Metric.SCRIPT.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest script(boolean script) {
        this.addOrRemoveMetric(script, Metric.SCRIPT.metricName());
        return this;
    }

    public boolean discovery() {
        return Metric.DISCOVERY.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest discovery(boolean discovery) {
        this.addOrRemoveMetric(discovery, Metric.DISCOVERY.metricName());
        return this;
    }

    public boolean ingest() {
        return Metric.INGEST.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest ingest(boolean ingest) {
        this.addOrRemoveMetric(ingest, Metric.INGEST.metricName());
        return this;
    }

    public boolean adaptiveSelection() {
        return Metric.ADAPTIVE_SELECTION.containedIn(this.requestedMetrics);
    }

    public NodesStatsRequest adaptiveSelection(boolean adaptiveSelection) {
        this.addOrRemoveMetric(adaptiveSelection, Metric.ADAPTIVE_SELECTION.metricName());
        return this;
    }

    private void addOrRemoveMetric(boolean includeMetric, String metricName) {
        if (includeMetric) {
            this.requestedMetrics.add(metricName);
        } else {
            this.requestedMetrics.remove(metricName);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.indices.writeTo(out);
        if (out.getVersion().before(Version.V_7_7_0)) {
            out.writeBoolean(Metric.OS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.PROCESS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.JVM.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.THREAD_POOL.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.FS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.TRANSPORT.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.HTTP.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.BREAKER.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.SCRIPT.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.DISCOVERY.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.INGEST.containedIn(this.requestedMetrics));
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeBoolean(Metric.ADAPTIVE_SELECTION.containedIn(this.requestedMetrics));
            }
        } else {
            out.writeStringArray(this.requestedMetrics.toArray(new String[0]));
        }
    }

    private static enum Metric {
        OS("os"),
        PROCESS("process"),
        JVM("jvm"),
        THREAD_POOL("thread_pool"),
        FS("fs"),
        TRANSPORT("transport"),
        HTTP("http"),
        BREAKER("breaker"),
        SCRIPT("script"),
        DISCOVERY("discovery"),
        INGEST("ingest"),
        ADAPTIVE_SELECTION("adaptive_selection");

        private String metricName;

        private Metric(String name) {
            this.metricName = name;
        }

        String metricName() {
            return this.metricName;
        }

        boolean containedIn(Set<String> metricNames) {
            return metricNames.contains(this.metricName());
        }

        static Set<String> allMetrics() {
            return Arrays.stream(Metric.values()).map(Metric::metricName).collect(Collectors.toSet());
        }
    }
}

