/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.DecompiledTryDescriptor;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.utils.SmartSet;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001aD\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\nH\u0002\u001a\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"collectDecompiledTryDescriptors", "", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/DecompiledTryDescriptor;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "insertSaveRestoreStackMarkers", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "decompiledTryDescriptorForStart", "newTryStartLabels", "", "insertTryCatchBlocksMarkers", "transformTryCatchBlocks", "", "Ljava/util/HashMap;", "debugString", "", "tcb", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "isDefaultHandlerNode", "", "backend"})
public final class AnalyzeTryCatchBlocksKt {
    private static final boolean isDefaultHandlerNode(@NotNull TryCatchBlockNode $this$isDefaultHandlerNode) {
        return Intrinsics.areEqual($this$isDefaultHandlerNode.start, $this$isDefaultHandlerNode.handler);
    }

    private static final String debugString(@NotNull MethodNode $this$debugString, TryCatchBlockNode tcb) {
        return "TCB<" + $this$debugString.instructions.indexOf(tcb.start) + ", " + $this$debugString.instructions.indexOf(tcb.end) + ", " + $this$debugString.instructions.indexOf(tcb.handler) + '>';
    }

    @NotNull
    public static final Map<AbstractInsnNode, AbstractInsnNode> insertTryCatchBlocksMarkers(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        if (methodNode.tryCatchBlocks.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart = AnalyzeTryCatchBlocksKt.collectDecompiledTryDescriptors(methodNode);
        boolean bl = false;
        HashMap<LabelNode, LabelNode> newTryStartLabels = new HashMap<LabelNode, LabelNode>();
        Map<AbstractInsnNode, AbstractInsnNode> restoreStackToSaveStackMarker = AnalyzeTryCatchBlocksKt.insertSaveRestoreStackMarkers(decompiledTryDescriptorForStart, methodNode, (Map<LabelNode, LabelNode>)newTryStartLabels);
        AnalyzeTryCatchBlocksKt.transformTryCatchBlocks(methodNode, newTryStartLabels);
        return restoreStackToSaveStackMarker;
    }

    /*
     * WARNING - void declaration
     */
    private static final void transformTryCatchBlocks(MethodNode methodNode, HashMap<LabelNode, LabelNode> newTryStartLabels) {
        Collection<TryCatchBlockNode> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<TryCatchBlockNode> list2 = methodNode.tryCatchBlocks;
        Intrinsics.checkExpressionValueIsNotNull(list2, "methodNode.tryCatchBlocks");
        Iterable iterable = list2;
        MethodNode methodNode2 = methodNode;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tcb;
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            LabelNode newTryStartLabel = newTryStartLabels.get(tcb.start);
            TryCatchBlockNode tryCatchBlockNode2 = newTryStartLabel == null ? tcb : new TryCatchBlockNode(newTryStartLabel, tcb.end, tcb.handler, tcb.type);
            collection.add(tryCatchBlockNode2);
        }
        collection = (List)destination$iv$iv;
        methodNode2.tryCatchBlocks = collection;
    }

    private static final Map<AbstractInsnNode, AbstractInsnNode> insertSaveRestoreStackMarkers(Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart, MethodNode methodNode, Map<LabelNode, LabelNode> newTryStartLabels) {
        boolean bl = false;
        HashMap restoreStackToSaveMarker = new HashMap();
        boolean bl2 = false;
        HashMap saveStackMarkerByTryLabel = new HashMap();
        boolean bl3 = false;
        HashSet<LabelNode> doneHandlerLabels = new HashSet<LabelNode>();
        for (DecompiledTryDescriptor decompiledTryDescriptor : decompiledTryDescriptorForStart.values()) {
            boolean bl4 = false;
            boolean bl5 = false;
            DecompiledTryDescriptor $this$with = decompiledTryDescriptor;
            boolean bl6 = false;
            AbstractInsnNode saveStackMarker = null;
            Map map2 = saveStackMarkerByTryLabel;
            LabelNode labelNode = $this$with.getTryStartLabel();
            boolean bl7 = false;
            Map map3 = map2;
            boolean bl8 = false;
            if (!map3.containsKey(labelNode)) {
                AbstractInsnNode nopNode;
                AbstractInsnNode finger$iv;
                AbstractInsnNode $this$findNextOrNull$iv22 = $this$with.getTryStartLabel();
                boolean $i$f$findNextOrNull = false;
                for (finger$iv = $this$findNextOrNull$iv22.getNext(); finger$iv != null; finger$iv = finger$iv.getNext()) {
                    AbstractInsnNode it = finger$iv;
                    boolean bl9 = false;
                    if (UtilKt.hasOpcode(it)) break;
                }
                if (finger$iv == null) {
                    Intrinsics.throwNpe();
                }
                boolean $this$findNextOrNull$iv22 = nopNode.getOpcode() == 0;
                $i$f$findNextOrNull = false;
                if (_Assertions.ENABLED && !$this$findNextOrNull$iv22) {
                    boolean $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32 = false;
                    String $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32 = methodNode.instructions.indexOf(nopNode) + ": try block should start with NOP";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32));
                }
                LabelNode newTryStartLabel = new LabelNode(new Label());
                newTryStartLabels.put($this$with.getTryStartLabel(), newTryStartLabel);
                saveStackMarker = PseudoInsn.SAVE_STACK_BEFORE_TRY.createInsnNode();
                MethodInsnNode restoreStackMarker = PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode();
                ((Map)saveStackMarkerByTryLabel).put($this$with.getTryStartLabel(), saveStackMarker);
                ((Map)restoreStackToSaveMarker).put(restoreStackMarker, saveStackMarker);
                methodNode.instructions.insertBefore(nopNode, saveStackMarker);
                methodNode.instructions.insertBefore(nopNode, newTryStartLabel);
                methodNode.instructions.insert(nopNode, restoreStackMarker);
            } else {
                Object v = saveStackMarkerByTryLabel.get($this$with.getTryStartLabel());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                saveStackMarker = (AbstractInsnNode)v;
            }
            for (LabelNode handlerStartLabel : $this$with.getHandlerStartLabels()) {
                AbstractInsnNode storeNode;
                AbstractInsnNode finger$iv;
                if (doneHandlerLabels.contains(handlerStartLabel)) continue;
                doneHandlerLabels.add(handlerStartLabel);
                LabelNode labelNode2 = handlerStartLabel;
                Intrinsics.checkExpressionValueIsNotNull(labelNode2, "handlerStartLabel");
                AbstractInsnNode $this$findNextOrNull$iv32 = labelNode2;
                boolean $i$f$findNextOrNull = false;
                for (finger$iv = $this$findNextOrNull$iv32.getNext(); finger$iv != null; finger$iv = finger$iv.getNext()) {
                    AbstractInsnNode it = finger$iv;
                    boolean bl10 = false;
                    if (UtilKt.hasOpcode(it)) break;
                }
                if (finger$iv == null) {
                    Intrinsics.throwNpe();
                }
                boolean $this$findNextOrNull$iv32 = storeNode.getOpcode() == 58;
                bl8 = false;
                if (_Assertions.ENABLED && !$this$findNextOrNull$iv32) {
                    boolean bl11 = false;
                    String string2 = methodNode.instructions.indexOf(storeNode) + ": handler should start with ASTORE";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                MethodInsnNode restoreStackMarker = PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode();
                ((Map)restoreStackToSaveMarker).put(restoreStackMarker, saveStackMarker);
                methodNode.instructions.insert(storeNode, restoreStackMarker);
            }
        }
        return restoreStackToSaveMarker;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<LabelNode, DecompiledTryDescriptor> collectDecompiledTryDescriptors(MethodNode methodNode) {
        void $this$mapNotNullTo$iv;
        boolean bl = false;
        Map decompiledTryDescriptorForStart = new HashMap();
        boolean bl2 = false;
        Map decompiledTryDescriptorForHandler = new HashMap();
        List<TryCatchBlockNode> list2 = methodNode.tryCatchBlocks;
        Intrinsics.checkExpressionValueIsNotNull(list2, "methodNode.tryCatchBlocks");
        Iterable iterable = list2;
        Collection destination$iv = SmartSet.Companion.create();
        boolean $i$f$mapNotNullTo = false;
        Map $this$forEach$iv$iv2 = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            LabelNode labelNode;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl3 = false;
            TryCatchBlockNode it = (TryCatchBlockNode)element$iv;
            boolean bl4 = false;
            TryCatchBlockNode tryCatchBlockNode = it;
            Intrinsics.checkExpressionValueIsNotNull(tryCatchBlockNode, "it");
            if ((AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tryCatchBlockNode) ? it.handler : null) == null) continue;
            labelNode = labelNode;
            boolean bl5 = false;
            boolean bl6 = false;
            LabelNode it$iv = labelNode;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        SmartSet defaultHandlers = (SmartSet)destination$iv;
        Iterator<TryCatchBlockNode> iterator3 = methodNode.tryCatchBlocks.iterator();
        while (iterator3.hasNext()) {
            Object object;
            LabelNode key$iv;
            void $this$getOrPut$iv;
            TryCatchBlockNode tcb;
            TryCatchBlockNode tryCatchBlockNode = tcb = iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull(tryCatchBlockNode, "tcb");
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tryCatchBlockNode)) {
                $i$f$mapNotNullTo = decompiledTryDescriptorForHandler.containsKey(tcb.start);
                boolean $this$forEach$iv$iv2 = false;
                if (_Assertions.ENABLED && !$i$f$mapNotNullTo) {
                    boolean $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = false;
                    String $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = AnalyzeTryCatchBlocksKt.debugString(methodNode, tcb) + ": default handler should occur after some regular handler";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22));
                }
            }
            $this$forEach$iv$iv2 = decompiledTryDescriptorForHandler;
            Intrinsics.checkExpressionValueIsNotNull(tcb.handler, "tcb.handler");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Object object2;
                LabelNode key$iv2;
                void $this$getOrPut$iv2;
                boolean bl8 = false;
                Map bl3 = decompiledTryDescriptorForStart;
                Intrinsics.checkExpressionValueIsNotNull(tcb.start, "tcb.start");
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    boolean bl9 = false;
                    LabelNode labelNode = tcb.start;
                    Intrinsics.checkExpressionValueIsNotNull(labelNode, "tcb.start");
                    DecompiledTryDescriptor answer$iv = new DecompiledTryDescriptor(labelNode);
                    $this$getOrPut$iv2.put(key$iv2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv2;
                }
                DecompiledTryDescriptor answer$iv = (DecompiledTryDescriptor)object2;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            DecompiledTryDescriptor decompiledTryDescriptor = (DecompiledTryDescriptor)object;
            boolean bl10 = false;
            boolean bl11 = false;
            DecompiledTryDescriptor $this$with = decompiledTryDescriptor;
            boolean bl12 = false;
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) {
                boolean bl13 = $this$with.getDefaultHandlerTcb() == null;
                boolean bl14 = false;
                if (_Assertions.ENABLED && !bl13) {
                    boolean bl15 = false;
                    StringBuilder stringBuilder2 = new StringBuilder().append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tcb)).append(": default handler is already found: ");
                    TryCatchBlockNode tryCatchBlockNode2 = $this$with.getDefaultHandlerTcb();
                    if (tryCatchBlockNode2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = stringBuilder2.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode2)).toString();
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                $this$with.setDefaultHandlerTcb(tcb);
            }
            if (defaultHandlers.contains(tcb.handler)) continue;
            $this$with.getHandlerStartLabels().add(tcb.handler);
        }
        return decompiledTryDescriptorForStart;
    }
}

