/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.leipzig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import opennlp.tools.util.ObjectStream;

class SampleShuffleStream<T>
implements ObjectStream<T> {
    private List<T> bufferedSamples = new ArrayList<T>();
    private Iterator<T> sampleIt;

    SampleShuffleStream(ObjectStream<T> samples) throws IOException {
        T sample;
        while ((sample = samples.read()) != null) {
            this.bufferedSamples.add(sample);
        }
        Collections.shuffle(this.bufferedSamples, new Random(23L));
        this.reset();
    }

    @Override
    public T read() throws IOException {
        if (this.sampleIt.hasNext()) {
            return this.sampleIt.next();
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.sampleIt = this.bufferedSamples.iterator();
    }
}

