/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Max3DSLoader
extends LoaderBase
implements Loader {
    private static final int TRACK_KEY_USE_TENS = 1;
    private static final int TRACK_KEY_USE_CONT = 2;
    private static final int TRACK_KEY_USE_BIAS = 4;
    private static final int TRACK_KEY_USE_EASE_TO = 8;
    private static final int TRACK_KEY_USE_EASE_FROM = 16;
    private static final Appearance DEFAULT_APPEARANCE = new Appearance();
    private Boolean useCaches;
    private float masterScale;
    private List<Mesh3DS> meshes;
    private Map<String, Material3DS> materials;
    private Group root;
    private Map<String, List<TransformGroup>> meshesGroups;

    public void setUseCaches(Boolean bl) {
        this.useCaches = (boolean)bl;
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        URL uRL;
        try {
            uRL = this.basePath != null ? new File(this.basePath).toURI().toURL() : new File(string).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException(string);
        }
        return this.load(new FileInputStream(string), uRL);
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        InputStream inputStream;
        URL uRL2 = this.baseUrl;
        if (this.baseUrl == null) {
            uRL2 = uRL;
        }
        try {
            inputStream = Max3DSLoader.openStream(uRL, this.useCaches);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Can't read " + uRL);
        }
        return this.load(inputStream, uRL2);
    }

    private static InputStream openStream(URL uRL, Boolean bl) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (bl != null) {
            uRLConnection.setUseCaches(bl);
        }
        return uRLConnection.getInputStream();
    }

    public Scene load(Reader reader) {
        throw new UnsupportedOperationException("Binary file format, can't read from a text");
    }

    private Scene load(InputStream inputStream, URL uRL) throws FileNotFoundException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            Scene scene = this.parseStream(new ChunksInputStream(inputStream, uRL));
            return scene;
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new ParsingErrorException(iOException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scene parseStream(ChunksInputStream chunksInputStream) throws IOException {
        this.masterScale = 1.0f;
        this.meshes = new ArrayList<Mesh3DS>();
        this.materials = new LinkedHashMap<String, Material3DS>();
        this.meshesGroups = new HashMap<String, List<TransformGroup>>();
        boolean bl = false;
        switch (chunksInputStream.readChunkHeader().getID()) {
            case M3DMAGIC: 
            case MLIBMAGIC: 
            case CMAGIC: {
                bl = true;
                while (!chunksInputStream.isChunckEndReached()) {
                    switch (chunksInputStream.readChunkHeader().getID()) {
                        case M3D_VERSION: {
                            chunksInputStream.readLittleEndianUnsignedInt();
                            break;
                        }
                        case EDITOR_DATA: {
                            this.parseEditorData(chunksInputStream);
                            break;
                        }
                        case KEY_FRAMER_DATA: {
                            this.parseKeyFramerData(chunksInputStream);
                            break;
                        }
                        default: {
                            chunksInputStream.readUntilChunkEnd();
                        }
                    }
                    chunksInputStream.releaseChunk();
                }
                break;
            }
            case EDITOR_DATA: {
                this.parseEditorData(chunksInputStream);
                break;
            }
            default: {
                if (bl) {
                    chunksInputStream.readUntilChunkEnd();
                    break;
                }
                throw new IncorrectFormatException("Bad magic number");
            }
        }
        chunksInputStream.releaseChunk();
        try {
            SceneBase sceneBase = this.createScene();
            return sceneBase;
        }
        finally {
            this.meshes = null;
            this.materials = null;
            this.meshesGroups = null;
            this.root = null;
        }
    }

    private SceneBase createScene() {
        Vector3f[] vector3fArray;
        Color3f color3f;
        Float f;
        Vector3f[] vector3fArray2;
        Mesh3DSSharedVertex[] mesh3DSSharedVertexArray;
        Point3f[] point3fArray;
        Face3DS[] face3DSArray;
        SceneBase sceneBase = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        sceneBase.setSceneGroup(branchGroup);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(-1.5707963267948966);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.setScale((double)this.masterScale);
        transform3D.mul(transform3D2);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        branchGroup.addChild((Node)transformGroup);
        if (this.root != null) {
            transformGroup.addChild((Node)this.root);
            transformGroup = this.root;
        }
        HashMap<Material3DS, Face3DS[]> hashMap = new HashMap<Material3DS, Face3DS[]>();
        for (Material3DS object : this.materials.values()) {
            face3DSArray = new Appearance();
            try {
                face3DSArray.setName(object.getName());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            point3fArray = new Material();
            face3DSArray.setMaterial((Material)point3fArray);
            mesh3DSSharedVertexArray = object.getAmbientColor();
            if (mesh3DSSharedVertexArray != null) {
                point3fArray.setAmbientColor((Color3f)mesh3DSSharedVertexArray);
            }
            if ((vector3fArray2 = object.getDiffuseColor()) != null) {
                point3fArray.setDiffuseColor((Color3f)vector3fArray2);
            }
            if ((f = object.getShininess()) != null) {
                point3fArray.setShininess(f.floatValue() * 128.0f * 0.6f);
            }
            if ((color3f = object.getSpecularColor()) != null) {
                if (f != null) {
                    vector3fArray = new Color3f(color3f);
                    vector3fArray.scale(f.floatValue());
                    point3fArray.setSpecularColor((Color3f)vector3fArray);
                } else {
                    point3fArray.setSpecularColor(color3f);
                }
            }
            if ((vector3fArray = object.getTransparency()) != null && vector3fArray.floatValue() > 0.0f) {
                face3DSArray.setTransparencyAttributes(new TransparencyAttributes(1, Math.min(1.0f, vector3fArray.floatValue())));
            }
            face3DSArray.setTexture(object.getTexture());
            hashMap.put(object, face3DSArray);
        }
        for (Mesh3DS mesh3DS : this.meshes) {
            int n;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Vector3f i;
            int nArray2;
            Object object5;
            Object object6;
            face3DSArray = mesh3DS.getFaces();
            if (face3DSArray == null || face3DSArray.length <= 0) continue;
            point3fArray = mesh3DS.getVertices();
            mesh3DSSharedVertexArray = new Mesh3DSSharedVertex[point3fArray.length];
            vector3fArray2 = new Vector3f[3 * face3DSArray.length];
            f = new Vector3f();
            color3f = new Vector3f();
            int n2 = 0;
            for (int j = 0; j < face3DSArray.length; ++j) {
                object6 = face3DSArray[j];
                object5 = ((Face3DS)object6).getVertexIndices();
                int iterator = 0;
                while (iterator < 3) {
                    nArray2 = object5[iterator];
                    f.sub((Tuple3f)point3fArray[object5[iterator < 2 ? iterator + 1 : 0]], (Tuple3f)point3fArray[nArray2]);
                    color3f.sub((Tuple3f)point3fArray[object5[iterator > 0 ? iterator - 1 : 2]], (Tuple3f)point3fArray[nArray2]);
                    i = new Vector3f();
                    i.cross((Vector3f)f, (Vector3f)color3f);
                    float f2 = i.length();
                    if (f2 > 0.0f) {
                        float f3 = (float)Math.atan2(f2, f.dot((Vector3f)color3f));
                        i.scale(f3 / f2);
                    }
                    object4 = new Mesh3DSSharedVertex(j, i);
                    ((Mesh3DSSharedVertex)object4).setNextVertex(mesh3DSSharedVertexArray[nArray2]);
                    mesh3DSSharedVertexArray[nArray2] = object4;
                    vector3fArray2[n2] = i;
                    ++iterator;
                    ++n2;
                }
            }
            vector3fArray = new Vector3f[3 * face3DSArray.length];
            int n3 = 0;
            for (n2 = 0; n2 < face3DSArray.length; ++n2) {
                object5 = face3DSArray[n2];
                int[] n4 = ((Face3DS)object5).getVertexIndices();
                int[] transformGroup3 = new int[3];
                for (int j = 0; j < 3; ++j) {
                    int n5 = n4[j];
                    object4 = new Vector3f();
                    if (((Face3DS)object5).getSmoothingGroup() == null) {
                        for (object3 = mesh3DSSharedVertexArray[n5]; object3 != null; object3 = ((Mesh3DSSharedVertex)object3).getNextVertex()) {
                            if (face3DSArray[((Mesh3DSSharedVertex)object3).getFaceIndex()].getSmoothingGroup() != null || ((Mesh3DSSharedVertex)object3).getNormal() != vector3fArray2[n3] && !(((Mesh3DSSharedVertex)object3).getNormal().dot(vector3fArray2[n3]) > 0.0f)) continue;
                            object4.add((Tuple3f)((Mesh3DSSharedVertex)object3).getNormal());
                        }
                    } else {
                        Mesh3DSSharedVertex mesh3DSSharedVertex;
                        long l = ((Face3DS)object5).getSmoothingGroup();
                        for (mesh3DSSharedVertex = mesh3DSSharedVertexArray[n5]; mesh3DSSharedVertex != null; mesh3DSSharedVertex = mesh3DSSharedVertex.getNextVertex()) {
                            object2 = face3DSArray[mesh3DSSharedVertex.getFaceIndex()];
                            if (((Face3DS)object2).getSmoothingGroup() == null || (((Face3DS)object5).getSmoothingGroup() & ((Face3DS)object2).getSmoothingGroup()) == 0L) continue;
                            l |= ((Face3DS)object2).getSmoothingGroup().longValue();
                        }
                        for (mesh3DSSharedVertex = mesh3DSSharedVertexArray[n5]; mesh3DSSharedVertex != null; mesh3DSSharedVertex = mesh3DSSharedVertex.getNextVertex()) {
                            object2 = face3DSArray[mesh3DSSharedVertex.getFaceIndex()];
                            if (((Face3DS)object2).getSmoothingGroup() == null || (l & ((Face3DS)object2).getSmoothingGroup()) == 0L) continue;
                            object4.add((Tuple3f)mesh3DSSharedVertex.getNormal());
                        }
                    }
                    if (object4.lengthSquared() != 0.0f) {
                        object4.normalize();
                    } else {
                        object4.set((Tuple3f)vector3fArray2[n3]);
                        if (object4.lengthSquared() != 0.0f) {
                            object4.normalize();
                        }
                    }
                    vector3fArray[n3] = object4;
                    transformGroup3[j] = n3++;
                }
                ((Face3DS)object5).setNormalIndices(transformGroup3);
            }
            Arrays.sort(face3DSArray, new Comparator<Face3DS>(){

                @Override
                public int compare(Face3DS face3DS, Face3DS face3DS2) {
                    Material3DS material3DS = face3DS.getMaterial();
                    Material3DS material3DS2 = face3DS2.getMaterial();
                    if (material3DS == null) {
                        if (material3DS2 == null) {
                            return face3DS.getIndex() - face3DS2.getIndex();
                        }
                        return -1;
                    }
                    if (material3DS2 == null) {
                        return 1;
                    }
                    return material3DS.hashCode() - material3DS2.hashCode();
                }
            });
            object6 = this.meshesGroups.get(mesh3DS.getName());
            if (object6 == null) {
                object = transformGroup;
            } else if (object6.size() == 1) {
                object = (Group)object6.get(0);
            } else {
                object5 = new SharedGroup();
                Iterator iterator = object6.iterator();
                while (iterator.hasNext()) {
                    TransformGroup transformGroup2 = (TransformGroup)iterator.next();
                    transformGroup2.addChild((Node)new Link((SharedGroup)object5));
                }
                object = object5;
            }
            object5 = mesh3DS.getTransform();
            if (object5 != null && (n = object5.getBestType()) != 1 && n != 2) {
                TransformGroup transformGroup3 = new TransformGroup();
                transformGroup3.setTransform((Transform3D)object5);
                object.addChild((Node)transformGroup3);
                object = transformGroup3;
            }
            TexCoord2f[] nArray = mesh3DS.getTextureCoordinates();
            nArray2 = 0;
            i = null;
            Object n6 = null;
            while (nArray2 < face3DSArray.length) {
                Face3DS face3DS;
                object4 = face3DSArray[nArray2];
                object3 = ((Face3DS)object4).getMaterial();
                int n7 = nArray2;
                while (++n7 < face3DSArray.length && object3 == face3DSArray[n7].getMaterial()) {
                }
                int n8 = n7 - nArray2;
                object2 = new int[n8 * 3];
                int[] nArray3 = new int[n8 * 3];
                int n9 = 0;
                for (int j = 0; j < n8; ++j) {
                    face3DS = face3DSArray[nArray2 + j];
                    int[] nArray4 = face3DS.getVertexIndices();
                    int[] nArray5 = face3DS.getNormalIndices();
                    int n10 = 0;
                    while (n10 < 3) {
                        object2[n9] = nArray4[n10];
                        nArray3[n9] = nArray5[n10];
                        ++n10;
                        ++n9;
                    }
                }
                GeometryInfo geometryInfo = new GeometryInfo(1);
                geometryInfo.setCoordinates(point3fArray);
                geometryInfo.setCoordinateIndices((int[])object2);
                geometryInfo.setNormals(vector3fArray);
                geometryInfo.setNormalIndices(nArray3);
                if (nArray != null) {
                    geometryInfo.setTextureCoordinateParams(1, 2);
                    geometryInfo.setTextureCoordinates(0, nArray);
                    geometryInfo.setTextureCoordinateIndices(0, (int[])object2);
                }
                GeometryArray geometryArray = geometryInfo.getGeometryArray(true, true, false);
                if (i == null || n6 != object3) {
                    n6 = object3;
                    face3DS = (Appearance)hashMap.get(object3);
                    if (face3DS == null) {
                        face3DS = DEFAULT_APPEARANCE;
                    }
                    face3DS = (Appearance)face3DS.cloneNodeComponent(false);
                    if (object3 != null && ((Material3DS)object3).isTwoSided()) {
                        face3DS.setPolygonAttributes(new PolygonAttributes(2, 0, 0.0f));
                    }
                    i = new Shape3D((Geometry)geometryArray, (Appearance)face3DS);
                    object.addChild((Node)i);
                    sceneBase.addNamedObject(mesh3DS.getName() + (nArray2 == 0 ? "" : "_" + String.valueOf(nArray2)), (Object)i);
                } else {
                    i.addGeometry((Geometry)geometryArray);
                }
                nArray2 = n7;
            }
        }
        return sceneBase;
    }

    private void parseEditorData(ChunksInputStream chunksInputStream) throws IOException {
        while (!chunksInputStream.isChunckEndReached()) {
            switch (chunksInputStream.readChunkHeader().getID()) {
                case MESH_VERSION: {
                    chunksInputStream.readLittleEndianInt();
                    break;
                }
                case MASTER_SCALE: {
                    this.masterScale = chunksInputStream.readLittleEndianFloat();
                    break;
                }
                case NAMED_OBJECT: {
                    this.parseNamedObject(chunksInputStream);
                    break;
                }
                case MATERIAL_ENTRY: {
                    Material3DS material3DS = this.parseMaterial(chunksInputStream);
                    this.materials.put(material3DS.getName(), material3DS);
                    break;
                }
                default: {
                    chunksInputStream.readUntilChunkEnd();
                }
            }
            chunksInputStream.releaseChunk();
        }
    }

    private void parseNamedObject(ChunksInputStream chunksInputStream) throws IOException {
        String string = chunksInputStream.readString();
        while (!chunksInputStream.isChunckEndReached()) {
            switch (chunksInputStream.readChunkHeader().getID()) {
                case TRIANGLE_MESH_OBJECT: {
                    this.meshes.add(this.parseMeshData(chunksInputStream, string));
                    break;
                }
                default: {
                    chunksInputStream.readUntilChunkEnd();
                }
            }
            chunksInputStream.releaseChunk();
        }
    }

    private Mesh3DS parseMeshData(ChunksInputStream chunksInputStream, String string) throws IOException {
        Point3f[] point3fArray = null;
        TexCoord2f[] texCoord2fArray = null;
        Transform3D transform3D = null;
        Short s = null;
        Face3DS[] face3DSArray = null;
        while (!chunksInputStream.isChunckEndReached()) {
            switch (chunksInputStream.readChunkHeader().getID()) {
                case MESH_MATRIX: {
                    try {
                        transform3D = this.parseMatrix(chunksInputStream);
                        transform3D.invert();
                    }
                    catch (SingularMatrixException singularMatrixException) {
                        transform3D = null;
                    }
                    break;
                }
                case MESH_COLOR: {
                    s = chunksInputStream.readUnsignedByte();
                    break;
                }
                case POINT_ARRAY: {
                    point3fArray = new Point3f[chunksInputStream.readLittleEndianUnsignedShort()];
                    for (int i = 0; i < point3fArray.length; ++i) {
                        point3fArray[i] = new Point3f(chunksInputStream.readLittleEndianFloat(), chunksInputStream.readLittleEndianFloat(), chunksInputStream.readLittleEndianFloat());
                    }
                    break;
                }
                case FACE_ARRAY: {
                    face3DSArray = this.parseFacesData(chunksInputStream);
                    while (!chunksInputStream.isChunckEndReached()) {
                        switch (chunksInputStream.readChunkHeader().getID()) {
                            case MESH_MATERIAL_GROUP: {
                                int n;
                                String string2 = chunksInputStream.readString();
                                Material3DS material3DS = null;
                                if (this.materials != null) {
                                    material3DS = this.materials.get(string2);
                                }
                                int n2 = chunksInputStream.readLittleEndianUnsignedShort();
                                for (n = 0; n < n2; ++n) {
                                    int n3 = chunksInputStream.readLittleEndianUnsignedShort();
                                    if (n3 >= face3DSArray.length) continue;
                                    face3DSArray[n3].setMaterial(material3DS);
                                }
                                break;
                            }
                            case SMOOTHING_GROUP: {
                                int n;
                                for (n = 0; n < face3DSArray.length; ++n) {
                                    face3DSArray[n].setSmoothingGroup(chunksInputStream.readLittleEndianUnsignedInt());
                                }
                                break;
                            }
                            default: {
                                chunksInputStream.readUntilChunkEnd();
                            }
                        }
                        chunksInputStream.releaseChunk();
                    }
                    break;
                }
                case TEXTURE_COORDINATES: {
                    texCoord2fArray = new TexCoord2f[chunksInputStream.readLittleEndianUnsignedShort()];
                    for (int i = 0; i < texCoord2fArray.length; ++i) {
                        texCoord2fArray[i] = new TexCoord2f(chunksInputStream.readLittleEndianFloat(), chunksInputStream.readLittleEndianFloat());
                    }
                    break;
                }
                default: {
                    chunksInputStream.readUntilChunkEnd();
                }
            }
            chunksInputStream.releaseChunk();
        }
        return new Mesh3DS(string, point3fArray, texCoord2fArray, face3DSArray, s, transform3D);
    }

    private void parseKeyFramerData(ChunksInputStream chunksInputStream) throws IOException {
        ArrayList<TransformGroup> arrayList = new ArrayList<TransformGroup>();
        TransformGroup transformGroup = null;
        while (!chunksInputStream.isChunckEndReached()) {
            switch (chunksInputStream.readChunkHeader().getID()) {
                case OBJECT_NODE_TAG: {
                    double d;
                    Object object;
                    boolean bl = true;
                    Vector3f vector3f = null;
                    Vector3f vector3f2 = null;
                    float f = 0.0f;
                    Vector3f vector3f3 = null;
                    Vector3f vector3f4 = null;
                    while (!chunksInputStream.isChunckEndReached()) {
                        switch (chunksInputStream.readChunkHeader().getID()) {
                            case NODE_HIERARCHY: {
                                object = chunksInputStream.readString();
                                bl = !"$$$DUMMY".equals(object);
                                chunksInputStream.readLittleEndianUnsignedShort();
                                chunksInputStream.readLittleEndianUnsignedShort();
                                short s = chunksInputStream.readLittleEndianShort();
                                TransformGroup transformGroup2 = new TransformGroup();
                                if (this.root == null) {
                                    this.root = new TransformGroup();
                                }
                                if (s == -1) {
                                    this.root.addChild((Node)transformGroup2);
                                } else {
                                    if (s > arrayList.size() - 1) {
                                        throw new IncorrectFormatException("Inconsistent nodes hierarchy");
                                    }
                                    ((TransformGroup)arrayList.get(s)).addChild((Node)transformGroup2);
                                }
                                arrayList.add(transformGroup2);
                                if (bl) {
                                    List<TransformGroup> list = this.meshesGroups.get(object);
                                    if (list == null) {
                                        list = new ArrayList<TransformGroup>();
                                        this.meshesGroups.put((String)object, list);
                                    }
                                    list.add(transformGroup2);
                                }
                                transformGroup = transformGroup2;
                                break;
                            }
                            case PIVOT: {
                                vector3f = this.parseVector(chunksInputStream);
                                break;
                            }
                            case POSITION_TRACK_TAG: {
                                this.parseKeyFramerTrackStart(chunksInputStream);
                                vector3f2 = this.parseVector(chunksInputStream);
                                chunksInputStream.readUntilChunkEnd();
                                break;
                            }
                            case ROTATION_TRACK_TAG: {
                                this.parseKeyFramerTrackStart(chunksInputStream);
                                f = chunksInputStream.readLittleEndianFloat();
                                vector3f3 = this.parseVector(chunksInputStream);
                                chunksInputStream.readUntilChunkEnd();
                                break;
                            }
                            case SCALE_TRACK_TAG: {
                                this.parseKeyFramerTrackStart(chunksInputStream);
                                vector3f4 = this.parseVector(chunksInputStream);
                                chunksInputStream.readUntilChunkEnd();
                                break;
                            }
                            default: {
                                chunksInputStream.readUntilChunkEnd();
                            }
                        }
                        chunksInputStream.releaseChunk();
                    }
                    object = new Transform3D();
                    if (vector3f2 != null) {
                        Transform3D transform3D = new Transform3D();
                        transform3D.setTranslation(vector3f2);
                        object.mul(transform3D);
                    }
                    if (vector3f3 != null && f != 0.0f && (d = (double)vector3f3.length()) > 0.0) {
                        float f2 = -f / 2.0f;
                        double d2 = Math.sin(f2) / d;
                        double d3 = Math.cos(f2);
                        Transform3D transform3D = new Transform3D();
                        transform3D.set(new Quat4d((double)vector3f3.x * d2, (double)vector3f3.y * d2, (double)vector3f3.z * d2, d3));
                        object.mul(transform3D);
                    }
                    if (vector3f4 != null) {
                        Transform3D transform3D = new Transform3D();
                        transform3D.setScale(new Vector3d(vector3f4));
                        object.mul(transform3D);
                    }
                    if (vector3f != null && bl) {
                        Transform3D transform3D = new Transform3D();
                        vector3f.negate();
                        transform3D.setTranslation(vector3f);
                        object.mul(transform3D);
                    }
                    transformGroup.setTransform(object);
                    break;
                }
                default: {
                    chunksInputStream.readUntilChunkEnd();
                }
            }
            chunksInputStream.releaseChunk();
        }
    }

    private void parseKeyFramerTrackStart(ChunksInputStream chunksInputStream) throws IOException {
        chunksInputStream.readLittleEndianUnsignedShort();
        chunksInputStream.readLittleEndianUnsignedInt();
        chunksInputStream.readLittleEndianUnsignedInt();
        chunksInputStream.readLittleEndianInt();
        chunksInputStream.readLittleEndianInt();
        int n = chunksInputStream.readLittleEndianUnsignedShort();
        if ((n & 1) != 0) {
            chunksInputStream.readLittleEndianFloat();
        }
        if ((n & 2) != 0) {
            chunksInputStream.readLittleEndianFloat();
        }
        if ((n & 4) != 0) {
            chunksInputStream.readLittleEndianFloat();
        }
        if ((n & 8) != 0) {
            chunksInputStream.readLittleEndianFloat();
        }
        if ((n & 0x10) != 0) {
            chunksInputStream.readLittleEndianFloat();
        }
    }

    private Face3DS[] parseFacesData(ChunksInputStream chunksInputStream) throws IOException {
        Face3DS[] face3DSArray = new Face3DS[chunksInputStream.readLittleEndianUnsignedShort()];
        for (int i = 0; i < face3DSArray.length; ++i) {
            face3DSArray[i] = new Face3DS(i, chunksInputStream.readLittleEndianUnsignedShort(), chunksInputStream.readLittleEndianUnsignedShort(), chunksInputStream.readLittleEndianUnsignedShort(), chunksInputStream.readLittleEndianUnsignedShort());
        }
        return face3DSArray;
    }

    private Material3DS parseMaterial(ChunksInputStream chunksInputStream) throws IOException {
        String string = null;
        Color3f color3f = null;
        Color3f color3f2 = null;
        Color3f color3f3 = null;
        Float f = null;
        Float f2 = null;
        boolean bl = false;
        Texture texture = null;
        while (!chunksInputStream.isChunckEndReached()) {
            switch (chunksInputStream.readChunkHeader().getID()) {
                case MATERIAL_NAME: {
                    string = chunksInputStream.readString();
                    break;
                }
                case MATERIAL_AMBIENT: {
                    color3f = this.parseColor(chunksInputStream);
                    break;
                }
                case MATERIAL_DIFFUSE: {
                    color3f2 = this.parseColor(chunksInputStream);
                    break;
                }
                case MATERIAL_SPECULAR: {
                    color3f3 = this.parseColor(chunksInputStream);
                    break;
                }
                case MATERIAL_SHININESS: {
                    f = this.parsePercentage(chunksInputStream);
                    break;
                }
                case MATERIAL_TRANSPARENCY: {
                    f2 = this.parsePercentage(chunksInputStream);
                    break;
                }
                case MATERIAL_TWO_SIDED: {
                    bl = true;
                    break;
                }
                case MATERIAL_TEXMAP: {
                    texture = this.parseTextureMap(chunksInputStream);
                    break;
                }
                default: {
                    chunksInputStream.readUntilChunkEnd();
                }
            }
            chunksInputStream.releaseChunk();
        }
        return new Material3DS(string, color3f, color3f2, color3f3, f, f2, texture, bl);
    }

    private Color3f parseColor(ChunksInputStream chunksInputStream) throws IOException {
        boolean bl = false;
        Color3f color3f = null;
        while (!chunksInputStream.isChunckEndReached()) {
            switch (chunksInputStream.readChunkHeader().getID()) {
                case LINEAR_COLOR_24: {
                    bl = true;
                    color3f = new Color3f((float)chunksInputStream.readUnsignedByte() / 255.0f, (float)chunksInputStream.readUnsignedByte() / 255.0f, (float)chunksInputStream.readUnsignedByte() / 255.0f);
                    break;
                }
                case COLOR_24: {
                    Color3f color3f2 = new Color3f((float)chunksInputStream.readUnsignedByte() / 255.0f, (float)chunksInputStream.readUnsignedByte() / 255.0f, (float)chunksInputStream.readUnsignedByte() / 255.0f);
                    if (bl) break;
                    color3f = color3f2;
                    break;
                }
                case LINEAR_COLOR_FLOAT: {
                    bl = true;
                    color3f = new Color3f(chunksInputStream.readLittleEndianFloat(), chunksInputStream.readLittleEndianFloat(), chunksInputStream.readLittleEndianFloat());
                    break;
                }
                case COLOR_FLOAT: {
                    Color3f color3f2 = new Color3f(chunksInputStream.readLittleEndianFloat(), chunksInputStream.readLittleEndianFloat(), chunksInputStream.readLittleEndianFloat());
                    if (bl) break;
                    color3f = color3f2;
                    break;
                }
                default: {
                    chunksInputStream.readUntilChunkEnd();
                }
            }
            chunksInputStream.releaseChunk();
        }
        if (color3f != null) {
            return color3f;
        }
        throw new IncorrectFormatException("Expected color value");
    }

    private Float parsePercentage(ChunksInputStream chunksInputStream) throws IOException {
        Float f = null;
        while (!chunksInputStream.isChunckEndReached()) {
            switch (chunksInputStream.readChunkHeader().getID()) {
                case PERCENTAGE_INT: {
                    f = Float.valueOf((float)chunksInputStream.readLittleEndianShort() / 100.0f);
                    break;
                }
                case PERCENTAGE_FLOAT: {
                    f = Float.valueOf(chunksInputStream.readLittleEndianFloat());
                    break;
                }
                default: {
                    chunksInputStream.readUntilChunkEnd();
                }
            }
            chunksInputStream.releaseChunk();
        }
        if (f != null) {
            return f;
        }
        throw new IncorrectFormatException("Expected percentage value");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Texture parseTextureMap(ChunksInputStream chunksInputStream) throws IOException {
        String string = null;
        while (!chunksInputStream.isChunckEndReached()) {
            switch (chunksInputStream.readChunkHeader().getID()) {
                case MATERIAL_MAPNAME: {
                    string = chunksInputStream.readString();
                    break;
                }
                default: {
                    chunksInputStream.readUntilChunkEnd();
                }
            }
            chunksInputStream.releaseChunk();
        }
        if (string == null) return null;
        Texture texture = this.readTexture(chunksInputStream, string);
        if (texture != null) {
            return texture;
        }
        URL uRL = chunksInputStream.getBaseURL();
        if (uRL == null) return null;
        if ("file".equals(uRL.getProtocol())) {
            try {
                String[] stringArray = new File(uRL.toURI()).getParentFile().list();
                if (stringArray == null) return null;
                for (String string2 : stringArray) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    return this.readTexture(chunksInputStream, string2);
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException("Can't access file");
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
        } else {
            String string3;
            int n;
            String string4;
            URL uRL2;
            String string5;
            if (!"jar".equals(uRL.getProtocol()) || (string5 = this.getEntryNameIgnoreCase(uRL2 = new URL((string4 = uRL.getFile()).substring(0, (n = string4.indexOf(33) + 2) - 2)), string3 = string4.substring(n, string4.lastIndexOf(47) + 1) + string)) == null) return null;
            return this.readTexture(chunksInputStream, string5.substring(string5.lastIndexOf(47) + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEntryNameIgnoreCase(URL uRL, String string) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            Object object;
            try (ZipFile zipFile = null;){
                zipFile = new ZipFile(new File(uRL.toURI()));
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement().getName();
                    if (!((String)object).equalsIgnoreCase(string)) continue;
                    Object object2 = object;
                    return object2;
                }
            }
        }
        try (ZipInputStream zipInputStream = null;){
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(uRL.openStream());
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                if (!string2.equalsIgnoreCase(string)) continue;
                String string3 = string2;
                return string3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Texture readTexture(ChunksInputStream chunksInputStream, String string) throws IOException {
        block12: {
            try (InputStream inputStream = null;){
                BufferedImage bufferedImage;
                URL uRL = chunksInputStream.getBaseURL();
                URL uRL2 = uRL != null ? new URL(uRL, string.replace("%", "%25").replace("#", "%23")) : new File(string).toURI().toURL();
                inputStream = Max3DSLoader.openStream(uRL2, this.useCaches);
                try {
                    bufferedImage = ImageIO.read(inputStream);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    inputStream.close();
                    inputStream = Max3DSLoader.openStream(uRL2, this.useCaches);
                    bufferedImage = ImageIO.read(inputStream);
                }
                if (bufferedImage != null) {
                    TextureLoader textureLoader = new TextureLoader(bufferedImage);
                    Texture texture = textureLoader.getTexture();
                    texture.setUserData((Object)uRL2);
                    Texture texture2 = texture;
                    return texture2;
                }
            }
        }
        return null;
    }

    private Transform3D parseMatrix(ChunksInputStream chunksInputStream) throws IOException {
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        fArray[0] = chunksInputStream.readLittleEndianFloat();
        fArray[4] = chunksInputStream.readLittleEndianFloat();
        fArray[8] = chunksInputStream.readLittleEndianFloat();
        fArray[1] = chunksInputStream.readLittleEndianFloat();
        fArray[5] = chunksInputStream.readLittleEndianFloat();
        fArray[9] = chunksInputStream.readLittleEndianFloat();
        fArray[2] = chunksInputStream.readLittleEndianFloat();
        fArray[6] = chunksInputStream.readLittleEndianFloat();
        fArray[10] = chunksInputStream.readLittleEndianFloat();
        fArray[3] = chunksInputStream.readLittleEndianFloat();
        fArray[7] = chunksInputStream.readLittleEndianFloat();
        fArray[11] = chunksInputStream.readLittleEndianFloat();
        return new Transform3D(fArray);
    }

    private Vector3f parseVector(ChunksInputStream chunksInputStream) throws IOException {
        return new Vector3f(chunksInputStream.readLittleEndianFloat(), chunksInputStream.readLittleEndianFloat(), chunksInputStream.readLittleEndianFloat());
    }

    static {
        DEFAULT_APPEARANCE.setMaterial(new Material(new Color3f(0.4f, 0.4f, 0.4f), new Color3f(), new Color3f(0.7102f, 0.702f, 0.6531f), new Color3f(0.3f, 0.3f, 0.3f), 128.0f));
    }

    private static class ChunksInputStream
    extends FilterInputStream {
        private Stack<Chunk3DS> stack = new Stack();
        private URL baseUrl;

        public ChunksInputStream(InputStream inputStream, URL uRL) {
            super(inputStream);
            this.baseUrl = uRL;
        }

        public URL getBaseURL() {
            return this.baseUrl;
        }

        public Chunk3DS readChunkHeader() throws IOException {
            short s;
            try {
                s = this.readLittleEndianShort(false);
            }
            catch (EOFException eOFException) {
                return null;
            }
            Chunk3DS chunk3DS = new Chunk3DS(s, this.readLittleEndianUnsignedInt(false));
            this.stack.push(chunk3DS);
            return chunk3DS;
        }

        public void releaseChunk() {
            Chunk3DS chunk3DS = this.stack.pop();
            if (chunk3DS.getLength() != chunk3DS.getReadLength()) {
                throw new IncorrectFormatException("Chunk " + (Object)((Object)chunk3DS.getID()) + " invalid length. Expected to read " + chunk3DS.getLength() + " bytes, but actually read " + chunk3DS.getReadLength() + " bytes");
            }
            if (!this.stack.isEmpty()) {
                this.stack.peek().incrementReadLength(chunk3DS.getLength());
            }
        }

        public boolean isChunckEndReached() {
            Chunk3DS chunk3DS = this.stack.peek();
            return chunk3DS.getLength() == chunk3DS.getReadLength();
        }

        public void readUntilChunkEnd() throws IOException {
            long l;
            Chunk3DS chunk3DS = this.stack.peek();
            for (long i = l = chunk3DS.getLength() - chunk3DS.getReadLength(); i > 0L; --i) {
                if (this.in.read() >= 0) continue;
                throw new IncorrectFormatException("Chunk " + (Object)((Object)chunk3DS.getID()) + " too short");
            }
            chunk3DS.incrementReadLength(l);
        }

        public short readUnsignedByte() throws IOException {
            int n = this.in.read();
            if (n == -1) {
                throw new EOFException();
            }
            this.stack.peek().incrementReadLength(1L);
            return (short)(n & 0xFF);
        }

        public int readLittleEndianUnsignedShort() throws IOException {
            return this.readLittleEndianShort(true) & 0xFFFF;
        }

        public short readLittleEndianShort() throws IOException {
            return this.readLittleEndianShort(true);
        }

        private short readLittleEndianShort(boolean bl) throws IOException {
            int n = this.in.read();
            if (n == -1) {
                throw new EOFException();
            }
            int n2 = this.in.read();
            if (n2 == -1) {
                throw new IncorrectFormatException("Can't read short");
            }
            if (bl) {
                this.stack.peek().incrementReadLength(2L);
            }
            return (short)(n2 << 8 | n);
        }

        public float readLittleEndianFloat() throws IOException {
            return Float.intBitsToFloat(this.readLittleEndianInt(true));
        }

        public long readLittleEndianUnsignedInt() throws IOException {
            return this.readLittleEndianUnsignedInt(true);
        }

        private long readLittleEndianUnsignedInt(boolean bl) throws IOException {
            return (long)this.readLittleEndianInt(bl) & 0xFFFFFFFFL;
        }

        public int readLittleEndianInt() throws IOException {
            return this.readLittleEndianInt(true);
        }

        private int readLittleEndianInt(boolean bl) throws IOException {
            int n = this.in.read();
            if (n == -1) {
                throw new EOFException();
            }
            int n2 = this.in.read();
            int n3 = this.in.read();
            int n4 = this.in.read();
            if (n2 == -1 || n3 == -1 || n4 == -1) {
                throw new IncorrectFormatException("Can't read int");
            }
            if (bl) {
                this.stack.peek().incrementReadLength(4L);
            }
            return n4 << 24 | n3 << 16 | n2 << 8 | n;
        }

        public String readString() throws IOException {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            while ((n = this.in.read()) != -1 && n != 0) {
                byteArrayOutputStream.write((byte)n);
            }
            if (n == -1) {
                throw new IncorrectFormatException("Unexpected end of file");
            }
            this.stack.peek().incrementReadLength(byteArrayOutputStream.size() + 1);
            return byteArrayOutputStream.toString("ISO-8859-1");
        }
    }

    private static class Chunk3DS {
        private final ChunkID id;
        private final long length;
        private long readLength;

        public Chunk3DS(short s, long l) throws IOException {
            if (l < 6L) {
                throw new IncorrectFormatException("Invalid chunk " + s + " length " + l);
            }
            this.id = ChunkID.valueOf(s);
            this.length = l;
            this.readLength = 6L;
        }

        public ChunkID getID() {
            return this.id;
        }

        public long getLength() {
            return this.length;
        }

        public void incrementReadLength(long l) {
            this.readLength += l;
        }

        public long getReadLength() {
            return this.readLength;
        }

        public String toString() {
            return (Object)((Object)this.id) + " " + this.length;
        }
    }

    private static enum ChunkID {
        NULL_CHUNK(0),
        M3DMAGIC(19789),
        SMAGIC(11565),
        LMAGIC(11581),
        MLIBMAGIC(15786),
        MATMAGIC(15871),
        CMAGIC(49725),
        M3D_VERSION(2),
        M3D_KFVERSION(5),
        COLOR_FLOAT(16),
        COLOR_24(17),
        LINEAR_COLOR_24(18),
        LINEAR_COLOR_FLOAT(19),
        PERCENTAGE_INT(48),
        PERCENTAGE_FLOAT(49),
        EDITOR_DATA(15677),
        MESH_VERSION(15678),
        MASTER_SCALE(256),
        LOW_SHADOW_BIAS(5120),
        HIGH_SHADOW_BIAS(5136),
        SHADOW_MAP_SIZE(5152),
        SHADOW_SAMPLES(5168),
        SHADOW_RANGE(5184),
        SHADOW_FILTER(5200),
        RAY_BIAS(5216),
        O_CONSTS(5376),
        AMBIENT_LIGHT(8448),
        BIT_MAP(4352),
        SOLID_BGND(4608),
        V_GRADIENT(4864),
        USE_BIT_MAP(4353),
        USE_SOLID_BGND(4609),
        USE_V_GRADIENT(4865),
        FOG(8704),
        FOG_BGND(8720),
        LAYER_FOG(8962),
        DISTANCE_CUE(8960),
        DCUE_BGND(8976),
        USE_FOG(8705),
        USE_LAYER_FOG(8963),
        USE_DISTANCE_CUE(8961),
        MATERIAL_ENTRY(45055),
        MATERIAL_NAME(40960),
        MATERIAL_AMBIENT(40976),
        MATERIAL_DIFFUSE(40992),
        MATERIAL_SPECULAR(41008),
        MATERIAL_SHININESS(41024),
        MATERIAL_SHIN2PCT(41025),
        MATERIAL_TRANSPARENCY(41040),
        MATERIAL_XPFALL(41042),
        MATERIAL_USE_XPFALL(41536),
        MATERIAL_REFBLUR(41043),
        MATERIAL_SHADING(41216),
        MATERIAL_USE_REFBLUR(41552),
        MATERIAL_SELF_ILLUM(41088),
        MATERIAL_TWO_SIDED(41089),
        MATERIAL_DECAL(41090),
        MATERIAL_ADDITIVE(41091),
        MATERIAL_SELF_ILPCT(41092),
        MATERIAL_WIRE(41093),
        MATERIAL_FACEMAP(41096),
        MATERIAL_PHONGSOFT(41100),
        MATERIAL_WIREABS(41102),
        MATERIAL_WIRE_SIZE(41095),
        MATERIAL_TEXMAP(41472),
        MATERIAL_SXP_TEXT_DATA(41760),
        MATERIAL_TEXMASK(41790),
        MATERIAL_SXP_TEXTMASK_DATA(41770),
        MATERIAL_TEX2MAP(41786),
        MATERIAL_SXP_TEXT2_DATA(41761),
        MATERIAL_TEX2MASK(41792),
        MATERIAL_SXP_TEXT2MASK_DATA(41772),
        MATERIAL_OPACMAP(41488),
        MATERIAL_SXP_OPAC_DATA(41762),
        MATERIAL_OPACMASK(41794),
        MATERIAL_SXP_OPACMASK_DATA(41774),
        MATERIAL_BUMPMAP(41520),
        MATERIAL_SXP_BUMP_DATA(41764),
        MATERIAL_BUMPMASK(41796),
        MATERIAL_SXP_BUMPMASK_DATA(41776),
        MATERIAL_SPECMAP(41476),
        MATERIAL_SXP_SPEC_DATA(41765),
        MATERIAL_SPECMASK(41800),
        MATERIAL_SXP_SPECMASK_DATA(41778),
        MATERIAL_SHINMAP(41788),
        MATERIAL_SXP_SHIN_DATA(41766),
        MATERIAL_SHINMASK(41798),
        MATERIAL_SXP_SHINMASK_DATA(41780),
        MATERIAL_SELFIMAP(41789),
        MATERIAL_SXP_SELFI_DATA(41768),
        MATERIAL_SELFIMASK(41802),
        MATERIAL_SXP_SELFIMASK_DATA(41782),
        MATERIAL_REFLMAP(41504),
        MATERIAL_REFLMASK(41804),
        MATERIAL_SXP_REFLMASK_DATA(41784),
        MATERIAL_ACUBIC(41744),
        MATERIAL_MAPNAME(41728),
        MATERIAL_MAP_TILING(41809),
        MATERIAL_MAP_TEXBLUR(41811),
        MATERIAL_MAP_USCALE(41812),
        MATERIAL_MAP_VSCALE(41814),
        MATERIAL_MAP_UOFFSET(41816),
        MATERIAL_MAP_VOFFSET(41818),
        MATERIAL_MAP_ANG(41820),
        MATERIAL_MAP_COL1(41824),
        MATERIAL_MAP_COL2(41826),
        MATERIAL_MAP_RCOL(41828),
        MATERIAL_MAP_GCOL(41830),
        MATERIAL_MAP_BCOL(41832),
        NAMED_OBJECT(16384),
        LIGHT_OBJECT(17920),
        DL_OFF(17952),
        DL_OUTER_RANGE(18010),
        DL_INNER_RANGE(18009),
        DL_MULTIPLIER(18011),
        DL_EXCLUDE(18004),
        DL_ATTENUATE(17957),
        DL_SPOTLIGHT(17936),
        DL_SPOT_ROLL(18006),
        DL_SHADOWED(17968),
        DL_LOCAL_SHADOW2(17985),
        DL_SEE_CONE(18000),
        DL_SPOT_RECTANGULAR(18001),
        DL_SPOT_ASPECT(18007),
        DL_SPOT_PROJECTOR(18003),
        DL_SPOT_OVERSHOOT(18002),
        DL_RAY_BIAS(18008),
        DL_RAYSHAD(17959),
        CAMERA_OBJECT(18176),
        CAM_SEE_CONE(18192),
        CAM_RANGES(18208),
        OBJECT_HIDDEN(16400),
        OBJECT_VIS_LOFTER(16401),
        OBJECT_DOESNT_CAST(16402),
        OBJECT_DOESNT_RCVSHADOW(16407),
        OBJECT_MATTE(16403),
        OBJECT_FAST(16404),
        OBJ_PROCEDURAL(16405),
        OBJECT_FROZEN(16406),
        TRIANGLE_MESH_OBJECT(16640),
        POINT_ARRAY(16656),
        POINT_FLAG_ARRAY(16657),
        FACE_ARRAY(16672),
        MESH_MATERIAL_GROUP(16688),
        SMOOTHING_GROUP(16720),
        MESH_BOXMAP(16784),
        TEXTURE_COORDINATES(16704),
        MESH_MATRIX(16736),
        MESH_COLOR(16741),
        MESH_TEXTURE_INFO(16752),
        KEY_FRAMER_DATA(45056),
        KFHDR(45066),
        KFSEG(45064),
        KFCURTIME(45065),
        AMBIENT_NODE_TAG(45057),
        OBJECT_NODE_TAG(45058),
        CAMERA_NODE_TAG(45059),
        TARGET_NODE_TAG(45060),
        LIGHT_NODE_TAG(45061),
        L_TARGET_NODE_TAG(45062),
        SPOTLIGHT_NODE_TAG(45063),
        NODE_ID(45104),
        NODE_HIERARCHY(45072),
        PIVOT(45075),
        INSTANCE_NAME(45073),
        MORPH_SMOOTH(45077),
        BOUNDING_BOX(45076),
        POSITION_TRACK_TAG(45088),
        COL_TRACK_TAG(45093),
        ROTATION_TRACK_TAG(45089),
        SCALE_TRACK_TAG(45090),
        MORPH_TRACK_TAG(45094),
        FOV_TRACK_TAG(45091),
        ROLL_TRACK_TAG(45092),
        HOT_TRACK_TAG(45095),
        FALL_TRACK_TAG(45096),
        HIDE_TRACK_TAG(45097),
        POLY_2D(20480),
        SHAPE_OK(20496),
        SHAPE_NOT_OK(20497),
        SHAPE_HOOK(20512),
        PATH_3D(24576),
        PATH_MATRIX(24581),
        SHAPE_2D(24592),
        M_SCALE(24608),
        M_TWIST(24624),
        M_TEETER(24640),
        M_FIT(24656),
        M_BEVEL(24672),
        XZ_CURVE(24688),
        YZ_CURVE(24704),
        INTERPCT(24720),
        DEFORM_LIMIT(24736),
        USE_CONTOUR(24832),
        USE_TWEEN(24848),
        USE_SCALE(24864),
        USE_TWIST(24880),
        USE_TEETER(24896),
        USE_FIT(24912),
        USE_BEVEL(24928),
        DEFAULT_VIEW(12288),
        VIEW_TOP(12304),
        VIEW_BOTTOM(12320),
        VIEW_LEFT(12336),
        VIEW_RIGHT(12352),
        VIEW_FRONT(12368),
        VIEW_BACK(12384),
        VIEW_USER(12400),
        VIEW_CAMERA(12416),
        VIEW_WINDOW(12432),
        VIEWPORT_LAYOUT_OLD(28672),
        VIEWPORT_DATA_OLD(28688),
        VIEWPORT_LAYOUT(28673),
        VIEWPORT_DATA(28689),
        VIEWPORT_DATA_3(28690),
        VIEWPORT_SIZE(28704),
        NETWORK_VIEW(28720);

        private short id;

        private ChunkID(int n2) {
            this.id = (short)n2;
        }

        public static ChunkID valueOf(short s) {
            for (ChunkID chunkID : ChunkID.values()) {
                if (s != chunkID.id) continue;
                return chunkID;
            }
            return NULL_CHUNK;
        }
    }

    private static class Material3DS {
        private String name;
        private Color3f ambientColor;
        private Color3f diffuseColor;
        private Color3f specularColor;
        private Float shininess;
        private Float transparency;
        private Texture texture;
        private boolean twoSided;

        public Material3DS(String string, Color3f color3f, Color3f color3f2, Color3f color3f3, Float f, Float f2, Texture texture, boolean bl) {
            this.name = string;
            this.ambientColor = color3f;
            this.diffuseColor = color3f2;
            this.specularColor = color3f3;
            this.shininess = f;
            this.transparency = f2;
            this.texture = texture;
            this.twoSided = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean isTwoSided() {
            return this.twoSided;
        }

        public Color3f getAmbientColor() {
            return this.ambientColor;
        }

        public Color3f getDiffuseColor() {
            return this.diffuseColor;
        }

        public Color3f getSpecularColor() {
            return this.specularColor;
        }

        public Float getShininess() {
            return this.shininess;
        }

        public Float getTransparency() {
            return this.transparency;
        }

        public Texture getTexture() {
            return this.texture;
        }
    }

    private static class Mesh3DS {
        private String name;
        private Point3f[] vertices;
        private TexCoord2f[] textureCoordinates;
        private Face3DS[] faces = null;
        private Short color;
        private Transform3D transform;

        public Mesh3DS(String string, Point3f[] point3fArray, TexCoord2f[] texCoord2fArray, Face3DS[] face3DSArray, Short s, Transform3D transform3D) {
            this.name = string;
            this.vertices = point3fArray;
            this.textureCoordinates = texCoord2fArray;
            this.faces = face3DSArray;
            this.color = s;
            this.transform = transform3D;
        }

        public String getName() {
            return this.name;
        }

        public Point3f[] getVertices() {
            return this.vertices;
        }

        public TexCoord2f[] getTextureCoordinates() {
            return this.textureCoordinates;
        }

        public Face3DS[] getFaces() {
            return this.faces;
        }

        public Transform3D getTransform() {
            return this.transform;
        }
    }

    private static class Face3DS {
        private int index;
        private int[] vertexIndices;
        private int[] normalIndices;
        private Material3DS material;
        private Long smoothingGroup;

        public Face3DS(int n, int n2, int n3, int n4, int n5) {
            this.index = n;
            this.vertexIndices = new int[]{n2, n3, n4};
        }

        public int getIndex() {
            return this.index;
        }

        public int[] getVertexIndices() {
            return this.vertexIndices;
        }

        public void setNormalIndices(int[] nArray) {
            this.normalIndices = nArray;
        }

        public int[] getNormalIndices() {
            return this.normalIndices;
        }

        public void setMaterial(Material3DS material3DS) {
            this.material = material3DS;
        }

        public Material3DS getMaterial() {
            return this.material;
        }

        public void setSmoothingGroup(Long l) {
            this.smoothingGroup = l;
        }

        public Long getSmoothingGroup() {
            return this.smoothingGroup;
        }
    }

    private static class Mesh3DSSharedVertex {
        private int faceIndex;
        private Vector3f normal;
        private Mesh3DSSharedVertex nextVertex;

        public Mesh3DSSharedVertex(int n, Vector3f vector3f) {
            this.faceIndex = n;
            this.normal = vector3f;
        }

        public int getFaceIndex() {
            return this.faceIndex;
        }

        public Vector3f getNormal() {
            return this.normal;
        }

        public void setNextVertex(Mesh3DSSharedVertex mesh3DSSharedVertex) {
            this.nextVertex = mesh3DSSharedVertex;
        }

        public Mesh3DSSharedVertex getNextVertex() {
            return this.nextVertex;
        }
    }
}

