//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.3
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Glacier2_Router_h__
#define __Glacier2_Router_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Ice/Router.h>
#include <Glacier2/Session.h>
#include <Glacier2/PermissionsVerifier.h>
#include <IceUtil/UndefSysMacros.h>
#include <Glacier2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 3
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef GLACIER2_API
#   if defined(ICE_STATIC_LIBS)
#       define GLACIER2_API /**/
#   elif defined(GLACIER2_API_EXPORTS)
#       define GLACIER2_API ICE_DECLSPEC_EXPORT
#   else
#       define GLACIER2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Glacier2
{

class Router;
class RouterPrx;

}

namespace Glacier2
{

/**
 * This exception is raised if a client tries to destroy a session
 * with a router, but no session exists for the client.
 * @see Router#destroySession
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) SessionNotExistException : public ::Ice::UserExceptionHelper<SessionNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(GLACIER2_API) virtual ~SessionNotExistException();

    SessionNotExistException(const SessionNotExistException&) = default;

    SessionNotExistException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();
};

/// \cond INTERNAL
static SessionNotExistException _iceS_SessionNotExistException_init;
/// \endcond

}

namespace Glacier2
{

/**
 * The Glacier2 specialization of the <code>Ice::Router</code> interface.
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API Router : public virtual ::Ice::Router
{
public:

    using ProxyType = RouterPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param current The Current object for the invocation.
     * @return The category.
     */
    virtual ::std::string getCategoryForClient(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getCategoryForClient(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws Glacier2::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    virtual void createSessionAsync(::std::string userId, ::std::string password, ::std::function<void(const ::std::shared_ptr<SessionPrx>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_createSession(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws Glacier2::PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    virtual void createSessionFromSecureConnectionAsync(::std::function<void(const ::std::shared_ptr<SessionPrx>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_createSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Keep the calling client's session with this router alive.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws Glacier2::SessionNotExistException Raised if no session exists
     * for the calling client.
     */
    virtual void refreshSessionAsync(::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_refreshSession(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the calling client's session with this router.
     * @param current The Current object for the invocation.
     * @throws Glacier2::SessionNotExistException Raised if no session exists
     * for the calling client.
     */
    virtual void destroySession(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_destroySession(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     */
    virtual long long int getSessionTimeout(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     */
    virtual int getACMTimeout(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getACMTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace Glacier2
{

/**
 * The Glacier2 specialization of the <code>Ice::Router</code> interface.
 * \headerfile Glacier2/Glacier2.h
 */
class ICE_CLASS(GLACIER2_API) RouterPrx : public virtual ::Ice::Proxy<RouterPrx, ::Ice::RouterPrx>
{
public:

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param context The Context map to send with the invocation.
     * @return The category.
     */
    ::std::string getCategoryForClient(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &RouterPrx::_iceI_getCategoryForClient, context).get();
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getCategoryForClientAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &RouterPrx::_iceI_getCategoryForClient, context);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getCategoryForClientAsync(::std::function<void(::std::string)> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_getCategoryForClient, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_getCategoryForClient(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws Glacier2::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::std::shared_ptr<SessionPrx> createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(true, this, &RouterPrx::_iceI_createSession, userId, password, context).get();
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    template<template<typename> class P = ::std::promise>
    auto createSessionAsync(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>, P>(false, this, &RouterPrx::_iceI_createSession, userId, password, context);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::std::function<void()>
    createSessionAsync(const ::std::string& userId, const ::std::string& password,
                       ::std::function<void(::std::shared_ptr<::Glacier2::SessionPrx>)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_createSession, userId, password, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_createSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws Glacier2::PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::std::shared_ptr<SessionPrx> createSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(true, this, &RouterPrx::_iceI_createSessionFromSecureConnection, context).get();
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    template<template<typename> class P = ::std::promise>
    auto createSessionFromSecureConnectionAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>, P>(false, this, &RouterPrx::_iceI_createSessionFromSecureConnection, context);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::std::function<void()>
    createSessionFromSecureConnectionAsync(::std::function<void(::std::shared_ptr<::Glacier2::SessionPrx>)> response,
                                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                           ::std::function<void(bool)> sent = nullptr,
                                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_createSessionFromSecureConnection, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_createSessionFromSecureConnection(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Keep the calling client's session with this router alive.
     * @param context The Context map to send with the invocation.
     * @throws Glacier2::SessionNotExistException Raised if no session exists
     * for the calling client.
     */
    void refreshSession(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &RouterPrx::_iceI_refreshSession, context).get();
    }

    /**
     * Keep the calling client's session with this router alive.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto refreshSessionAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &RouterPrx::_iceI_refreshSession, context);
    }

    /**
     * Keep the calling client's session with this router alive.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    refreshSessionAsync(::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_refreshSession, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_refreshSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Destroy the calling client's session with this router.
     * @param context The Context map to send with the invocation.
     * @throws Glacier2::SessionNotExistException Raised if no session exists
     * for the calling client.
     */
    void destroySession(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &RouterPrx::_iceI_destroySession, context).get();
    }

    /**
     * Destroy the calling client's session with this router.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto destroySessionAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &RouterPrx::_iceI_destroySession, context);
    }

    /**
     * Destroy the calling client's session with this router.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    destroySessionAsync(::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_destroySession, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_destroySession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     */
    long long int getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<long long int>(true, this, &RouterPrx::_iceI_getSessionTimeout, context).get();
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getSessionTimeoutAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<long long int>>().get_future())
    {
        return _makePromiseOutgoing<long long int, P>(false, this, &RouterPrx::_iceI_getSessionTimeout, context);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getSessionTimeoutAsync(::std::function<void(long long int)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<long long int>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_getSessionTimeout, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_getSessionTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<long long int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     */
    int getACMTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &RouterPrx::_iceI_getACMTimeout, context).get();
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getACMTimeoutAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &RouterPrx::_iceI_getACMTimeout, context);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getACMTimeoutAsync(::std::function<void(int)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_getACMTimeout, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(GLACIER2_API) void _iceI_getACMTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    RouterPrx() = default;
    friend ::std::shared_ptr<RouterPrx> IceInternal::createProxy<RouterPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace Glacier2
{

using RouterPtr = ::std::shared_ptr<Router>;
using RouterPrxPtr = ::std::shared_ptr<RouterPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace Glacier2
{

class Router;
/// \cond INTERNAL
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Router>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(Router*);
/// \endcond

}

}

namespace Glacier2
{

class Router;
/// \cond INTERNAL
GLACIER2_API ::Ice::Object* upCast(Router*);
/// \endcond
typedef ::IceInternal::Handle< Router> RouterPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::Router> RouterPrx;
typedef RouterPrx RouterPrxPtr;
/// \cond INTERNAL
GLACIER2_API void _icePatchObjectPtr(RouterPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace Glacier2
{

/**
 * This exception is raised if a client tries to destroy a session
 * with a router, but no session exists for the client.
 * @see Router#destroySession
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API SessionNotExistException : public ::Ice::UserException
{
public:

    SessionNotExistException() {}
    virtual ~SessionNotExistException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual SessionNotExistException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static SessionNotExistException _iceS_SessionNotExistException_init;
/// \endcond

}

namespace Glacier2
{

/**
 * AMD callback class for Glacier2::Router::createSession_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class GLACIER2_API AMD_Router_createSession : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Router_createSession();

    /**
     * Call ice_response for a successful completion.
     * @param result A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     */
    virtual void ice_response(const SessionPrx& result) = 0;
};

typedef ::IceUtil::Handle< ::Glacier2::AMD_Router_createSession> AMD_Router_createSessionPtr;

/**
 * AMD callback class for Glacier2::Router::createSessionFromSecureConnection_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class GLACIER2_API AMD_Router_createSessionFromSecureConnection : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Router_createSessionFromSecureConnection();

    /**
     * Call ice_response for a successful completion.
     * @param result A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     */
    virtual void ice_response(const SessionPrx& result) = 0;
};

typedef ::IceUtil::Handle< ::Glacier2::AMD_Router_createSessionFromSecureConnection> AMD_Router_createSessionFromSecureConnectionPtr;

/**
 * AMD callback class for Glacier2::Router::refreshSession_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class GLACIER2_API AMD_Router_refreshSession : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Router_refreshSession();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::Glacier2::AMD_Router_refreshSession> AMD_Router_refreshSessionPtr;

}

/// \cond INTERNAL
namespace IceAsync
{

namespace Glacier2
{

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class GLACIER2_API AMD_Router_createSession : public ::Glacier2::AMD_Router_createSession, public ::IceInternal::IncomingAsync
{
public:

    AMD_Router_createSession(::IceInternal::Incoming&);

    virtual void ice_response(const ::Glacier2::SessionPrx&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class GLACIER2_API AMD_Router_createSessionFromSecureConnection : public ::Glacier2::AMD_Router_createSessionFromSecureConnection, public ::IceInternal::IncomingAsync
{
public:

    AMD_Router_createSessionFromSecureConnection(::IceInternal::Incoming&);

    virtual void ice_response(const ::Glacier2::SessionPrx&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class GLACIER2_API AMD_Router_refreshSession : public ::Glacier2::AMD_Router_refreshSession, public ::IceInternal::IncomingAsync
{
public:

    AMD_Router_refreshSession(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

}

}
/// \endcond

namespace Glacier2
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::Router::begin_getCategoryForClient.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_getCategoryForClient.
 */
class Callback_Router_getCategoryForClient_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_getCategoryForClient_Base> Callback_Router_getCategoryForClientPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::Router::begin_createSession.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_createSession.
 */
class Callback_Router_createSession_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_createSession_Base> Callback_Router_createSessionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::Router::begin_createSessionFromSecureConnection.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_createSessionFromSecureConnection.
 */
class Callback_Router_createSessionFromSecureConnection_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_createSessionFromSecureConnection_Base> Callback_Router_createSessionFromSecureConnectionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::Router::begin_refreshSession.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_refreshSession.
 */
class Callback_Router_refreshSession_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_refreshSession_Base> Callback_Router_refreshSessionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::Router::begin_destroySession.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_destroySession.
 */
class Callback_Router_destroySession_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_destroySession_Base> Callback_Router_destroySessionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::Router::begin_getSessionTimeout.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_getSessionTimeout.
 */
class Callback_Router_getSessionTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_getSessionTimeout_Base> Callback_Router_getSessionTimeoutPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Glacier2::Router::begin_getACMTimeout.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_getACMTimeout.
 */
class Callback_Router_getACMTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_getACMTimeout_Base> Callback_Router_getACMTimeoutPtr;

}

namespace IceProxy
{

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) Router : public virtual ::Ice::Proxy<Router, ::IceProxy::Ice::Router>
{
public:

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param context The Context map to send with the invocation.
     * @return The category.
     */
    ICE_MEMBER(GLACIER2_API) ::std::string getCategoryForClient(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getCategoryForClient(_iceI_begin_getCategoryForClient(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getCategoryForClient(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getCategoryForClient(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getCategoryForClient(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCategoryForClient(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getCategoryForClient(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCategoryForClient(context, cb, cookie);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getCategoryForClient(const ::Glacier2::Callback_Router_getCategoryForClientPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCategoryForClient(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getCategoryForClient(const ::Ice::Context& context, const ::Glacier2::Callback_Router_getCategoryForClientPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCategoryForClient(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getCategoryForClient.
     * @param result The asynchronous result object for the invocation.
     * @return The category.
     */
    ICE_MEMBER(GLACIER2_API) ::std::string end_getCategoryForClient(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_getCategoryForClient(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws Glacier2::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createSession(_iceI_begin_createSession(userId, password, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createSession(userId, password, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(userId, password, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(userId, password, context, cb, cookie);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& userId, const ::std::string& password, const ::Glacier2::Callback_Router_createSessionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(userId, password, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& userId, const ::std::string& password, const ::Ice::Context& context, const ::Glacier2::Callback_Router_createSessionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(userId, password, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_createSession.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws Glacier2::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx end_createSession(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_createSession(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param context The Context map to send with the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws Glacier2::PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx createSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createSessionFromSecureConnection(_iceI_begin_createSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, cb, cookie);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Glacier2::Callback_Router_createSessionFromSecureConnectionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context, const ::Glacier2::Callback_Router_createSessionFromSecureConnectionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_createSessionFromSecureConnection.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws Glacier2::PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     */
    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx end_createSessionFromSecureConnection(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_createSessionFromSecureConnection(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Keep the calling client's session with this router alive.
     * @param context The Context map to send with the invocation.
     * @throws Glacier2::SessionNotExistException Raised if no session exists
     * for the calling client.
     */
    ICE_MEMBER(GLACIER2_API) void refreshSession(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_refreshSession(_iceI_begin_refreshSession(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Keep the calling client's session with this router alive.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_refreshSession(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_refreshSession(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Keep the calling client's session with this router alive.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_refreshSession(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_refreshSession(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Keep the calling client's session with this router alive.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_refreshSession(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_refreshSession(context, cb, cookie);
    }

    /**
     * Keep the calling client's session with this router alive.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_refreshSession(const ::Glacier2::Callback_Router_refreshSessionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_refreshSession(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Keep the calling client's session with this router alive.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_refreshSession(const ::Ice::Context& context, const ::Glacier2::Callback_Router_refreshSessionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_refreshSession(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_refreshSession.
     * @param result The asynchronous result object for the invocation.
     * @throws Glacier2::SessionNotExistException Raised if no session exists
     * for the calling client.
     */
    ICE_MEMBER(GLACIER2_API) void end_refreshSession(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_refreshSession(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Destroy the calling client's session with this router.
     * @param context The Context map to send with the invocation.
     * @throws Glacier2::SessionNotExistException Raised if no session exists
     * for the calling client.
     */
    ICE_MEMBER(GLACIER2_API) void destroySession(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroySession(_iceI_begin_destroySession(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the calling client's session with this router.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroySession(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroySession(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the calling client's session with this router.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroySession(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroySession(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the calling client's session with this router.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroySession(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroySession(context, cb, cookie);
    }

    /**
     * Destroy the calling client's session with this router.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroySession(const ::Glacier2::Callback_Router_destroySessionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroySession(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the calling client's session with this router.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroySession(const ::Ice::Context& context, const ::Glacier2::Callback_Router_destroySessionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroySession(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_destroySession.
     * @param result The asynchronous result object for the invocation.
     * @throws Glacier2::SessionNotExistException Raised if no session exists
     * for the calling client.
     */
    ICE_MEMBER(GLACIER2_API) void end_destroySession(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_destroySession(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     */
    ICE_MEMBER(GLACIER2_API) ::Ice::Long getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSessionTimeout(_iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, cb, cookie);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Glacier2::Callback_Router_getSessionTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::Glacier2::Callback_Router_getSessionTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getSessionTimeout.
     * @param result The asynchronous result object for the invocation.
     * @return The timeout (in seconds).
     */
    ICE_MEMBER(GLACIER2_API) ::Ice::Long end_getSessionTimeout(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_getSessionTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The timeout (in seconds).
     */
    ICE_MEMBER(GLACIER2_API) ::Ice::Int getACMTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getACMTimeout(_iceI_begin_getACMTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getACMTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(context, cb, cookie);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Glacier2::Callback_Router_getACMTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context, const ::Glacier2::Callback_Router_getACMTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getACMTimeout.
     * @param result The asynchronous result object for the invocation.
     * @return The timeout (in seconds).
     */
    ICE_MEMBER(GLACIER2_API) ::Ice::Int end_getACMTimeout(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_getACMTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace Glacier2
{

/**
 * The Glacier2 specialization of the <code>Ice::Router</code> interface.
 * \headerfile Glacier2/Glacier2.h
 */
class GLACIER2_API Router : virtual public ::Ice::Router
{
public:

    typedef RouterPrx ProxyType;
    typedef RouterPtr PointerType;

    virtual ~Router();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     * @param current The Current object for the invocation.
     * @return The category.
     */
    virtual ::std::string getCategoryForClient(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getCategoryForClient(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param cb The AMD callback object for the invocation.
     * @param userId The user id for which to check the password.
     * @param password The password for the given user id.
     * @param current The Current object for the invocation.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws Glacier2::PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    virtual void createSession_async(const ::Glacier2::AMD_Router_createSessionPtr& cb, const ::std::string& userId, const ::std::string& password, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_createSession(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     * @throws Glacier2::CannotCreateSessionException Raised if the session
     * cannot be created.
     * @throws Glacier2::PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     */
    virtual void createSessionFromSecureConnection_async(const ::Glacier2::AMD_Router_createSessionFromSecureConnectionPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_createSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Keep the calling client's session with this router alive.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     * @throws Glacier2::SessionNotExistException Raised if no session exists
     * for the calling client.
     */
    virtual void refreshSession_async(const ::Glacier2::AMD_Router_refreshSessionPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_refreshSession(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the calling client's session with this router.
     * @param current The Current object for the invocation.
     * @throws Glacier2::SessionNotExistException Raised if no session exists
     * for the calling client.
     */
    virtual void destroySession(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_destroySession(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     */
    virtual ::Ice::Long getSessionTimeout(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     */
    virtual ::Ice::Int getACMTimeout(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getACMTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Router& lhs, const Router& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Router& lhs, const Router& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::Glacier2::SessionNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}
/// \endcond

namespace Glacier2
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::Router::begin_getCategoryForClient.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_getCategoryForClient.
 */
template<class T>
class CallbackNC_Router_getCategoryForClient : public Callback_Router_getCategoryForClient_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_Router_getCategoryForClient(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getCategoryForClient(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getCategoryForClient.
 */
template<class T> Callback_Router_getCategoryForClientPtr
newCallback_Router_getCategoryForClient(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getCategoryForClient<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getCategoryForClient.
 */
template<class T> Callback_Router_getCategoryForClientPtr
newCallback_Router_getCategoryForClient(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getCategoryForClient<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::Router::begin_getCategoryForClient.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_getCategoryForClient.
 */
template<class T, typename CT>
class Callback_Router_getCategoryForClient : public Callback_Router_getCategoryForClient_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_Router_getCategoryForClient(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getCategoryForClient(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getCategoryForClient.
 */
template<class T, typename CT> Callback_Router_getCategoryForClientPtr
newCallback_Router_getCategoryForClient(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getCategoryForClient<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getCategoryForClient.
 */
template<class T, typename CT> Callback_Router_getCategoryForClientPtr
newCallback_Router_getCategoryForClient(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getCategoryForClient<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::Router::begin_createSession.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_createSession.
 */
template<class T>
class CallbackNC_Router_createSession : public Callback_Router_createSession_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const SessionPrx&);

    CallbackNC_Router_createSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_createSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_createSession.
 */
template<class T> Callback_Router_createSessionPtr
newCallback_Router_createSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_createSession<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_createSession.
 */
template<class T> Callback_Router_createSessionPtr
newCallback_Router_createSession(T* instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_createSession<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::Router::begin_createSession.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_createSession.
 */
template<class T, typename CT>
class Callback_Router_createSession : public Callback_Router_createSession_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const SessionPrx&, const CT&);

    Callback_Router_createSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_createSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_createSession.
 */
template<class T, typename CT> Callback_Router_createSessionPtr
newCallback_Router_createSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_createSession<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_createSession.
 */
template<class T, typename CT> Callback_Router_createSessionPtr
newCallback_Router_createSession(T* instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_createSession<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::Router::begin_createSessionFromSecureConnection.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_createSessionFromSecureConnection.
 */
template<class T>
class CallbackNC_Router_createSessionFromSecureConnection : public Callback_Router_createSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const SessionPrx&);

    CallbackNC_Router_createSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_createSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_createSessionFromSecureConnection.
 */
template<class T> Callback_Router_createSessionFromSecureConnectionPtr
newCallback_Router_createSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_createSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_createSessionFromSecureConnection.
 */
template<class T> Callback_Router_createSessionFromSecureConnectionPtr
newCallback_Router_createSessionFromSecureConnection(T* instance, void (T::*cb)(const SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_createSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::Router::begin_createSessionFromSecureConnection.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_createSessionFromSecureConnection.
 */
template<class T, typename CT>
class Callback_Router_createSessionFromSecureConnection : public Callback_Router_createSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const SessionPrx&, const CT&);

    Callback_Router_createSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        SessionPrx ret;
        try
        {
            ret = proxy->end_createSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_createSessionFromSecureConnection.
 */
template<class T, typename CT> Callback_Router_createSessionFromSecureConnectionPtr
newCallback_Router_createSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_createSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_createSessionFromSecureConnection.
 */
template<class T, typename CT> Callback_Router_createSessionFromSecureConnectionPtr
newCallback_Router_createSessionFromSecureConnection(T* instance, void (T::*cb)(const SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_createSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::Router::begin_refreshSession.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_refreshSession.
 */
template<class T>
class CallbackNC_Router_refreshSession : public Callback_Router_refreshSession_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Router_refreshSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_refreshSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_refreshSession.
 */
template<class T> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_refreshSession<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_refreshSession.
 */
template<class T> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_refreshSession<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_refreshSession.
 */
template<class T> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_refreshSession<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_refreshSession.
 */
template<class T> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_refreshSession<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::Router::begin_refreshSession.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_refreshSession.
 */
template<class T, typename CT>
class Callback_Router_refreshSession : public Callback_Router_refreshSession_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Router_refreshSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_refreshSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_refreshSession.
 */
template<class T, typename CT> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_refreshSession<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_refreshSession.
 */
template<class T, typename CT> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_refreshSession<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_refreshSession.
 */
template<class T, typename CT> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_refreshSession<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_refreshSession.
 */
template<class T, typename CT> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_refreshSession<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::Router::begin_destroySession.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_destroySession.
 */
template<class T>
class CallbackNC_Router_destroySession : public Callback_Router_destroySession_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Router_destroySession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_destroySession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_destroySession.
 */
template<class T> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_destroySession<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_destroySession.
 */
template<class T> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_destroySession<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_destroySession.
 */
template<class T> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_destroySession<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_destroySession.
 */
template<class T> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_destroySession<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::Router::begin_destroySession.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_destroySession.
 */
template<class T, typename CT>
class Callback_Router_destroySession : public Callback_Router_destroySession_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Router_destroySession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_destroySession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_destroySession.
 */
template<class T, typename CT> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_destroySession<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_destroySession.
 */
template<class T, typename CT> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_destroySession<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_destroySession.
 */
template<class T, typename CT> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_destroySession<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_destroySession.
 */
template<class T, typename CT> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_destroySession<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::Router::begin_getSessionTimeout.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_getSessionTimeout.
 */
template<class T>
class CallbackNC_Router_getSessionTimeout : public Callback_Router_getSessionTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Long);

    CallbackNC_Router_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        ::Ice::Long ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getSessionTimeout.
 */
template<class T> Callback_Router_getSessionTimeoutPtr
newCallback_Router_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getSessionTimeout.
 */
template<class T> Callback_Router_getSessionTimeoutPtr
newCallback_Router_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::Router::begin_getSessionTimeout.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_getSessionTimeout.
 */
template<class T, typename CT>
class Callback_Router_getSessionTimeout : public Callback_Router_getSessionTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Long, const CT&);

    Callback_Router_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        ::Ice::Long ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getSessionTimeout.
 */
template<class T, typename CT> Callback_Router_getSessionTimeoutPtr
newCallback_Router_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getSessionTimeout.
 */
template<class T, typename CT> Callback_Router_getSessionTimeoutPtr
newCallback_Router_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Glacier2::Router::begin_getACMTimeout.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_getACMTimeout.
 */
template<class T>
class CallbackNC_Router_getACMTimeout : public Callback_Router_getACMTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Router_getACMTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getACMTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getACMTimeout.
 */
template<class T> Callback_Router_getACMTimeoutPtr
newCallback_Router_getACMTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getACMTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getACMTimeout.
 */
template<class T> Callback_Router_getACMTimeoutPtr
newCallback_Router_getACMTimeout(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getACMTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Glacier2::Router::begin_getACMTimeout.
 * Create a wrapper instance by calling ::Glacier2::newCallback_Router_getACMTimeout.
 */
template<class T, typename CT>
class Callback_Router_getACMTimeout : public Callback_Router_getACMTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Router_getACMTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getACMTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getACMTimeout.
 */
template<class T, typename CT> Callback_Router_getACMTimeoutPtr
newCallback_Router_getACMTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getACMTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Glacier2::Router::begin_getACMTimeout.
 */
template<class T, typename CT> Callback_Router_getACMTimeoutPtr
newCallback_Router_getACMTimeout(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getACMTimeout<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
