﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/rekognition/Rekognition_EXPORTS.h>
#include <aws/rekognition/model/TextDetection.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Rekognition
{
namespace Model
{

  /**
   * <p>Information about text detected in a video. Incudes the detected text, the
   * time in milliseconds from the start of the video that the text was detected, and
   * where it was detected on the screen.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/rekognition-2016-06-27/TextDetectionResult">AWS
   * API Reference</a></p>
   */
  class AWS_REKOGNITION_API TextDetectionResult
  {
  public:
    TextDetectionResult();
    TextDetectionResult(Aws::Utils::Json::JsonView jsonValue);
    TextDetectionResult& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The time, in milliseconds from the start of the video, that the text was
     * detected.</p>
     */
    inline long long GetTimestamp() const{ return m_timestamp; }

    /**
     * <p>The time, in milliseconds from the start of the video, that the text was
     * detected.</p>
     */
    inline bool TimestampHasBeenSet() const { return m_timestampHasBeenSet; }

    /**
     * <p>The time, in milliseconds from the start of the video, that the text was
     * detected.</p>
     */
    inline void SetTimestamp(long long value) { m_timestampHasBeenSet = true; m_timestamp = value; }

    /**
     * <p>The time, in milliseconds from the start of the video, that the text was
     * detected.</p>
     */
    inline TextDetectionResult& WithTimestamp(long long value) { SetTimestamp(value); return *this;}


    /**
     * <p>Details about text detected in a video.</p>
     */
    inline const TextDetection& GetTextDetection() const{ return m_textDetection; }

    /**
     * <p>Details about text detected in a video.</p>
     */
    inline bool TextDetectionHasBeenSet() const { return m_textDetectionHasBeenSet; }

    /**
     * <p>Details about text detected in a video.</p>
     */
    inline void SetTextDetection(const TextDetection& value) { m_textDetectionHasBeenSet = true; m_textDetection = value; }

    /**
     * <p>Details about text detected in a video.</p>
     */
    inline void SetTextDetection(TextDetection&& value) { m_textDetectionHasBeenSet = true; m_textDetection = std::move(value); }

    /**
     * <p>Details about text detected in a video.</p>
     */
    inline TextDetectionResult& WithTextDetection(const TextDetection& value) { SetTextDetection(value); return *this;}

    /**
     * <p>Details about text detected in a video.</p>
     */
    inline TextDetectionResult& WithTextDetection(TextDetection&& value) { SetTextDetection(std::move(value)); return *this;}

  private:

    long long m_timestamp;
    bool m_timestampHasBeenSet;

    TextDetection m_textDetection;
    bool m_textDetectionHasBeenSet;
  };

} // namespace Model
} // namespace Rekognition
} // namespace Aws
