/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.dataproperty;

import java.awt.Component;
import java.util.Optional;
import javax.swing.Icon;
import org.protege.editor.core.ui.menu.PopupMenuId;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.selection.SelectionDriver;
import org.protege.editor.owl.ui.renderer.AddChildIcon;
import org.protege.editor.owl.ui.renderer.AddSiblingIcon;
import org.protege.editor.owl.ui.renderer.DeleteEntityIcon;
import org.protege.editor.owl.ui.renderer.OWLDataPropertyIcon;
import org.protege.editor.owl.ui.renderer.OWLEntityIcon;
import org.protege.editor.owl.ui.view.AbstractOWLPropertyHierarchyViewComponent;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;

public class OWLDataPropertyHierarchyViewComponent
extends AbstractOWLPropertyHierarchyViewComponent<OWLDataProperty>
implements SelectionDriver {
    @Override
    protected boolean isOWLDataPropertyView() {
        return true;
    }

    @Override
    protected void performExtraInitialisation() throws Exception {
        super.performExtraInitialisation();
        this.getAssertedTree().setPopupMenuId(new PopupMenuId("[AssertedDataPropertyHierarchy]"));
    }

    @Override
    protected OWLObjectHierarchyProvider<OWLDataProperty> getHierarchyProvider() {
        return this.getOWLModelManager().getOWLHierarchyManager().getOWLDataPropertyHierarchyProvider();
    }

    @Override
    protected Optional<OWLObjectHierarchyProvider<OWLDataProperty>> getInferredHierarchyProvider() {
        return Optional.of(this.getOWLModelManager().getOWLHierarchyManager().getOWLDataPropertyHierarchyProvider());
    }

    @Override
    protected OWLSubPropertyAxiom getSubPropertyAxiom(OWLDataProperty child, OWLDataProperty parent) {
        return this.getOWLDataFactory().getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)child, (OWLDataPropertyExpression)parent);
    }

    @Override
    protected boolean canAcceptDrop(Object child, Object parent) {
        return child instanceof OWLDataProperty;
    }

    @Override
    protected OWLEntityCreationSet<OWLDataProperty> createProperty() {
        return this.getOWLWorkspace().createOWLDataProperty();
    }

    @Override
    protected Icon getSubIcon() {
        return new AddChildIcon(new OWLDataPropertyIcon());
    }

    @Override
    protected Icon getSibIcon() {
        return new AddSiblingIcon(new OWLDataPropertyIcon());
    }

    @Override
    protected Icon getDeleteIcon() {
        return new DeleteEntityIcon(new OWLDataPropertyIcon(OWLEntityIcon.FillType.HOLLOW));
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public Optional<OWLObject> getSelection() {
        return Optional.ofNullable(this.getSelectedEntity());
    }
}

