/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.AbstractScopedSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class Setting<T>
implements ToXContentObject {
    private final Key key;
    protected final Function<Settings, String> defaultValue;
    @Nullable
    private final Setting<T> fallbackSetting;
    private final Function<String, T> parser;
    private final Validator<T> validator;
    private final EnumSet<Property> properties;
    private static final EnumSet<Property> EMPTY_PROPERTIES = EnumSet.noneOf(Property.class);

    private Setting(Key key, @Nullable Setting<T> fallbackSetting, Function<Settings, String> defaultValue, Function<String, T> parser, Validator<T> validator, Property ... properties) {
        assert (this instanceof SecureSetting || this.isGroupSetting() || parser.apply(defaultValue.apply(Settings.EMPTY)) != null) : "parser returned null";
        this.key = key;
        this.fallbackSetting = fallbackSetting;
        this.defaultValue = defaultValue;
        this.parser = parser;
        this.validator = validator;
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null for setting [" + key + "]");
        }
        if (properties.length == 0) {
            this.properties = EMPTY_PROPERTIES;
        } else {
            EnumSet<Property> propertiesAsSet = EnumSet.copyOf(Arrays.asList(properties));
            if (propertiesAsSet.contains((Object)Property.Dynamic) && propertiesAsSet.contains((Object)Property.Final)) {
                throw new IllegalArgumentException("final setting [" + key + "] cannot be dynamic");
            }
            this.checkPropertyRequiresIndexScope(propertiesAsSet, Property.NotCopyableOnResize);
            this.checkPropertyRequiresIndexScope(propertiesAsSet, Property.InternalIndex);
            this.checkPropertyRequiresIndexScope(propertiesAsSet, Property.PrivateIndex);
            this.checkPropertyRequiresNodeScope(propertiesAsSet, Property.Consistent);
            this.properties = propertiesAsSet;
        }
    }

    private void checkPropertyRequiresIndexScope(EnumSet<Property> properties, Property property) {
        if (properties.contains((Object)property) && !properties.contains((Object)Property.IndexScope)) {
            throw new IllegalArgumentException("non-index-scoped setting [" + this.key + "] can not have property [" + (Object)((Object)property) + "]");
        }
    }

    private void checkPropertyRequiresNodeScope(EnumSet<Property> properties, Property property) {
        if (properties.contains((Object)property) && !properties.contains((Object)Property.NodeScope)) {
            throw new IllegalArgumentException("non-node-scoped setting [" + this.key + "] can not have property [" + (Object)((Object)property) + "]");
        }
    }

    public Setting(Key key, Function<Settings, String> defaultValue, Function<String, T> parser, Property ... properties) {
        this(key, defaultValue, parser, (T v) -> {}, properties);
    }

    public Setting(Key key, Function<Settings, String> defaultValue, Function<String, T> parser, Validator<T> validator, Property ... properties) {
        this(key, null, defaultValue, parser, validator, properties);
    }

    public Setting(String key, String defaultValue, Function<String, T> parser, Property ... properties) {
        this(key, (Settings s) -> defaultValue, parser, properties);
    }

    public Setting(String key, String defaultValue, Function<String, T> parser, Validator<T> validator, Property ... properties) {
        this((Key)new SimpleKey(key), (Settings s) -> defaultValue, parser, validator, properties);
    }

    public Setting(String key, Function<Settings, String> defaultValue, Function<String, T> parser, Property ... properties) {
        this((Key)new SimpleKey(key), defaultValue, parser, properties);
    }

    public Setting(Key key, Setting<T> fallbackSetting, Function<String, T> parser, Property ... properties) {
        this(key, fallbackSetting, fallbackSetting::getRaw, parser, (T v) -> {}, properties);
    }

    public Setting(String key, Setting<T> fallBackSetting, Function<String, T> parser, Property ... properties) {
        this((Key)new SimpleKey(key), fallBackSetting, parser, properties);
    }

    public final String getKey() {
        return this.key.toString();
    }

    public final Key getRawKey() {
        return this.key;
    }

    public final boolean isDynamic() {
        return this.properties.contains((Object)Property.Dynamic);
    }

    public final boolean isFinal() {
        return this.properties.contains((Object)Property.Final);
    }

    public final boolean isInternalIndex() {
        return this.properties.contains((Object)Property.InternalIndex);
    }

    public final boolean isPrivateIndex() {
        return this.properties.contains((Object)Property.PrivateIndex);
    }

    public EnumSet<Property> getProperties() {
        return this.properties;
    }

    public boolean isFiltered() {
        return this.properties.contains((Object)Property.Filtered);
    }

    public boolean hasNodeScope() {
        return this.properties.contains((Object)Property.NodeScope);
    }

    public boolean isConsistent() {
        return this.properties.contains((Object)Property.Consistent);
    }

    public boolean hasIndexScope() {
        return this.properties.contains((Object)Property.IndexScope);
    }

    public boolean isDeprecated() {
        return this.properties.contains((Object)Property.Deprecated);
    }

    boolean isGroupSetting() {
        return false;
    }

    final boolean isListSetting() {
        return this instanceof ListSetting;
    }

    boolean hasComplexMatcher() {
        return this.isGroupSetting();
    }

    void validateWithoutDependencies(Settings settings) {
        this.validator.validate(this.get(settings, false));
    }

    public String getDefaultRaw(Settings settings) {
        return this.defaultValue.apply(settings);
    }

    public T getDefault(Settings settings) {
        return this.parser.apply(this.getDefaultRaw(settings));
    }

    public boolean exists(Settings settings) {
        return settings.keySet().contains(this.getKey());
    }

    public boolean existsOrFallbackExists(Settings settings) {
        return settings.keySet().contains(this.getKey()) || this.fallbackSetting != null && this.fallbackSetting.existsOrFallbackExists(settings);
    }

    public T get(Settings settings) {
        return this.get(settings, true);
    }

    private T get(Settings settings, boolean validate) {
        String value = this.getRaw(settings);
        try {
            T parsed = this.parser.apply(value);
            if (validate) {
                Map<Setting<?>, Object> map;
                Iterator<Setting<?>> it = this.validator.settings();
                if (it.hasNext()) {
                    map = new HashMap();
                    while (it.hasNext()) {
                        Setting<?> setting = it.next();
                        if (setting instanceof AffixSetting) {
                            AffixSetting as = (AffixSetting)setting;
                            for (String ns : as.getNamespaces(settings)) {
                                Setting s = as.getConcreteSettingForNamespace(ns);
                                map.put(s, super.get(settings, false));
                            }
                            continue;
                        }
                        map.put(setting, super.get(settings, false));
                    }
                } else {
                    map = Collections.emptyMap();
                }
                this.validator.validate(parsed);
                this.validator.validate(parsed, map);
                this.validator.validate(parsed, map, this.exists(settings));
            }
            return parsed;
        }
        catch (ElasticsearchParseException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (NumberFormatException ex) {
            String err = "Failed to parse value" + (this.isFiltered() ? "" : " [" + value + "]") + " for setting [" + this.getKey() + "]";
            throw new IllegalArgumentException(err, ex);
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception t) {
            String err = "Failed to parse value" + (this.isFiltered() ? "" : " [" + value + "]") + " for setting [" + this.getKey() + "]";
            throw new IllegalArgumentException(err, t);
        }
    }

    public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
        if (!this.exists(source)) {
            builder.put(this.getKey(), this.getRaw(defaultSettings));
        }
    }

    private String getRaw(Settings settings) {
        this.checkDeprecation(settings);
        return this.innerGetRaw(settings);
    }

    String innerGetRaw(Settings settings) {
        SecureSettings secureSettings = settings.getSecureSettings();
        if (secureSettings != null && secureSettings.getSettingNames().contains(this.getKey())) {
            throw new IllegalArgumentException("Setting [" + this.getKey() + "] is a non-secure setting and must be stored inside elasticsearch.yml, but was found inside the Elasticsearch keystore");
        }
        return settings.get(this.getKey(), this.defaultValue.apply(settings));
    }

    void checkDeprecation(Settings settings) {
        if (this.isDeprecated() && this.exists(settings)) {
            String key = this.getKey();
            Settings.DeprecationLoggerHolder.deprecationLogger.deprecatedAndMaybeLog(key, "[{}] setting was deprecated in Elasticsearch and will be removed in a future release! See the breaking changes documentation for the next major version.", key);
        }
    }

    public final boolean match(String toTest) {
        return this.key.match(toTest);
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("key", this.key.toString());
        builder.field("properties", this.properties);
        builder.field("is_group_setting", this.isGroupSetting());
        builder.field("default", this.defaultValue.apply(Settings.EMPTY));
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    public final T get(Settings primary, Settings secondary) {
        if (this.exists(primary)) {
            return this.get(primary);
        }
        if (this.exists(secondary)) {
            return this.get(secondary);
        }
        if (this.fallbackSetting == null) {
            return this.get(primary);
        }
        if (this.fallbackSetting.exists(primary)) {
            return this.fallbackSetting.get(primary);
        }
        return this.fallbackSetting.get(secondary);
    }

    public Setting<T> getConcreteSetting(String key) {
        assert (key.startsWith(this.getKey())) : "was " + key + " expected: " + this.getKey();
        return this;
    }

    public Set<SettingDependency> getSettingsDependencies(String key) {
        return Collections.emptySet();
    }

    final AbstractScopedSettings.SettingUpdater<T> newUpdater(Consumer<T> consumer, Logger logger) {
        return this.newUpdater(consumer, logger, s -> {});
    }

    AbstractScopedSettings.SettingUpdater<T> newUpdater(Consumer<T> consumer, Logger logger, Consumer<T> validator) {
        if (this.isDynamic()) {
            return new Updater(consumer, logger, validator);
        }
        throw new IllegalStateException("setting [" + this.getKey() + "] is not dynamic");
    }

    static <A, B> AbstractScopedSettings.SettingUpdater<Tuple<A, B>> compoundUpdater(final BiConsumer<A, B> consumer, final BiConsumer<A, B> validator, final Setting<A> aSetting, final Setting<B> bSetting, final Logger logger) {
        final AbstractScopedSettings.SettingUpdater<A> aSettingUpdater = aSetting.newUpdater(null, logger);
        final AbstractScopedSettings.SettingUpdater<B> bSettingUpdater = bSetting.newUpdater(null, logger);
        return new AbstractScopedSettings.SettingUpdater<Tuple<A, B>>(){

            @Override
            public boolean hasChanged(Settings current, Settings previous) {
                return aSettingUpdater.hasChanged(current, previous) || bSettingUpdater.hasChanged(current, previous);
            }

            @Override
            public Tuple<A, B> getValue(Settings current, Settings previous) {
                Object valueA = aSettingUpdater.getValue(current, previous);
                Object valueB = bSettingUpdater.getValue(current, previous);
                validator.accept(valueA, valueB);
                return new Tuple(valueA, valueB);
            }

            @Override
            public void apply(Tuple<A, B> value, Settings current, Settings previous) {
                if (aSettingUpdater.hasChanged(current, previous)) {
                    Setting.logSettingUpdate(aSetting, current, previous, logger);
                }
                if (bSettingUpdater.hasChanged(current, previous)) {
                    Setting.logSettingUpdate(bSetting, current, previous, logger);
                }
                consumer.accept(value.v1(), value.v2());
            }

            public String toString() {
                return "CompoundUpdater for: " + aSettingUpdater + " and " + bSettingUpdater;
            }
        };
    }

    static AbstractScopedSettings.SettingUpdater<Settings> groupedSettingsUpdater(Consumer<Settings> consumer, List<? extends Setting<?>> configuredSettings) {
        return Setting.groupedSettingsUpdater(consumer, configuredSettings, v -> {});
    }

    static AbstractScopedSettings.SettingUpdater<Settings> groupedSettingsUpdater(final Consumer<Settings> consumer, final List<? extends Setting<?>> configuredSettings, final Consumer<Settings> validator) {
        return new AbstractScopedSettings.SettingUpdater<Settings>(){

            private Settings get(Settings settings) {
                return settings.filter(s -> {
                    for (Setting setting : configuredSettings) {
                        if (!setting.key.match((String)s)) continue;
                        return true;
                    }
                    return false;
                });
            }

            @Override
            public boolean hasChanged(Settings current, Settings previous) {
                Settings previousSettings;
                Settings currentSettings = this.get(current);
                return !currentSettings.equals(previousSettings = this.get(previous));
            }

            @Override
            public Settings getValue(Settings current, Settings previous) {
                validator.accept(current);
                return this.get(current);
            }

            @Override
            public void apply(Settings value, Settings current, Settings previous) {
                consumer.accept(value);
            }

            public String toString() {
                return "Updater grouped: " + configuredSettings.stream().map(Setting::getKey).collect(Collectors.joining(", "));
            }
        };
    }

    public static Setting<Version> versionSetting(String key, Version defaultValue, Property ... properties) {
        return new Setting<Version>(key, s -> Integer.toString(defaultValue.id), s -> Version.fromId(Integer.parseInt(s)), properties);
    }

    public static Setting<Float> floatSetting(String key, float defaultValue, Property ... properties) {
        return new Setting<Float>(key, s -> Float.toString(defaultValue), Float::parseFloat, properties);
    }

    public static Setting<Float> floatSetting(String key, float defaultValue, float minValue, Property ... properties) {
        return new Setting<Float>(key, s -> Float.toString(defaultValue), s -> {
            float value = Float.parseFloat(s);
            if (value < minValue) {
                String err = "Failed to parse value" + (Setting.isFiltered(properties) ? "" : " [" + s + "]") + " for setting [" + key + "] must be >= " + minValue;
                throw new IllegalArgumentException(err);
            }
            return Float.valueOf(value);
        }, properties);
    }

    private static boolean isFiltered(Property[] properties) {
        return properties != null && Arrays.asList(properties).contains((Object)Property.Filtered);
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, int minValue, int maxValue, Property ... properties) {
        return new Setting<Integer>(key, s -> Integer.toString(defaultValue), s -> Setting.parseInt(s, minValue, maxValue, key, Setting.isFiltered(properties)), properties);
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, int minValue, Property ... properties) {
        return new Setting<Integer>(key, s -> Integer.toString(defaultValue), s -> Setting.parseInt(s, minValue, key, Setting.isFiltered(properties)), properties);
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, int minValue, Validator<Integer> validator, Property ... properties) {
        return new Setting<Integer>(key, Integer.toString(defaultValue), s -> Setting.parseInt(s, minValue, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<Integer> intSetting(String key, Setting<Integer> fallbackSetting, int minValue, Property ... properties) {
        return new Setting<Integer>(key, fallbackSetting, s -> Setting.parseInt(s, minValue, key, Setting.isFiltered(properties)), properties);
    }

    public static Setting<Integer> intSetting(String key, Setting<Integer> fallbackSetting, int minValue, Validator<Integer> validator, Property ... properties) {
        return new Setting<Integer>((Key)new SimpleKey(key), fallbackSetting, fallbackSetting::getRaw, s -> Setting.parseInt(s, minValue, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<Long> longSetting(String key, long defaultValue, long minValue, Property ... properties) {
        return new Setting<Long>(key, s -> Long.toString(defaultValue), s -> Setting.parseLong(s, minValue, key, Setting.isFiltered(properties)), properties);
    }

    public static Setting<String> simpleString(String key, Property ... properties) {
        return new Setting<String>(key, s -> "", Function.identity(), properties);
    }

    public static Setting<String> simpleString(String key, Validator<String> validator, Property ... properties) {
        return new Setting<String>((Key)new SimpleKey(key), null, s -> "", Function.identity(), validator, properties);
    }

    public static Setting<String> simpleString(String key, Validator<String> validator, Setting<String> fallback, Property ... properties) {
        return new Setting<String>((Key)new SimpleKey(key), fallback, fallback::getRaw, Function.identity(), validator, properties);
    }

    public static Setting<String> simpleString(String key, String defaultValue, Validator<String> validator, Property ... properties) {
        validator.validate(defaultValue);
        return new Setting<String>((Key)new SimpleKey(key), null, s -> defaultValue, Function.identity(), validator, properties);
    }

    public static Setting<String> simpleString(String key, Setting<String> fallback, Property ... properties) {
        return Setting.simpleString(key, fallback, Function.identity(), properties);
    }

    public static Setting<String> simpleString(String key, Setting<String> fallback, Function<String, String> parser, Property ... properties) {
        return new Setting<String>(key, fallback, parser, properties);
    }

    public static Setting<String> simpleString(String key, String defaultValue, Property ... properties) {
        return new Setting<String>(key, s -> defaultValue, Function.identity(), properties);
    }

    public static int parseInt(String s, int minValue, String key) {
        return Setting.parseInt(s, minValue, Integer.MAX_VALUE, key, false);
    }

    public static int parseInt(String s, int minValue, String key, boolean isFiltered) {
        return Setting.parseInt(s, minValue, Integer.MAX_VALUE, key, isFiltered);
    }

    public static int parseInt(String s, int minValue, int maxValue, String key) {
        return Setting.parseInt(s, minValue, maxValue, key, false);
    }

    static int parseInt(String s, int minValue, int maxValue, String key, boolean isFiltered) {
        int value = Integer.parseInt(s);
        if (value < minValue) {
            String err = "Failed to parse value" + (isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be >= " + minValue;
            throw new IllegalArgumentException(err);
        }
        if (value > maxValue) {
            String err = "Failed to parse value" + (isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be <= " + maxValue;
            throw new IllegalArgumentException(err);
        }
        return value;
    }

    public static long parseLong(String s, long minValue, String key) {
        return Setting.parseLong(s, minValue, key, false);
    }

    static long parseLong(String s, long minValue, String key, boolean isFiltered) {
        long value = Long.parseLong(s);
        if (value < minValue) {
            String err = "Failed to parse value" + (isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be >= " + minValue;
            throw new IllegalArgumentException(err);
        }
        return value;
    }

    public static TimeValue parseTimeValue(String s, TimeValue minValue, String key) {
        TimeValue timeValue = TimeValue.parseTimeValue((String)s, null, (String)key);
        if (timeValue.millis() < minValue.millis()) {
            throw new IllegalArgumentException("Failed to parse value [" + s + "] for setting [" + key + "] must be >= " + minValue);
        }
        return timeValue;
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, Property ... properties) {
        return Setting.intSetting(key, defaultValue, Integer.MIN_VALUE, properties);
    }

    public static Setting<Boolean> boolSetting(String key, boolean defaultValue, Property ... properties) {
        return new Setting<Boolean>(key, s -> Boolean.toString(defaultValue), b -> Setting.parseBoolean(b, key, Setting.isFiltered(properties)), properties);
    }

    public static Setting<Boolean> boolSetting(String key, Setting<Boolean> fallbackSetting, Property ... properties) {
        return new Setting<Boolean>(key, fallbackSetting, b -> Setting.parseBoolean(b, key, Setting.isFiltered(properties)), properties);
    }

    public static Setting<Boolean> boolSetting(String key, Setting<Boolean> fallbackSetting, Validator<Boolean> validator, Property ... properties) {
        return new Setting<Boolean>((Key)new SimpleKey(key), fallbackSetting, fallbackSetting::getRaw, b -> Setting.parseBoolean(b, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<Boolean> boolSetting(String key, boolean defaultValue, Validator<Boolean> validator, Property ... properties) {
        return new Setting<Boolean>(key, Boolean.toString(defaultValue), b -> Setting.parseBoolean(b, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<Boolean> boolSetting(String key, Function<Settings, String> defaultValueFn, Property ... properties) {
        return new Setting<Boolean>(key, defaultValueFn, b -> Setting.parseBoolean(b, key, Setting.isFiltered(properties)), properties);
    }

    static boolean parseBoolean(String b, String key, boolean isFiltered) {
        try {
            return Booleans.parseBoolean((String)b);
        }
        catch (IllegalArgumentException ex) {
            if (isFiltered) {
                throw new IllegalArgumentException("Failed to parse value for setting [" + key + "]");
            }
            throw ex;
        }
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, ByteSizeValue value, Property ... properties) {
        return Setting.byteSizeSetting(key, (Settings s) -> value.toString(), properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, Setting<ByteSizeValue> fallbackSetting, Property ... properties) {
        return new Setting<ByteSizeValue>(key, fallbackSetting, s -> ByteSizeValue.parseBytesSizeValue(s, key), properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, Function<Settings, String> defaultValue, Property ... properties) {
        return new Setting<ByteSizeValue>(key, defaultValue, s -> ByteSizeValue.parseBytesSizeValue(s, key), properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, ByteSizeValue defaultValue, ByteSizeValue minValue, ByteSizeValue maxValue, Property ... properties) {
        return Setting.byteSizeSetting(key, (Settings s) -> defaultValue.getStringRep(), minValue, maxValue, properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, Function<Settings, String> defaultValue, ByteSizeValue minValue, ByteSizeValue maxValue, Property ... properties) {
        return new Setting<ByteSizeValue>(key, defaultValue, s -> Setting.parseByteSize(s, minValue, maxValue, key), properties);
    }

    public static ByteSizeValue parseByteSize(String s, ByteSizeValue minValue, ByteSizeValue maxValue, String key) {
        ByteSizeValue value = ByteSizeValue.parseBytesSizeValue(s, key);
        if (value.getBytes() < minValue.getBytes()) {
            String message = String.format(Locale.ROOT, "failed to parse value [%s] for setting [%s], must be >= [%s]", s, key, minValue.getStringRep());
            throw new IllegalArgumentException(message);
        }
        if (value.getBytes() > maxValue.getBytes()) {
            String message = String.format(Locale.ROOT, "failed to parse value [%s] for setting [%s], must be <= [%s]", s, key, maxValue.getStringRep());
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static Setting<ByteSizeValue> memorySizeSetting(String key, ByteSizeValue defaultValue, Property ... properties) {
        return Setting.memorySizeSetting(key, (Settings s) -> defaultValue.toString(), properties);
    }

    public static Setting<ByteSizeValue> memorySizeSetting(String key, Function<Settings, String> defaultValue, Property ... properties) {
        return new Setting<ByteSizeValue>(key, defaultValue, s -> MemorySizeValue.parseBytesSizeValueOrHeapRatio(s, key), properties);
    }

    public static Setting<ByteSizeValue> memorySizeSetting(String key, String defaultPercentage, Property ... properties) {
        return new Setting<ByteSizeValue>(key, s -> defaultPercentage, s -> MemorySizeValue.parseBytesSizeValueOrHeapRatio(s, key), properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, List<String> defaultStringValue, Function<String, T> singleValueParser, Property ... properties) {
        return Setting.listSetting(key, null, singleValueParser, (Settings s) -> defaultStringValue, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, List<String> defaultStringValue, Function<String, T> singleValueParser, Validator<List<T>> validator, Property ... properties) {
        return Setting.listSetting(key, null, singleValueParser, (Settings s) -> defaultStringValue, validator, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, Setting<List<T>> fallbackSetting, Function<String, T> singleValueParser, Property ... properties) {
        return Setting.listSetting(key, fallbackSetting, singleValueParser, (Settings s) -> Setting.parseableStringToList(fallbackSetting.getRaw((Settings)s)), properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, Function<String, T> singleValueParser, Function<Settings, List<String>> defaultStringValue, Property ... properties) {
        return Setting.listSetting(key, null, singleValueParser, defaultStringValue, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, Function<String, T> singleValueParser, Function<Settings, List<String>> defaultStringValue, Validator<List<T>> validator, Property ... properties) {
        return Setting.listSetting(key, null, singleValueParser, defaultStringValue, validator, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, @Nullable Setting<List<T>> fallbackSetting, Function<String, T> singleValueParser, Function<Settings, List<String>> defaultStringValue, Property ... properties) {
        return Setting.listSetting(key, fallbackSetting, singleValueParser, defaultStringValue, (List<T> v) -> {}, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, @Nullable Setting<List<T>> fallbackSetting, Function<String, T> singleValueParser, Function<Settings, List<String>> defaultStringValue, Validator<List<T>> validator, Property ... properties) {
        if (defaultStringValue.apply(Settings.EMPTY) == null) {
            throw new IllegalArgumentException("default value function must not return null");
        }
        Function<String, List> parser = s -> Setting.parseableStringToList(s).stream().map(singleValueParser).collect(Collectors.toList());
        return new ListSetting(key, (Setting)fallbackSetting, (Function)defaultStringValue, (Function)parser, (Validator)validator, properties);
    }

    private static List<String> parseableStringToList(String parsableString) {
        ArrayList<String> arrayList;
        block11: {
            XContentParser xContentParser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, parsableString);
            try {
                XContentParser.Token token = xContentParser.nextToken();
                if (token != XContentParser.Token.START_ARRAY) {
                    throw new IllegalArgumentException("expected START_ARRAY but got " + token);
                }
                ArrayList<String> list = new ArrayList<String>();
                while ((token = xContentParser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token != XContentParser.Token.VALUE_STRING) {
                        throw new IllegalArgumentException("expected VALUE_STRING but got " + token);
                    }
                    list.add(xContentParser.text());
                }
                arrayList = list;
                if (xContentParser == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (xContentParser != null) {
                        try {
                            xContentParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("failed to parse array", e);
                }
            }
            xContentParser.close();
        }
        return arrayList;
    }

    private static String arrayToParsableString(List<String> array) {
        try {
            XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());
            builder.startArray();
            for (String element : array) {
                builder.value(element);
            }
            builder.endArray();
            return Strings.toString(builder);
        }
        catch (IOException ex) {
            throw new ElasticsearchException(ex);
        }
    }

    static void logSettingUpdate(Setting setting, Settings current, Settings previous, Logger logger) {
        if (logger.isInfoEnabled()) {
            if (setting.isFiltered()) {
                logger.info("updating [{}]", (Object)setting.key);
            } else {
                logger.info("updating [{}] from [{}] to [{}]", (Object)setting.key, (Object)setting.getRaw(previous), (Object)setting.getRaw(current));
            }
        }
    }

    public static Setting<Settings> groupSetting(String key, Property ... properties) {
        return Setting.groupSetting(key, (Settings s) -> {}, properties);
    }

    public static Setting<Settings> groupSetting(String key, Consumer<Settings> validator, Property ... properties) {
        return new GroupSetting(key, (Consumer)validator, properties);
    }

    public static Setting<TimeValue> timeSetting(String key, Setting<TimeValue> fallbackSetting, TimeValue minValue, Property ... properties) {
        SimpleKey simpleKey = new SimpleKey(key);
        return new Setting<TimeValue>((Key)simpleKey, fallbackSetting, fallbackSetting::getRaw, Setting.minTimeValueParser(key, minValue, Setting.isFiltered(properties)), v -> {}, properties);
    }

    public static Setting<TimeValue> timeSetting(String key, Function<Settings, TimeValue> defaultValue, TimeValue minValue, Property ... properties) {
        SimpleKey simpleKey = new SimpleKey(key);
        return new Setting<TimeValue>((Key)simpleKey, s -> ((TimeValue)defaultValue.apply((Settings)s)).getStringRep(), Setting.minTimeValueParser(key, minValue, Setting.isFiltered(properties)), properties);
    }

    public static Setting<TimeValue> timeSetting(String key, TimeValue defaultValue, TimeValue minValue, TimeValue maxValue, Property ... properties) {
        SimpleKey simpleKey = new SimpleKey(key);
        return new Setting<TimeValue>((Key)simpleKey, s -> defaultValue.getStringRep(), Setting.minMaxTimeValueParser(key, minValue, maxValue, Setting.isFiltered(properties)), properties);
    }

    private static Function<String, TimeValue> minTimeValueParser(String key, TimeValue minValue, boolean isFiltered) {
        return s -> {
            TimeValue value;
            try {
                value = TimeValue.parseTimeValue((String)s, null, (String)key);
            }
            catch (RuntimeException ex) {
                if (isFiltered) {
                    throw new IllegalArgumentException("failed to parse value for setting [" + key + "] as a time value");
                }
                throw ex;
            }
            if (value.millis() < minValue.millis()) {
                String message = String.format(Locale.ROOT, "failed to parse value%s for setting [%s], must be >= [%s]", isFiltered ? "" : " [" + s + "]", key, minValue.getStringRep());
                throw new IllegalArgumentException(message);
            }
            return value;
        };
    }

    private static Function<String, TimeValue> minMaxTimeValueParser(String key, TimeValue minValue, TimeValue maxValue, boolean isFiltered) {
        return s -> {
            TimeValue value;
            try {
                value = Setting.minTimeValueParser(key, minValue, isFiltered).apply((String)s);
            }
            catch (RuntimeException ex) {
                if (isFiltered) {
                    throw new IllegalArgumentException("failed to parse value for setting [" + key + "] as a time value");
                }
                throw ex;
            }
            if (value.millis() > maxValue.millis()) {
                String message = String.format(Locale.ROOT, "failed to parse value%s for setting [%s], must be <= [%s]", isFiltered ? "" : " [" + s + "]", key, maxValue.getStringRep());
                throw new IllegalArgumentException(message);
            }
            return value;
        };
    }

    public static Setting<TimeValue> timeSetting(String key, TimeValue defaultValue, TimeValue minValue, Property ... properties) {
        return Setting.timeSetting(key, (Settings s) -> defaultValue, minValue, properties);
    }

    public static Setting<TimeValue> timeSetting(String key, TimeValue defaultValue, Property ... properties) {
        return new Setting<TimeValue>(key, s -> defaultValue.getStringRep(), s -> TimeValue.parseTimeValue((String)s, (String)key), properties);
    }

    public static Setting<TimeValue> timeSetting(String key, Setting<TimeValue> fallbackSetting, Property ... properties) {
        return new Setting<TimeValue>(key, fallbackSetting, s -> TimeValue.parseTimeValue((String)s, (String)key), properties);
    }

    public static Setting<TimeValue> timeSetting(String key, Setting<TimeValue> fallBackSetting, Validator<TimeValue> validator, Property ... properties) {
        return new Setting<TimeValue>((Key)new SimpleKey(key), fallBackSetting, fallBackSetting::getRaw, s -> TimeValue.parseTimeValue((String)s, (String)key), validator, properties);
    }

    public static Setting<TimeValue> positiveTimeSetting(String key, TimeValue defaultValue, Property ... properties) {
        return Setting.timeSetting(key, defaultValue, TimeValue.timeValueMillis((long)0L), properties);
    }

    public static Setting<TimeValue> positiveTimeSetting(String key, Setting<TimeValue> fallbackSetting, TimeValue minValue, Property ... properties) {
        return Setting.timeSetting(key, fallbackSetting, minValue, properties);
    }

    public static Setting<Double> doubleSetting(String key, double defaultValue, double minValue, Property ... properties) {
        return Setting.doubleSetting(key, defaultValue, minValue, Double.POSITIVE_INFINITY, properties);
    }

    public static Setting<Double> doubleSetting(String key, double defaultValue, double minValue, double maxValue, Property ... properties) {
        return new Setting<Double>(key, s -> Double.toString(defaultValue), s -> {
            double d = Double.parseDouble(s);
            if (d < minValue) {
                String err = "Failed to parse value" + (Setting.isFiltered(properties) ? "" : " [" + s + "]") + " for setting [" + key + "] must be >= " + minValue;
                throw new IllegalArgumentException(err);
            }
            if (d > maxValue) {
                String err = "Failed to parse value" + (Setting.isFiltered(properties) ? "" : " [" + s + "]") + " for setting [" + key + "] must be <= " + maxValue;
                throw new IllegalArgumentException(err);
            }
            return d;
        }, properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Setting setting = (Setting)o;
        return Objects.equals(this.key, setting.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public static <T> AffixSetting<T> prefixKeySetting(String prefix, Function<String, Setting<T>> delegateFactory) {
        BiFunction<String, String, Setting<T>> delegateFactoryWithNamespace = (ns, k) -> (Setting)delegateFactory.apply((String)k);
        return Setting.affixKeySetting(new AffixKey(prefix), delegateFactoryWithNamespace, new AffixSettingDependency[0]);
    }

    public static <T> AffixSetting<T> affixKeySetting(String prefix, String suffix, Function<String, Setting<T>> delegateFactory, AffixSettingDependency ... dependencies) {
        BiFunction<String, String, Setting<T>> delegateFactoryWithNamespace = (ns, k) -> (Setting)delegateFactory.apply((String)k);
        return Setting.affixKeySetting(new AffixKey(prefix, suffix), delegateFactoryWithNamespace, dependencies);
    }

    public static <T> AffixSetting<T> affixKeySetting(String prefix, String suffix, BiFunction<String, String, Setting<T>> delegateFactory, AffixSettingDependency ... dependencies) {
        Setting<T> delegate = delegateFactory.apply("_na_", "_na_");
        return new AffixSetting<T>(new AffixKey(prefix, suffix), delegate, delegateFactory, dependencies);
    }

    private static <T> AffixSetting<T> affixKeySetting(AffixKey key, BiFunction<String, String, Setting<T>> delegateFactory, AffixSettingDependency ... dependencies) {
        Setting<T> delegate = delegateFactory.apply("_na_", "_na_");
        return new AffixSetting<T>(key, delegate, delegateFactory, dependencies);
    }

    public static interface Key {
        public boolean match(String var1);
    }

    @FunctionalInterface
    public static interface Validator<T> {
        public void validate(T var1);

        default public void validate(T value, Map<Setting<?>, Object> settings) {
        }

        default public void validate(T value, Map<Setting<?>, Object> settings, boolean isPresent) {
        }

        default public Iterator<Setting<?>> settings() {
            return Collections.emptyIterator();
        }
    }

    public static enum Property {
        Filtered,
        Dynamic,
        Final,
        Deprecated,
        NodeScope,
        Consistent,
        IndexScope,
        NotCopyableOnResize,
        InternalIndex,
        PrivateIndex;

    }

    public static class SimpleKey
    implements Key {
        protected final String key;

        public SimpleKey(String key) {
            this.key = key;
        }

        @Override
        public boolean match(String key) {
            return this.key.equals(key);
        }

        public String toString() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleKey simpleKey = (SimpleKey)o;
            return Objects.equals(this.key, simpleKey.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    private static class ListSetting<T>
    extends Setting<List<T>> {
        private final Function<Settings, List<String>> defaultStringValue;

        private ListSetting(String key, @Nullable Setting<List<T>> fallbackSetting, Function<Settings, List<String>> defaultStringValue, Function<String, List<T>> parser, Validator<List<T>> validator, Property ... properties) {
            super((Key)new ListKey(key), (Setting)fallbackSetting, s -> Setting.arrayToParsableString((List)defaultStringValue.apply((Settings)s)), parser, (Validator)validator, properties);
            this.defaultStringValue = defaultStringValue;
        }

        @Override
        String innerGetRaw(Settings settings) {
            List<String> array = settings.getAsList(this.getKey(), null);
            return array == null ? (String)this.defaultValue.apply(settings) : Setting.arrayToParsableString(array);
        }

        @Override
        boolean hasComplexMatcher() {
            return true;
        }

        @Override
        public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
            if (!this.exists(source)) {
                List<String> asList = defaultSettings.getAsList(this.getKey(), null);
                if (asList == null) {
                    builder.putList(this.getKey(), this.defaultStringValue.apply(defaultSettings));
                } else {
                    builder.putList(this.getKey(), asList);
                }
            }
        }
    }

    public static class AffixSetting<T>
    extends Setting<T> {
        private final AffixKey key;
        private final BiFunction<String, String, Setting<T>> delegateFactory;
        private final Set<AffixSettingDependency> dependencies;

        public AffixSetting(AffixKey key, Setting<T> delegate, BiFunction<String, String, Setting<T>> delegateFactory, AffixSettingDependency ... dependencies) {
            super((Key)key, delegate.defaultValue, ((Setting)delegate).parser, ((Setting)delegate).properties.toArray(new Property[0]));
            this.key = key;
            this.delegateFactory = delegateFactory;
            this.dependencies = Collections.unmodifiableSet(new HashSet<AffixSettingDependency>(Arrays.asList(dependencies)));
        }

        @Override
        boolean isGroupSetting() {
            return true;
        }

        private Stream<String> matchStream(Settings settings) {
            return settings.keySet().stream().filter(this::match).map(this.key::getConcreteString);
        }

        @Override
        public Set<SettingDependency> getSettingsDependencies(String settingsKey) {
            if (this.dependencies.isEmpty()) {
                return Collections.emptySet();
            }
            String namespace = this.key.getNamespace(settingsKey);
            return this.dependencies.stream().map(s -> new SettingDependency(){
                final /* synthetic */ AffixSettingDependency val$s;
                final /* synthetic */ String val$namespace;
                {
                    this.val$s = affixSettingDependency;
                    this.val$namespace = string;
                }

                @Override
                public Setting<Object> getSetting() {
                    return this.val$s.getSetting().getConcreteSettingForNamespace(this.val$namespace);
                }

                @Override
                public void validate(String key, Object value, Object dependency) {
                    this.val$s.validate(key, value, dependency);
                }
            }).collect(Collectors.toSet());
        }

        AbstractScopedSettings.SettingUpdater<Map<AbstractScopedSettings.SettingUpdater<T>, T>> newAffixUpdater(final BiConsumer<String, T> consumer, final Logger logger, final BiConsumer<String, T> validator) {
            return new AbstractScopedSettings.SettingUpdater<Map<AbstractScopedSettings.SettingUpdater<T>, T>>(){

                @Override
                public boolean hasChanged(Settings current, Settings previous) {
                    return Stream.concat(this.matchStream(current), this.matchStream(previous)).findAny().isPresent();
                }

                @Override
                public Map<AbstractScopedSettings.SettingUpdater<T>, T> getValue(Settings current, Settings previous) {
                    IdentityHashMap result = new IdentityHashMap();
                    Stream.concat(this.matchStream(current), this.matchStream(previous)).distinct().forEach(aKey -> {
                        String namespace = key.getNamespace((String)aKey);
                        Setting concreteSetting = this.getConcreteSetting(namespace, aKey);
                        AbstractScopedSettings.SettingUpdater<Object> updater = concreteSetting.newUpdater(v -> consumer.accept(namespace, v), logger, v -> validator.accept(namespace, v));
                        if (updater.hasChanged(current, previous)) {
                            Object value = updater.getValue(current, previous);
                            result.put(updater, value);
                        }
                    });
                    return result;
                }

                @Override
                public void apply(Map<AbstractScopedSettings.SettingUpdater<T>, T> value, Settings current, Settings previous) {
                    for (Map.Entry entry : value.entrySet()) {
                        entry.getKey().apply(entry.getValue(), current, previous);
                    }
                }
            };
        }

        AbstractScopedSettings.SettingUpdater<Map<String, T>> newAffixMapUpdater(final Consumer<Map<String, T>> consumer, final Logger logger, final BiConsumer<String, T> validator) {
            return new AbstractScopedSettings.SettingUpdater<Map<String, T>>(){

                @Override
                public boolean hasChanged(Settings current, Settings previous) {
                    return !current.filter(k -> this.match((String)k)).equals(previous.filter(k -> this.match((String)k)));
                }

                @Override
                public Map<String, T> getValue(Settings current, Settings previous) {
                    IdentityHashMap result = new IdentityHashMap();
                    Stream.concat(this.matchStream(current), this.matchStream(previous)).distinct().forEach(aKey -> {
                        String namespace = key.getNamespace((String)aKey);
                        Setting concreteSetting = this.getConcreteSetting(namespace, aKey);
                        AbstractScopedSettings.SettingUpdater<Object> updater = concreteSetting.newUpdater(v -> {}, logger, v -> validator.accept(namespace, v));
                        if (updater.hasChanged(current, previous)) {
                            Object value = updater.getValue(current, previous);
                            result.put(namespace, value);
                        }
                    });
                    return result;
                }

                @Override
                public void apply(Map<String, T> value, Settings current, Settings previous) {
                    consumer.accept(value);
                }
            };
        }

        @Override
        public T get(Settings settings) {
            throw new UnsupportedOperationException("affix settings can't return values use #getConcreteSetting to obtain a concrete setting");
        }

        @Override
        public String innerGetRaw(Settings settings) {
            throw new UnsupportedOperationException("affix settings can't return values use #getConcreteSetting to obtain a concrete setting");
        }

        @Override
        public Setting<T> getConcreteSetting(String key) {
            if (this.match(key)) {
                String namespace = this.key.getNamespace(key);
                return this.delegateFactory.apply(namespace, key);
            }
            throw new IllegalArgumentException("key [" + key + "] must match [" + this.getKey() + "] but didn't.");
        }

        private Setting<T> getConcreteSetting(String namespace, String key) {
            if (this.match(key)) {
                return this.delegateFactory.apply(namespace, key);
            }
            throw new IllegalArgumentException("key [" + key + "] must match [" + this.getKey() + "] but didn't.");
        }

        public Setting<T> getConcreteSettingForNamespace(String namespace) {
            String fullKey = this.key.toConcreteKey(namespace).toString();
            return this.getConcreteSetting(namespace, fullKey);
        }

        @Override
        public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
            this.matchStream(defaultSettings).forEach(key -> this.getConcreteSetting((String)key).diff(builder, source, defaultSettings));
        }

        public String getNamespace(Setting<T> concreteSetting) {
            return this.key.getNamespace(concreteSetting.getKey());
        }

        public Stream<Setting<T>> getAllConcreteSettings(Settings settings) {
            return this.matchStream(settings).distinct().map(this::getConcreteSetting);
        }

        public Set<String> getNamespaces(Settings settings) {
            return settings.keySet().stream().filter(this::match).map(this.key::getNamespace).collect(Collectors.toSet());
        }

        public Map<String, T> getAsMap(Settings settings) {
            HashMap map = new HashMap();
            this.matchStream(settings).distinct().forEach(key -> {
                String namespace = this.key.getNamespace((String)key);
                Setting<T> concreteSetting = this.getConcreteSetting(namespace, (String)key);
                map.put(namespace, concreteSetting.get(settings));
            });
            return Collections.unmodifiableMap(map);
        }
    }

    private final class Updater
    implements AbstractScopedSettings.SettingUpdater<T> {
        private final Consumer<T> consumer;
        private final Logger logger;
        private final Consumer<T> accept;

        Updater(Consumer<T> consumer, Logger logger, Consumer<T> accept) {
            this.consumer = consumer;
            this.logger = logger;
            this.accept = accept;
        }

        public String toString() {
            return "Updater for: " + Setting.this.toString();
        }

        @Override
        public boolean hasChanged(Settings current, Settings previous) {
            String newValue = Setting.this.getRaw(current);
            String value = Setting.this.getRaw(previous);
            assert (!Setting.this.isGroupSetting()) : "group settings must override this method";
            assert (value != null) : "value was null but can't be unless default is null which is invalid";
            return !value.equals(newValue);
        }

        @Override
        public T getValue(Settings current, Settings previous) {
            String newValue = Setting.this.getRaw(current);
            String value = Setting.this.getRaw(previous);
            try {
                Object inst = Setting.this.get(current);
                this.accept.accept(inst);
                return inst;
            }
            catch (AssertionError | Exception e) {
                if (Setting.this.isFiltered()) {
                    throw new IllegalArgumentException("illegal value can't update [" + Setting.this.key + "]");
                }
                throw new IllegalArgumentException("illegal value can't update [" + Setting.this.key + "] from [" + value + "] to [" + newValue + "]", (Throwable)e);
            }
        }

        @Override
        public void apply(T value, Settings current, Settings previous) {
            Setting.logSettingUpdate(Setting.this, current, previous, this.logger);
            this.consumer.accept(value);
        }
    }

    private static class GroupSetting
    extends Setting<Settings> {
        private final String key;
        private final Consumer<Settings> validator;

        private GroupSetting(String key, Consumer<Settings> validator, Property ... properties) {
            super((Key)new GroupKey(key), (Settings s) -> "", (String s) -> null, properties);
            this.key = key;
            this.validator = validator;
        }

        @Override
        public boolean isGroupSetting() {
            return true;
        }

        @Override
        public String innerGetRaw(Settings settings) {
            Settings subSettings = this.get(settings);
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.startObject();
                subSettings.toXContent(builder, EMPTY_PARAMS);
                builder.endObject();
                return Strings.toString(builder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Settings get(Settings settings) {
            Settings byPrefix = settings.getByPrefix(this.getKey());
            this.validator.accept(byPrefix);
            return byPrefix;
        }

        @Override
        public boolean exists(Settings settings) {
            for (String settingsKey : settings.keySet()) {
                if (!settingsKey.startsWith(this.key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
            Set<String> leftGroup = this.get(source).keySet();
            Settings defaultGroup = this.get(defaultSettings);
            builder.put(Settings.builder().put(defaultGroup.filter(k -> !leftGroup.contains(k)), false).normalizePrefix(this.getKey()).build(), false);
        }

        @Override
        public AbstractScopedSettings.SettingUpdater<Settings> newUpdater(final Consumer<Settings> consumer, final Logger logger, final Consumer<Settings> validator) {
            if (!this.isDynamic()) {
                throw new IllegalStateException("setting [" + this.getKey() + "] is not dynamic");
            }
            final GroupSetting setting = this;
            return new AbstractScopedSettings.SettingUpdater<Settings>(){

                @Override
                public boolean hasChanged(Settings current, Settings previous) {
                    Settings previousSettings;
                    Settings currentSettings = this.get(current);
                    return !currentSettings.equals(previousSettings = this.get(previous));
                }

                @Override
                public Settings getValue(Settings current, Settings previous) {
                    Settings currentSettings = this.get(current);
                    Settings previousSettings = this.get(previous);
                    try {
                        validator.accept(currentSettings);
                    }
                    catch (AssertionError | Exception e) {
                        String err = "illegal value can't update [" + key + "]" + (this.isFiltered() ? "" : " from [" + previousSettings + "] to [" + currentSettings + "]");
                        throw new IllegalArgumentException(err, (Throwable)e);
                    }
                    return currentSettings;
                }

                @Override
                public void apply(Settings value, Settings current, Settings previous) {
                    Setting.logSettingUpdate(this, current, previous, logger);
                    consumer.accept(value);
                }

                public String toString() {
                    return "Updater for: " + setting.toString();
                }
            };
        }
    }

    public static final class AffixKey
    implements Key {
        private final Pattern pattern;
        private final String prefix;
        private final String suffix;

        AffixKey(String prefix) {
            this(prefix, null);
        }

        AffixKey(String prefix, String suffix) {
            assert (prefix != null || suffix != null) : "Either prefix or suffix must be non-null";
            this.prefix = prefix;
            if (!prefix.endsWith(".")) {
                throw new IllegalArgumentException("prefix must end with a '.'");
            }
            this.suffix = suffix;
            this.pattern = suffix == null ? Pattern.compile("(" + Pattern.quote(prefix) + "((?:[-\\w]+[.])*[-\\w]+$))") : Pattern.compile("(" + Pattern.quote(prefix) + "([-\\w]+)\\." + Pattern.quote(suffix) + ")(?:\\..*)?");
        }

        @Override
        public boolean match(String key) {
            return this.pattern.matcher(key).matches();
        }

        String getConcreteString(String key) {
            Matcher matcher = this.pattern.matcher(key);
            if (!matcher.matches()) {
                throw new IllegalStateException("can't get concrete string for key " + key + " key doesn't match");
            }
            return matcher.group(1);
        }

        String getNamespace(String key) {
            Matcher matcher = this.pattern.matcher(key);
            if (!matcher.matches()) {
                throw new IllegalStateException("can't get concrete string for key " + key + " key doesn't match");
            }
            return matcher.group(2);
        }

        public SimpleKey toConcreteKey(String missingPart) {
            StringBuilder key = new StringBuilder();
            if (this.prefix != null) {
                key.append(this.prefix);
            }
            key.append(missingPart);
            if (this.suffix != null) {
                key.append(".");
                key.append(this.suffix);
            }
            return new SimpleKey(key.toString());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.prefix != null) {
                sb.append(this.prefix);
            }
            if (this.suffix != null) {
                sb.append('*');
                sb.append('.');
                sb.append(this.suffix);
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AffixKey that = (AffixKey)o;
            return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.suffix, that.suffix);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.suffix);
        }
    }

    public static interface AffixSettingDependency
    extends SettingDependency {
        @Override
        public AffixSetting getSetting();
    }

    public static final class ListKey
    extends SimpleKey {
        private final Pattern pattern;

        public ListKey(String key) {
            super(key);
            this.pattern = Pattern.compile(Pattern.quote(key) + "(\\.\\d+)?");
        }

        @Override
        public boolean match(String toTest) {
            return this.pattern.matcher(toTest).matches();
        }
    }

    public static final class GroupKey
    extends SimpleKey {
        public GroupKey(String key) {
            super(key);
            if (!key.endsWith(".")) {
                throw new IllegalArgumentException("key must end with a '.'");
            }
        }

        @Override
        public boolean match(String toTest) {
            return Regex.simpleMatch(this.key + "*", toTest);
        }
    }

    public static interface SettingDependency {
        public Setting getSetting();

        default public void validate(String key, Object value, Object dependency) {
        }
    }
}

