/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.node.DResolvedType;
import org.elasticsearch.painless.node.DType;

public class DUnresolvedType
extends DType {
    protected final String typeName;

    public DUnresolvedType(Location location, String typeName) {
        super(location);
        this.typeName = Objects.requireNonNull(typeName);
    }

    @Override
    public DResolvedType resolveType(PainlessLookup painlessLookup) {
        Class<?> type = painlessLookup.canonicalTypeNameToType(this.typeName);
        if (type == null) {
            throw this.location.createError(new IllegalArgumentException("cannot resolve type [" + this.typeName + "]"));
        }
        return new DResolvedType(this.location, type);
    }

    public String toString() {
        return "(DUnresolvedType [" + this.typeName + "])";
    }
}

