/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatableNumberListValue
extends AnimatableValue {
    protected float[] numbers;

    protected AnimatableNumberListValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableNumberListValue(AnimationTarget animationTarget, float[] fArray) {
        super(animationTarget);
        this.numbers = fArray;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f, AnimatableValue animatableValue3, int n) {
        AnimatableNumberListValue animatableNumberListValue;
        AnimatableNumberListValue animatableNumberListValue2 = (AnimatableNumberListValue)animatableValue2;
        AnimatableNumberListValue animatableNumberListValue3 = (AnimatableNumberListValue)animatableValue3;
        boolean bl = animatableValue2 != null;
        boolean bl2 = animatableValue3 != null;
        boolean bl3 = !(bl && animatableNumberListValue2.numbers.length != this.numbers.length || bl2 && animatableNumberListValue3.numbers.length != this.numbers.length);
        float[] fArray = !bl3 && bl && (double)f >= 0.5 ? animatableNumberListValue2.numbers : this.numbers;
        int n2 = fArray.length;
        if (animatableValue == null) {
            animatableNumberListValue = new AnimatableNumberListValue(this.target);
            animatableNumberListValue.numbers = new float[n2];
        } else {
            animatableNumberListValue = (AnimatableNumberListValue)animatableValue;
            if (animatableNumberListValue.numbers == null || animatableNumberListValue.numbers.length != n2) {
                animatableNumberListValue.numbers = new float[n2];
            }
        }
        for (int i = 0; i < n2; ++i) {
            float f2 = fArray[i];
            if (bl3) {
                if (bl) {
                    f2 += f * (animatableNumberListValue2.numbers[i] - f2);
                }
                if (bl2) {
                    f2 += (float)n * animatableNumberListValue3.numbers[i];
                }
            }
            if (animatableNumberListValue.numbers[i] == f2) continue;
            animatableNumberListValue.numbers[i] = f2;
            animatableNumberListValue.hasChanged = true;
        }
        return animatableNumberListValue;
    }

    public float[] getNumbers() {
        return this.numbers;
    }

    @Override
    public boolean canPace() {
        return false;
    }

    @Override
    public float distanceTo(AnimatableValue animatableValue) {
        return 0.0f;
    }

    @Override
    public AnimatableValue getZeroValue() {
        float[] fArray = new float[this.numbers.length];
        return new AnimatableNumberListValue(this.target, fArray);
    }

    @Override
    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.numbers[0]);
        for (int i = 1; i < this.numbers.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(this.numbers[i]);
        }
        return stringBuffer.toString();
    }
}

