/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import com.inet.jortho.SpellChecker;
import freemind.controller.Controller;
import freemind.controller.LastStateStorageManagement;
import freemind.controller.MenuBar;
import freemind.controller.actions.generated.instance.MindmapLastStateStorage;
import freemind.main.EditServer;
import freemind.main.FeedBack;
import freemind.main.FreeMindCommon;
import freemind.main.FreeMindMain;
import freemind.main.FreeMindSecurityManager;
import freemind.main.FreeMindSplashModern;
import freemind.main.FreeMindStarter;
import freemind.main.HtmlTools;
import freemind.main.LogFileLogHandler;
import freemind.main.LoggingOutputStream;
import freemind.main.Resources;
import freemind.main.StdFormatter;
import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.preferences.FreemindPropertyListener;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FreeMind
extends JFrame
implements FreeMindMain {
    public static final String J_SPLIT_PANE_SPLIT_TYPE = "JSplitPane.SPLIT_TYPE";
    public static final String VERTICAL_SPLIT_BELOW = "vertical_split_below";
    public static final String HORIZONTAL_SPLIT_RIGHT = "horizontal_split_right";
    public static final String LOG_FILE_NAME = "log";
    private static final String PORT_FILE = "portFile";
    private static final String FREE_MIND_PROGRESS_LOAD_MAPS = "FreeMind.progress.loadMaps";
    private static final String FREE_MIND_PROGRESS_LOAD_MAPS_NAME = "FreeMind.progress.loadNamedMaps";
    private static final String SPLIT_PANE_POSITION = "split_pane_position";
    private static final String SPLIT_PANE_LAST_POSITION = "split_pane_last_position";
    public static final String RESOURCE_LOOKANDFEEL = "lookandfeel";
    public static final String RESOURCES_SELECTION_METHOD = "selection_method";
    public static final String RESOURCES_NODE_STYLE = "standardnodestyle";
    public static final String RESOURCES_ROOT_NODE_STYLE = "standardrootnodestyle";
    public static final String RESOURCES_NODE_TEXT_COLOR = "standardnodetextcolor";
    public static final String RESOURCES_SELECTED_NODE_COLOR = "standardselectednodecolor";
    public static final String RESOURCES_SELECTED_NODE_RECTANGLE_COLOR = "standardselectednoderectanglecolor";
    public static final String RESOURCE_DRAW_RECTANGLE_FOR_SELECTION = "standarddrawrectangleforselection";
    public static final String RESOURCES_EDGE_COLOR = "standardedgecolor";
    public static final String RESOURCES_EDGE_STYLE = "standardedgestyle";
    public static final String RESOURCES_CLOUD_COLOR = "standardcloudcolor";
    public static final String RESOURCES_LINK_COLOR = "standardlinkcolor";
    public static final String RESOURCES_BACKGROUND_COLOR = "standardbackgroundcolor";
    public static final String RESOURCE_PRINT_ON_WHITE_BACKGROUND = "printonwhitebackground";
    public static final String RESOURCES_WHEEL_VELOCITY = "wheel_velocity";
    public static final String RESOURCES_USE_TABBED_PANE = "use_tabbed_pane";
    public static final String RESOURCES_USE_SPLIT_PANE = "use_split_pane";
    public static final String RESOURCES_DELETE_NODES_WITHOUT_QUESTION = "delete_nodes_without_question";
    public static final String RESOURCES_RELOAD_FILES_WITHOUT_QUESTION = "reload_files_without_question";
    private Logger logger = null;
    protected static final FreeMindMain.VersionInformation VERSION = new FreeMindMain.VersionInformation("1.0.1");
    public static final String XML_VERSION = "1.0.1";
    public static final String RESOURCES_REMIND_USE_RICH_TEXT_IN_NEW_LONG_NODES = "remind_use_rich_text_in_new_long_nodes";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_ASKING = "resources_execute_scripts_without_asking";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_FILE_RESTRICTION = "resources_execute_scripts_without_file_restriction";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_NETWORK_RESTRICTION = "resources_execute_scripts_without_network_restriction";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_EXEC_RESTRICTION = "resources_execute_scripts_without_exec_restriction";
    public static final String RESOURCES_SCRIPT_USER_KEY_NAME_FOR_SIGNING = "resources_script_user_key_name_for_signing";
    public static final String RESOURCES_CONVERT_TO_CURRENT_VERSION = "resources_convert_to_current_version";
    public static final String RESOURCES_CUT_NODES_WITHOUT_QUESTION = "resources_cut_nodes_without_question";
    public static final String RESOURCES_DON_T_SHOW_NOTE_ICONS = "resources_don_t_show_note_icons";
    public static final String RESOURCES_REMOVE_NOTES_WITHOUT_QUESTION = "resources_remove_notes_without_question";
    public static final String RESOURCES_SAVE_FOLDING_STATE = "resources_save_folding_state";
    public static final String RESOURCES_SIGNED_SCRIPT_ARE_TRUSTED = "resources_signed_script_are_trusted";
    public static final String RESOURCES_USE_DEFAULT_FONT_FOR_NOTES_TOO = "resources_use_default_font_for_notes_too";
    public static final String RESOURCES_USE_MARGIN_TOP_ZERO_FOR_NOTES = "resources_use_margin_top_zero_for_notes";
    public static final String RESOURCES_DON_T_SHOW_CLONE_ICONS = "resources_don_t_show_clone_icons";
    public static final String RESOURCES_DON_T_OPEN_PORT = "resources_don_t_open_port";
    public static final String KEYSTROKE_MOVE_MAP_LEFT = "keystroke_MoveMapLeft";
    public static final String KEYSTROKE_MOVE_MAP_RIGHT = "keystroke_MoveMapRight";
    public static final String KEYSTROKE_PREVIOUS_MAP = "keystroke_previousMap";
    public static final String KEYSTROKE_NEXT_MAP = "keystroke_nextMap";
    public static final String RESOURCES_SEARCH_IN_NOTES_TOO = "resources_search_in_notes_too";
    public static final String RESOURCES_DON_T_SHOW_NOTE_TOOLTIPS = "resources_don_t_show_note_tooltips";
    public static final String RESOURCES_SEARCH_FOR_NODE_TEXT_WITHOUT_QUESTION = "resources_search_for_node_text_without_question";
    public static final String RESOURCES_COMPLETE_CLONING = "complete_cloning";
    public static final String RESOURCES_CLONE_TYPE_COMPLETE_CLONE = "COMPLETE_CLONE";
    public static final String TOOLTIP_DISPLAY_TIME = "tooltip_display_time";
    public static final String PROXY_PORT = "proxy.port";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PASSWORD = "proxy.password";
    public static final String PROXY_USER = "proxy.user";
    public static final String PROXY_IS_AUTHENTICATED = "proxy.is_authenticated";
    public static final String PROXY_USE_SETTINGS = "proxy.use_settings";
    public static final String RESOURCES_DISPLAY_FOLDING_BUTTONS = "resources_display_folding_buttons";
    public static Properties props;
    private static Properties defProps;
    private MenuBar menuBar;
    private JLabel status;
    private Map filetypes;
    private File autoPropertiesFile;
    private File patternsFile;
    Controller controller;
    private FreeMindCommon mFreeMindCommon;
    private static FileHandler mFileHandler;
    private static boolean mFileHandlerError;
    private JScrollPane mScrollPane = null;
    private JSplitPane mSplitPane;
    private JComponent mContentComponent = null;
    private JTabbedPane mTabbedPane = null;
    private ImageIcon mWindowIcon;
    private boolean mStartupDone = false;
    private List mStartupDoneListeners = new Vector();
    private EditServer mEditServer = null;
    private Vector mLoggerList = new Vector();
    private static LogFileLogHandler sLogFileHandler;

    public FreeMind(Properties pDefaultPreferences, Properties pUserPreferences, File pAutoPropertiesFile) {
        super("FreeMind");
        System.setSecurityManager(new FreeMindSecurityManager());
        defProps = pDefaultPreferences;
        props = pUserPreferences;
        this.autoPropertiesFile = pAutoPropertiesFile;
        if (this.logger == null) {
            this.logger = this.getLogger(FreeMind.class.getName());
            StringBuffer info = new StringBuffer();
            info.append("freemind_version = ");
            info.append(VERSION);
            info.append("; freemind_xml_version = ");
            info.append(XML_VERSION);
            try {
                String propsLoc = "version.properties";
                URL versionUrl = this.getClass().getClassLoader().getResource(propsLoc);
                Properties buildNumberPros = new Properties();
                InputStream stream = versionUrl.openStream();
                buildNumberPros.load(stream);
                info.append("\nBuild: " + buildNumberPros.getProperty("build.number") + "\n");
                stream.close();
            }
            catch (Exception e) {
                info.append("Problems reading build number file: " + e);
            }
            info.append("\njava_version = ");
            info.append(System.getProperty("java.version"));
            info.append("; os_name = ");
            info.append(System.getProperty("os.name"));
            info.append("; os_version = ");
            info.append(System.getProperty("os.version"));
            this.logger.info(info.toString());
        }
        this.mFreeMindCommon = new FreeMindCommon(this);
        Resources.createInstance(this);
    }

    void init(FeedBack feedback) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.patternsFile = new File(this.getFreemindDirectory(), this.getDefaultProperty("patternsfile"));
        feedback.increase("FreeMind.progress.updateLookAndFeel", null);
        this.updateLookAndFeel();
        feedback.increase("FreeMind.progress.createController", null);
        this.setIconImage(this.mWindowIcon.getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.controller = new Controller(this);
        this.controller.init();
        feedback.increase("FreeMind.progress.settingPreferences", null);
        Controller.addPropertyChangeListener(new FreemindPropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals("language")) {
                    FreeMind.this.mFreeMindCommon.clearLanguageResources();
                    FreeMind.this.getResources();
                }
            }
        });
        this.controller.optionAntialiasAction.changeAntialias(this.getProperty("antialias"));
        this.setupSpellChecking();
        this.setupProxy();
        feedback.increase("FreeMind.progress.propageteLookAndFeel", null);
        SwingUtilities.updateComponentTreeUI(this);
        feedback.increase("FreeMind.progress.buildScreen", null);
        this.setScreenBounds();
        feedback.increase("FreeMind.progress.createInitialMode", null);
        this.controller.createNewMode(this.getProperty("initial_mode"));
    }

    private void updateLookAndFeel() {
        try {
            String lookAndFeel = props.getProperty(RESOURCE_LOOKANDFEEL);
            if (lookAndFeel.equals("windows")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (lookAndFeel.equals("motif")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (lookAndFeel.equals("mac")) {
                UIManager.setLookAndFeel("javax.swing.plaf.mac.MacLookAndFeel");
            } else if (lookAndFeel.equals("metal")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (lookAndFeel.equals("gtk")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else if (!lookAndFeel.equals("nothing")) {
                if (lookAndFeel.indexOf(46) != -1) {
                    UIManager.setLookAndFeel(lookAndFeel);
                } else {
                    this.logger.info("Default (System) Look & Feel: " + UIManager.getSystemLookAndFeelClassName());
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Unable to set Look & Feel.");
        }
        this.mFreeMindCommon.loadUIProperties(defProps);
    }

    @Override
    public boolean isApplet() {
        return false;
    }

    @Override
    public File getPatternsFile() {
        return this.patternsFile;
    }

    @Override
    public FreeMindMain.VersionInformation getFreemindVersion() {
        return VERSION;
    }

    @Override
    public int getWinHeight() {
        return this.getHeight();
    }

    @Override
    public int getWinWidth() {
        return this.getWidth();
    }

    @Override
    public int getWinX() {
        return this.getX();
    }

    @Override
    public int getWinY() {
        return this.getY();
    }

    @Override
    public int getWinState() {
        return this.getExtendedState();
    }

    @Override
    public URL getResource(String name) {
        return this.getClass().getClassLoader().getResource(name);
    }

    @Override
    public String getProperty(String key) {
        return props.getProperty(key);
    }

    @Override
    public int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    @Override
    public Properties getProperties() {
        return props;
    }

    @Override
    public void setProperty(String key, String value) {
        props.setProperty(key, value);
    }

    public String getDefaultProperty(String key) {
        return defProps.getProperty(key);
    }

    @Override
    public void setDefaultProperty(String key, String value) {
        defProps.setProperty(key, value);
    }

    @Override
    public String getFreemindDirectory() {
        return System.getProperty("user.home") + File.separator + this.getProperty("properties_folder");
    }

    @Override
    public void saveProperties(boolean pIsShutdown) {
        try {
            FileOutputStream out = new FileOutputStream(this.autoPropertiesFile);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)out, "8859_1");
            outputStreamWriter.write("#FreeMind ");
            outputStreamWriter.write(VERSION.toString());
            outputStreamWriter.write(10);
            outputStreamWriter.flush();
            Properties toBeStored = Tools.copyChangedProperties(props, defProps);
            toBeStored.store(out, null);
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            Resources.getInstance().logException(ex);
        }
        this.getController().getFilterController().saveConditions();
        if (pIsShutdown && this.mEditServer != null) {
            this.mEditServer.stopServer();
        }
    }

    @Override
    public MapView getView() {
        return this.controller.getView();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public void setView(MapView view) {
        this.mScrollPane.setViewportView(view);
    }

    @Override
    public MenuBar getFreeMindMenuBar() {
        return this.menuBar;
    }

    @Override
    public void out(String msg) {
        if (this.status != null) {
            this.status.setText(msg);
        }
    }

    @Override
    public void err(String msg) {
        if (this.status != null) {
            this.status.setText(msg);
        }
    }

    @Override
    public void openDocument(URL url) throws Exception {
        block16: {
            String correctedUrl = new String(url.toExternalForm());
            if (url.getProtocol().equals("file")) {
                correctedUrl = correctedUrl.replace('\\', '/').replaceAll(" ", "%20");
            }
            String osName = System.getProperty("os.name");
            String urlString = url.toString();
            if (osName.substring(0, 3).equals("Win")) {
                String propertyString = new String("default_browser_command_windows");
                propertyString = osName.indexOf("9") != -1 || osName.indexOf("Me") != -1 ? propertyString + "_9x" : propertyString + "_nt";
                String browser_command = new String();
                String command = new String();
                try {
                    Object[] messageArguments = new Object[]{urlString};
                    MessageFormat formatter = new MessageFormat(this.getProperty(propertyString));
                    browser_command = formatter.format(messageArguments);
                    if (url.getProtocol().equals("file")) {
                        File file = Tools.urlToFile(url);
                        if (!Tools.isBelowJava6()) {
                            Class<?> desktopClass = Class.forName("java.awt.Desktop");
                            Method getDesktopMethod = desktopClass.getMethod("getDesktop", new Class[0]);
                            Object desktopObject = getDesktopMethod.invoke(null, new Object[0]);
                            Method openMethod = desktopObject.getClass().getMethod("open", File.class);
                            this.logger.info("Opening file " + file);
                            openMethod.invoke(desktopObject, file);
                            return;
                        }
                        command = "cmd /C rundll32 url.dll,FileProtocolHandler " + urlString;
                        if (System.getProperty("os.name").startsWith("Windows 2000")) {
                            command = "cmd /C rundll32 shell32.dll,ShellExec_RunDLL " + urlString;
                        }
                    } else {
                        command = urlString.startsWith("mailto:") ? "cmd /C rundll32 url.dll,FileProtocolHandler " + urlString : browser_command;
                    }
                    this.logger.info("Starting browser with " + command);
                    this.execWindows(command);
                }
                catch (IOException x) {
                    this.controller.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + command + "\".\n\nYou may look at the user or default property called '" + propertyString + "'.");
                    System.err.println("Caught: " + x);
                }
            } else if (osName.startsWith("Mac OS")) {
                String browser_command = new String();
                try {
                    Object[] messageArguments = new Object[]{correctedUrl, urlString};
                    if ("file".equals(url.getProtocol())) {
                        File file = Tools.urlToFile(url);
                        Object[] command = new String[]{this.getProperty("default_browser_command_mac_open"), "file:" + file.getAbsolutePath()};
                        this.logger.info("Starting command: " + Arrays.deepToString(command));
                        Runtime.getRuntime().exec((String[])command, null, null);
                        break block16;
                    }
                    MessageFormat formatter = new MessageFormat(this.getProperty("default_browser_command_mac"));
                    browser_command = formatter.format(messageArguments);
                    this.logger.info("Starting command: " + browser_command);
                    Runtime.getRuntime().exec(browser_command);
                }
                catch (IOException ex2) {
                    this.controller.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + browser_command + "\".\n\nYou may look at the user or default property called 'default_browser_command_mac'.");
                    System.err.println("Caught: " + ex2);
                }
            } else {
                String browser_command = new String();
                try {
                    Object[] messageArguments = new Object[]{correctedUrl, urlString};
                    MessageFormat formatter = new MessageFormat(this.getProperty("default_browser_command_other_os"));
                    browser_command = formatter.format(messageArguments);
                    this.logger.info("Starting command: " + browser_command);
                    Runtime.getRuntime().exec(browser_command);
                }
                catch (IOException ex2) {
                    this.controller.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + browser_command + "\".\n\nYou may look at the user or default property called 'default_browser_command_other_os'.");
                    System.err.println("Caught: " + ex2);
                }
            }
        }
    }

    private void execWindows(String pCommand) throws IOException {
        StringTokenizer st = new StringTokenizer(pCommand, " ");
        Object[] cmd = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmd[i++] = st.nextToken();
        }
        HashMap<String, String> newEnv = new HashMap<String, String>();
        newEnv.putAll(System.getenv());
        String envName = "JENV_1";
        newEnv.put(envName, cmd[cmd.length - 1]);
        cmd[cmd.length - 1] = "%" + envName + "%";
        this.logger.info("Starting command array " + Arrays.toString(cmd) + ", and env for " + envName + " = " + HtmlTools.unicodeToHTMLUnicodeEntity((String)newEnv.get(envName), true));
        ProcessBuilder pb = new ProcessBuilder((String[])cmd);
        Map<String, String> env = pb.environment();
        env.putAll(newEnv);
        Process p = pb.start();
    }

    private String transpose(String input, char findChar, String replaceString) {
        String res = new String();
        for (int i = 0; i < input.length(); ++i) {
            char d = input.charAt(i);
            res = d == findChar ? res + replaceString : res + d;
        }
        return res;
    }

    @Override
    public void setWaitingCursor(boolean waiting) {
        if (waiting) {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getRootPane().getGlassPane().setVisible(true);
        } else {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getRootPane().getGlassPane().setVisible(false);
        }
    }

    private String getProgramForFile(String type) {
        if (this.filetypes == null) {
            this.filetypes = new HashMap();
            String raw = this.getProperty("filetypes");
            if (raw == null || raw.equals("")) {
                return "";
            }
            StringTokenizer tokens = new StringTokenizer(raw, ",");
            while (tokens.hasMoreTokens()) {
                StringTokenizer pair = new StringTokenizer(tokens.nextToken(), ":");
                String key = pair.nextToken().trim().toLowerCase();
                String value = pair.nextToken().trim();
                this.filetypes.put(key, value);
            }
        }
        return (String)this.filetypes.get(type.trim().toLowerCase());
    }

    @Override
    public ResourceBundle getResources() {
        return this.mFreeMindCommon.getResources();
    }

    @Override
    public String getResourceString(String resource) {
        return this.mFreeMindCommon.getResourceString(resource);
    }

    @Override
    public String getResourceString(String key, String pDefault) {
        return this.mFreeMindCommon.getResourceString(key, pDefault);
    }

    @Override
    public Logger getLogger(String forClass) {
        Logger loggerForClass = Logger.getLogger(forClass);
        this.mLoggerList.add(loggerForClass);
        if (mFileHandler == null && !mFileHandlerError) {
            Logger parentLogger = loggerForClass.getParent();
            Handler[] handlers = parentLogger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                Handler handler = handlers[i];
                if (!(handler instanceof ConsoleHandler)) continue;
                parentLogger.removeHandler(handler);
            }
            try {
                mFileHandler = new FileHandler(this.getFreemindDirectory() + File.separator + LOG_FILE_NAME, 1400000, 5, false);
                mFileHandler.setFormatter(new StdFormatter());
                mFileHandler.setLevel(Level.INFO);
                parentLogger.addHandler(mFileHandler);
                ConsoleHandler stdConsoleHandler = new ConsoleHandler();
                stdConsoleHandler.setFormatter(new StdFormatter());
                stdConsoleHandler.setLevel(Level.WARNING);
                parentLogger.addHandler(stdConsoleHandler);
                sLogFileHandler = new LogFileLogHandler();
                sLogFileHandler.setFormatter(new SimpleFormatter());
                sLogFileHandler.setLevel(Level.INFO);
                Logger logger = Logger.getLogger(StdFormatter.STDOUT.getName());
                LoggingOutputStream los = new LoggingOutputStream(logger, StdFormatter.STDOUT);
                System.setOut(new PrintStream(los, true));
                logger = Logger.getLogger(StdFormatter.STDERR.getName());
                los = new LoggingOutputStream(logger, StdFormatter.STDERR);
                System.setErr(new PrintStream(los, true));
            }
            catch (Exception e) {
                System.err.println("Error creating logging File Handler");
                e.printStackTrace();
                mFileHandlerError = true;
            }
        }
        if (sLogFileHandler != null) {
            loggerForClass.addHandler(sLogFileHandler);
        }
        return loggerForClass;
    }

    public static void main(String[] args, Properties pDefaultPreferences, Properties pUserPreferences, File pAutoPropertiesFile) {
        final FreeMind frame = new FreeMind(pDefaultPreferences, pUserPreferences, pAutoPropertiesFile);
        FreeMindSplashModern splash = null;
        frame.checkForAnotherInstance(args);
        frame.initServer();
        splash = new FreeMindSplashModern(frame);
        splash.setVisible(true);
        FeedBack feedBack = splash.getFeedBack();
        frame.mWindowIcon = splash.getWindowIcon();
        feedBack.setMaximumValue(10 + frame.getMaximumNumberOfMapsToLoad(args));
        frame.init(feedBack);
        feedBack.increase("FreeMind.progress.startCreateController", null);
        ModeController ctrl = frame.createModeController(args);
        feedBack.increase(FREE_MIND_PROGRESS_LOAD_MAPS, null);
        frame.loadMaps(args, ctrl, feedBack);
        Tools.waitForEventQueue();
        feedBack.increase("FreeMind.progress.endStartup", null);
        frame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                frame.getController().obtainFocusForSelected();
                frame.removeWindowFocusListener(this);
            }
        });
        frame.setVisible(true);
        if (splash != null) {
            splash.setVisible(false);
        }
        frame.fireStartupDone();
    }

    private void setupSpellChecking() {
        boolean checkSpelling = Tools.safeEquals("true", props.getProperty("check_spelling"));
        if (checkSpelling) {
            try {
                String decodedPath = Tools.getFreeMindBasePath();
                URL url = null;
                if (new File(decodedPath).exists()) {
                    url = new URL("file", null, decodedPath);
                }
                SpellChecker.registerDictionaries(url, (String)Locale.getDefault().getLanguage());
            }
            catch (MalformedURLException e) {
                Resources.getInstance().logException(e);
            }
            catch (UnsupportedEncodingException e) {
                Resources.getInstance().logException(e);
            }
        }
    }

    private void setupProxy() {
        if ("true".equals(props.getProperty(PROXY_USE_SETTINGS))) {
            if ("true".equals(props.getProperty(PROXY_IS_AUTHENTICATED))) {
                Authenticator.setDefault(new FreeMindStarter.ProxyAuthenticator(props.getProperty(PROXY_USER), Tools.decompress(props.getProperty(PROXY_PASSWORD))));
            }
            System.setProperty("http.proxyHost", props.getProperty(PROXY_HOST));
            System.setProperty("http.proxyPort", props.getProperty(PROXY_PORT));
        }
    }

    private void initServer() {
        String portFile = this.getPortFile();
        if (portFile == null) {
            return;
        }
        this.mEditServer = new EditServer(portFile, this);
        this.mEditServer.start();
    }

    private void checkForAnotherInstance(String[] pArgs) {
        String portFile = this.getPortFile();
        if (portFile == null) {
            return;
        }
        if (portFile != null && new File(portFile).exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(portFile));
                String check = in.readLine();
                if (!check.equals("b")) {
                    throw new Exception("Wrong port file format");
                }
                int port = Integer.parseInt(in.readLine());
                int key = Integer.parseInt(in.readLine());
                Socket socket = new Socket(InetAddress.getByName("127.0.0.1"), port);
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                out.writeInt(key);
                String script = Tools.arrayToUrls(pArgs);
                out.writeUTF(script);
                this.logger.info("Waiting for server");
                try {
                    socket.getInputStream().read();
                }
                catch (Exception e) {
                    // empty catch block
                }
                in.close();
                out.close();
                System.exit(0);
            }
            catch (Exception e) {
                this.logger.info("An error occurred while connecting to the FreeMind server instance. This probably means that FreeMind crashed and/or exited abnormally the last time it was run. If you don't know what this means, don't worry. Exception: " + e);
            }
        }
    }

    private String getPortFile() {
        if (this.mEditServer == null && Resources.getInstance().getBoolProperty(RESOURCES_DON_T_OPEN_PORT)) {
            return null;
        }
        return this.getFreemindDirectory() + File.separator + this.getProperty(PORT_FILE);
    }

    private void fireStartupDone() {
        this.mStartupDone = true;
        for (FreeMindMain.StartupDoneListener listener : this.mStartupDoneListeners) {
            listener.startupDone();
        }
    }

    private void setScreenBounds() {
        this.menuBar = new MenuBar(this.controller);
        this.setJMenuBar(this.menuBar);
        this.mScrollPane = new MapView.ScrollPane();
        if (Resources.getInstance().getBoolProperty("no_scrollbar")) {
            this.mScrollPane.setVerticalScrollBarPolicy(21);
            this.mScrollPane.setHorizontalScrollBarPolicy(31);
        } else {
            this.mScrollPane.setVerticalScrollBarPolicy(22);
            this.mScrollPane.setHorizontalScrollBarPolicy(32);
        }
        this.status = new JLabel("!");
        this.status.setPreferredSize(this.status.getPreferredSize());
        this.status.setText("");
        this.mContentComponent = this.mScrollPane;
        boolean shouldUseTabbedPane = Resources.getInstance().getBoolProperty(RESOURCES_USE_TABBED_PANE);
        if (shouldUseTabbedPane) {
            InputMap map = (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
            KeyStroke keyStrokeCtrlUp = KeyStroke.getKeyStroke(38, 128);
            map.remove(keyStrokeCtrlUp);
            this.mTabbedPane = new JTabbedPane();
            this.mTabbedPane.setFocusable(false);
            this.controller.addTabbedPane(this.mTabbedPane);
            this.getContentPane().add((Component)this.mTabbedPane, "Center");
        } else {
            this.getContentPane().add((Component)this.mContentComponent, "Center");
        }
        this.getContentPane().add((Component)this.status, "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FreeMind.this.controller.quit.actionPerformed(new ActionEvent(this, 0, "quit"));
            }
        });
        if (Tools.safeEquals(this.getProperty("toolbarVisible"), "false")) {
            this.controller.setToolbarVisible(false);
        }
        if (Tools.safeEquals(this.getProperty("leftToolbarVisible"), "false")) {
            this.controller.setLeftToolbarVisible(false);
        }
        this.setFocusTraversalKeysEnabled(false);
        this.pack();
        int win_width = this.getIntProperty("appwindow_width", 0);
        int win_height = this.getIntProperty("appwindow_height", 0);
        int win_x = this.getIntProperty("appwindow_x", 0);
        int win_y = this.getIntProperty("appwindow_y", 0);
        win_width = win_width > 0 ? win_width : 640;
        win_height = win_height > 0 ? win_height : 440;
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Insets screenInsets = defaultToolkit.getScreenInsets(this.getGraphicsConfiguration());
        Dimension screenSize = defaultToolkit.getScreenSize();
        int screenWidth = screenSize.width - screenInsets.left - screenInsets.right;
        win_width = Math.min(win_width, screenWidth);
        int screenHeight = screenSize.height - screenInsets.top - screenInsets.bottom;
        win_height = Math.min(win_height, screenHeight);
        win_x = Math.max(screenInsets.left, win_x);
        win_x = Math.min(screenWidth + screenInsets.left - win_width, win_x);
        win_y = Math.max(screenInsets.top, win_y);
        win_y = Math.min(screenWidth + screenInsets.top - win_height, win_y);
        this.setBounds(win_x, win_y, win_width, win_height);
        int win_state = Integer.parseInt(props.getProperty("appwindow_state", "0"));
        win_state = (win_state & 1) != 0 ? 0 : win_state;
        this.setExtendedState(win_state);
    }

    private ModeController createModeController(String[] args) {
        ModeController ctrl = this.controller.getModeController();
        try {
            Class<?> macClass = Class.forName("accessories.plugins.MacChanges");
            macClass.getConstructors()[0].newInstance(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ctrl;
    }

    private int getMaximumNumberOfMapsToLoad(String[] args) {
        LastStateStorageManagement management = this.getLastStateStorageManagement();
        return Math.max(args.length + management.getLastOpenList().size(), 1);
    }

    private void loadMaps(String[] args, ModeController pModeController, FeedBack pFeedBack) {
        boolean fileLoaded = false;
        if (Tools.isPreferenceTrue(this.getProperty("load_last_maps_and_layout"))) {
            int index = 0;
            MapModule mapToFocus = null;
            LastStateStorageManagement management = this.getLastStateStorageManagement();
            for (MindmapLastStateStorage store : management.getLastOpenList()) {
                String restorable = store.getRestorableName();
                pFeedBack.increase(FREE_MIND_PROGRESS_LOAD_MAPS_NAME, new Object[]{restorable.replaceAll(".*/", "")});
                try {
                    if (this.controller.getLastOpenedList().open(restorable) && index == management.getLastFocussedTab()) {
                        mapToFocus = this.controller.getMapModule();
                    }
                    fileLoaded = true;
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                }
                ++index;
            }
            if (mapToFocus != null) {
                this.controller.getMapModuleManager().changeToMapModule(mapToFocus.getDisplayName());
            }
        }
        for (int i = 0; i < args.length; ++i) {
            String fileArgument = args[i];
            pFeedBack.increase(FREE_MIND_PROGRESS_LOAD_MAPS_NAME, new Object[]{fileArgument.replaceAll(".*/", "")});
            if (!fileArgument.toLowerCase().endsWith(".mm")) continue;
            if (!Tools.isAbsolutePath(fileArgument)) {
                fileArgument = System.getProperty("user.dir") + System.getProperty("file.separator") + fileArgument;
            }
            try {
                pModeController.load(new File(fileArgument));
                fileLoaded = true;
                continue;
            }
            catch (Exception ex) {
                System.err.println("File " + fileArgument + " not found error");
            }
        }
        if (!fileLoaded) {
            fileLoaded = this.processLoadEventFromStartupPhase();
        }
        if (!fileLoaded) {
            String restoreable = this.getProperty("onStartIfNotSpecified");
            if (Tools.isPreferenceTrue(this.getProperty("loadLastMap")) && restoreable != null && restoreable.length() > 0) {
                pFeedBack.increase(FREE_MIND_PROGRESS_LOAD_MAPS_NAME, new Object[]{restoreable.replaceAll(".*/", "")});
                try {
                    this.controller.getLastOpenedList().open(restoreable);
                    this.controller.getModeController().getView().moveToRoot();
                    fileLoaded = true;
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                    this.out("An error occured on opening the file: " + restoreable + ".");
                }
            }
        }
        if (!fileLoaded && Tools.isPreferenceTrue(this.getProperty("load_new_map_when_no_other_is_specified"))) {
            pModeController.newMap();
            pFeedBack.increase(FREE_MIND_PROGRESS_LOAD_MAPS, null);
        }
    }

    private LastStateStorageManagement getLastStateStorageManagement() {
        String lastStateMapXml = this.getProperty("mindmap_last_state_map_storage");
        LastStateStorageManagement management = new LastStateStorageManagement(lastStateMapXml);
        return management;
    }

    private boolean processLoadEventFromStartupPhase() {
        String propertyKey;
        boolean atLeastOneFileHasBeenLoaded = false;
        int count = 0;
        while (this.getProperty(propertyKey = "loadEventDuringStartup" + count) != null) {
            if (this.processLoadEventFromStartupPhase(propertyKey)) {
                atLeastOneFileHasBeenLoaded = true;
            }
            ++count;
        }
        return atLeastOneFileHasBeenLoaded;
    }

    private boolean processLoadEventFromStartupPhase(String propertyKey) {
        String filename = this.getProperty(propertyKey);
        try {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("Loading " + filename);
            }
            this.controller.getModeController().load(Tools.fileToUrl(new File(filename)));
            this.getProperties().remove(propertyKey);
            return true;
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            this.out("An error occured on opening the file: " + filename + ".");
            return false;
        }
    }

    @Override
    public JFrame getJFrame() {
        return this;
    }

    @Override
    public ClassLoader getFreeMindClassLoader() {
        return this.mFreeMindCommon.getFreeMindClassLoader();
    }

    @Override
    public String getFreemindBaseDir() {
        return this.mFreeMindCommon.getFreemindBaseDir();
    }

    @Override
    public String getAdjustableProperty(String label) {
        return this.mFreeMindCommon.getAdjustableProperty(label);
    }

    @Override
    public JSplitPane insertComponentIntoSplitPane(JComponent pMindMapComponent) {
        if (this.mSplitPane != null) {
            return this.mSplitPane;
        }
        this.removeContentComponent();
        int splitType = 0;
        String splitProperty = this.getProperty(J_SPLIT_PANE_SPLIT_TYPE);
        if (Tools.safeEquals(splitProperty, HORIZONTAL_SPLIT_RIGHT)) {
            splitType = 1;
        } else if (!Tools.safeEquals(splitProperty, VERTICAL_SPLIT_BELOW)) {
            this.logger.warning("Split type not known: " + splitProperty);
        }
        this.mSplitPane = new JSplitPane(splitType, this.mScrollPane, pMindMapComponent);
        this.mSplitPane.setContinuousLayout(true);
        this.mSplitPane.setOneTouchExpandable(false);
        this.mSplitPane.setResizeWeight(1.0);
        Tools.correctJSplitPaneKeyMap();
        this.mContentComponent = this.mSplitPane;
        this.setContentComponent();
        int splitPanePosition = this.getIntProperty(SPLIT_PANE_POSITION, -1);
        int lastSplitPanePosition = this.getIntProperty(SPLIT_PANE_LAST_POSITION, -1);
        if (splitPanePosition != -1 && lastSplitPanePosition != -1) {
            this.mSplitPane.setDividerLocation(splitPanePosition);
            this.mSplitPane.setLastDividerLocation(lastSplitPanePosition);
        }
        return this.mSplitPane;
    }

    @Override
    public void removeSplitPane() {
        if (this.mSplitPane != null) {
            this.setProperty(SPLIT_PANE_POSITION, "" + this.mSplitPane.getDividerLocation());
            this.setProperty(SPLIT_PANE_LAST_POSITION, "" + this.mSplitPane.getLastDividerLocation());
            this.removeContentComponent();
            this.mContentComponent = this.mScrollPane;
            this.setContentComponent();
            this.mSplitPane = null;
        }
    }

    private void removeContentComponent() {
        if (this.mTabbedPane != null) {
            if (this.mTabbedPane.getSelectedIndex() >= 0) {
                this.mTabbedPane.setComponentAt(this.mTabbedPane.getSelectedIndex(), new JPanel());
            }
        } else {
            this.getContentPane().remove(this.mContentComponent);
            this.getRootPane().revalidate();
        }
    }

    private void setContentComponent() {
        if (this.mTabbedPane != null) {
            if (this.mTabbedPane.getSelectedIndex() >= 0) {
                this.mTabbedPane.setComponentAt(this.mTabbedPane.getSelectedIndex(), this.mContentComponent);
            }
        } else {
            this.getContentPane().add((Component)this.mContentComponent, "Center");
            this.getRootPane().revalidate();
        }
    }

    @Override
    public JScrollPane getScrollPane() {
        return this.mScrollPane;
    }

    @Override
    public JComponent getContentComponent() {
        return this.mContentComponent;
    }

    @Override
    public void registerStartupDoneListener(FreeMindMain.StartupDoneListener pStartupDoneListener) {
        if (!this.mStartupDone) {
            this.mStartupDoneListeners.add(pStartupDoneListener);
        }
    }

    @Override
    public List getLoggerList() {
        return Collections.unmodifiableList(this.mLoggerList);
    }

    static {
        mFileHandlerError = false;
    }

    private class MyEventQueue
    extends EventQueue {
        private MyEventQueue() {
        }

        @Override
        public void postEvent(AWTEvent theEvent) {
            FreeMind.this.logger.info("Event Posted: " + theEvent);
            super.postEvent(theEvent);
        }
    }
}

