/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.SwimlanesB;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class SwimlanesC
extends SwimlanesB {
    public SwimlanesC(ISkinParam skinParam, Pragma pragma) {
        super(skinParam, pragma);
    }

    @Override
    protected void drawWhenSwimlanes(UGraphic ug, TextBlock full) {
        super.drawWhenSwimlanes(ug, full);
        double x2 = 0.0;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimensionFull = full.calculateDimension(stringBounder);
        UTranslate titleHeightTranslate = this.getTitleHeightTranslate(stringBounder);
        for (Swimlane swimlane : this.swimlanes) {
            this.drawSeparation(ug.apply(UTranslate.dx(x2)), dimensionFull.getHeight() + titleHeightTranslate.getDy());
            x2 += swimlane.getActualWidth();
        }
        this.drawSeparation(ug.apply(UTranslate.dx(x2)), dimensionFull.getHeight() + titleHeightTranslate.getDy());
    }

    private void drawSeparation(UGraphic ug, double height) {
        HColor color = this.skinParam.getHtmlColor(ColorParam.swimlaneBorder, null, false);
        if (color == null) {
            color = ColorParam.swimlaneBorder.getDefaultValue();
        }
        UStroke thickness = Rose.getStroke(this.skinParam, LineParam.swimlaneBorder, 2.0);
        if (SkinParam.USE_STYLES()) {
            color = this.getStyle().value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
            thickness = this.getStyle().getStroke();
        }
        ug.apply(thickness).apply(color).draw(ULine.vline(height));
    }
}

