/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileSwitchNude;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileSwitchWithDiamonds;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileSwitchWithManyLinks;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileSwitchWithOneLink;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileFactoryDelegatorSwitch
extends FtileFactoryDelegator {
    public FtileFactoryDelegatorSwitch(FtileFactory factory) {
        super(factory);
    }

    @Override
    public Ftile createSwitch(Swimlane swimlane, List<Branch> branches, LinkRendering afterEndwhile, LinkRendering topInlinkRendering, Display labelTest) {
        return this.createWithLinks(swimlane, branches, labelTest);
    }

    private Ftile createNude(Swimlane swimlane, List<Branch> branches) {
        ArrayList<Ftile> ftiles = new ArrayList<Ftile>();
        for (Branch branch : branches) {
            ftiles.add(new FtileMinWidth(branch.getFtile(), 30.0));
        }
        return new FtileSwitchNude(ftiles, swimlane);
    }

    private Ftile createWithDiamonds(Swimlane swimlane, List<Branch> branches, Display labelTest) {
        ArrayList<Ftile> ftiles = new ArrayList<Ftile>();
        for (Branch branch : branches) {
            ftiles.add(new FtileMinWidth(branch.getFtile(), 30.0));
        }
        Ftile diamond1 = this.getDiamond1(swimlane, branches.get(0), labelTest);
        Ftile diamond2 = this.getDiamond2(swimlane, branches.get(0));
        return new FtileSwitchWithDiamonds(ftiles, branches, swimlane, diamond1, diamond2, this.getStringBounder());
    }

    private Ftile createWithLinks(Swimlane swimlane, List<Branch> branches, Display labelTest) {
        FtileSwitchWithDiamonds result;
        ArrayList<Ftile> ftiles = new ArrayList<Ftile>();
        Ftile diamond1 = this.getDiamond1(swimlane, branches.get(0), labelTest);
        Ftile diamond2 = this.getDiamond2(swimlane, branches.get(0));
        for (Branch branch : branches) {
            ftiles.add(new FtileMinWidth(branch.getFtile(), 30.0));
        }
        Rainbow arrowColor = Rainbow.build(this.skinParam());
        if (ftiles.size() == 1) {
            result = new FtileSwitchWithOneLink(ftiles, branches, swimlane, diamond1, diamond2, this.getStringBounder(), arrowColor);
            return ((FtileSwitchWithOneLink)result).addLinks();
        }
        result = new FtileSwitchWithManyLinks(ftiles, branches, swimlane, diamond1, diamond2, this.getStringBounder(), arrowColor);
        return ((FtileSwitchWithManyLinks)result).addLinks();
    }

    private Ftile getDiamond1(Swimlane swimlane, Branch branch0, Display test) {
        HColor borderColor = this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBorder);
        HColor backColor = branch0.getColor() == null ? this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBackground) : branch0.getColor();
        FontConfiguration fcDiamond = new FontConfiguration(this.skinParam(), FontParam.ACTIVITY_DIAMOND, null);
        TextBlock tbTest = Display.isNull(test) || test.isWhite() ? TextBlockUtils.empty(0.0, 0.0) : test.create(fcDiamond, branch0.skinParam().getDefaultTextAlignment(HorizontalAlignment.LEFT), branch0.skinParam());
        return new FtileDiamondInside(branch0.skinParam(), backColor, borderColor, swimlane, tbTest);
    }

    private Ftile getDiamond2(Swimlane swimlane, Branch branch0) {
        HColor borderColor = this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBorder);
        HColor backColor = branch0.getColor() == null ? this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBackground) : branch0.getColor();
        return new FtileDiamondInside(branch0.skinParam(), backColor, borderColor, swimlane, TextBlockUtils.empty(0.0, 0.0));
    }

    private HColor fontColor(FontParam param) {
        return this.skinParam().getFontHtmlColor(null, param);
    }
}

