/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    private static final int COLS = 6;
    private static final int FREE_LINES = 6;
    public static final String DONORS = "6_eA02mFU3XMJYceJdotTlPGzS6YgH0ylZFbdo3X7Mo0347DLH8jYjmdkzS0GG5q3HqzvlQT7lSRwI-YAztxfXdHbh_c-7d6K0m4FPw_hePj_hS7Zwa_zqxZk-ioVNvpXqL918Z8CYV51XeoyFvcECytZOzUUWOieUgdwBxsVvUkikvULOLPkbkrJf-kK3UsOexfygF0XLEm4rJHe91ZEfLp7GvLZVBgWQyjDCYaSEUtystNP5QCVeYKJ6riGKPlZD2TazOloOACsd_K9z2YOxgcH2u9nTPB93h_h7HuMK3tQoI-0iaG2pODpA6K8pf1iNCZXYGfWeREKOp6rX_PyYG4GnvQs8T_r9CZxYcPCGmjafHhe23ZPXo0j4hTcd2skXbGdITR36kIgelZ8Tnt7AQdd3feU0GiKYoe1QeXo9lG2P_ciruokFIBeeQ__3R9jLa2r5ss1DWtC_eM7aqIvNzwromGTvMoUKfZgTVU7sDto5rJPXx-Hs-Zb2suryr22XOlBO0VWPwhYKhoyrVMZOKuX6ifVI5TvxOhrr64IpPag5YNpsB9QyuTNN9ZqsAP3XRZ4_ovs8GCjD2LojNG3LfrsQtpXPBKrBX-oAj3-tN0DNLczuxHUY-Ri_p_8gpCZ8e3TBh4AEX6GC4SJQkXOW4Hc1QwEkGcG2v0kPhSYjNgG_pQ9mZUJ7eW2XiXFH2lFvURN8Gm3MkwFSKCOFgGKYT9seG8JTe4FOagnKXPXDuEavPXqyRKTT86ZzC6On37T5nz4ZvR2Dp2i4urcft5skSOGt2BxsK-FUz36LVndMxXFUz9QloG0JlJWXwHAYFgorBsad3JG64MRyb9GtnNsCx5G_S5vvaisi3CsUOuP3PKBYMfgNzY-A59zxS2MTjURKNUWFGIc8GmCxh1wQt98pMvH98qdEd4s04WgnQVs6-AS6TGTSlBpk8wXCaZLYz2Xlmk-GIMAhhmT65xT_VZ6SEZo3wSzyAigN7fKdmieERi9YXA2wLwIb6apGaov5Y3dlNMmFQxEXR8rc_LiEbGUDj4fvKRJ4mXmrMY_sYqI3GguXAz-2GnWB_nyfHwnbW77T_XPODnWAmX2O4gZER8WTFIMDswbh7Uely_QsspSlxytskooAaddl6g0kWECk8_I57dw6BM3RmDyzNOC0VOO0OJtTdXoWDBxmOI5kp3EwkeAzECv4eCbbkKYrPnVAYwhtGFBcP3R5XnKKnHT9_YfBLD8wWKs_Tz4KvoOCv_YYgpKhWgTMfYn8JOxb6SmjXxByLTrwn0W-guJE3jgTUtYsckqkTuGQbXk0RafoDooAPvQ45DJPlwH62R6EjxSziXcUQ_IOz-YjREVbOFGplRlybLeE7R7qAxeISOBX8t3F2xnvpSmCqt5FB6r1rbkPYsSz4zmouHhB3Vz5ra8U6LPQqo4SRSt5ekF2t4Czk67Bo5xDFLAFg2g2fk80SMctKEOb4fnoDI98Nc72sR4v6s0m00";

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 6, 6);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(UTranslate.dy(header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(UTranslate.dx(x)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(PSystemVersion.getPlantumlImage());
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        TranscoderImpl t = new TranscoderImpl(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        String s = t.decode(DONORS).replace('*', '.');
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

