/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.lang.ComplementBeforeOrAfterOrAtTaskStartOrEnd;
import net.sourceforge.plantuml.project.lang.ComplementDate;
import net.sourceforge.plantuml.project.lang.ComplementPattern;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verb;
import net.sourceforge.plantuml.project.lang.VerbPattern;
import net.sourceforge.plantuml.project.time.Day;

public class VerbHappens
implements VerbPattern {
    @Override
    public Collection<ComplementPattern> getComplements() {
        return Arrays.asList(new ComplementBeforeOrAfterOrAtTaskStartOrEnd(), new ComplementDate());
    }

    @Override
    public IRegex toRegex() {
        return new RegexLeaf("happens[%s]*(at[%s]*|the[%s]*|on[%s]*)*");
    }

    @Override
    public Verb getVerb(final GanttDiagram project, RegexResult arg) {
        return new Verb(){

            @Override
            public CommandExecutionResult execute(Subject subject, Complement complement) {
                Task task = (Task)subject;
                task.setLoad(Load.inWinks(1));
                if (complement instanceof Day) {
                    Day start = (Day)complement;
                    Day startingDate = project.getStartingDate();
                    if (startingDate == null) {
                        return CommandExecutionResult.error("No starting date for the project");
                    }
                    task.setStart(start.asInstantDay(startingDate));
                    task.setDiamond(true);
                } else {
                    TaskInstant when = (TaskInstant)complement;
                    task.setStart(when.getInstantTheorical());
                    task.setDiamond(true);
                }
                return CommandExecutionResult.ok();
            }
        };
    }
}

