/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.image.ContainingEllipse;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Footprint {
    private final StringBounder stringBounder;

    public Footprint(StringBounder stringBounder) {
        this.stringBounder = stringBounder;
    }

    public ContainingEllipse getEllipse(UDrawable drawable, double alpha) {
        MyUGraphic ug = new MyUGraphic();
        drawable.drawU(ug);
        List all = ug.all;
        ContainingEllipse circle = new ContainingEllipse(alpha);
        for (Point2D pt : all) {
            circle.append(pt);
        }
        return circle;
    }

    class MyUGraphic
    implements UGraphic {
        private final UTranslate translate;
        private final List<Point2D.Double> all;

        public double dpiFactor() {
            return 1.0;
        }

        private MyUGraphic(List<Point2D.Double> all, UTranslate translate) {
            this.all = all;
            this.translate = translate;
        }

        @Override
        public boolean matchesProperty(String propertyName) {
            return false;
        }

        public MyUGraphic() {
            this(new ArrayList<Point2D.Double>(), new UTranslate());
        }

        @Override
        public UGraphic apply(UChange change) {
            if (change instanceof UTranslate) {
                return new MyUGraphic(this.all, this.translate.compose((UTranslate)change));
            }
            if (change instanceof UStroke || change instanceof HColor) {
                return new MyUGraphic(this.all, this.translate);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public StringBounder getStringBounder() {
            return Footprint.this.stringBounder;
        }

        @Override
        public UParam getParam() {
            return new UParamNull();
        }

        @Override
        public void draw(UShape shape) {
            double x = this.translate.getDx();
            double y = this.translate.getDy();
            if (shape instanceof UText) {
                this.drawText(x, y, (UText)shape);
            } else if (!(shape instanceof UHorizontalLine) && !(shape instanceof ULine)) {
                if (shape instanceof UImage) {
                    this.drawImage(x, y, (UImage)shape);
                } else if (shape instanceof UPath) {
                    this.drawPath(x, y, (UPath)shape);
                } else {
                    throw new UnsupportedOperationException(shape.getClass().toString());
                }
            }
        }

        @Override
        public ColorMapper getColorMapper() {
            return new ColorMapperIdentity();
        }

        @Override
        public void startUrl(Url url) {
        }

        @Override
        public void closeAction() {
        }

        private void addPoint(double x, double y) {
            this.all.add(new Point2D.Double(x, y));
        }

        private void drawText(double x, double y, UText text) {
            Dimension2D dim = Footprint.this.stringBounder.calculateDimension(text.getFontConfiguration().getFont(), text.getText());
            this.addPoint(x, y -= dim.getHeight() - 1.5);
            this.addPoint(x, y + dim.getHeight());
            this.addPoint(x + dim.getWidth(), y);
            this.addPoint(x + dim.getWidth(), y + dim.getHeight());
        }

        private void drawImage(double x, double y, UImage image) {
            this.addPoint(x, y);
            this.addPoint(x, y + (double)image.getHeight());
            this.addPoint(x + (double)image.getWidth(), y);
            this.addPoint(x + (double)image.getWidth(), y + (double)image.getHeight());
        }

        private void drawPath(double x, double y, UPath path) {
            this.addPoint(x + path.getMinX(), y + path.getMinY());
            this.addPoint(x + path.getMaxX(), y + path.getMaxY());
        }

        @Override
        public void flushUg() {
        }
    }
}

