/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

public final class EscHelpers$ {
    public static EscHelpers$ MODULE$;

    static {
        new EscHelpers$();
    }

    public final char ESC() {
        return '\u001b';
    }

    public boolean isEscapeTerminator(char c) {
        return c >= '@' && c <= '~';
    }

    private boolean isCSI(char c) {
        return c == '[';
    }

    private boolean isAnsiTwoCharacterTerminator(char c) {
        return c >= '@' && c <= '_';
    }

    public boolean hasEscapeSequence(String s) {
        return s.indexOf(27) >= 0;
    }

    public String removeEscapeSequences(String s) {
        String string;
        if (s.isEmpty() || !this.hasEscapeSequence(s)) {
            string = s;
        } else {
            StringBuilder sb = new StringBuilder();
            this.nextESC(s, 0, sb);
            string = sb.toString();
        }
        return string;
    }

    private void nextESC(String s, int start, StringBuilder sb) {
        while (true) {
            int next;
            int escIndex;
            if ((escIndex = s.indexOf(27, start)) < 0) break;
            sb.append(s, start, escIndex);
            start = next = escIndex + 1 >= s.length() ? this.skipESC(s, escIndex + 1) : (this.isCSI(s.charAt(escIndex + 1)) ? this.skipESC(s, escIndex + 2) : (this.isAnsiTwoCharacterTerminator(s.charAt(escIndex + 1)) ? escIndex + 2 : this.skipESC(s, escIndex + 1)));
        }
        sb.append(s, start, s.length());
    }

    private int skipESC(String s, int i) {
        int n;
        while (true) {
            if (i >= s.length()) {
                n = i;
                break;
            }
            if (this.isEscapeTerminator(s.charAt(i))) {
                n = i + 1;
                break;
            }
            ++i;
        }
        return n;
    }

    private EscHelpers$() {
        MODULE$ = this;
    }
}

