/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import sbt.internal.inc.CreateZip;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tma!B\u0013'\u0003\u0003i\u0003\"\u0002\u001d\u0001\t\u0003Id\u0001B\u001e\u0001\u0005qB\u0001\"\u0010\u0002\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006q\t!\tA\u0012\u0005\b\u0015\n\u0011\r\u0011\"\u0003L\u0011\u0019i&\u0001)A\u0005\u0019\")aL\u0001C\u0001?\")!M\u0001C\u0005G\")a\r\u0001C\u0001O\")q\u000f\u0001C\u0001q\")Q\u0010\u0001C\u0001}\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\t\u001d\t9\u0002\u0001B\u0001\u00033!q!a\u000f\u0001\u0005\u0003\tI\u0002C\u0004\u0002*\u0001!I!!\u0010\t\r\u0019\u0004A\u0011BA,\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBaa\u001e\u0001\u0005\n\u00055\u0004bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!a(\u0001\t\u0013\t\t\u000bC\u0004\u00020\u0002!I!!-\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u0011\u0011\u0003\u0001\u0007\u0012\u00055\u0007bBAi\u0001\u0019E\u00111\u001b\u0005\b\u0003/\u0004a\u0011CAm\u0011\u001d\ty\u000e\u0001D\t\u0003CDq!!:\u0001\r#\t9\u000fC\u0004\u0002p\u00021\t\"!=\t\u000f\u0005]\bA\"\u0005\u0002z\"9\u0011Q \u0001\u0007\u0012\u0005}\bb\u0002B\u0004\u0001\u0019E!\u0011\u0002\u0005\b\u0003S\u0001a\u0011\u0003B\u0007\u0005AIe\u000eZ3y\u0005\u0006\u001cX\r\u001a.ja>\u00038O\u0003\u0002(Q\u0005\u0019\u0011N\\2\u000b\u0005%R\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0003-\n1a\u001d2u\u0007\u0001\u00192\u0001\u0001\u00185!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fMB\u0011QGN\u0007\u0002M%\u0011qG\n\u0002\n\u0007J,\u0017\r^3[SB\fa\u0001P5oSRtD#\u0001\u001e\u0011\u0005U\u0002!\u0001D\"bG\",Gm\u0015;b[B\u001c8C\u0001\u0002/\u0003\rQ\u0018\u000e\u001d\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b!![8\u000b\u0003\r\u000bAA[1wC&\u0011Q\t\u0011\u0002\u0005\r&dW\r\u0006\u0002H\u0013B\u0011\u0001JA\u0007\u0002\u0001!)Q\b\u0002a\u0001}\u0005)2-Y2iK\u0012t\u0015-\\3U_RKW.Z:uC6\u0004X#\u0001'\u0011\t5#vK\u0017\b\u0003\u001dJ\u0003\"a\u0014\u0019\u000e\u0003AS!!\u0015\u0017\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0006'\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u00131!T1q\u0015\t\u0019\u0006\u0007\u0005\u0002N1&\u0011\u0011L\u0016\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005=Z\u0016B\u0001/1\u0005\u0011auN\\4\u0002-\r\f7\r[3e\u001d\u0006lW\rV8US6,7\u000f^1na\u0002\n\u0001bZ3u'R\fW\u000e\u001d\u000b\u00035\u0002DQ!Y\u0004A\u0002]\u000bQ!\u001a8uef\fq\"\u001b8ji&\fG.\u001b>f\u0007\u0006\u001c\u0007.\u001a\u000b\u0003\u0019\u0012DQ!\u001a\u0005A\u0002y\nqA_5q\r&dW-A\u0007sK6|g/Z#oiJLWm\u001d\u000b\u0004Q.d\u0007CA\u0018j\u0013\tQ\u0007G\u0001\u0003V]&$\b\"B3\n\u0001\u0004q\u0004\"B7\n\u0001\u0004q\u0017aB3oiJLWm\u001d\t\u0004_R<fB\u00019s\u001d\ty\u0015/C\u00012\u0013\t\u0019\b'A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(\u0001C%uKJ\f'\r\\3\u000b\u0005M\u0004\u0014!D7fe\u001e,\u0017I]2iSZ,7\u000fF\u0002isnDQA\u001f\u0006A\u0002y\nA!\u001b8u_\")AP\u0003a\u0001}\u0005!aM]8n\u0003AIgn\u00197vI\u0016Le.\u0011:dQ&4X\r\u0006\u0003i\u007f\u0006\u0005\u0001\"B3\f\u0001\u0004q\u0004bBA\u0002\u0017\u0001\u0007\u0011QA\u0001\u0006M&dWm\u001d\t\u0006_\u0006\u001d\u00111B\u0005\u0004\u0003\u00131(aA*fcB)q&!\u0004?/&\u0019\u0011q\u0002\u0019\u0003\rQ+\b\u000f\\33\u00039\u0011X-\u00193DK:$(/\u00197ESJ$B!!\u0006\u0002(A\u0011\u0001j\u0004\u0002\u000b\u0007\u0016tGO]1m\t&\u0014\u0018\u0003BA\u000e\u0003C\u00012aLA\u000f\u0013\r\ty\u0002\r\u0002\b\u001d>$\b.\u001b8h!\ry\u00131E\u0005\u0004\u0003K\u0001$aA!os\")Q\r\u0004a\u0001}\u0005yqO]5uK\u000e+g\u000e\u001e:bY\u0012K'\u000fF\u0003i\u0003[\ty\u0003C\u0003f\u001b\u0001\u0007a\bC\u0004\u000225\u0001\r!!\u0006\u0002\u0015\r,g\u000e\u001e:bY\u0012K'/A\u0006mSN$XI\u001c;sS\u0016\u001cH\u0003BA\u001c\u0003s\u0001Ba\\A\u0004/\")QM\u0004a\u0001}\t1\u0001*Z1eKJ$R\u0001[A \u0003'Bq!!\u0011\u0012\u0001\u0004\t\u0019%\u0001\u0003qCRD\u0007\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0005M&dWMC\u0002\u0002N\t\u000b1A\\5p\u0013\u0011\t\t&a\u0012\u0003\tA\u000bG\u000f\u001b\u0005\b\u0003+\n\u0002\u0019AA\u000b\u00035qWm^\"f]R\u0014\u0018\r\u001c#jeR)\u0001.!\u0017\u0002\\!9\u0011\u0011\t\nA\u0002\u0005\r\u0003bBA/%\u0001\u0007\u0011qL\u0001\ti>\u0014V-\\8wKB!Q*!\u0019X\u0013\r\t\u0019G\u0016\u0002\u0004'\u0016$\u0018a\u0007:f[>4X-\u00128ue&,7O\u0012:p[\u000e+g\u000e\u001e:bY\u0012K'\u000fF\u0003i\u0003S\nY\u0007C\u0004\u00022M\u0001\r!!\u0006\t\u000f\u0005u3\u00031\u0001\u0002`Q)\u0001.a\u001c\u0002t!9\u0011\u0011\u000f\u000bA\u0002\u0005\r\u0013A\u0002;be\u001e,G\u000fC\u0004\u0002vQ\u0001\r!a\u0011\u0002\rM|WO]2f\u00031iWM]4f\u0011\u0016\fG-\u001a:t)!\tY(a \u0002\u0004\u0006\u001d\u0005#B8\u0002\b\u0005u\u0004C\u0001%\u0011\u0011\u001d\t\t)\u0006a\u0001\u0003+\t\u0001\u0003^1sO\u0016$8)\u001a8ue\u0006dG)\u001b:\t\u000f\u0005\u0015U\u00031\u0001\u0002\u0016\u0005\u00012o\\;sG\u0016\u001cUM\u001c;sC2$\u0015N\u001d\u0005\u0007\u0003\u0013+\u0002\u0019\u0001.\u0002\u0017M|WO]2f'R\f'\u000f^\u0001\u0013iJ,hnY1uK\u000e+g\u000e\u001e:bY\u0012K'\u000fF\u0003[\u0003\u001f\u000b\t\nC\u0004\u00022Y\u0001\r!!\u0006\t\u000f\u0005\u0005c\u00031\u0001\u0002D\u0005Ya-\u001b8bY&TXMW5q)\u001dA\u0017qSAM\u00037Cq!!\r\u0018\u0001\u0004\t)\u0002C\u0004\u0002B]\u0001\r!a\u0011\t\r\u0005uu\u00031\u0001[\u0003=\u0019WM\u001c;sC2$\u0015N]*uCJ$\u0018a\u0003;sC:\u001ch-\u001a:BY2$\u0012\u0002[AR\u0003K\u000b9+a+\t\u000f\u0005U\u0004\u00041\u0001\u0002D!9\u0011\u0011\u000f\rA\u0002\u0005\r\u0003BBAU1\u0001\u0007!,\u0001\u0005ti\u0006\u0014H\u000fU8t\u0011\u0019\ti\u000b\u0007a\u00015\u0006y!-\u001f;fgR{GK]1og\u001a,'/\u0001\npa\u0016tg)\u001b7f\r>\u0014(+Z1eS:<G\u0003BAZ\u0003\u007f\u0003B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY%\u0001\u0005dQ\u0006tg.\u001a7t\u0013\u0011\ti,a.\u0003'I+\u0017\rZ1cY\u0016\u0014\u0015\u0010^3DQ\u0006tg.\u001a7\t\u000f\u0005\u0005\u0013\u00041\u0001\u0002D\u0005\u0011r\u000e]3o\r&dWMR8s/JLG/\u001b8h)\u0011\t)-a3\u0011\t\u0005U\u0016qY\u0005\u0005\u0003\u0013\f9LA\u0006GS2,7\t[1o]\u0016d\u0007bBA!5\u0001\u0007\u00111\t\u000b\u0005\u0003+\ty\rC\u0004\u0002Bm\u0001\r!a\u0011\u0002%\u001d,GoQ3oiJ\fG\u000eR5s'R\f'\u000f\u001e\u000b\u00045\u0006U\u0007bBA\u00199\u0001\u0007\u0011QC\u0001\u0013g\u0016$8)\u001a8ue\u0006dG)\u001b:Ti\u0006\u0014H\u000fF\u0003i\u00037\fi\u000eC\u0004\u00022u\u0001\r!!\u0006\t\r\u0005uU\u00041\u0001[\u0003)9W\r\u001e%fC\u0012,'o\u001d\u000b\u0005\u0003w\n\u0019\u000fC\u0004\u00022y\u0001\r!!\u0006\u0002\u0015M,G\u000fS3bI\u0016\u00148\u000fF\u0003i\u0003S\fY\u000fC\u0004\u00022}\u0001\r!!\u0006\t\u000f\u00055x\u00041\u0001\u0002|\u00059\u0001.Z1eKJ\u001c\u0018aC4fi\u001aKG.\u001a(b[\u0016$2aVAz\u0011\u001d\t)\u0010\ta\u0001\u0003{\na\u0001[3bI\u0016\u0014\u0018!D4fi\u001aKG.Z(gMN,G\u000fF\u0002[\u0003wDq!!>\"\u0001\u0004\ti(A\u0007tKR4\u0015\u000e\\3PM\u001a\u001cX\r\u001e\u000b\u0006Q\n\u0005!1\u0001\u0005\b\u0003k\u0014\u0003\u0019AA?\u0011\u0019\u0011)A\ta\u00015\u00061qN\u001a4tKR\f1cZ3u\u0019\u0006\u001cH/T8eS\u001aLW\r\u001a+j[\u0016$2A\u0017B\u0006\u0011\u001d\t)p\ta\u0001\u0003{\"R\u0001\u001bB\b\u0005#Aq!!\r%\u0001\u0004\t)\u0002C\u0004\u0003\u0014\u0011\u0002\rA!\u0006\u0002\u0019=,H\u000f];u'R\u0014X-Y7\u0011\u0007}\u00129\"C\u0002\u0003\u001a\u0001\u0013AbT;uaV$8\u000b\u001e:fC6\u0004")
public abstract class IndexBasedZipOps
implements CreateZip {
    @Override
    public void createZip(File target, Seq<Tuple2<File, String>> files) {
        CreateZip.createZip$(this, target, files);
    }

    public void removeEntries(File zipFile, Iterable<String> entries) {
        this.removeEntries(zipFile.toPath(), (Set<String>)entries.toSet());
    }

    public void mergeArchives(File into, File from) {
        this.mergeArchives(into.toPath(), from.toPath());
    }

    public void includeInArchive(File zipFile, Seq<Tuple2<File, String>> files) {
        if (zipFile.exists()) {
            File tempZip = zipFile.toPath().resolveSibling(new StringBuilder(4).append(UUID.randomUUID()).append(".jar").toString()).toFile();
            this.createZip(tempZip, files);
            this.mergeArchives(zipFile, tempZip);
            return;
        }
        this.createZip(zipFile, files);
    }

    public Object readCentralDir(File zipFile) {
        return this.readCentralDir(zipFile.toPath());
    }

    public void writeCentralDir(File zipFile, Object centralDir) {
        this.writeCentralDir(zipFile.toPath(), centralDir);
    }

    public Seq<String> listEntries(File zipFile) {
        Object centralDir = this.readCentralDir(zipFile);
        return (Seq)this.getHeaders(centralDir).map((Function1 & Serializable & scala.Serializable)header -> this.getFileName(header), Seq$.MODULE$.canBuildFrom());
    }

    private void writeCentralDir(Path path, Object newCentralDir) {
        Object currentCentralDir = this.readCentralDir(path);
        long currentCentralDirStart = this.truncateCentralDir(currentCentralDir, path);
        this.finalizeZip(newCentralDir, path, currentCentralDirStart);
    }

    private void removeEntries(Path path, Set<String> toRemove) {
        if (toRemove.nonEmpty()) {
            Object centralDir = this.readCentralDir(path);
            this.removeEntriesFromCentralDir(centralDir, toRemove);
            long writeOffset = this.truncateCentralDir(centralDir, path);
            this.finalizeZip(centralDir, path, writeOffset);
        }
    }

    private void removeEntriesFromCentralDir(Object centralDir, Set<String> toRemove) {
        Seq clearedHeaders = (Seq)this.getHeaders(centralDir).filterNot((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)toRemove.contains((Object)this.getFileName(header))));
        this.setHeaders(centralDir, (Seq<Object>)clearedHeaders);
    }

    private void mergeArchives(Path target, Path source) {
        Object targetCentralDir = this.readCentralDir(target);
        Object sourceCentralDir = this.readCentralDir(source);
        long sourceStart = this.truncateCentralDir(targetCentralDir, target);
        long sourceLength = this.getCentralDirStart(sourceCentralDir);
        this.transferAll(source, target, sourceStart, sourceLength);
        Seq<Object> mergedHeaders = this.mergeHeaders(targetCentralDir, sourceCentralDir, sourceStart);
        this.setHeaders(targetCentralDir, mergedHeaders);
        long centralDirStart = sourceStart + sourceLength;
        this.finalizeZip(targetCentralDir, target, centralDirStart);
        Files.delete(source);
    }

    private Seq<Object> mergeHeaders(Object targetCentralDir, Object sourceCentralDir, long sourceStart) {
        Seq<Object> sourceHeaders = this.getHeaders(sourceCentralDir);
        sourceHeaders.foreach((Function1 & Serializable & scala.Serializable)header -> {
            IndexBasedZipOps.$anonfun$mergeHeaders$1(this, sourceStart, header);
            return BoxedUnit.UNIT;
        });
        Set sourceNames = ((TraversableOnce)sourceHeaders.map((Function1 & Serializable & scala.Serializable)header -> this.getFileName(header), Seq$.MODULE$.canBuildFrom())).toSet();
        return (Seq)((Seq)this.getHeaders(targetCentralDir).filterNot((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)sourceNames.contains((Object)this.getFileName(h))))).$plus$plus(sourceHeaders, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private long truncateCentralDir(Object centralDir, Path path) {
        void var3_3;
        long sizeAfterTruncate = this.getCentralDirStart(centralDir);
        new FileOutputStream(path.toFile(), true).getChannel().truncate(sizeAfterTruncate).close();
        return (long)var3_3;
    }

    private void finalizeZip(Object centralDir, Path path, long centralDirStart) {
        this.setCentralDirStart(centralDir, centralDirStart);
        FileOutputStream fileOutputStream = new FileOutputStream(path.toFile(), true);
        fileOutputStream.getChannel().position(centralDirStart);
        BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
        this.writeCentralDir(centralDir, outputStream);
        outputStream.close();
    }

    private void transferAll(Path source, Path target, long startPos, long bytesToTransfer) {
        long transferred;
        ReadableByteChannel sourceFile = this.openFileForReading(source);
        FileChannel targetFile = this.openFileForWriting(target);
        long offset = startPos;
        for (long remaining = bytesToTransfer; remaining > 0L; remaining -= transferred) {
            transferred = targetFile.transferFrom(sourceFile, offset, remaining);
            offset += transferred;
        }
        sourceFile.close();
        targetFile.close();
    }

    private ReadableByteChannel openFileForReading(Path path) {
        return Channels.newChannel(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
    }

    private FileChannel openFileForWriting(Path path) {
        return new FileOutputStream(path.toFile(), true).getChannel();
    }

    public abstract Object readCentralDir(Path var1);

    public abstract long getCentralDirStart(Object var1);

    public abstract void setCentralDirStart(Object var1, long var2);

    public abstract Seq<Object> getHeaders(Object var1);

    public abstract void setHeaders(Object var1, Seq<Object> var2);

    public abstract String getFileName(Object var1);

    public abstract long getFileOffset(Object var1);

    public abstract void setFileOffset(Object var1, long var2);

    public abstract long getLastModifiedTime(Object var1);

    public abstract void writeCentralDir(Object var1, OutputStream var2);

    public static final /* synthetic */ void $anonfun$mergeHeaders$1(IndexBasedZipOps $this, long sourceStart$1, Object header) {
        long newOffset = $this.getFileOffset(header) + sourceStart$1;
        $this.setFileOffset(header, newOffset);
    }

    public IndexBasedZipOps() {
        CreateZip.$init$(this);
    }

    public final class CachedStamps {
        private final Map<String, Object> cachedNameToTimestamp;

        private Map<String, Object> cachedNameToTimestamp() {
            return this.cachedNameToTimestamp;
        }

        public long getStamp(String entry) {
            return BoxesRunTime.unboxToLong((Object)this.cachedNameToTimestamp().getOrElse((Object)entry, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        }

        private Map<String, Object> initializeCache(File zipFile) {
            if (zipFile.exists()) {
                Object centralDir = IndexBasedZipOps.this.readCentralDir(zipFile.toPath());
                return (Map)IndexBasedZipOps.this.getHeaders(centralDir).map((Function1 & Serializable & scala.Serializable)header -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.IndexBasedZipOps.this.getFileName(header)), (Object)BoxesRunTime.boxToLong((long)$this.IndexBasedZipOps.this.getLastModifiedTime(header))), package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
            }
            return Predef$.MODULE$.Map().empty();
        }

        public CachedStamps(File zip) {
            if (IndexBasedZipOps.this == null) {
                throw null;
            }
            this.cachedNameToTimestamp = this.initializeCache(zip);
        }
    }
}

