/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyFixedViewport;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.painters.TracePainterVerticalBar;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JFrame;
import javax.swing.UIManager;

public final class AdvancedStaticChart {
    public static void main(String[] args) throws ParseException {
        Chart2D chart = new Chart2D();
        Trace2DSimple trace = new Trace2DSimple();
        trace.setTracePainter(new TracePainterVerticalBar(2, chart));
        AxisLinear yAxis = new AxisLinear();
        Font titleFont = UIManager.getDefaults().getFont("Label.font").deriveFont(14.0f).deriveFont(1);
        IAxis.AxisTitle axisTitle = yAxis.getAxisTitle();
        axisTitle.setTitleFont(titleFont);
        axisTitle.setTitle("hoppelhase");
        chart.setAxisYLeft(yAxis);
        yAxis.setFormatter(new LabelFormatterDate(new SimpleDateFormat()));
        IAxis xAxis = chart.getAxisX();
        axisTitle = xAxis.getAxisTitle();
        axisTitle.setTitle("emil");
        axisTitle.setTitleFont(titleFont);
        xAxis.setRangePolicy(new RangePolicyFixedViewport(new Range(0.0, 220.0)));
        double high = System.currentTimeMillis();
        for (double i = 0.0; i < 200.0; i += 1.0) {
            trace.addPoint(i, high);
            high += 50000.0;
        }
        chart.addTrace(trace);
        JFrame frame = new JFrame("AdvancedStaticChart");
        frame.getContentPane().add(new ChartPanel(chart));
        frame.setSize(600, 600);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    private AdvancedStaticChart() {
    }
}

