/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.exceptions;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;

class MessageUtils {
    MessageUtils() {
    }

    static String buildMessage(BeanResolutionContext resolutionContext, String message) {
        BeanDefinition declaringType;
        boolean hasPath;
        BeanResolutionContext.Path path = resolutionContext.getPath();
        boolean bl = hasPath = !path.isEmpty();
        if (hasPath) {
            BeanResolutionContext.Segment segment = (BeanResolutionContext.Segment)path.peek();
            declaringType = segment.getDeclaringType();
        } else {
            declaringType = resolutionContext.getRootDefinition();
        }
        String ls = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder("Error instantiating bean of type  [");
        builder.append(declaringType.getName()).append("]").append(ls).append(ls);
        if (message != null) {
            builder.append("Message: ").append(message).append(ls);
        }
        if (hasPath) {
            String pathString = path.toString();
            builder.append("Path Taken: ").append(pathString);
        }
        return builder.toString();
    }

    static String buildMessage(BeanResolutionContext resolutionContext, MethodInjectionPoint methodInjectionPoint, Argument argument, String message, boolean circular) {
        StringBuilder builder = new StringBuilder("Failed to inject value for parameter [");
        String ls = System.getProperty("line.separator");
        builder.append(argument.getName()).append("] of method [").append(methodInjectionPoint.getName()).append("] of class: ").append(methodInjectionPoint.getDeclaringBean().getName()).append(ls).append(ls);
        if (message != null) {
            builder.append("Message: ").append(message).append(ls);
        }
        MessageUtils.appendPath(resolutionContext, circular, builder, ls);
        return builder.toString();
    }

    static String buildMessage(BeanResolutionContext resolutionContext, FieldInjectionPoint fieldInjectionPoint, String message, boolean circular) {
        StringBuilder builder = new StringBuilder("Failed to inject value for field [");
        String ls = System.getProperty("line.separator");
        builder.append(fieldInjectionPoint.getName()).append("] of class: ").append(fieldInjectionPoint.getDeclaringBean().getName()).append(ls).append(ls);
        if (message != null) {
            builder.append("Message: ").append(message).append(ls);
        }
        MessageUtils.appendPath(resolutionContext, circular, builder, ls);
        return builder.toString();
    }

    static String buildMessage(BeanResolutionContext resolutionContext, Argument argument, String message, boolean circular) {
        StringBuilder builder = new StringBuilder("Failed to inject value for parameter [");
        String ls = System.getProperty("line.separator");
        BeanResolutionContext.Path path = resolutionContext.getPath();
        builder.append(argument.getName()).append("] of class: ").append(((BeanResolutionContext.Segment)path.peek()).getDeclaringType().getName()).append(ls).append(ls);
        if (message != null) {
            builder.append("Message: ").append(message).append(ls);
        }
        MessageUtils.appendPath(circular, builder, ls, path);
        return builder.toString();
    }

    private static void appendPath(BeanResolutionContext resolutionContext, boolean circular, StringBuilder builder, String ls) {
        BeanResolutionContext.Path path = resolutionContext.getPath();
        if (!path.isEmpty()) {
            MessageUtils.appendPath(circular, builder, ls, path);
        }
    }

    private static void appendPath(boolean circular, StringBuilder builder, String ls, BeanResolutionContext.Path path) {
        String pathString = circular ? path.toCircularString() : path.toString();
        builder.append("Path Taken: ");
        if (circular) {
            builder.append(ls);
        }
        builder.append(pathString);
    }
}

