/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public interface Element
extends AnnotationMetadataDelegate,
AnnotatedElement {
    @Nonnull
    public String getName();

    public boolean isProtected();

    public boolean isPublic();

    @Nonnull
    public Object getNativeType();

    @Nonnull
    default public <T extends Annotation> Element annotate(@Nonnull String annotationType, @Nonnull Consumer<AnnotationValueBuilder<T>> consumer) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support adding annotations at compilation time");
    }

    @Nonnull
    default public <T extends Annotation> Element annotate(@Nonnull String annotationType) {
        return this.annotate(annotationType, (AnnotationValueBuilder<T> annotationValueBuilder) -> {});
    }

    @Nonnull
    default public <T extends Annotation> Element annotate(@Nonnull Class<T> annotationType, @Nonnull Consumer<AnnotationValueBuilder<T>> consumer) {
        ArgumentUtils.requireNonNull((String)"annotationType", annotationType);
        ArgumentUtils.requireNonNull((String)"consumer", consumer);
        return this.annotate(annotationType.getName(), consumer);
    }

    @Nonnull
    default public <T extends Annotation> Element annotate(@Nonnull Class<T> annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", annotationType);
        return this.annotate(annotationType.getName(), (AnnotationValueBuilder<T> annotationValueBuilder) -> {});
    }

    @Nonnull
    default public String getSimpleName() {
        return this.getName();
    }

    default public boolean isAbstract() {
        return false;
    }

    default public boolean isStatic() {
        return false;
    }

    default public Optional<String> getDocumentation() {
        return Optional.empty();
    }

    default public boolean isPrivate() {
        return !this.isPublic();
    }

    default public boolean isFinal() {
        return false;
    }
}

