/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
class CompositeQualifier<T>
implements Qualifier<T> {
    private final Qualifier[] qualifiers;

    CompositeQualifier(Qualifier ... qualifiers) {
        this.qualifiers = qualifiers;
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        Stream<BT> reduced = candidates;
        for (Qualifier qualifier : this.qualifiers) {
            reduced = qualifier.reduce(beanType, reduced);
        }
        return reduced;
    }

    @Override
    public boolean contains(Qualifier<T> qualifier) {
        for (Qualifier q : this.qualifiers) {
            if (!q.equals(qualifier)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeQualifier that = (CompositeQualifier)o;
        return Arrays.equals(this.qualifiers, that.qualifiers);
    }

    public int hashCode() {
        return Arrays.hashCode(this.qualifiers);
    }

    public String toString() {
        return Arrays.stream(this.qualifiers).map(Object::toString).collect(Collectors.joining(" and "));
    }
}

