/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.serialize;

import io.micronaut.core.serialize.JdkSerializer;
import io.micronaut.core.serialize.exceptions.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.Nullable;

public interface ObjectSerializer {
    public static final ObjectSerializer JDK = new JdkSerializer();

    public void serialize(@Nullable Object var1, OutputStream var2) throws SerializationException;

    public <T> Optional<T> deserialize(@Nullable InputStream var1, Class<T> var2) throws SerializationException;

    default public Optional<byte[]> serialize(@Nullable Object object) throws SerializationException {
        if (object == null) {
            return Optional.empty();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.serialize(object, outputStream);
        return Optional.of(outputStream.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> Optional<T> deserialize(@Nullable byte[] bytes, Class<T> requiredType) throws SerializationException {
        if (bytes == null) {
            return Optional.empty();
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
            Optional<T> optional = this.deserialize(input, requiredType);
            return optional;
        }
        catch (IOException e) {
            throw new SerializationException("I/O error occurred during deserialization: " + e.getMessage(), e);
        }
    }

    default public Optional<Object> deserialize(@Nullable byte[] bytes) throws SerializationException {
        if (bytes == null) {
            return Optional.empty();
        }
        return this.deserialize(bytes, Object.class);
    }
}

