/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.cpu.SnapshotCPUView;
import org.netbeans.lib.profiler.ui.jdbc.SnapshotJDBCView;
import org.netbeans.lib.profiler.ui.memory.SnapshotMemoryView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveSnapshotAction;
import org.netbeans.modules.profiler.SnapshotInfoAction;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.spi.actions.AbstractSavable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class SnapshotResultsWindow
extends ProfilerTopComponent {
    private static final byte PERSISTENCE_VERSION_MAJOR = 8;
    private static final byte PERSISTENCE_VERSION_MINOR = 1;
    private static final String HELP_CTX_KEY_CPU = "CpuSnapshot.HelpCtx";
    private static final String HELP_CTX_KEY_MEM = "MemorySnapshot.HelpCtx";
    private static final Image WINDOW_ICON_CPU = Icons.getImage((String)"ProfilerIcons.Cpu");
    private static final Image WINDOW_ICON_FRAGMENT = Icons.getImage((String)"ProfilerIcons.Fragment");
    private static final Image WINDOW_ICON_MEMORY = Icons.getImage((String)"ProfilerIcons.Memory");
    private static final Image WINDOW_ICON_JDBC = Icons.getImage((String)"ProfilerIcons.WindowSql");
    private static final HashMap windowsList = new HashMap();
    private LoadedSnapshot snapshot;
    private InstanceContent ic = new InstanceContent();
    private SavePerformer savePerformer = new SavePerformer();
    private JPanel displayedPanel;
    private String tabName = "";
    private SnapshotListener listener;
    private boolean forcedClose = false;
    private HelpCtx helpCtx = HelpCtx.DEFAULT_HELP;

    public SnapshotResultsWindow() {
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.ic));
        this.ic.add((Object)this.getActionMap());
        this.setLayout(new BorderLayout());
    }

    public SnapshotResultsWindow(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        this();
        this.initImpl(loadedSnapshot);
    }

    private void initImpl(LoadedSnapshot loadedSnapshot) {
        this.snapshot = loadedSnapshot;
        this.updateSaveState();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.refreshTabName();
        switch (this.snapshot.getType()) {
            case 1: {
                this.setIcon(WINDOW_ICON_CPU);
                this.helpCtx = new HelpCtx(HELP_CTX_KEY_CPU);
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_CpuSnapshotAccessDescr());
                this.setupCPUResultsView();
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                this.setIcon(WINDOW_ICON_MEMORY);
                this.helpCtx = new HelpCtx(HELP_CTX_KEY_MEM);
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_MemorySnapshotAccessDescr());
                this.setupMemoryResultsView();
                break;
            }
            case 32: {
                this.setIcon(WINDOW_ICON_JDBC);
                this.helpCtx = new HelpCtx(HELP_CTX_KEY_CPU);
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_CpuSnapshotAccessDescr());
                this.setupJDBCResultsView();
            }
        }
        if (this.displayedPanel != null) {
            this.add(this.displayedPanel, "Center");
            this.invalidate();
            this.doLayout();
            this.repaint();
        }
        this.listener = (SnapshotListener)Lookup.getDefault().lookup(SnapshotListener.class);
        this.listener.registerSnapshotResultsWindow(this);
    }

    public static synchronized void closeAllWindows() {
        Collection collection = windowsList.values();
        if (!collection.isEmpty()) {
            SnapshotResultsWindow[] snapshotResultsWindowArray = collection.toArray(new SnapshotResultsWindow[0]);
            for (int i = 0; i < snapshotResultsWindowArray.length; ++i) {
                SnapshotResultsWindow snapshotResultsWindow = snapshotResultsWindowArray[i];
                snapshotResultsWindow.forcedClose();
            }
        }
    }

    public static synchronized void closeWindow(LoadedSnapshot loadedSnapshot) {
        SnapshotResultsWindow snapshotResultsWindow = (SnapshotResultsWindow)((Object)windowsList.get(loadedSnapshot));
        if (snapshotResultsWindow != null) {
            snapshotResultsWindow.forcedClose();
        }
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot loadedSnapshot) {
        return SnapshotResultsWindow.get(loadedSnapshot, -1, false);
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        SnapshotResultsWindow snapshotResultsWindow = (SnapshotResultsWindow)((Object)windowsList.get(loadedSnapshot));
        if (snapshotResultsWindow == null) {
            snapshotResultsWindow = new SnapshotResultsWindow(loadedSnapshot, n, bl);
            windowsList.put(loadedSnapshot, snapshotResultsWindow);
        }
        return snapshotResultsWindow;
    }

    public static synchronized boolean hasSnapshotWindow(LoadedSnapshot loadedSnapshot) {
        return windowsList.get(loadedSnapshot) != null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeByte(8);
        objectOutput.writeByte(1);
        objectOutput.writeUTF(Utilities.toURI((File)this.snapshot.getFile()).toString());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.add(new JLabel(Bundle.SnapshotResultsWindow_LoadingProgress(), 0), "Center");
            this.invalidate();
            this.doLayout();
            this.repaint();
            super.readExternal(objectInput);
            objectInput.readByte();
            objectInput.readByte();
            URI uRI = new URI(objectInput.readUTF());
            final File file = Utilities.toFile((URI)uRI);
            new RequestProcessor("NPS loader for " + this.getName()).post(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileObject fileObject = FileUtil.toFileObject((File)file);
                        final LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().loadSnapshot(fileObject);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SnapshotResultsWindow.this.removeAll();
                                SnapshotResultsWindow.this.initImpl(loadedSnapshot);
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        SnapshotResultsWindow.this.handleReadThrowable(throwable);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            this.handleReadThrowable(throwable);
        }
    }

    private void handleReadThrowable(Throwable throwable) {
        ProfilerLogger.info((String)("Restoring profiler snapshot failed: " + throwable.getMessage()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotResultsWindow.this.close();
            }
        });
    }

    public int getPersistenceType() {
        return ProfilerIDESettings.getInstance().getReopenSnapshots() ? 1 : 2;
    }

    public HelpCtx getHelpCtx() {
        return this.helpCtx;
    }

    public boolean canClose() {
        if (this.snapshot == null) {
            return true;
        }
        File file = this.snapshot.getFile();
        if (file != null) {
            this.putClientProperty("nb.recent.file.path", file);
        }
        if (this.forcedClose) {
            this.savePerformer.remove();
            return true;
        }
        if (this.snapshot.isSaved()) {
            return true;
        }
        Boolean bl = ProfilerDialogs.displayCancellableConfirmationDNSA((String)Bundle.SnapshotResultsWindow_SaveSnapshotDialogMsg(), null, null, (String)"org.netbeans.modules.profiler.SnapshotResultsWindow.canClose", (boolean)false);
        if (Boolean.TRUE.equals(bl)) {
            try {
                this.savePerformer.save();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return true;
        }
        if (Boolean.FALSE.equals(bl)) {
            this.savePerformer.remove();
            return true;
        }
        return false;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.displayedPanel == null ? this : this.displayedPanel;
    }

    public void refreshTabName() {
        this.tabName = ResultsManager.getDefault().getSnapshotDisplayName(this.snapshot);
        File file = this.snapshot.getFile();
        if (file != null) {
            this.setToolTipText(file.getAbsolutePath());
        }
        this.updateTitle();
    }

    public void updateTitle() {
        if (this.snapshot.isSaved()) {
            this.setName(this.tabName);
        } else {
            this.setName(this.tabName + " *");
        }
        if (this.snapshot.getFile() != null) {
            this.setToolTipText(this.snapshot.getFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentClosed() {
        if (this.snapshot == null) {
            return;
        }
        Class<SnapshotResultsWindow> clazz = SnapshotResultsWindow.class;
        synchronized (SnapshotResultsWindow.class) {
            windowsList.remove(this.snapshot);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ResultsManager.getDefault().closeSnapshot(this.snapshot);
            this.snapshot = null;
            this.listener.unregisterSnapshotResultsWindow(this);
            return;
        }
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    boolean setRefSnapshot(LoadedSnapshot loadedSnapshot) {
        ResultsSnapshot resultsSnapshot;
        ResultsSnapshot resultsSnapshot2 = resultsSnapshot = loadedSnapshot == null ? null : loadedSnapshot.getSnapshot();
        if (this.displayedPanel instanceof SnapshotCPUView && resultsSnapshot instanceof CPUResultsSnapshot) {
            ((SnapshotCPUView)this.displayedPanel).setRefSnapshot((CPUResultsSnapshot)resultsSnapshot);
            return true;
        }
        if (this.displayedPanel instanceof SnapshotMemoryView && resultsSnapshot instanceof MemoryResultsSnapshot) {
            ((SnapshotMemoryView)this.displayedPanel).setRefSnapshot((MemoryResultsSnapshot)resultsSnapshot);
            return true;
        }
        if (this.displayedPanel instanceof SnapshotJDBCView && resultsSnapshot instanceof JdbcResultsSnapshot) {
            ((SnapshotJDBCView)this.displayedPanel).setRefSnapshot((JdbcResultsSnapshot)resultsSnapshot);
            return true;
        }
        return false;
    }

    private void setupCPUResultsView() {
        ResultsSnapshot resultsSnapshot = this.snapshot.getSnapshot();
        if (resultsSnapshot instanceof CPUResultsSnapshot) {
            CPUResultsSnapshot cPUResultsSnapshot = (CPUResultsSnapshot)resultsSnapshot;
            boolean bl = this.snapshot.getSettings().getCPUProfilingType() == 2;
            SaveSnapshotAction saveSnapshotAction = new SaveSnapshotAction(this.snapshot);
            CompareSnapshotsAction compareSnapshotsAction = new CompareSnapshotsAction(this.snapshot);
            SnapshotInfoAction snapshotInfoAction = new SnapshotInfoAction(this.snapshot);
            ExportUtils.Exportable exportable = ResultsManager.getDefault().createSnapshotExporter(this.snapshot);
            final SnapshotCPUView snapshotCPUView = new SnapshotCPUView(cPUResultsSnapshot, bl, saveSnapshotAction, compareSnapshotsAction, snapshotInfoAction, exportable){

                protected boolean showSourceSupported() {
                    return GoToSource.isAvailable();
                }

                protected boolean profileMethodSupported() {
                    return ProfilerFeature.Registry.hasProviders();
                }

                protected boolean profileClassSupported() {
                    return ProfilerFeature.Registry.hasProviders();
                }

                protected void showSource(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                    Lookup.Provider provider = SnapshotResultsWindow.this.snapshot.getProject();
                    String string = sourceCodeSelection.getClassName();
                    String string2 = sourceCodeSelection.getMethodName();
                    String string3 = sourceCodeSelection.getMethodSignature();
                    GoToSource.openSource((Lookup.Provider)provider, (String)string, (String)string2, (String)string3);
                }

                protected void selectForProfiling(final ClientUtils.SourceCodeSelection sourceCodeSelection) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            Lookup.Provider provider = SnapshotResultsWindow.this.snapshot.getProject();
                            String string = "*".equals(sourceCodeSelection.getMethodName()) ? Bundle.SnapshotResultsWindow_ProfileClass() : Bundle.SnapshotResultsWindow_ProfileMethod();
                            ProfilerSession.findAndConfigure(Lookups.fixed((Object[])new Object[]{sourceCodeSelection}), provider, string);
                        }
                    });
                }
            };
            compareSnapshotsAction.setPerformer(new CompareSnapshotsAction.Performer(){

                @Override
                public void compare(LoadedSnapshot loadedSnapshot) {
                    snapshotCPUView.setRefSnapshot((CPUResultsSnapshot)loadedSnapshot.getSnapshot());
                }
            });
            this.registerActions((JComponent)snapshotCPUView);
            this.displayedPanel = snapshotCPUView;
        }
    }

    private void setupMemoryResultsView() {
        ResultsSnapshot resultsSnapshot = this.snapshot.getSnapshot();
        if (resultsSnapshot instanceof MemoryResultsSnapshot) {
            GenericFilter genericFilter = this.snapshot.getSettings().getInstrumentationFilter();
            if (genericFilter != null && genericFilter.isEmpty()) {
                genericFilter = null;
            }
            MemoryResultsSnapshot memoryResultsSnapshot = (MemoryResultsSnapshot)resultsSnapshot;
            SaveSnapshotAction saveSnapshotAction = new SaveSnapshotAction(this.snapshot);
            CompareSnapshotsAction compareSnapshotsAction = new CompareSnapshotsAction(this.snapshot);
            SnapshotInfoAction snapshotInfoAction = new SnapshotInfoAction(this.snapshot);
            ExportUtils.Exportable exportable = ResultsManager.getDefault().createSnapshotExporter(this.snapshot);
            final SnapshotMemoryView snapshotMemoryView = new SnapshotMemoryView(memoryResultsSnapshot, genericFilter, saveSnapshotAction, compareSnapshotsAction, snapshotInfoAction, exportable){

                protected boolean showSourceSupported() {
                    return GoToSource.isAvailable();
                }

                protected boolean profileMethodSupported() {
                    return ProfilerFeature.Registry.hasProviders();
                }

                protected boolean profileClassSupported() {
                    return ProfilerFeature.Registry.hasProviders();
                }

                protected void showSource(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                    Lookup.Provider provider = SnapshotResultsWindow.this.snapshot.getProject();
                    String string = sourceCodeSelection.getClassName();
                    String string2 = sourceCodeSelection.getMethodName();
                    String string3 = sourceCodeSelection.getMethodSignature();
                    GoToSource.openSource((Lookup.Provider)provider, (String)string, (String)string2, (String)string3);
                }

                protected void selectForProfiling(final ClientUtils.SourceCodeSelection sourceCodeSelection) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            Lookup.Provider provider = SnapshotResultsWindow.this.snapshot.getProject();
                            ProfilerSession.findAndConfigure(Lookups.fixed((Object[])new Object[]{sourceCodeSelection}), provider, Bundle.SnapshotResultsWindow_ProfileClass());
                        }
                    });
                }
            };
            compareSnapshotsAction.setPerformer(new CompareSnapshotsAction.Performer(){

                @Override
                public void compare(LoadedSnapshot loadedSnapshot) {
                    snapshotMemoryView.setRefSnapshot((MemoryResultsSnapshot)loadedSnapshot.getSnapshot());
                }
            });
            this.registerActions((JComponent)snapshotMemoryView);
            this.displayedPanel = snapshotMemoryView;
        }
    }

    private void setupJDBCResultsView() {
        ResultsSnapshot resultsSnapshot = this.snapshot.getSnapshot();
        if (resultsSnapshot instanceof JdbcResultsSnapshot) {
            JdbcResultsSnapshot jdbcResultsSnapshot = (JdbcResultsSnapshot)resultsSnapshot;
            SaveSnapshotAction saveSnapshotAction = new SaveSnapshotAction(this.snapshot);
            CompareSnapshotsAction compareSnapshotsAction = new CompareSnapshotsAction(this.snapshot);
            SnapshotInfoAction snapshotInfoAction = new SnapshotInfoAction(this.snapshot);
            ExportUtils.Exportable exportable = ResultsManager.getDefault().createSnapshotExporter(this.snapshot);
            final SnapshotJDBCView snapshotJDBCView = new SnapshotJDBCView(jdbcResultsSnapshot, saveSnapshotAction, compareSnapshotsAction, snapshotInfoAction, exportable){

                protected boolean showSourceSupported() {
                    return GoToSource.isAvailable();
                }

                protected void showSource(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                    Lookup.Provider provider = SnapshotResultsWindow.this.snapshot.getProject();
                    String string = sourceCodeSelection.getClassName();
                    String string2 = sourceCodeSelection.getMethodName();
                    String string3 = sourceCodeSelection.getMethodSignature();
                    GoToSource.openSource((Lookup.Provider)provider, (String)string, (String)string2, (String)string3);
                }

                protected void showSQLQuery(String string, String string2) {
                    HTMLTextArea hTMLTextArea = new HTMLTextArea(string2);
                    JScrollPane jScrollPane = new JScrollPane((Component)hTMLTextArea);
                    jScrollPane.setPreferredSize(new Dimension(500, 250));
                    JLabel jLabel = new JLabel(Bundle.SnapshotResultsWindow_SqlQueryLabel(), 10);
                    jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                    jLabel.setLabelFor((Component)hTMLTextArea);
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add((Component)jLabel, "North");
                    jPanel.add((Component)jScrollPane, "Center");
                    jPanel.setBorder(BorderFactory.createEmptyBorder(12, 10, 0, 10));
                    HelpCtx helpCtx = new HelpCtx("SqlQueryViewer.HelpCtx");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)jPanel, Bundle.SnapshotResultsWindow_SqlQueryCaption(), false, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, helpCtx, null));
                }

                protected void selectForProfiling(final ClientUtils.SourceCodeSelection sourceCodeSelection) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            Lookup.Provider provider = SnapshotResultsWindow.this.snapshot.getProject();
                            String string = "*".equals(sourceCodeSelection.getMethodName()) ? Bundle.SnapshotResultsWindow_ProfileClass() : Bundle.SnapshotResultsWindow_ProfileMethod();
                            ProfilerSession.findAndConfigure(Lookups.fixed((Object[])new Object[]{sourceCodeSelection}), provider, string);
                        }
                    });
                }
            };
            compareSnapshotsAction.setPerformer(new CompareSnapshotsAction.Performer(){

                @Override
                public void compare(LoadedSnapshot loadedSnapshot) {
                    snapshotJDBCView.setRefSnapshot((JdbcResultsSnapshot)loadedSnapshot.getSnapshot());
                }
            });
            this.registerActions((JComponent)snapshotJDBCView);
            this.displayedPanel = snapshotJDBCView;
        }
    }

    private void forcedClose() {
        this.forcedClose = true;
        this.close();
    }

    private void registerActions(final JComponent jComponent) {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Action action = jComponent.getActionMap().get("filter-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)abstractAction, (ActionMap)actionMap, (InputMap)inputMap);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Action action = jComponent.getActionMap().get("find-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)abstractAction2, (ActionMap)actionMap, (InputMap)inputMap);
    }

    private void updateSaveState() {
        if (this.snapshot != null) {
            if (this.snapshot.isSaved()) {
                this.savePerformer.remove();
            } else {
                this.savePerformer.add();
            }
        } else {
            this.savePerformer.remove();
        }
    }

    private class SavePerformer
    extends AbstractSavable {
        private SavePerformer() {
        }

        private void add() {
            this.register();
            SnapshotResultsWindow.this.ic.add((Object)this);
        }

        private void remove() {
            this.unregister();
            SnapshotResultsWindow.this.ic.remove((Object)this);
        }

        protected String findDisplayName() {
            return SnapshotResultsWindow.this.tabName;
        }

        protected void handleSave() {
            LoadedSnapshot loadedSnapshot = SnapshotResultsWindow.this.snapshot;
            if (loadedSnapshot == null) {
                return;
            }
            ResultsManager.getDefault().saveSnapshot(loadedSnapshot);
            SnapshotResultsWindow.this.ic.remove((Object)this);
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }

    public static interface FindPerformer {
        public void performFind();

        public void performFindNext();

        public void performFindPrevious();
    }

    public static class SnapshotListener
    implements SnapshotsListener {
        List<SnapshotResultsWindow> registeredWindows;

        void registerSnapshotResultsWindow(SnapshotResultsWindow snapshotResultsWindow) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.registeredWindows == null) {
                this.registeredWindows = new ArrayList<SnapshotResultsWindow>();
            }
            this.registeredWindows.add(snapshotResultsWindow);
        }

        void unregisterSnapshotResultsWindow(SnapshotResultsWindow snapshotResultsWindow) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.registeredWindows != null) {
                this.registeredWindows.remove((Object)snapshotResultsWindow);
            }
        }

        @Override
        public void snapshotLoaded(LoadedSnapshot loadedSnapshot) {
        }

        @Override
        public void snapshotRemoved(LoadedSnapshot loadedSnapshot) {
        }

        @Override
        public void snapshotSaved(LoadedSnapshot loadedSnapshot) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.registeredWindows != null) {
                for (SnapshotResultsWindow snapshotResultsWindow : this.registeredWindows) {
                    if (snapshotResultsWindow.snapshot != loadedSnapshot) continue;
                    snapshotResultsWindow.updateSaveState();
                }
            }
        }

        @Override
        public void snapshotTaken(LoadedSnapshot loadedSnapshot) {
        }
    }
}

