/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;

public final class DefaultProxySelector
implements ProxySelector {
    private List<ProxyDef> proxies = new ArrayList<ProxyDef>();

    public DefaultProxySelector add(Proxy proxy2, String nonProxyHosts) {
        Objects.requireNonNull(proxy2, "proxy cannot be null");
        this.proxies.add(new ProxyDef(proxy2, nonProxyHosts));
        return this;
    }

    @Override
    public Proxy getProxy(RemoteRepository repository) {
        ProxyDef proxy22;
        HashMap<String, ProxyDef> candidates = new HashMap<String, ProxyDef>();
        String host = repository.getHost();
        for (ProxyDef proxy22 : this.proxies) {
            String key2;
            if (proxy22.nonProxyHosts.isNonProxyHost(host) || candidates.containsKey(key2 = proxy22.proxy.getType().toLowerCase(Locale.ENGLISH))) continue;
            candidates.put(key2, proxy22);
        }
        String protocol = repository.getProtocol().toLowerCase(Locale.ENGLISH);
        if ("davs".equals(protocol)) {
            protocol = "https";
        } else if ("dav".equals(protocol)) {
            protocol = "http";
        } else if (protocol.startsWith("dav:")) {
            protocol = protocol.substring("dav:".length());
        }
        proxy22 = (ProxyDef)candidates.get(protocol);
        if (proxy22 == null && "https".equals(protocol)) {
            proxy22 = (ProxyDef)candidates.get("http");
        }
        return proxy22 != null ? proxy22.proxy : null;
    }

    static class ProxyDef {
        final Proxy proxy;
        final NonProxyHosts nonProxyHosts;

        ProxyDef(Proxy proxy2, String nonProxyHosts) {
            this.proxy = proxy2;
            this.nonProxyHosts = new NonProxyHosts(nonProxyHosts);
        }
    }

    static class NonProxyHosts {
        private final Pattern[] patterns;

        NonProxyHosts(String nonProxyHosts) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            if (nonProxyHosts != null) {
                StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
                while (tokenizer.hasMoreTokens()) {
                    String pattern = tokenizer.nextToken();
                    pattern = pattern.replace(".", "\\.").replace("*", ".*");
                    patterns.add(Pattern.compile(pattern, 2));
                }
            }
            this.patterns = patterns.toArray(new Pattern[patterns.size()]);
        }

        boolean isNonProxyHost(String host) {
            if (host != null) {
                for (Pattern pattern : this.patterns) {
                    if (!pattern.matcher(host).matches()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

