/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs.auxiliary.remote.RemoteCache;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheMonitor;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheClient;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.CacheWatchRepairable;
import org.apache.commons.jcs.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs.engine.ZombieCacheWatch;
import org.apache.commons.jcs.engine.behavior.ICacheObserver;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheManager {
    private static final Log log = LogFactory.getLog(RemoteCacheManager.class);
    private final ConcurrentMap<String, RemoteCacheNoWait<?, ?>> caches = new ConcurrentHashMap();
    private final ICacheEventLogger cacheEventLogger;
    private final IElementSerializer elementSerializer;
    private ICacheServiceNonLocal<?, ?> remoteService;
    private CacheWatchRepairable remoteWatch;
    private final ICompositeCacheManager cacheMgr;
    private final RemoteCacheMonitor monitor;
    private final String registry;
    private boolean canFix = true;

    protected RemoteCacheManager(IRemoteCacheAttributes cattr, ICompositeCacheManager cacheMgr, RemoteCacheMonitor monitor, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.cacheMgr = cacheMgr;
        this.monitor = monitor;
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
        this.remoteWatch = new CacheWatchRepairable();
        this.registry = RemoteUtils.getNamingURL(cattr.getRemoteLocation(), cattr.getRemoteServiceName());
        try {
            this.lookupRemoteService();
        }
        catch (IOException e) {
            log.error("Could not find server", e);
            monitor.notifyError();
        }
    }

    protected void lookupRemoteService() throws IOException {
        if (log.isInfoEnabled()) {
            log.info("Looking up server [" + this.registry + "]");
        }
        try {
            Remote obj = Naming.lookup(this.registry);
            if (log.isInfoEnabled()) {
                log.info("Server found: " + obj);
            }
            this.remoteService = (ICacheServiceNonLocal)obj;
            if (log.isDebugEnabled()) {
                log.debug("Remote Service = " + this.remoteService);
            }
            this.remoteWatch.setCacheWatch((ICacheObserver)((Object)this.remoteService));
        }
        catch (Exception ex) {
            this.remoteService = new ZombieCacheServiceNonLocal();
            this.remoteWatch.setCacheWatch(new ZombieCacheWatch());
            throw new IOException("Problem finding server at [" + this.registry + "]", ex);
        }
    }

    public <K, V> void addRemoteCacheListener(IRemoteCacheAttributes cattr, IRemoteCacheListener<K, V> listener) throws IOException {
        if (cattr.isReceive()) {
            if (log.isInfoEnabled()) {
                log.info("The remote cache is configured to receive events from the remote server.  We will register a listener. remoteWatch = " + this.remoteWatch + " | IRemoteCacheListener = " + listener + " | cacheName " + cattr.getCacheName());
            }
            this.remoteWatch.addCacheListener(cattr.getCacheName(), listener);
        } else if (log.isInfoEnabled()) {
            log.info("The remote cache is configured to NOT receive events from the remote server.  We will NOT register a listener.");
        }
    }

    public void removeRemoteCacheListener(IRemoteCacheAttributes cattr) throws IOException {
        RemoteCacheNoWait cache = (RemoteCacheNoWait)this.caches.get(cattr.getCacheName());
        if (cache != null) {
            this.removeListenerFromCache(cache);
        } else if (cattr.isReceive()) {
            log.warn("Trying to deregister Cache Listener that was never registered.");
        } else if (log.isDebugEnabled()) {
            log.debug("Since the remote cache is configured to not receive, there is no listener to deregister.");
        }
    }

    private void removeListenerFromCache(RemoteCacheNoWait<?, ?> cache) throws IOException {
        IRemoteCacheClient<?, ?> rc = cache.getRemoteCache();
        if (log.isDebugEnabled()) {
            log.debug("Found cache for [" + cache.getCacheName() + "], deregistering listener.");
        }
        IRemoteCacheListener<?, ?> listener = rc.getListener();
        this.remoteWatch.removeCacheListener(cache.getCacheName(), listener);
    }

    public <K, V> RemoteCacheNoWait<K, V> getCache(IRemoteCacheAttributes cattr) {
        RemoteCacheNoWait remoteCacheNoWait = this.caches.computeIfAbsent(cattr.getCacheName(), key -> this.newRemoteCacheNoWait(cattr));
        return remoteCacheNoWait;
    }

    protected <K, V> RemoteCacheNoWait<K, V> newRemoteCacheNoWait(IRemoteCacheAttributes cattr) {
        RemoteCacheListener listener = null;
        try {
            listener = new RemoteCacheListener(cattr, this.cacheMgr, this.elementSerializer);
            this.addRemoteCacheListener(cattr, listener);
        }
        catch (IOException ioe) {
            log.error("Problem adding listener. Message: " + ioe.getMessage() + " | RemoteCacheListener = " + listener, ioe);
        }
        catch (Exception e) {
            log.error("Problem adding listener. Message: " + e.getMessage() + " | RemoteCacheListener = " + listener, e);
        }
        RemoteCache remoteCacheClient = new RemoteCache(cattr, this.remoteService, listener, this.monitor);
        remoteCacheClient.setCacheEventLogger(this.cacheEventLogger);
        remoteCacheClient.setElementSerializer(this.elementSerializer);
        RemoteCacheNoWait remoteCacheNoWait = new RemoteCacheNoWait(remoteCacheClient);
        remoteCacheNoWait.setCacheEventLogger(this.cacheEventLogger);
        remoteCacheNoWait.setElementSerializer(this.elementSerializer);
        return remoteCacheNoWait;
    }

    public void release() {
        for (RemoteCacheNoWait c : this.caches.values()) {
            try {
                if (log.isInfoEnabled()) {
                    log.info("freeCache [" + c.getCacheName() + "]");
                }
                this.removeListenerFromCache(c);
                c.dispose();
            }
            catch (IOException ex) {
                log.error("Problem releasing " + c.getCacheName(), ex);
            }
        }
        this.caches.clear();
    }

    public void fixCaches() {
        if (!this.canFix) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Fixing caches. ICacheServiceNonLocal " + this.remoteService + " | IRemoteCacheObserver " + this.remoteWatch);
        }
        for (RemoteCacheNoWait c : this.caches.values()) {
            if (c.getStatus() != CacheStatus.ERROR) continue;
            c.fixCache(this.remoteService);
        }
        if (log.isInfoEnabled()) {
            String msg = "Remote connection to " + this.registry + " resumed.";
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logApplicationEvent("RemoteCacheManager", "fix", msg);
            }
            log.info(msg);
        }
    }

    public boolean canFixCaches() {
        try {
            this.lookupRemoteService();
        }
        catch (IOException e) {
            log.error("Could not find server", e);
            this.canFix = false;
        }
        return this.canFix;
    }
}

