/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.zip;

class ZipConstants {
    static final int METHOD_STORED = 0;
    static final int METHOD_DEFLATED = 8;
    static long LOCSIG = 67324752L;
    static long CENSIG = 33639248L;
    static long ENDSIG = 101010256L;
    static final int LOCHDR = 30;
    static final int CENHDR = 46;
    static final int ENDHDR = 22;
    static final long ZIP64_ENDSIG = 101075792L;
    static final long ZIP64_LOCSIG = 117853008L;
    static final int ZIP64_ENDHDR = 56;
    static final int ZIP64_LOCHDR = 20;
    static final int ZIP64_MINVAL32 = 65535;
    static final long ZIP64_MINVAL = 0xFFFFFFFFL;
    static final int EXTID_ZIP64 = 1;
    static final int EXTID_NTFS = 10;
    static final int EXTID_EXTT = 21589;
    static final long END_MAXLEN = 65557L;
    static final int READBLOCKSZ = 128;

    ZipConstants() {
    }

    static final int CH(byte[] byArray, int n) {
        return Byte.toUnsignedInt(byArray[n]);
    }

    static final int SH(byte[] byArray, int n) {
        return Byte.toUnsignedInt(byArray[n]) | Byte.toUnsignedInt(byArray[n + 1]) << 8;
    }

    static final long LG(byte[] byArray, int n) {
        return (long)(ZipConstants.SH(byArray, n) | ZipConstants.SH(byArray, n + 2) << 16) & 0xFFFFFFFFL;
    }

    static final long LL(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n) | ZipConstants.LG(byArray, n + 4) << 32;
    }

    static final long GETSIG(byte[] byArray) {
        return ZipConstants.LG(byArray, 0);
    }

    static final long LOCSIG(byte[] byArray) {
        return ZipConstants.LG(byArray, 0);
    }

    static final int LOCNAM(byte[] byArray) {
        return ZipConstants.SH(byArray, 26);
    }

    static final int LOCEXT(byte[] byArray) {
        return ZipConstants.SH(byArray, 28);
    }

    static final int ENDSUB(byte[] byArray) {
        return ZipConstants.SH(byArray, 8);
    }

    static final int ENDTOT(byte[] byArray) {
        return ZipConstants.SH(byArray, 10);
    }

    static final long ENDSIZ(byte[] byArray) {
        return ZipConstants.LG(byArray, 12);
    }

    static final long ENDOFF(byte[] byArray) {
        return ZipConstants.LG(byArray, 16);
    }

    static final int ENDCOM(byte[] byArray) {
        return ZipConstants.SH(byArray, 20);
    }

    static final int ENDCOM(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 20);
    }

    static final long ZIP64_ENDTOD(byte[] byArray) {
        return ZipConstants.LL(byArray, 24);
    }

    static final long ZIP64_ENDTOT(byte[] byArray) {
        return ZipConstants.LL(byArray, 32);
    }

    static final long ZIP64_ENDSIZ(byte[] byArray) {
        return ZipConstants.LL(byArray, 40);
    }

    static final long ZIP64_ENDOFF(byte[] byArray) {
        return ZipConstants.LL(byArray, 48);
    }

    static final long ZIP64_LOCOFF(byte[] byArray) {
        return ZipConstants.LL(byArray, 8);
    }

    static final long CENSIG(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 0);
    }

    static final int CENVEM(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 4);
    }

    static final int CENVER(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 6);
    }

    static final int CENFLG(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 8);
    }

    static final int CENHOW(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 10);
    }

    static final long CENTIM(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 12);
    }

    static final long CENCRC(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 16);
    }

    static final long CENSIZ(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 20);
    }

    static final long CENLEN(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 24);
    }

    static final int CENNAM(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 28);
    }

    static final int CENEXT(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 30);
    }

    static final int CENCOM(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 32);
    }

    static final int CENDSK(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 34);
    }

    static final int CENATT(byte[] byArray, int n) {
        return ZipConstants.SH(byArray, n + 36);
    }

    static final long CENATX(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 38);
    }

    static final long CENOFF(byte[] byArray, int n) {
        return ZipConstants.LG(byArray, n + 42);
    }
}

