/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.lang.invoke.MethodHandles;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.CdcrParams;
import org.apache.solr.handler.CdcrStateManager;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CdcrProcessStateManager
extends CdcrStateManager {
    private CdcrParams.ProcessState state = DEFAULT_STATE;
    private ProcessStateWatcher wrappedWatcher;
    private Watcher watcher;
    private SolrCore core;
    static CdcrParams.ProcessState DEFAULT_STATE = CdcrParams.ProcessState.STOPPED;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    CdcrProcessStateManager(SolrCore core) {
        this.core = core;
        this.createStateNode();
        try {
            SolrZkClient zkClient = core.getCoreContainer().getZkController().getZkClient();
            this.watcher = this.initWatcher(zkClient);
            this.setState(CdcrParams.ProcessState.get(zkClient.getData(this.getZnodePath(), this.watcher, null, true)));
        }
        catch (InterruptedException | KeeperException e) {
            log.warn("Failed fetching initial state", e);
        }
    }

    private Watcher initWatcher(SolrZkClient zkClient) {
        this.wrappedWatcher = new ProcessStateWatcher();
        return zkClient.wrapWatcher((Watcher)this.wrappedWatcher);
    }

    private String getZnodeBase() {
        return "/collections/" + this.core.getCoreDescriptor().getCloudDescriptor().getCollectionName() + "/cdcr/state";
    }

    private String getZnodePath() {
        return this.getZnodeBase() + "/process";
    }

    void setState(CdcrParams.ProcessState state) {
        if (this.state != state) {
            this.state = state;
            this.callback();
        }
    }

    CdcrParams.ProcessState getState() {
        return this.state;
    }

    void synchronize() {
        SolrZkClient zkClient = this.core.getCoreContainer().getZkController().getZkClient();
        try {
            zkClient.setData(this.getZnodePath(), this.getState().getBytes(), true);
            this.setState(CdcrParams.ProcessState.get(zkClient.getData(this.getZnodePath(), this.watcher, null, true)));
        }
        catch (InterruptedException | KeeperException e) {
            log.warn("Failed synchronising new state", e);
        }
    }

    private void createStateNode() {
        SolrZkClient zkClient = this.core.getCoreContainer().getZkController().getZkClient();
        try {
            if (!zkClient.exists(this.getZnodePath(), true).booleanValue()) {
                if (!zkClient.exists(this.getZnodeBase(), true).booleanValue()) {
                    zkClient.makePath(this.getZnodeBase(), null, CreateMode.PERSISTENT, null, false, true);
                }
                zkClient.create(this.getZnodePath(), DEFAULT_STATE.getBytes(), CreateMode.PERSISTENT, true);
                log.info("Created znode {}", (Object)this.getZnodePath());
            }
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (InterruptedException | KeeperException e) {
            log.warn("Failed to create CDCR process state node", e);
        }
    }

    void shutdown() {
        if (this.wrappedWatcher != null) {
            this.wrappedWatcher.cancel();
        }
    }

    private class ProcessStateWatcher
    implements Watcher {
        private boolean isCancelled = false;

        private ProcessStateWatcher() {
        }

        void cancel() {
            this.isCancelled = true;
        }

        public void process(WatchedEvent event) {
            if (this.isCancelled) {
                return;
            }
            String collectionName = CdcrProcessStateManager.this.core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
            String shard = CdcrProcessStateManager.this.core.getCoreDescriptor().getCloudDescriptor().getShardId();
            log.info("The CDCR process state has changed: {} @ {}:{}", new Object[]{event, collectionName, shard});
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            SolrZkClient zkClient = CdcrProcessStateManager.this.core.getCoreContainer().getZkController().getZkClient();
            try {
                CdcrParams.ProcessState state = CdcrParams.ProcessState.get(zkClient.getData(CdcrProcessStateManager.this.getZnodePath(), CdcrProcessStateManager.this.watcher, null, true));
                log.info("Received new CDCR process state from watcher: {} @ {}:{}", new Object[]{state, collectionName, shard});
                CdcrProcessStateManager.this.setState(state);
            }
            catch (InterruptedException | KeeperException e) {
                log.warn("Failed synchronising new state @ " + collectionName + ":" + shard, e);
            }
        }
    }
}

