/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class HomeObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> properties;

    public String getProperty(String string) {
        if (this.properties != null) {
            return this.properties.get(string);
        }
        return null;
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            if (this.properties != null && this.properties.containsKey(string)) {
                try {
                    this.properties.remove(string);
                    if (this.properties.size() == 0) {
                        this.properties = null;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.properties = null;
                }
            }
        } else if (this.properties == null) {
            this.properties = Collections.singletonMap(string, string2);
        } else {
            if (this.properties.size() == 1 && !(this.properties instanceof HashMap)) {
                Map<String, String> map = this.properties;
                this.properties = new HashMap<String, String>();
                String string3 = map.keySet().iterator().next();
                this.properties.put(string3, map.get(string3));
            }
            this.properties.put(string, string2);
        }
    }

    public Collection<String> getPropertyNames() {
        if (this.properties != null) {
            return this.properties.keySet();
        }
        return Collections.emptySet();
    }

    public HomeObject clone() {
        try {
            HomeObject homeObject = (HomeObject)super.clone();
            if (this.properties != null) {
                homeObject.properties = homeObject.properties.size() == 1 ? Collections.singletonMap(this.properties.keySet().iterator().next(), this.properties.values().iterator().next()) : new HashMap<String, String>(this.properties);
            }
            return homeObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Super class isn't cloneable");
        }
    }
}

