/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.JarScannerFactory;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TldLocation;
import org.apache.jasper.compiler.WebXml;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.JarFactory;

public class TldLocationsCache {
    private final Log log = LogFactory.getLog(TldLocationsCache.class);
    private static final String KEY = TldLocationsCache.class.getName();
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_INF = "/WEB-INF/";
    private static final String WEB_INF_LIB = "/WEB-INF/lib/";
    private static final String JAR_EXT = ".jar";
    private static final String TLD_EXT = ".tld";
    private static Set<String> noTldJars = null;
    private static volatile boolean showTldScanWarning = true;
    private Hashtable<String, TldLocation> mappings;
    private volatile boolean initialized;
    private ServletContext ctxt;

    public static synchronized void setNoTldJars(String jarNames) {
        if (jarNames == null) {
            noTldJars = null;
        } else {
            if (noTldJars == null) {
                noTldJars = new HashSet<String>();
            } else {
                noTldJars.clear();
            }
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken().trim();
                if (token.length() <= 0) continue;
                noTldJars.add(token);
            }
        }
    }

    public TldLocationsCache(ServletContext ctxt) {
        this.ctxt = ctxt;
        this.mappings = new Hashtable();
        this.initialized = false;
    }

    public static synchronized TldLocationsCache getInstance(ServletContext ctxt) {
        if (ctxt == null) {
            throw new IllegalArgumentException("ServletContext was null");
        }
        TldLocationsCache cache = (TldLocationsCache)ctxt.getAttribute(KEY);
        if (cache == null) {
            cache = new TldLocationsCache(ctxt);
            ctxt.setAttribute(KEY, (Object)cache);
        }
        return cache;
    }

    public TldLocation getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private synchronized void init() throws JasperException {
        if (this.initialized) {
            return;
        }
        try {
            this.tldScanWebXml();
            this.tldScanResourcePaths(WEB_INF);
            JarScanner jarScanner = JarScannerFactory.getJarScanner(this.ctxt);
            jarScanner.scan(this.ctxt, Thread.currentThread().getContextClassLoader(), (JarScannerCallback)new TldJarScannerCallback(), noTldJars);
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit", ex.getMessage()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanWebXml() throws Exception {
        WebXml webXml = null;
        try {
            webXml = new WebXml(this.ctxt);
            if (webXml.getInputSource() == null) {
                return;
            }
            boolean validate = Boolean.parseBoolean(this.ctxt.getInitParameter("org.apache.jasper.XML_VALIDATE"));
            String blockExternalString = this.ctxt.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
            boolean blockExternal = blockExternalString == null ? true : Boolean.parseBoolean(blockExternalString);
            ParserUtils pu = new ParserUtils(validate, blockExternal);
            TreeNode webtld = null;
            webtld = pu.parseXMLDocument(webXml.getSystemId(), webXml.getInputSource());
            TreeNode jspConfig = webtld.findChild("jsp-config");
            if (jspConfig != null) {
                webtld = jspConfig;
            }
            Iterator<TreeNode> taglibs = webtld.findChildren("taglib");
            while (taglibs.hasNext()) {
                TreeNode taglib = taglibs.next();
                String tagUri = null;
                String tagLoc = null;
                TreeNode child = taglib.findChild("taglib-uri");
                if (child != null) {
                    tagUri = child.getBody();
                }
                if ((child = taglib.findChild("taglib-location")) != null) {
                    tagLoc = child.getBody();
                }
                if (tagLoc == null) continue;
                if (TldLocationsCache.uriType(tagLoc) == 2) {
                    tagLoc = WEB_INF + tagLoc;
                }
                TldLocation location = tagLoc.endsWith(JAR_EXT) ? new TldLocation("META-INF/taglib.tld", this.ctxt.getResource(tagLoc).toString()) : new TldLocation(tagLoc);
                this.mappings.put(tagUri, location);
            }
        }
        finally {
            if (webXml != null) {
                webXml.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanResourcePaths(String startPath) throws Exception {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (!path.endsWith(TLD_EXT) && (path.startsWith(WEB_INF_LIB) || path.startsWith("/WEB-INF/classes/"))) continue;
                if (path.endsWith(TLD_EXT)) {
                    if (path.startsWith("/WEB-INF/tags/") && !path.endsWith("implicit.tld")) continue;
                    InputStream stream = this.ctxt.getResourceAsStream(path);
                    try {
                        this.tldScanStream(path, null, stream);
                        continue;
                    }
                    finally {
                        if (stream == null) continue;
                        try {
                            stream.close();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleThrowable(t);
                        }
                        continue;
                    }
                }
                this.tldScanResourcePaths(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanDir(File start) throws IOException {
        File[] fileList = start.listFiles();
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    this.tldScanDir(fileList[i]);
                    continue;
                }
                if (!fileList[i].getAbsolutePath().endsWith(TLD_EXT)) continue;
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(fileList[i]);
                    this.tldScanStream(fileList[i].toURI().toString(), null, stream);
                    continue;
                }
                finally {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleThrowable(t);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanJar(JarURLConnection jarConn) throws IOException {
        Jar jar = null;
        boolean foundTld = false;
        URL resourceURL = jarConn.getJarFileURL();
        String resourcePath = resourceURL.toString();
        try {
            jar = JarFactory.newInstance((URL)jarConn.getURL());
            jar.nextEntry();
            String entryName = jar.getEntryName();
            while (entryName != null) {
                if (entryName.startsWith("META-INF/") && entryName.endsWith(TLD_EXT)) {
                    InputStream is = null;
                    try {
                        is = jar.getEntryInputStream();
                        foundTld = true;
                        this.tldScanStream(resourcePath, entryName, is);
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                }
                jar.nextEntry();
                entryName = jar.getEntryName();
            }
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
        if (!foundTld) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)Localizer.getMessage("jsp.tldCache.noTldInJar", resourcePath));
            } else if (showTldScanWarning) {
                showTldScanWarning = false;
                this.log.info((Object)Localizer.getMessage("jsp.tldCache.noTldSummary"));
            }
        }
    }

    private void tldScanStream(String resourcePath, String entryName, InputStream stream) throws IOException {
        try {
            String body;
            String uri = null;
            boolean validate = Boolean.parseBoolean(this.ctxt.getInitParameter("org.apache.jasper.XML_VALIDATE_TLD"));
            String blockExternalString = this.ctxt.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
            boolean blockExternal = blockExternalString == null ? true : Boolean.parseBoolean(blockExternalString);
            ParserUtils pu = new ParserUtils(validate, blockExternal);
            TreeNode tld = pu.parseXMLDocument(resourcePath, stream);
            TreeNode uriNode = tld.findChild("uri");
            if (uriNode != null && (body = uriNode.getBody()) != null) {
                uri = body;
            }
            if (uri != null && this.mappings.get(uri) == null) {
                TldLocation location = entryName == null ? new TldLocation(resourcePath) : new TldLocation(entryName, resourcePath);
                this.mappings.put(uri, location);
            }
        }
        catch (JasperException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }

    static {
        StringBuilder jarList = new StringBuilder(System.getProperty("tomcat.util.scan.DefaultJarScanner.jarsToSkip", ""));
        String tldJars = System.getProperty("org.apache.catalina.startup.TldConfig.jarsToSkip", "");
        if (tldJars.length() > 0) {
            if (jarList.length() > 0) {
                jarList.append(',');
            }
            jarList.append(tldJars);
        }
        if (jarList.length() > 0) {
            TldLocationsCache.setNoTldJars(jarList.toString());
        }
    }

    private class TldJarScannerCallback
    implements JarScannerCallback {
        private TldJarScannerCallback() {
        }

        public void scan(JarURLConnection urlConn) throws IOException {
            TldLocationsCache.this.tldScanJar(urlConn);
        }

        public void scan(File file) throws IOException {
            File metaInf = new File(file, "META-INF");
            if (metaInf.isDirectory()) {
                TldLocationsCache.this.tldScanDir(metaInf);
            }
        }
    }
}

