/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.ShaderAppearanceRetained;
import javax.media.j3d.ShaderAttributeSet;
import javax.media.j3d.ShaderProgram;

public class ShaderAppearance
extends Appearance {
    public static final int ALLOW_SHADER_PROGRAM_READ = 22;
    public static final int ALLOW_SHADER_PROGRAM_WRITE = 23;
    public static final int ALLOW_SHADER_ATTRIBUTE_SET_READ = 24;
    public static final int ALLOW_SHADER_ATTRIBUTE_SET_WRITE = 25;
    private static final int[] readCapabilities = new int[]{22, 24};

    public ShaderAppearance() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    @Override
    void createRetained() {
        this.retained = new ShaderAppearanceRetained();
        this.retained.setSource(this);
    }

    public void setShaderProgram(ShaderProgram shaderProgram) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAppearance0"));
        }
        ((ShaderAppearanceRetained)this.retained).setShaderProgram(shaderProgram);
    }

    public ShaderProgram getShaderProgram() {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAppearance1"));
        }
        return ((ShaderAppearanceRetained)this.retained).getShaderProgram();
    }

    public void setShaderAttributeSet(ShaderAttributeSet shaderAttributeSet) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAppearance2"));
        }
        ((ShaderAppearanceRetained)this.retained).setShaderAttributeSet(shaderAttributeSet);
    }

    public ShaderAttributeSet getShaderAttributeSet() {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAppearance3"));
        }
        return ((ShaderAppearanceRetained)this.retained).getShaderAttributeSet();
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        ShaderAppearance shaderAppearance = new ShaderAppearance();
        shaderAppearance.duplicateNodeComponent(this);
        return shaderAppearance;
    }

    @Override
    public void duplicateNodeComponent(NodeComponent nodeComponent) {
        this.checkDuplicateNodeComponent(nodeComponent);
    }

    @Override
    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        Hashtable hashtable = nodeComponent.nodeHashtable;
        ShaderAppearanceRetained shaderAppearanceRetained = (ShaderAppearanceRetained)nodeComponent.retained;
        ShaderAppearanceRetained shaderAppearanceRetained2 = (ShaderAppearanceRetained)this.retained;
        shaderAppearanceRetained2.setShaderProgram((ShaderProgram)this.getNodeComponent(shaderAppearanceRetained.getShaderProgram(), bl, hashtable));
    }

    @Override
    boolean duplicateChild() {
        if (super.duplicateChild()) {
            return true;
        }
        if (this.getDuplicateOnCloneTree()) {
            return true;
        }
        ShaderAppearanceRetained shaderAppearanceRetained = (ShaderAppearanceRetained)this.retained;
        ShaderProgram shaderProgram = shaderAppearanceRetained.getShaderProgram();
        return shaderProgram != null && shaderProgram.getDuplicateOnCloneTree();
    }
}

