/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeAbbreviation;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001aS\u0010\u0002\u001a\u0002H\u0003\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u000526\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u0002H\u00030\u0007H\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0016\u0010\u000e\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0016\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010\u0019\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012\u001a$\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010!\u001a\u00020\"\u001a\u001a\u0010\u001e\u001a\u00020\u001f*\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001a\u0010$\u001a\u00020%*\u00020&2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010'\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0014\u0010(\u001a\u0004\u0018\u00010\u000f*\u00020)2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001a\u0010(\u001a\u0004\u0018\u00010\u000f*\u0006\u0012\u0002\b\u00030*2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0012\u0010+\u001a\u00020,*\u00020-2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010.\u001a\u00020/*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u00060"}, d2={"createErrorType", "Lorg/jetbrains/kotlin/ir/types/IrErrorType;", "convertWithOffsets", "T", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/fir/FirElement;", "f", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "startOffset", "endOffset", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/ir/IrElement;", "toBackingFieldSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "toClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "toFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "toIrSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "definitelyNotNull", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "toIrTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinTypeProjection;", "toPropertyOrFieldSymbol", "toSymbol", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "toTypeParameterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "toValueSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "fir2ir"})
public final class ConversionUtilsKt {
    @NotNull
    public static final <T extends IrElement> T convertWithOffsets(@NotNull FirElement $this$convertWithOffsets, @NotNull Function2<? super Integer, ? super Integer, ? extends T> f) {
        Intrinsics.checkParameterIsNotNull($this$convertWithOffsets, "$this$convertWithOffsets");
        Intrinsics.checkParameterIsNotNull(f, "f");
        if (FirSourceElementKt.getPsi($this$convertWithOffsets) instanceof PsiCompiledElement) {
            return (T)((IrElement)f.invoke(-1, -1));
        }
        PsiElement psiElement = FirSourceElementKt.getPsi($this$convertWithOffsets);
        int startOffset = psiElement != null ? PsiUtilsKt.getStartOffsetSkippingComments(psiElement) : -1;
        PsiElement psiElement2 = FirSourceElementKt.getPsi($this$convertWithOffsets);
        int endOffset = psiElement2 != null ? PsiUtilsKt.getEndOffset(psiElement2) : -1;
        return (T)((IrElement)f.invoke(startOffset, endOffset));
    }

    @NotNull
    public static final IrErrorType createErrorType() {
        return new IrErrorTypeImpl(null, CollectionsKt.emptyList(), Variance.INVARIANT);
    }

    @NotNull
    public static final IrType toIrType(@NotNull FirTypeRef $this$toIrType, @NotNull FirSession session, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull($this$toIrType, "$this$toIrType");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        if (!($this$toIrType instanceof FirResolvedTypeRef)) {
            return ConversionUtilsKt.createErrorType();
        }
        return ConversionUtilsKt.toIrType$default(((FirResolvedTypeRef)$this$toIrType).getType(), session, declarationStorage, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType toIrType(@NotNull ConeKotlinType $this$toIrType, @NotNull FirSession session, @NotNull Fir2IrDeclarationStorage declarationStorage, boolean definitelyNotNull) {
        IrType irType;
        Intrinsics.checkParameterIsNotNull($this$toIrType, "$this$toIrType");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        ConeKotlinType coneKotlinType = $this$toIrType;
        if (coneKotlinType instanceof ConeClassErrorType) {
            irType = ConversionUtilsKt.createErrorType();
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            Collection<IrTypeArgument> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FirClassifierSymbol<?> firClassifierSymbol = ResolveUtilsKt.toSymbol(((ConeLookupTagBasedType)$this$toIrType).getLookupTag(), session);
            if (firClassifierSymbol == null) {
                return ConversionUtilsKt.createErrorType();
            }
            FirClassifierSymbol<?> firSymbol = firClassifierSymbol;
            IrClassifierSymbol irSymbol = ConversionUtilsKt.toIrSymbol(firSymbol, session, declarationStorage);
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = $this$toIrType.getTypeArguments();
            boolean bl = !definitelyNotNull && ConeTypeUtilsKt.isMarkedNullable($this$toIrType);
            IrClassifierSymbol irClassifierSymbol = irSymbol;
            boolean $i$f$map = false;
            void var9_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var12_15 = $this$mapTo$iv$iv;
            int n = ((void)var12_15).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var16_19 = item$iv$iv = var12_15[i];
                collection = destination$iv$iv;
                boolean bl2 = false;
                IrTypeArgument irTypeArgument = ConversionUtilsKt.toIrTypeArgument((ConeKotlinTypeProjection)it, session, declarationStorage);
                collection.add(irTypeArgument);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 16;
            IrTypeAbbreviation irTypeAbbreviation = null;
            List list2 = CollectionsKt.emptyList();
            List list3 = collection;
            boolean bl3 = bl;
            IrClassifierSymbol irClassifierSymbol2 = irClassifierSymbol;
            irType = new IrSimpleTypeImpl(irClassifierSymbol2, bl3, list3, list2, irTypeAbbreviation, n2, defaultConstructorMarker);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            irType = ConversionUtilsKt.toIrType(((ConeFlexibleType)$this$toIrType).getUpperBound(), session, declarationStorage, definitelyNotNull);
        } else {
            if (coneKotlinType instanceof ConeCapturedType) {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                irType = ConversionUtilsKt.toIrType(((ConeDefinitelyNotNullType)$this$toIrType).getOriginal(), session, declarationStorage, true);
            } else if (coneKotlinType instanceof ConeIntersectionType) {
                irType = ConversionUtilsKt.toIrType((ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toIrType).getIntersectedTypes()), session, declarationStorage, definitelyNotNull);
            } else if (coneKotlinType instanceof ConeStubType) {
                irType = ConversionUtilsKt.createErrorType();
            } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
                irType = ConversionUtilsKt.toIrType(ConeIntegerLiteralType.getApproximatedType$default((ConeIntegerLiteralType)$this$toIrType, null, 1, null), session, declarationStorage, definitelyNotNull);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irType;
    }

    public static /* synthetic */ IrType toIrType$default(ConeKotlinType coneKotlinType, FirSession firSession, Fir2IrDeclarationStorage fir2IrDeclarationStorage, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return ConversionUtilsKt.toIrType(coneKotlinType, firSession, fir2IrDeclarationStorage, bl);
    }

    @NotNull
    public static final IrTypeArgument toIrTypeArgument(@NotNull ConeKotlinTypeProjection $this$toIrTypeArgument, @NotNull FirSession session, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        IrTypeArgument irTypeArgument;
        Intrinsics.checkParameterIsNotNull($this$toIrTypeArgument, "$this$toIrTypeArgument");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        ConeKotlinTypeProjection coneKotlinTypeProjection = $this$toIrTypeArgument;
        if (Intrinsics.areEqual(coneKotlinTypeProjection, ConeStarProjection.INSTANCE)) {
            irTypeArgument = IrStarProjectionImpl.INSTANCE;
        } else if (coneKotlinTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            IrType irType = ConversionUtilsKt.toIrType$default(((ConeKotlinTypeProjectionIn)$this$toIrTypeArgument).getType(), session, declarationStorage, false, 4, null);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.IN_VARIANCE);
        } else if (coneKotlinTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            IrType irType = ConversionUtilsKt.toIrType$default(((ConeKotlinTypeProjectionOut)$this$toIrTypeArgument).getType(), session, declarationStorage, false, 4, null);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.OUT_VARIANCE);
        } else if (coneKotlinTypeProjection instanceof ConeKotlinType) {
            IrType irType = ConversionUtilsKt.toIrType$default((ConeKotlinType)$this$toIrTypeArgument, session, declarationStorage, false, 4, null);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.INVARIANT);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irTypeArgument;
    }

    @NotNull
    public static final IrClassifierSymbol toIrSymbol(@NotNull FirClassifierSymbol<?> $this$toIrSymbol, @NotNull FirSession session, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        IrClassifierSymbol irClassifierSymbol;
        Intrinsics.checkParameterIsNotNull($this$toIrSymbol, "$this$toIrSymbol");
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        FirClassifierSymbol<?> firClassifierSymbol = $this$toIrSymbol;
        if (firClassifierSymbol instanceof FirTypeParameterSymbol) {
            irClassifierSymbol = ConversionUtilsKt.toTypeParameterSymbol((FirTypeParameterSymbol)$this$toIrSymbol, declarationStorage);
        } else if (firClassifierSymbol instanceof FirTypeAliasSymbol) {
            FirTypeAlias typeAlias = (FirTypeAlias)((FirTypeAliasSymbol)$this$toIrSymbol).getFir();
            FirTypeRef firTypeRef = typeAlias.getExpandedTypeRef();
            if (firTypeRef == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
            }
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)firTypeRef).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
            }
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
            FirClassLikeSymbol<?> firClassLikeSymbol = ResolveUtilsKt.toSymbol(coneClassLikeType.getLookupTag(), session);
            if (firClassLikeSymbol == null) {
                Intrinsics.throwNpe();
            }
            irClassifierSymbol = ConversionUtilsKt.toIrSymbol((FirClassifierSymbol)firClassLikeSymbol, session, declarationStorage);
        } else if (firClassifierSymbol instanceof FirClassSymbol) {
            irClassifierSymbol = ConversionUtilsKt.toClassSymbol((FirClassSymbol)$this$toIrSymbol, declarationStorage);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Should not be here: " + $this$toIrSymbol)));
        }
        return irClassifierSymbol;
    }

    @Nullable
    public static final IrSymbol toSymbol(@NotNull FirReference $this$toSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        IrSymbol irSymbol;
        Intrinsics.checkParameterIsNotNull($this$toSymbol, "$this$toSymbol");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        FirReference firReference = $this$toSymbol;
        if (firReference instanceof FirResolvedNamedReference) {
            irSymbol = ConversionUtilsKt.toSymbol(((FirResolvedNamedReference)$this$toSymbol).getResolvedSymbol(), declarationStorage);
        } else if (firReference instanceof FirThisReference) {
            IrValueParameterSymbol irValueParameterSymbol;
            IrSymbol boundSymbol;
            AbstractFirBasedSymbol<?> abstractFirBasedSymbol = ((FirThisReference)$this$toSymbol).getBoundSymbol();
            IrSymbol irSymbol2 = boundSymbol = abstractFirBasedSymbol != null ? ConversionUtilsKt.toSymbol(abstractFirBasedSymbol, declarationStorage) : null;
            if (boundSymbol instanceof IrClassSymbol) {
                IrValueParameter irValueParameter = ((IrClass)((IrClassSymbol)boundSymbol).getOwner()).getThisReceiver();
                irValueParameterSymbol = irValueParameter != null ? (IrValueParameterSymbol)irValueParameter.getSymbol() : null;
            } else if (boundSymbol instanceof IrFunctionSymbol) {
                IrValueParameter irValueParameter = ((IrFunctionSymbol)boundSymbol).getOwner().getExtensionReceiverParameter();
                irValueParameterSymbol = irValueParameter != null ? (IrValueParameterSymbol)irValueParameter.getSymbol() : null;
            } else {
                irValueParameterSymbol = null;
            }
            irSymbol = irValueParameterSymbol;
        } else {
            irSymbol = null;
        }
        return irSymbol;
    }

    private static final IrSymbol toSymbol(@NotNull AbstractFirBasedSymbol<?> $this$toSymbol, Fir2IrDeclarationStorage declarationStorage) {
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = $this$toSymbol;
        return abstractFirBasedSymbol instanceof FirClassSymbol ? (IrSymbol)ConversionUtilsKt.toClassSymbol((FirClassSymbol)$this$toSymbol, declarationStorage) : (abstractFirBasedSymbol instanceof FirFunctionSymbol ? (IrSymbol)ConversionUtilsKt.toFunctionSymbol((FirFunctionSymbol)$this$toSymbol, declarationStorage) : (abstractFirBasedSymbol instanceof FirPropertySymbol ? (((FirProperty)((FirPropertySymbol)$this$toSymbol).getFir()).isLocal() ? (IrSymbol)ConversionUtilsKt.toValueSymbol((FirVariableSymbol)$this$toSymbol, declarationStorage) : ConversionUtilsKt.toPropertyOrFieldSymbol((FirVariableSymbol)$this$toSymbol, declarationStorage)) : (abstractFirBasedSymbol instanceof FirFieldSymbol ? ConversionUtilsKt.toPropertyOrFieldSymbol((FirVariableSymbol)$this$toSymbol, declarationStorage) : (abstractFirBasedSymbol instanceof FirBackingFieldSymbol ? ConversionUtilsKt.toBackingFieldSymbol((FirVariableSymbol)$this$toSymbol, declarationStorage) : (abstractFirBasedSymbol instanceof FirDelegateFieldSymbol ? ConversionUtilsKt.toBackingFieldSymbol((FirVariableSymbol)$this$toSymbol, declarationStorage) : (abstractFirBasedSymbol instanceof FirVariableSymbol ? (IrSymbol)ConversionUtilsKt.toValueSymbol((FirVariableSymbol)$this$toSymbol, declarationStorage) : null))))));
    }

    @NotNull
    public static final IrClassSymbol toClassSymbol(@NotNull FirClassSymbol<?> $this$toClassSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull($this$toClassSymbol, "$this$toClassSymbol");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        return declarationStorage.getIrClassSymbol($this$toClassSymbol);
    }

    @NotNull
    public static final IrTypeParameterSymbol toTypeParameterSymbol(@NotNull FirTypeParameterSymbol $this$toTypeParameterSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull($this$toTypeParameterSymbol, "$this$toTypeParameterSymbol");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        return declarationStorage.getIrTypeParameterSymbol($this$toTypeParameterSymbol);
    }

    @NotNull
    public static final IrFunctionSymbol toFunctionSymbol(@NotNull FirFunctionSymbol<?> $this$toFunctionSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull($this$toFunctionSymbol, "$this$toFunctionSymbol");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        return declarationStorage.getIrFunctionSymbol($this$toFunctionSymbol);
    }

    @NotNull
    public static final IrSymbol toPropertyOrFieldSymbol(@NotNull FirVariableSymbol<?> $this$toPropertyOrFieldSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull($this$toPropertyOrFieldSymbol, "$this$toPropertyOrFieldSymbol");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        return declarationStorage.getIrPropertyOrFieldSymbol($this$toPropertyOrFieldSymbol);
    }

    @NotNull
    public static final IrSymbol toBackingFieldSymbol(@NotNull FirVariableSymbol<?> $this$toBackingFieldSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull($this$toBackingFieldSymbol, "$this$toBackingFieldSymbol");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        return declarationStorage.getIrBackingFieldSymbol($this$toBackingFieldSymbol);
    }

    @NotNull
    public static final IrValueSymbol toValueSymbol(@NotNull FirVariableSymbol<?> $this$toValueSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull($this$toValueSymbol, "$this$toValueSymbol");
        Intrinsics.checkParameterIsNotNull(declarationStorage, "declarationStorage");
        return declarationStorage.getIrValueSymbol($this$toValueSymbol);
    }
}

