﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/alexaforbusiness/AlexaForBusiness_EXPORTS.h>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace AlexaForBusiness
{
namespace Model
{

  /**
   * <p>Creates settings for the instant booking feature that are applied to a room
   * profile. When users start their meeting with Alexa, Alexa automatically books
   * the room for the configured duration if the room is available.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateInstantBooking">AWS
   * API Reference</a></p>
   */
  class AWS_ALEXAFORBUSINESS_API CreateInstantBooking
  {
  public:
    CreateInstantBooking();
    CreateInstantBooking(Aws::Utils::Json::JsonView jsonValue);
    CreateInstantBooking& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Duration between 15 and 240 minutes at increments of 15 that determines how
     * long to book an available room when a meeting is started with Alexa.</p>
     */
    inline int GetDurationInMinutes() const{ return m_durationInMinutes; }

    /**
     * <p>Duration between 15 and 240 minutes at increments of 15 that determines how
     * long to book an available room when a meeting is started with Alexa.</p>
     */
    inline bool DurationInMinutesHasBeenSet() const { return m_durationInMinutesHasBeenSet; }

    /**
     * <p>Duration between 15 and 240 minutes at increments of 15 that determines how
     * long to book an available room when a meeting is started with Alexa.</p>
     */
    inline void SetDurationInMinutes(int value) { m_durationInMinutesHasBeenSet = true; m_durationInMinutes = value; }

    /**
     * <p>Duration between 15 and 240 minutes at increments of 15 that determines how
     * long to book an available room when a meeting is started with Alexa.</p>
     */
    inline CreateInstantBooking& WithDurationInMinutes(int value) { SetDurationInMinutes(value); return *this;}


    /**
     * <p>Whether instant booking is enabled or not.</p>
     */
    inline bool GetEnabled() const{ return m_enabled; }

    /**
     * <p>Whether instant booking is enabled or not.</p>
     */
    inline bool EnabledHasBeenSet() const { return m_enabledHasBeenSet; }

    /**
     * <p>Whether instant booking is enabled or not.</p>
     */
    inline void SetEnabled(bool value) { m_enabledHasBeenSet = true; m_enabled = value; }

    /**
     * <p>Whether instant booking is enabled or not.</p>
     */
    inline CreateInstantBooking& WithEnabled(bool value) { SetEnabled(value); return *this;}

  private:

    int m_durationInMinutes;
    bool m_durationInMinutesHasBeenSet;

    bool m_enabled;
    bool m_enabledHasBeenSet;
  };

} // namespace Model
} // namespace AlexaForBusiness
} // namespace Aws
