﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/codestar-notifications/CodeStarNotifications_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/codestar-notifications/model/TargetStatus.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CodeStarNotifications
{
namespace Model
{

  /**
   * <p>Information about the targets specified for a notification
   * rule.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/TargetSummary">AWS
   * API Reference</a></p>
   */
  class AWS_CODESTARNOTIFICATIONS_API TargetSummary
  {
  public:
    TargetSummary();
    TargetSummary(Aws::Utils::Json::JsonView jsonValue);
    TargetSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The Amazon Resource Name (ARN) of the SNS topic.</p>
     */
    inline const Aws::String& GetTargetAddress() const{ return m_targetAddress; }

    /**
     * <p>The Amazon Resource Name (ARN) of the SNS topic.</p>
     */
    inline bool TargetAddressHasBeenSet() const { return m_targetAddressHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the SNS topic.</p>
     */
    inline void SetTargetAddress(const Aws::String& value) { m_targetAddressHasBeenSet = true; m_targetAddress = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the SNS topic.</p>
     */
    inline void SetTargetAddress(Aws::String&& value) { m_targetAddressHasBeenSet = true; m_targetAddress = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the SNS topic.</p>
     */
    inline void SetTargetAddress(const char* value) { m_targetAddressHasBeenSet = true; m_targetAddress.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the SNS topic.</p>
     */
    inline TargetSummary& WithTargetAddress(const Aws::String& value) { SetTargetAddress(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the SNS topic.</p>
     */
    inline TargetSummary& WithTargetAddress(Aws::String&& value) { SetTargetAddress(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the SNS topic.</p>
     */
    inline TargetSummary& WithTargetAddress(const char* value) { SetTargetAddress(value); return *this;}


    /**
     * <p>The type of the target (for example, SNS).</p>
     */
    inline const Aws::String& GetTargetType() const{ return m_targetType; }

    /**
     * <p>The type of the target (for example, SNS).</p>
     */
    inline bool TargetTypeHasBeenSet() const { return m_targetTypeHasBeenSet; }

    /**
     * <p>The type of the target (for example, SNS).</p>
     */
    inline void SetTargetType(const Aws::String& value) { m_targetTypeHasBeenSet = true; m_targetType = value; }

    /**
     * <p>The type of the target (for example, SNS).</p>
     */
    inline void SetTargetType(Aws::String&& value) { m_targetTypeHasBeenSet = true; m_targetType = std::move(value); }

    /**
     * <p>The type of the target (for example, SNS).</p>
     */
    inline void SetTargetType(const char* value) { m_targetTypeHasBeenSet = true; m_targetType.assign(value); }

    /**
     * <p>The type of the target (for example, SNS).</p>
     */
    inline TargetSummary& WithTargetType(const Aws::String& value) { SetTargetType(value); return *this;}

    /**
     * <p>The type of the target (for example, SNS).</p>
     */
    inline TargetSummary& WithTargetType(Aws::String&& value) { SetTargetType(std::move(value)); return *this;}

    /**
     * <p>The type of the target (for example, SNS).</p>
     */
    inline TargetSummary& WithTargetType(const char* value) { SetTargetType(value); return *this;}


    /**
     * <p>The status of the target.</p>
     */
    inline const TargetStatus& GetTargetStatus() const{ return m_targetStatus; }

    /**
     * <p>The status of the target.</p>
     */
    inline bool TargetStatusHasBeenSet() const { return m_targetStatusHasBeenSet; }

    /**
     * <p>The status of the target.</p>
     */
    inline void SetTargetStatus(const TargetStatus& value) { m_targetStatusHasBeenSet = true; m_targetStatus = value; }

    /**
     * <p>The status of the target.</p>
     */
    inline void SetTargetStatus(TargetStatus&& value) { m_targetStatusHasBeenSet = true; m_targetStatus = std::move(value); }

    /**
     * <p>The status of the target.</p>
     */
    inline TargetSummary& WithTargetStatus(const TargetStatus& value) { SetTargetStatus(value); return *this;}

    /**
     * <p>The status of the target.</p>
     */
    inline TargetSummary& WithTargetStatus(TargetStatus&& value) { SetTargetStatus(std::move(value)); return *this;}

  private:

    Aws::String m_targetAddress;
    bool m_targetAddressHasBeenSet;

    Aws::String m_targetType;
    bool m_targetTypeHasBeenSet;

    TargetStatus m_targetStatus;
    bool m_targetStatusHasBeenSet;
  };

} // namespace Model
} // namespace CodeStarNotifications
} // namespace Aws
